//******************************************************************************
// "charlcd" LCD kijelz frisstsnek processzorhasznlat mr program
// kszt: Roberto Benjami (robertodebenjami(at)gmail(dot)com)
//
// Mkdse:
// - kt szmllt nvel, az egyiket LCD frissts kzben,
//   a msikat az LCD frisstsnek kikapcsolsa utn
//   kirja a kt beszmolt rtket, valamint azt, hogy az els mrs eredmnye 
//   hny szzalkkal kevesebb a msodiknl.
//
// charlcd.h szksges belltsai:
// - megszaktsos folyamatos frisstsi zemmd (LCDMODECONTIRQ)
// - ne az 1.timert hasznljuk (LCDTIMERNUM)
//
// letesztelhetjk:
// - LCDFRAMEPERSEC vltoztatsnak a hatst
// - 4/8 bites zemmd (LCD4BITMODE) hatst
// - villogtats ki/be hatst (LCDBLINKCHAR)
// - a klnbz CPU rajel hatst
//******************************************************************************

#include <avr/io.h>
#include <avr/interrupt.h>
#include <compat/ina90.h>
#include <string.h>
#include <stdlib.h>
#include "charlcd.h"

// led lbak definilsa
// #define  LEDS
#define  LED1ON     PORTB |=  (1 << 2)
#define  LED2ON     PORTB |=  (1 << 3)
#define  LED1OFF    PORTB &= ~(1 << 2)
#define  LED2OFF    PORTB &= ~(1 << 3)
#define  LED1IO     DDRB |=  (1 << 2)
#define  LED2IO     DDRB |=  (1 << 3)
#define  LED1       (PORTB & (1 << 2))
#define  LED2       (PORTB & (1 << 3))

// 1 megszakts/sec
#define  TIMECLK    1

// rajel forrs frekvencia
#define  TimerSrcClock (1UL*SystemClock)

#if (!defined LCDMODECONTIRQ)
#error "A tesztprogram LCDMODECONTIRQ zemmdban mkdik!"
#endif

//******************************************************************************
void init(void)
{
  // idzt inicializlsa
  // timer 1
  #define  TIMEDIV ((TimerSrcClock+TIMECLK/2)/TIMECLK-1)
  #if TIMEDIV < 65536
  #define TMCLKDIV         1
  #define TMCLKSEL         1
  #elif TIMEDIV < (65536*8)
  #define TMCLKDIV         8
  #define TMCLKSEL         2
  #elif TIMEDIV < (65536*64)
  #define TMCLKDIV        64
  #define TMCLKSEL         3
  #elif TIMEDIV < (65536*256)
  #define TMCLKDIV       256
  #define TMCLKSEL         4
  #elif TIMEDIV < (65536*1024)
  #define TMCLKDIV      1024
  #define TMCLKSEL         5
  #endif // TIMEDIV

  #define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)
  OCR1AH = TMCOMP >> 8;                 // comparator HI
  OCR1AL = (unsigned char)TMCOMP;       // comparator LO
  TCCR1B = (0<<WGM12)|(TMCLKSEL<<CS10); // mode0, Clk = ClkIO/1..8..64..256..1024

  #ifdef  LEDS
  LED1OFF; LED2OFF; LEDIO1; LEDIO2;
  #endif

}
//******************************************************************************

int main(void)
{
  static unsigned long cycle1, cycle2;  // 32 bites ciklusszmll
  unsigned char c;

  LcdInit();                            // mkdsre brjuk az LCD-t

  #if (1UL * LCDWIDTH * LCDLINES) < 80 
  // 2x16 karakteres -------------------
  #ifdef LCDBLINKCHAR
  for(c = 24; c < 32; c++)
    LcdBlinkChar(c);
  #endif // LCDBLINKCHAR
  #else  // (1UL * LCDWIDTH * LCDLINES) < 80
  // 4x40 karakteres -------------------
  memcpy((char *)LcdText +   0, "****************************************", 40); // kezdkperny feltltse
  memcpy((char *)LcdText +  40, "*          LCD CPU used meter          *", 40); // kezdkperny feltltse
  memcpy((char *)LcdText +  80, "*                                      *", 40); // kezdkperny feltltse
  memcpy((char *)LcdText + 120, "****************************************", 40); // kezdkperny feltltse
  #ifdef LCDBLINKCHAR
  for(c = 41; c < 78; c++)
    LcdBlinkChar(c);                    // msodik sor szveg villog
  #endif // LCDBLINKCHAR
  #endif // else (1UL * LCDWIDTH * LCDLINES) < 80

  init();
  while(1)
  {
    cycle1 = 0; cycle2 = 0;             // szmllk nullzsa
    
    // mrs 1 ---------------------------
    LcdRefreshStart();                  // kijelzfrissts menjen
    #ifdef  LEDS
    LED1OFF; LED2ON;
    #endif
    TCNT1H = 0; TCNT1L = 0;             // timer1 (ra) nullzs
	#ifdef TIFR
    TIFR = (1 << OCF1A);                // timer1 tlcsordulsjelzs trls
    while(!(TIFR & (1<<OCF1A))) cycle1++;// id leteltig szmol
	#else
    TIFR1 = (1 << OCF1A);               // timer1 tlcsordulsjelzs trls
    while(!(TIFR1 & (1<<OCF1A))) cycle1++;// id leteltig szmol
	#endif
    LcdRefreshStop();
    
    // mrs 2 ---------------------------
    #ifdef  LEDS
    LED1ON; LED2OFF;
    #endif
    TCNT1H = 0; TCNT1L = 0;             // timer1 (ra) nullzs
	#ifdef TIFR
    while(!(TIFR & (1<<OCF1A))) cycle2++;// id leteltig szmol
    TIFR = (1 << OCF1A);                // timer1 tlcsordulsjelzs trls
	#else
    TIFR1 = (1 << OCF1A);               // timer1 tlcsordulsjelzs trls
    while(!(TIFR1 & (1<<OCF1A))) cycle2++;// id leteltig szmol
	#endif

    // megjelents -----------------------
    #if (1UL * LCDWIDTH * LCDLINES) < 80 
    // 2x16 karakteres -------------------
    memcpy((char *)LcdText, "                                ", 32);
    ltoa(cycle1,  (char *)LcdText +  0, 10);
    ltoa(cycle2,  (char *)LcdText +  8, 10);
    ltoa(100-(100*cycle1/cycle2), (char *)LcdText + 16, 10);
    #else  // (1UL * LCDWIDTH * LCDLINES) < 80
    // 4x40 karakteres -------------------
    //                            "0204060810121416182022242628303234363840"
    memcpy((char *)LcdText +  80, "*With:        Without:              %  *", 40);
    ltoa(cycle1,  (char *)LcdText +  86, 10);
    ltoa(cycle2,  (char *)LcdText + 102, 10);
    ltoa(100-(100*cycle1/cycle2), (char *)LcdText + 113, 10);
    #endif // else (1UL * LCDWIDTH * LCDLINES) < 80 
  }
}
