//******************************************************************************
// "charlcd" LCD kijelz frisstsnek processzorhasznlat mr program
// kszt: Roberto Benjami (robertodebenjami(at)gmail(dot)com)
//
// Mkdse:
// - kt szmllt nvel, az egyiket LCD frissts kzben,
//   a msikat az LCD frisstsnek kikapcsolsa utn
//   kirja a kt beszmolt rtket, valamint azt, hogy az els mrs eredmnye 
//   hny szzalkkal kevesebb a msodiknl.
//
// charlcd.h szksges belltsai:
// - megszaktsos folyamatos frisstsi zemmd (LCDMODECONTIRQ)
//
// letesztelhetjk:
// - LCDFRAMEPERSEC vltoztatsnak a hatst
// - 4/8 bites zemmd (LCD4BITMODE) hatst
// - villogtats ki/be hatst (LCDBLINKCHAR)
// - a klnbz CPU rajel hatst
//******************************************************************************

#include <p18cxxx.h>
#include <string.h>
#include <stdlib.h>
#include <timers.h>
#include "charlcd.h"
#include "bootloaders.h"

// led lbak definilsa
// #define  LEDS
#define  LED1       PORTBbits.RB0
#define  LED2       PORTBbits.RB1
#define  LEDIO1     TRISBbits.TRISB0
#define  LEDIO2     TRISBbits.TRISB1

#if (!defined LCDMODECONTIRQ)
#error "A tesztprogram LCDMODECONTIRQ zemmdban mkdik!"
#endif

#if LCDTIMERNUM == 1
#error "Az LCD-t ne az 1. timerrel hasznljuk!"
#endif

//******************************************************************************
void init(void)
{
  // 1. idzt inicializlsa
  T1CONbits.RD16 = 1;                   // 16bites rs/olv
  // T1CONbits.T1RUN = 0;
  T1CONbits.T1OSCEN = 0;                // rakvarc tilts
  T1CONbits.TMR1CS = 0;                 // forrs rajel = CPU clk
  T1CONbits.T1CKPS = 3;                 // eloszt : 1:8
  T1CONbits.TMR1ON = 0;                 // kikapcs

  // ledek belltsa
  #ifdef  LEDS
  LED1 = 0; LED2 = 0; LEDIO1 = 0; LEDIO2 = 0;
  #endif
}
//******************************************************************************

void main(void)
{
  static unsigned long cycle1, cycle2;  // 32 bites ciklusszmll
  unsigned char c;

  // ha szksg van AD lb digitlis I/O lbra trtn tkapcsolsra
  #ifdef InitAD
  InitAD();
  #endif

  LcdInit();                            // mkdsre brjuk az LCD-t

  #if (1UL * LCDWIDTH * LCDLINES) < 80 
  // 2x16 karakteres -------------------
  #ifdef LCDBLINKCHAR
  memcpypgm2ram((char *)LcdText + 24, "--------", 8); // kezdkperny feltltse
  for(c = 24; c < 32; c++)
    LcdBlinkChar(c);
  #endif // LCDBLINKCHAR
  #else  // (1UL * LCDWIDTH * LCDLINES) < 80
  // 4x40 karakteres -------------------
  //                                   "0204060810121416182022242628303234363840"
  memcpypgm2ram((char *)LcdText +   0, "****************************************", 40); // kezdkperny feltltse
  memcpypgm2ram((char *)LcdText +  40, "*          LCD CPU used meter          *", 40); // kezdkperny feltltse
  memcpypgm2ram((char *)LcdText +  80, "*                                      *", 40); // kezdkperny feltltse
  memcpypgm2ram((char *)LcdText + 120, "****************************************", 40); // kezdkperny feltltse
  #ifdef LCDBLINKCHAR
  for(c = 41; c < 78; c++)
    LcdBlinkChar(c);                    // msodik sor szveg villog
  #endif // LCDBLINKCHAR
  #endif // else (1UL * LCDWIDTH * LCDLINES) < 80

  init();
  while(1)
  {
    cycle1 = 0; cycle2 = 0;             // szmllk nullzsa
    
    // mrs 1 ---------------------------
    #ifdef  LEDS
    LED1 = 0; LED2 = 1;
    #endif
    TMR1H = 0; TMR1L = 0;               // timer1 (ra) nullzs
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    T1CONbits.TMR1ON = 1;               // TMR1 start
    while(!PIR1bits.TMR1IF) cycle1++;   // T1 tlcsordulsig szmol
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    while(!PIR1bits.TMR1IF) cycle1++;   // T1 tlcsordulsig szmol
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    while(!PIR1bits.TMR1IF) cycle1++;   // T1 tlcsordulsig szmol
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    while(!PIR1bits.TMR1IF) cycle1++;   // T1 tlcsordulsig szmol
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    while(!PIR1bits.TMR1IF) cycle1++;   // T1 tlcsordulsig szmol
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    while(!PIR1bits.TMR1IF) cycle1++;   // T1 tlcsordulsig szmol
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    while(!PIR1bits.TMR1IF) cycle1++;   // T1 tlcsordulsig szmol
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    while(!PIR1bits.TMR1IF) cycle1++;   // T1 tlcsordulsig szmol
    LcdRefreshStop();                   // kijelzfrissts lj
    
    // mrs 2 ---------------------------
    #ifdef  LEDS
    LED1 = 1; LED2 = 0;
    #endif
    TMR1H = 0; TMR1L = 0;               // timer1 (ra) nullzs
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    T1CONbits.TMR1ON = 1;               // TMR1 start
    while(!PIR1bits.TMR1IF) cycle2++;   // T1 tlcsordulsig szmol
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    while(!PIR1bits.TMR1IF) cycle2++;   // T1 tlcsordulsig szmol
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    while(!PIR1bits.TMR1IF) cycle2++;   // T1 tlcsordulsig szmol
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    while(!PIR1bits.TMR1IF) cycle2++;   // T1 tlcsordulsig szmol
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    while(!PIR1bits.TMR1IF) cycle2++;   // T1 tlcsordulsig szmol
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    while(!PIR1bits.TMR1IF) cycle2++;   // T1 tlcsordulsig szmol
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    while(!PIR1bits.TMR1IF) cycle2++;   // T1 tlcsordulsig szmol
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    while(!PIR1bits.TMR1IF) cycle2++;   // T1 tlcsordulsig szmol

    // megjelents -----------------------
    LcdRefreshStart();                  // kijelzfrissts menjen
    #if (1UL * LCDWIDTH * LCDLINES) < 80
    // 2x16 karakteres -------------------
    // memcpypgm2ram((char *)LcdText,       "                                ", 32); // kezdkperny feltltse
    ltoa(cycle1,  (char *)LcdText +  0);
    ltoa(cycle2,  (char *)LcdText +  8);
    cycle1 = 10000-(10000*cycle1/cycle2);

    #define NUMPOZ 16
	if(cycle1 > 10000)
    {
      ltoa(cycle1, (char *)LcdText + NUMPOZ);
	  LcdText[NUMPOZ + 5] = LcdText[NUMPOZ + 4];
	  LcdText[NUMPOZ + 4] = LcdText[NUMPOZ + 3];
	  LcdText[NUMPOZ + 3] = '.';
	  LcdText[NUMPOZ + 6] = '%';
    }
    else if(cycle1 > 1000)
    {
      ltoa(cycle1, (char *)LcdText + NUMPOZ + 1);
	  LcdText[NUMPOZ + 5] = LcdText[NUMPOZ + 4];
	  LcdText[NUMPOZ + 4] = LcdText[NUMPOZ + 3];
	  LcdText[NUMPOZ + 3] = '.';
	  LcdText[NUMPOZ + 6] = '%';
    }
    else if(cycle1 > 100)
    {
      ltoa(cycle1, (char *)LcdText + NUMPOZ + 3);
	  LcdText[NUMPOZ + 2] = LcdText[NUMPOZ + 3];
	  LcdText[NUMPOZ + 3] = '.';
	  LcdText[NUMPOZ + 6] = '%';
    }
    else if(cycle1 > 10)
    {
      ltoa(cycle1, (char *)LcdText + NUMPOZ + 4);
	  LcdText[NUMPOZ + 2] = '0';
	  LcdText[NUMPOZ + 3] = '.';
	  LcdText[NUMPOZ + 6] = '%';
    }
    else
    {
      ltoa(cycle1, (char *)LcdText + NUMPOZ + 5);
	  LcdText[NUMPOZ + 2] = '0';
	  LcdText[NUMPOZ + 3] = '.';
	  LcdText[NUMPOZ + 4] = '0';
	  LcdText[NUMPOZ + 6] = '%';
    }

	#else  // (1UL * LCDWIDTH * LCDLINES) < 80
    // 4x40 karakteres -------------------
    //                                   "0204060810121416182022242628303234363840"
    memcpypgm2ram((char *)LcdText +  80, "*With:        Without:              %  *", 40); // kezdkperny feltltse
    ltoa(cycle1,  (char *)LcdText +  86);
    ltoa(cycle2,  (char *)LcdText + 102);
    ltoa(100-(100*cycle1/cycle2), (char *)LcdText + 113);
    #endif // else (1UL * LCDWIDTH * LCDLINES) < 80
  }
}

#pragma interrupt YourHighPriorityISRCode
void YourHighPriorityISRCode()
{
  #if (LCDTIMERPR18 == -1) || (LCDTIMERPR18 == 1)
  LcdIntProcess();                      // interrupt md esetn frisstjk a kijelz tartalmt
  #endif
}

#pragma interruptlow YourLowPriorityISRCode
void YourLowPriorityISRCode()
{
  #if LCDTIMERPR18 == 0
  LcdIntProcess();                      // interrupt md esetn frisstjk a kijelz tartalmt
  #endif
}
