//******************************************************************************
// "charlcd" LCD kijelz frisstsnek processzorhasznlat mr program
// kszt: Roberto Benjami (robertodebenjami(at)gmail(dot)com)
//
// Mkdse:
// - kt szmllt nvel, az egyiket LCD frissts kzben,
//   a msikat az LCD frisstsnek kikapcsolsa utn
//   kirja a kt beszmolt rtket, valamint azt, hogy az els mrs eredmnye 
//   hny szzalkkal kevesebb a msodiknl.
//
// charlcd.h szksges belltsai:
// - megszaktsos folyamatos frisstsi zemmd (LCDMODECONTIRQ)
// - ne az 1.timert hasznljuk (LCDTIMERNUM)
//
// letesztelhetjk:
// - LCDFRAMEPERSEC vltoztatsnak a hatst
// - 4/8 bites zemmd (LCD4BITMODE) hatst
// - villogtats ki/be hatst (LCDBLINKCHAR)
// - a klnbz CPU rajel hatst
//******************************************************************************

#include <pic.h>
#include <string.h>
#include <stdlib.h>
#include "charlcd.h"

// rajel forrs frekvencia
#define TimerSrcClock (1UL*SystemClock/4)

// 100 megszakts/sec
#define  TIMECLK    100

// led lbak definilsa
#define  LEDS
#define  LED1       PORTBbits.RB0
#define  LED2       PORTBbits.RB1
#define  LEDIO1     TRISBbits.TRISB0
#define  LEDIO2     TRISBbits.TRISB1

__CONFIG(FOSC_HS & WDTE_OFF & PWRTE_OFF & CP_OFF & BOREN_OFF & LVP_OFF);

#if (defined LCDREFRESHMODEONE) || (!defined LCDTIMERINT) || LCDTIMERNUM == 1
#error "Rossz belltsok az lcdchar.h-ban"
#endif

//******************************************************************************
void init(void)
{
  // 1. idzt inicializlsa
  T1CONbits.T1OSCEN = 0;                // rakvarc tilts
  T1CONbits.TMR1CS = 0;                 // forrs rajel = CPU clk
  T1CONbits.T1CKPS = 3;                 // eloszt : 1:8
  T1CONbits.TMR1ON = 0;                 // kikapcs

  // ledek belltsa
  #ifdef  LEDS
  LED1 = 0; LED2 = 0; LEDIO1 = 0; LEDIO2 = 0;
  #endif
}
//******************************************************************************

void main(void)
{
  static unsigned long cycle1, cycle2;  // 32 bites ciklusszmll
  unsigned char c;

  // ha szksg van AD lb digitlis I/O lbra trtn tkapcsolsra
  #ifdef InitAD
  InitAD();
  #endif

  LcdInit();                            // mkdsre brjuk az LCD-t

  #if (1UL * LCDWIDTH * LCDLINES) < 80 
  // 2x16 karakteres -------------------
  //                         "01020304050607080910111213141516"
  // memcpy((char *)LcdText, " LCD CPU used       meter       ", 32); // kezdkperny feltltse
  #ifdef LCDBLINKCHAR
  for(c = 24; c < 32; c++)
    LcdBlinkChar(c);
  #endif // LCDBLINKCHAR
  #else  // (1UL * LCDWIDTH * LCDLINES) < 80
  // 4x40 karakteres -------------------
  //                                   "0204060810121416182022242628303234363840"
  memcpy((char *)LcdText +   0, "****************************************", 40); // kezdkperny feltltse
  memcpy((char *)LcdText +  40, "*          LCD CPU used meter          *", 40); // kezdkperny feltltse
  memcpy((char *)LcdText +  80, "*                                      *", 40); // kezdkperny feltltse
  memcpy((char *)LcdText + 120, "****************************************", 40); // kezdkperny feltltse
  #ifdef LCDBLINKCHAR
  for(c = 41; c < 78; c++)
    LcdBlinkChar(c);                    // msodik sor szveg villog
  #endif // LCDBLINKCHAR
  #endif // else (1UL * LCDWIDTH * LCDLINES) < 80

  // megszakts belltsok
  INTCONbits.PEIE = 1;                  // perifria IRQ eng
  INTCONbits.GIE = 1;                   // globlis IRQ eng

  init();
  while(1)
  {
    cycle1 = 0; cycle2 = 0;             // szmllk nullzsa
    
    // mrs 1 ---------------------------
    LcdRefreshStart();                  // kijelzfrissts menjen
    #ifdef  LEDS
    LED1 = 0; LED2 = 1;
    #endif
    TMR1H = 0; TMR1L = 0;               // timer1 (ra) nullzs
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    T1CONbits.TMR1ON = 1;               // TMR1 start
    while(!PIR1bits.TMR1IF) cycle1++;   // T1 tlcsordulsig szmol
    LcdRefreshStop();                   // kijelzfrissts lj
    
    // mrs 2 ---------------------------
    #ifdef  LEDS
    LED2 = 0; LED1 = 1;
    #endif
    TMR1H = 0; TMR1L = 0;               // timer1 (ra) nullzs
    PIR1bits.TMR1IF = 0;                // timer1 tlcsordulsjelzs trls
    T1CONbits.TMR1ON = 1;               // TMR1 start
    while(!PIR1bits.TMR1IF) cycle2++;   // T1 tlcsordulsig szmol

    // megjelents -----------------------

    #if (1UL * LCDWIDTH * LCDLINES) < 80 
    // 2x16 karakteres -------------------
    memcpy((char *)LcdText, "                        -CpuSpd-", 32); // kezdkperny feltltse
    ltoa((char *)LcdText +  0, cycle1, 10);
    ltoa((char *)LcdText +  8, cycle2, 10);
    ltoa((char *)LcdText + 16, 100-((100*cycle1+50)/cycle2), 10);
    #else  // (1UL * LCDWIDTH * LCDLINES) < 80
    // 4x40 karakteres -------------------
    //                            "0204060810121416182022242628303234363840"
    memcpy((char *)LcdText +  80, "*With:        Without:              %  *", 40); // kezdkperny feltltse
    ltoa((char *)LcdText +  86, cycle1, 10);
    ltoa((char *)LcdText + 102, cycle2, 10);
    ltoa((char *)LcdText + 113, 100-((100*cycle1+50)/cycle2), 10);
    #endif // else (1UL * LCDWIDTH * LCDLINES) < 80 
  }
}

//******************************************************************************
// PIC16 megszakts kiszolgls
static void interrupt isr(void)
{
  #ifdef LCDTIMERINT
  LcdIntProcess();                      // interrupt md esetn frisstjk a kijelz tartalmt
  #endif
}
