//******************************************************************************
// Ez a "charlcd" LCD kijelz kurzorhasznlati lehetsgt mutatja be.
// kszt: Roberto Benjami (robertodebenjami(at)gmail(dot)com)
//
// Mkdse:
// - A kijelzn a karakterkszletet visszafel grdti, mikzben a kurzort elre viszi.
//   A kurzort e kzben ki-be kapcsolgatja, s a formjt is vltogatja.
//
// charlcd.h szksges belltsai:
// - egyszeri frisstsi zemmd (LCDMODEONCEBUSY vagy LCDMODEONCEDELAY vagy LCDMODEONCEIRQ)
// - kurzor (LCDCURSOR be)
// kszt: Roberto Benjami (robertodebenjami(at)gmail(dot)com)
//******************************************************************************

#include <p18cxxx.h>
#include <string.h>
#include <stdlib.h>
#include <timers.h>
#include "charlcd.h"
#include "bootloaders.h"

// led lbak definilsa (ha nincs, trljk a LEDS defincit)
// #define  LEDS
#define  LED1       PORTBbits.RB0
#define  LED2       PORTBbits.RB1
#define  LEDIO1     TRISBbits.TRISB0
#define  LEDIO2     TRISBbits.TRISB1

//******************************************************************************
void mwait(void)
{
  #define DELAYNUM (CpuClock/1000/14)
  static unsigned char cc;
  volatile unsigned int dh, dl;

  #ifdef  LEDS
  if(LED1) LED1 = 0; else LED2 = 1;
  #endif

  dh = 1000;
  while(dh--)
  {
    dl = DELAYNUM;
    while(dl--);
  }

  LcdText[0]++;
  for(cc = 0; cc < sizeof(LcdText) - 2; cc++)
    LcdText[cc + 1] = LcdText[cc] + 1;
}

//******************************************************************************

void main(void)
{
  unsigned char c;

  // ha szksg van AD lb digitlis I/O lbra trtn tkapcsolsra
  #ifdef InitAD
  InitAD();
  #endif

  // ledek belltsa
  #ifdef  LEDS
  LED1 = 0; LED2 = 0; LEDIO1 = 0; LEDIO2 = 0;
  #endif

  LcdInit();                            // mkdsre brjuk az LCD-t

  // megszakts belltsok
  RCONbits.IPEN = 1;                    // ktszint IRQ eng
  INTCONbits.GIEL = 1;                  // globlis LO IRQ eng
  INTCONbits.GIEH = 1;                  // globlis IRQ eng

  while(1)
  {
    LcdRefreshAll();
    mwait();
    LcdCursorPos++;
    LcdCursorOff();

    LcdRefreshAll();
    mwait();
    LcdCursorPos++;
    LcdCursorOn();

    LcdRefreshAll();
    mwait();
    LcdCursorPos++;
	LcdCursorBlink();

    LcdRefreshAll();
    mwait();
    LcdCursorPos++;
	LcdCursorUnBlink();

	if(LcdCursorPos >= sizeof(LcdText) - 2) LcdCursorPos = 0;
  }
}

#pragma interrupt YourHighPriorityISRCode
void YourHighPriorityISRCode()
{
}

#pragma interruptlow YourLowPriorityISRCode
void YourLowPriorityISRCode()
{
  #ifdef LCDTIMERINT
  LcdIntProcess();                      // interrupt md esetn frisstjk a kijelz tartalmt
  #endif
}
