//******************************************************************************
// 16 bites PIC ra demo az charlcd tesztelshez
// kszt: Roberto Benjami (robertodebenjami(at)gmail(dot)com)
//
// charlcd.h szksges belltsai:
// - a bellts brmi lehet, csak a felhasznlt mikrovezrl is tmogassa,
//   (pl. a belltott I/O lb s a TIMER ltezzen)
//   s az egymstl fgg belltsoknl ne legyen sszefrhetetlnsg
//   (pl. kurzor csak egyszeri frisstsi mdban legyen),
// - adott esetben a felhasznlt I/O lbak analgrl -> digitlisra trtn tlltsrl gondoskodjunk!
//   (ezt vagy a hardvareprofile.h InitAD() defincijba, vagy akr ide a main utn is berhatjuk)
// - legalbb 32 karakter legyen a kijelz(k)n, (legalbb 2x16, LCDSTEREO esetn 1x16)
//******************************************************************************

// include, rajel forrs frekvencia
#if defined(__dsPIC30F__)
#include <p30Fxxxx.h>
#define TimerSrcClock (1UL*SystemClock/4)
#elif defined(__dsPIC33F__)
#include <p33Fxxxx.h>
#define TimerSrcClock (1UL*SystemClock/2)
#elif defined(__PIC24F__)
#include <p24Fxxxx.h>
#define TimerSrcClock (1UL*SystemClock/2)
#elif defined(__PIC24FK__)
#include <p24Fxxxx.h>
#define TimerSrcClock (1UL*SystemClock/2)
#elif defined(__PIC24H__)
#include <p24Hxxxx.h>
#define TimerSrcClock (1UL*SystemClock/2)
#endif

#include <timer.h>
#include <string.h>
#include <stdlib.h>
#include "charlcd.h"

// 1000 megszakts/sec
#define  TIMECLK  1000

// melyik idztn jrjon az ra ? (hogy ne tkzzn az lcdchar ltal felhasznltal)
#if (LCDTIMERNUM == 1)
#define  CLOCKTIMERNUM   2
#else
#define  CLOCKTIMERNUM   1
#endif

// 1msec megszakts
#define  TMCOMP (((TimerSrcClock)+1000/2)/1000-1)

unsigned int ev = 2013;
unsigned char honap = 12;
unsigned char nap = 27;
unsigned char ora = 23;
unsigned char perc = 58;
volatile unsigned char masodperc = 0;
unsigned char honaphosszak[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

#ifdef USERCHARSETCHANGE
USERCHARSETARRAY userchars;
#endif

// osztsarny
#define  TIMEDIV ((TimerSrcClock+TIMECLK/2)/TIMECLK-1)

//******************************************************************************
void init(void)
{
  // PIC24 TIMER2 idzt inicializlsa
  #if CLOCKTIMERNUM == 1
  OpenTimer1(T1_ON & T1_GATE_OFF & T1_PS_1_1 & T1_SOURCE_INT & T1_INT_ON, TIMEDIV);
  SetPriorityIntT1(1);                  // legkisebb priorits
  EnableIntT1;
  #else
  OpenTimer2(T2_ON & T2_GATE_OFF & T2_PS_1_1 & T2_32BIT_MODE_OFF & T2_SOURCE_INT & T2_INT_ON, TIMEDIV);
  SetPriorityIntT2(1);                  // legkisebb priorits
  EnableIntT2;
  #endif
}
//******************************************************************************

int main(void)
{
  static unsigned char lastsec;
  #ifdef USERCHARSETCHANGE
  unsigned char i, j;
  #endif

  // ha szksg van AD lb digitlis I/O lbra trtn tkapcsolsra
  #ifdef InitAD
  InitAD();
  #endif

  // felhasznli karakterkszlet msolsa RAM-ba (csak ha engedlyezve van)
  #ifdef USERCHARSETCHANGE
  memcpy((char *)userchars, userromcharset, sizeof(USERCHARSETARRAY)); 
  #endif

  LcdInit();                            // mkdsre brjuk az LCD-t
  init();

  //                     "01020304050607080910111213141516"
  memcpy((char*)LcdText, "   eeee.hh.nn       oo:pp:mm    ", 32);
  lastsec = 255;
  while(1)
  {
	// folyamatos frisstsi zemmd megszakts nlkl
    #ifdef LCDMODECONT
    LcdProcess();
    #endif

    if(lastsec != masodperc)
    {
      // Ha nincs automata villogtats 1sec a villogsi idztse
      #if (defined LCDBLINKCHAR) && (!defined LCDMODECONTIRQ) || (LCDBLINKSPEED == 0)
      BlinkPhase = !BlinkPhase;
      #endif


      // jr az ra jr
      if(masodperc == 60)
      {
        masodperc = 0;
        if(++perc == 60)
        {
          perc = 0;
          if(++ora == 24)
          {
            ora = 0;
            if(++nap > honaphosszak[honap - 1])
            {
              nap = 1;
              if(++honap == 13)
              {
                honap = 1;
                ev++;
      } } } } }
      lastsec = masodperc;

      // szmjegyek kirsa

      itoa((char*)LcdText + 3, ev, 10);
      itoa((char*)LcdText + 8, honap, 10);
      itoa((char*)LcdText + 11, nap, 10);
      itoa((char*)LcdText + 20, ora, 10);
      itoa((char*)LcdText + 23, perc, 10);
      itoa((char*)LcdText + 26, masodperc, 10);

      // egyszmjegy szmok ktszmjegyv alaktsa
      if(!LcdText[9]) {LcdText[9]  = LcdText[8];  LcdText[8]  = '0';}
      if(!LcdText[12]){LcdText[12] = LcdText[11]; LcdText[11] = '0';}
      if(!LcdText[21]){LcdText[21] = LcdText[20]; LcdText[20] = '0';}
      if(!LcdText[24]){LcdText[24] = LcdText[23]; LcdText[23] = '0';}
      if(!LcdText[27]){LcdText[27] = LcdText[26]; LcdText[26] = '0';}

      // itoa ltal fellrt rsjelek ptlsa
      LcdText[7] = '.';
      LcdText[10] = '.';
      LcdText[22] = ':';
      LcdText[25] = ':';

      // szmok kztti kettspont villogtats
      #ifdef LCDBLINKCHAR
      LcdBlinkChar(22);
      LcdBlinkChar(25);
      #endif
  
      // felhasznl ltal definilt karakterek a sarkokban
      #ifdef USERCHARSET
      LcdText[0] = 8;
      LcdText[1] = 10;
      LcdText[16] = 9;
      LcdText[17] = 11;
      LcdText[14] = 12;
      LcdText[15] = 14;
      LcdText[30] = 13;
      LcdText[31] = 15;
      #endif

      // kurzor lptetse s kurzortpus vltogatsa
      #ifdef LCDCURSOR
      LcdCursorPos++;
      if(LcdCursorPos >= (1UL * LCDWIDTH * LCDLINES))
        LcdCursorPos = 0;
      if((LcdCursorPos & 0b11) == 0b00) LcdCursorOff();
      else if((LcdCursorPos & 0b11) == 0b01) {LcdCursorUnBlink(); LcdCursorOn();}
      else if((LcdCursorPos & 0b11) == 0b10) {LcdCursorBlink(); LcdCursorOn();}
      else if((LcdCursorPos & 0b11) == 0b11) {LcdCursorUnBlink(); LcdCursorOn();}
	  #endif

      // karakterkszlet shiftelse s feltltse (csak ha karakterkszlet vltoztatsnak lehetsge engedve van)
      #ifdef USERCHARSETCHANGE
      j = userchars[63];
      i = 63;
      while(i-- > 0)
        userchars[i + 1] = userchars[i];
      userchars[0] = j;
      LcdChangeCharset(userchars);
      #endif // USERCHARSETCHANGE

      // egyszeri frisstsi zemmdban megjelents
      #if ((defined LCDMODEONCEBUSY) || (defined LCDMODEONCEDELAY) || (defined LCDMODEONCEIRQ)) 
      LcdRefreshAll();
	  #endif
    }
  }
}

//******************************************************************************
// PIC24 megszakts kiszolgls
#if CLOCKTIMERNUM == 1
void __attribute__ ((interrupt, auto_psv)) _T1Interrupt(void)
{
  volatile static unsigned int msec = 0;
  IFS0bits.T1IF = 0;
  msec++;
  if(msec == 1000)
  {
    masodperc++;
    msec = 0; 
  }
  #if (defined LCDUSERTIMER)
  LcdIntProcess();                      // sajt megszaktskezelvel s idztskezelvel hasznlva
  #endif
}
#else
void __attribute__ ((interrupt, auto_psv)) _T2Interrupt(void)
{
  volatile static unsigned int msec = 0;
  IFS0bits.T2IF = 0;
  msec++;
  if(msec == 1000)
  {
    masodperc++;
    msec = 0; 
  }
  #if (defined LCDUSERTIMER)
  LcdIntProcess();                      // sajt megszaktskezelvel s idztskezelvel hasznlva
  #endif
}
#endif
