//******************************************************************************
// 8 bites 16Fxxx PIC ra demo az charlcd tesztelshez
// kszt: Roberto Benjami (robertodebenjami(at)gmail(dot)com)
//
// charlcd.h szksges belltsai:
// - a bellts brmi lehet, csak a felhasznlt mikrovezrl is tmogassa,
//   (pl. a belltott I/O lb s a TIMER ltezzen)
//   s az egymstl fgg belltsoknl ne legyen sszefrhetetlnsg
//   (pl. kurzor csak egyszeri frisstsi mdban legyen),
// - adott esetben a felhasznlt I/O lbak analgrl -> digitlisra trtn tlltsrl gondoskodjunk!
//   (ezt vagy a hardvareprofile.h InitAD() defincijba, vagy akr ide a main utn is berhatjuk)
// - legalbb 32 karakter legyen a kijelz(k)n, (legalbb 2x16, LCDSTEREO esetn 1x16)
//******************************************************************************

#include <pic.h>
#include <string.h>
#include <stdlib.h>
#include "charlcd.h"

// rajel forrs frekvencia
#define TimerSrcClock (1UL*SystemClock/4)

// 100 megszakts/sec
#define  TIMECLK  100

// led lbak definilsa (ha nincs, trljk a LEDS defincit)
// #define  LEDS
#define  LED1       PORTBbits.RB0
#define  LED2       PORTBbits.RB1
#define  LEDIO1     TRISBbits.TRISB0
#define  LEDIO2     TRISBbits.TRISB1

// melyik idztn jrjon az ra ? (hogy ne tkzzn az lcdchar ltal felhasznltal)
#if (LCDTIMERNUM == 1)
#define  CLOCKTIMERNUM   2
#else
#define  CLOCKTIMERNUM   1
#endif

__CONFIG(FOSC_HS & WDTE_OFF & PWRTE_OFF & CP_OFF & BOREN_OFF & LVP_OFF);

unsigned int ev = 2013;
unsigned char honap = 12;
unsigned char nap = 24;
unsigned char ora = 23;
unsigned char perc = 58;
volatile unsigned char masodperc = 0;
unsigned char honaphosszak[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

#ifdef USERCHARSETCHANGE
USERCHARSETARRAY userchars;
#endif

// osztsarny
#define  TIMEDIV ((TimerSrcClock+TIMECLK/2)/TIMECLK)

//******************************************************************************
void init(void)
{
  // idzt inicializlsa
  #if CLOCKTIMERNUM == 1
  #if TIMEDIV < 65536
  #define TMCOMP (((TimerSrcClock/1)+TIMECLK/2)/TIMECLK)
  #define TMCOMPCOR     65540
  T1CONbits.T1CKPS = 0;
  #elif TIMEDIV < (65536*8)
  #define TMCOMP (((TimerSrcClock/8)+TIMECLK/2)/TIMECLK)
  #define TMCOMPCOR     65536
  T1CONbits.T1CKPS = 3;
  #else
  #error "PIC16: ez a frekvencia tl alacsony"
  #endif // TIMEDIV

  T1CONbits.TMR1CS = 0;                 // forrs rajel = systemclock
  PIE1bits.TMR1IE = 1;                  // megszakts engedlyezs
  TMR1 = TMCOMPCOR-TMCOMP;              // timer kezdrtk feltltse bitidre
  T1CONbits.TMR1ON = 1;                 // bekapcs
  #else  // CLOCKTIMERNUM == 1

  #if TIMEDIV < 256
  T2CONbits.T2CKPS = 0; T2CONbits.TOUTPS = 0;
  PR2 = (((TimerSrcClock/1)+TIMECLK/2)/TIMECLK-1);
  #elif TIMEDIV < (256*16)
  T2CONbits.T2CKPS = 2; T2CONbits.TOUTPS = 0;
  PR2 = (((TimerSrcClock/16)+TIMECLK/2)/TIMECLK-1);
  #elif TIMEDIV < (256*16*16)
  T2CONbits.T2CKPS = 2; T2CONbits.TOUTPS = 15;
  PR2 = (((TimerSrcClock/256)+TIMECLK/2)/TIMECLK-1);
  #else
  #error "PIC16: ez a frekvencia tl alacsony"
  #endif
  PIE1bits.TMR2IE = 1;                  /* megszakts engelyezs */\
  T2CONbits.TMR2ON = 1;                 // Timer2 ON
  #endif // else CLOCKTIMERNUM == 1

  INTCONbits.PEIE = 1;                  // perifria IRQ eng
  INTCONbits.GIE = 1;                   // globlis IRQ eng
  
  // ledek belltsa
  #ifdef  LEDS
  LED1 = 0; LED2 = 0; LEDIO1 = 0; LEDIO2 = 0;
  #endif
}
//******************************************************************************


void main(void)
{
  unsigned char lastsec = 255;
  #ifdef USERCHARSETCHANGE
  unsigned char i, j;
  #endif

  // ha szksg van AD lb digitlis I/O lbra trtn tkapcsolsra
  #ifdef InitAD
  InitAD();
  #endif

  // felhasznli karakterkszlet msolsa RAM-ba (csak ha engedlyezve van)
  #ifdef USERCHARSETCHANGE
  memcpy((char *)userchars, userromcharset, sizeof(USERCHARSETARRAY)); 
  #endif

  LcdInit();                            // mkdsre brjuk az LCD-t
  //                      "01020304050607080910111213141516"
  memcpy((char *)LcdText, "   eeee.hh.nn       oo:pp:mm    ", 32); // kezdkperny feltltse

  init();
  while(1)
  {
	// folyamatos frisstsi zemmd megszakts nlkl
    #ifdef LCDMODECONT
    LcdProcess();
    #endif

	if(lastsec != masodperc)
    {
      // 2 led msodpercenknt felvltva villogjon
      #ifdef  LEDS
      if(LED1) 
        {LED1 = 0; LED2 = 1;}
      else 
        {LED1 = 1; LED2 = 0;}
      #endif

       // Ha nincs automata villogtatsn 1sec a villogsi idztse
      #if (defined LCDBLINKCHAR) && (!defined LCDMODECONTIRQ) || (LCDBLINKSPEED == 0)
      BlinkPhase = !BlinkPhase;
      #endif

	  // jr az ra jr
      if(masodperc == 60)
      {
        masodperc = 0;
        if(++perc == 60)
        {
          perc = 0;
          if(++ora == 24)
          {
            ora = 0;
            if(++nap > honaphosszak[honap - 1])
            {
              nap = 1;
              if(++honap == 13)
              {
                honap = 1;
                ev++;
      } } } } }
      lastsec = masodperc;

      // szmjegyek kirsa
      utoa((char *)LcdText + 3, ev, 10);
      utoa((char *)LcdText + 8, honap, 10);
      utoa((char *)LcdText + 11, nap, 10);
      utoa((char *)LcdText + 20, ora, 10);
      utoa((char *)LcdText + 23, perc, 10);
      utoa((char *)LcdText + 26, masodperc, 10);

      // egyszmjegy szmok ktszmjegyv alaktsa
      if(!LcdText[9]) {LcdText[9]  = LcdText[8];  LcdText[8]  = '0';}
      if(!LcdText[12]){LcdText[12] = LcdText[11]; LcdText[11] = '0';}
      if(!LcdText[21]){LcdText[21] = LcdText[20]; LcdText[20] = '0';}
      if(!LcdText[24]){LcdText[24] = LcdText[23]; LcdText[23] = '0';}
      if(!LcdText[27]){LcdText[27] = LcdText[26]; LcdText[26] = '0';}

      // utoa ltal #0-val fellrt rsjelek ptlsa
      LcdText[7] = '.';
      LcdText[10] = '.';
      LcdText[22] = ':';
      LcdText[25] = ':';

      // szmok kztti kettspont villogtats
      #ifdef LCDBLINKCHAR
      LcdBlinkChar(22);
      LcdBlinkChar(25);
      #endif

      // felhasznl ltal definilt karakterek a sarkokban
      #ifdef USERCHARSET
      LcdText[0] = 8;
      LcdText[1] = 10;
      LcdText[16] = 9;
      LcdText[17] = 11;
      LcdText[14] = 12;
      LcdText[15] = 14;
      LcdText[30] = 13;
      LcdText[31] = 15;
      #endif

      // kurzor lptetse s kurzortpus vltogatsa
      #ifdef LCDCURSOR
      LcdCursorPos++;
      if(LcdCursorPos >= (1UL * LCDWIDTH * LCDLINES))
        LcdCursorPos = 0;
      if((LcdCursorPos & 0b11) == 0b00) LcdCursorOff();
      else if((LcdCursorPos & 0b11) == 0b01) {LcdCursorUnBlink(); LcdCursorOn();}
      else if((LcdCursorPos & 0b11) == 0b10) {LcdCursorBlink(); LcdCursorOn();}
      else if((LcdCursorPos & 0b11) == 0b11) {LcdCursorUnBlink(); LcdCursorOn();}
	  #endif

      // karakterkszlet shiftelse s feltltse (csak ha karakterkszlet vltoztatsnak lehetsge engedve van)
      #ifdef USERCHARSETCHANGE
      j = userchars[63];
      i = 63;
      while(i-- > 0)
        userchars[i + 1] = userchars[i];
      userchars[0] = j;
      LcdChangeCharset(userchars);
      #endif // USERCHARSETCHANGE

      // egyszeri frisstsi zemmdban megjelents
      #if ((defined LCDMODEONCEBUSY) || (defined LCDMODEONCEWAIT) || (defined LCDMODEONCEIRQ)) 
      LcdRefreshAll();
	  #endif
    }
  }
}


//******************************************************************************
// PIC16 megszakts kiszolgls
static void interrupt isr(void)
{
  static unsigned char msec10 = 0;
  
  #if CLOCKTIMERNUM == 1
  if(PIR1bits.TMR1IF)                   // timer1 interrupt ?
  {
    TMR1 += (TMCOMPCOR-TMCOMP);         // timer1 kompartor hinynak ptlsa
    PIR1bits.TMR1IF = 0;                // nyugtzs
    msec10++;
    if(msec10 >= 100)
    {
      masodperc++;
      msec10 = 0; 
    }
  }
  #else
  if(PIR1bits.TMR2IF)                   // timer2 interrupt ?
  {
    PIR1bits.TMR2IF = 0;                // nyugtzs
    msec10++;
    if(msec10 >= 100)
    {
      masodperc++;
      msec10 = 0; 
    }

    #if (defined LCDUSERTIMER)
    LcdIntProcess();                    // sajt megszaktskezelvel s idztskezelvel hasznlva
    #endif
  }
  #endif

  #if (!defined LCDUSERTIMER) && ((defined LCDMODEONCEIRQ) || (defined LCDMODECONTIRQ))
  LcdIntProcess();                      // interrupt md esetn frisstjk a kijelz tartalmt
  #endif
}
