//******************************************************************************
// 8 bites 18Fxxx PIC ra demo az charlcd tesztelshez
// kszt: Roberto Benjami (robertodebenjami(at)gmail(dot)com)
//
// charlcd.h szksges belltsai:
// - a bellts brmi lehet, csak a felhasznlt mikrovezrl is tmogassa,
//   (pl. a belltott I/O lb s a TIMER ltezzen)
//   s az egymstl fgg belltsoknl ne legyen sszefrhetetlnsg
//   (pl. kurzor csak egyszeri frisstsi mdban legyen),
// - adott esetben a felhasznlt I/O lbak analgrl -> digitlisra trtn tlltsrl gondoskodjunk!
//   (ezt vagy a hardvareprofile.h InitAD() defincijba, vagy akr ide a main utn is berhatjuk)
// - legalbb 32 karakter legyen a kijelz(k)n, (legalbb 2x16, LCDSTEREO esetn 1x16)
//******************************************************************************

#include <htc.h>
#include <string.h>
#include <stdlib.h>
#include <timers.h>
#include "charlcd.h"

// rajel forrs frekvencia
#define  TimerSrcClock (1UL*SystemClock/4)

// 1000 megszakts/sec
#define  TIMECLK 1000

// led lbak definilsa (ha nincs, trljk a LEDS defincit)
// #define  LEDS
#define  LED1       LATCbits.LATC0
#define  LED2       LATCbits.LATC1
#define  LEDIO1     TRISCbits.TRISC0
#define  LEDIO2     TRISCbits.TRISC1

// melyik idztn jrjon az ra ? (hogy ne tkzzn az lcdchar ltal felhasznltal)
#if (LCDTIMERNUM == 0)
#define  CLOCKTIMERNUM   1
#else
#define  CLOCKTIMERNUM   0
#endif

unsigned int ev = 2013;
unsigned char honap = 12;
unsigned char nap = 24;
unsigned char ora = 23;
unsigned char perc = 58;
unsigned char masodperc = 0;
const unsigned char honaphosszak[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

unsigned char temp;                     // timer kompartor segdvltozja

#ifdef USERCHARSETCHANGE
USERCHARSETARRAY userchars;
#endif

#define TMCOMP ((TimerSrcClock+TIMECLK/2)/TIMECLK)

// kompartor korrekcis rtk
#define  TMCOMPCOR0     7 
#define  TMCOMPCOR1     5 

// timer0 kompartor hinynak ptlsa
#define TIMER0COMPLESS { \
  temp = (65535+TMCOMPCOR0-TMCOMP) + TMR0L; \
  WREG = ((65535+TMCOMPCOR0-TMCOMP) >> 8); \
  asm("addwfc (TMR0H), 1, 0"); \
  TMR0L = temp; \
}

// timer1 kompartor hinynak ptlsa
#define TIMER1COMPLESS { \
  temp = (65535+TMCOMPCOR1-TMCOMP) + TMR1L; \
  WREG = ((65535+TMCOMPCOR1-TMCOMP) >> 8); \
  asm("addwfc (TMR1H), 1, 0"); \
  TMR1L = temp; \
}

//******************************************************************************
void init(void)
{
  // idzt inicializlsa
  #if CLOCKTIMERNUM == 0
  T0CONbits.T08BIT = 0;                 // TMR0 16bites
  T0CONbits.T0CS = 0;                   // rajel forrs
  T0CONbits.PSA = 1;                    // eloszt tilts
  INTCON2bits.TMR0IP = 1;               // magas priorits
  INTCONbits.TMR0IE = 1;                // TMR0 megszakts eng
  T0CONbits.TMR0ON = 1;                 // bekapcs
  TMR0L = 65536+TMCOMPCOR0-TMCOMP;      // timerL kezdrtk feltltse bitidre
  TMR0H = (65536+TMCOMPCOR0-TMCOMP) >> 8;// timerH kezdrtk feltltse bitidre
  #else
  T1CONbits.RD16 = 1;                   // 16bites rs/olv
  T1CONbits.TMR1CS = 0;                 // forrs rajel = systemclock
  T1CONbits.T1CKPS1 = 0; T1CONbits.T1CKPS0 = 0; // oszt 1:1
  IPR1bits.TMR1IP = 1;                  // magas priorits
  PIE1bits.TMR1IE = 1;                  // megszakts engelyezs
  T1CONbits.TMR1ON = 1;                 // bekapcs
  TMR1L = 65536+TMCOMPCOR1-TMCOMP;      // timerL kezdrtk feltltse bitidre
  TMR1H = (65536+TMCOMPCOR1-TMCOMP) >> 8;// timerH kezdrtk feltltse bitidre
  #endif

  // megszakts belltsok
  #if LCDTIMERPR18 == -1
  RCONbits.IPEN = 0;                    // ktszint IRQ tilts
  #else
  RCONbits.IPEN = 1;                    // ktszint IRQ eng
  #endif
  INTCONbits.GIEL = 1;                  // globlis LO IRQ eng
  INTCONbits.GIEH = 1;                  // globlis IRQ eng

  // ledek belltsa
  #ifdef  LEDS
  LED1 = 0; LED2 = 0; LEDIO1 = 0; LEDIO2 = 0;
  #endif
}
//******************************************************************************
void main(void)
{
  unsigned char lastsec = 255;
  #ifdef USERCHARSETCHANGE
  unsigned char i, j;
  #endif

  // ha szksg van AD lb digitlis I/O lbra trtn tkapcsolsra
  #ifdef InitAD
  InitAD();
  #endif

  // felhasznli karakterkszlet msolsa RAM-ba (csak ha engedlyezve van)
  #ifdef USERCHARSETCHANGE
  memcpy((char *)userchars, userromcharset, sizeof(USERCHARSETARRAY)); 
  #endif

  LcdInit();                            // mkdsre brjuk az LCD-t
  //                             "01020304050607080910111213141516"
  memcpy((char *)LcdText, "   eeee.hh.nn       oo:pp:mm    ", 32); // kezdkperny feltltse

  init();
  while(1)
  {
	// folyamatos frisstsi zemmd megszakts nlkl
    #ifdef LCDMODECONT
    LcdProcess();
    #endif

    if(lastsec != masodperc)
    {
      // 2 led felvltva villogjon
      #ifdef  LEDS
      if(LED1)
        {LED1 = 0; LED2 = 1;}
      else
        {LED1 = 1; LED2 = 0;}
	  #endif

      // Ha nincs automata villogtats 1sec a villogsi idztse
      #if (defined LCDBLINKCHAR) && (!defined LCDMODECONTIRQ) || (LCDBLINKSPEED == 0)
      BlinkPhase = !BlinkPhase;
      #endif

	  // jr az ra jr
      if(masodperc == 60)
      {
        masodperc = 0;
        if(++perc == 60)
        {
          perc = 0;
          if(++ora == 24)
          {
            ora = 0;
            if(++nap > honaphosszak[honap - 1])
            {
              nap = 1;
              if(++honap == 13)
              {
                honap = 1;
                ev++;
      } } } } }
      lastsec = masodperc;

      // szmjegyek kirsa
      utoa((char *)LcdText + 3, ev, 10);
      utoa((char *)LcdText + 8, honap, 10);
      utoa((char *)LcdText + 11, nap, 10);
      utoa((char *)LcdText + 20, ora, 10);
      utoa((char *)LcdText + 23, perc, 10);
      utoa((char *)LcdText + 26, masodperc, 10);

      // egyszmjegy szmok ktszmjegyv alaktsa
      if(!LcdText[9]) {LcdText[9]  = LcdText[8];  LcdText[8]  = '0';}
      if(!LcdText[12]){LcdText[12] = LcdText[11]; LcdText[11] = '0';}
      if(!LcdText[21]){LcdText[21] = LcdText[20]; LcdText[20] = '0';}
      if(!LcdText[24]){LcdText[24] = LcdText[23]; LcdText[23] = '0';}
      if(!LcdText[27]){LcdText[27] = LcdText[26]; LcdText[26] = '0';}

      // *toa ltal fellrt rsjelek ptlsa
      LcdText[7] = '.';
      LcdText[10] = '.';
      LcdText[22] = ':';
      LcdText[25] = ':';

      // szmok kztti kettspont villogtats
      #ifdef LCDBLINKCHAR
      LcdBlinkChar(22);
      LcdBlinkChar(25);
      #endif

      // felhasznl ltal definilt karakterek a sarkokban
      #ifdef USERCHARSET
      LcdText[0] = 8;
      LcdText[1] = 10;
      LcdText[16] = 9;
      LcdText[17] = 11;
      LcdText[14] = 12;
      LcdText[15] = 14;
      LcdText[30] = 13;
      LcdText[31] = 15;
      #endif

      // kurzor lptetse s kurzortpus vltogatsa
      #ifdef LCDCURSOR
      LcdCursorPos++;
      if(LcdCursorPos >= (1UL * LCDWIDTH * LCDLINES))
        LcdCursorPos = 0;
      if((LcdCursorPos & 0b11) == 0b00) LcdCursorOff();
      else if((LcdCursorPos & 0b11) == 0b01) {LcdCursorUnBlink(); LcdCursorOn();}
      else if((LcdCursorPos & 0b11) == 0b10) {LcdCursorBlink(); LcdCursorOn();}
      else if((LcdCursorPos & 0b11) == 0b11) {LcdCursorUnBlink(); LcdCursorOn();}
	  #endif

      // karakterkszlet shiftelse s feltltse (csak ha karakterkszlet vltoztatsnak lehetsge engedve van)
      #ifdef USERCHARSETCHANGE
      j = userchars[63];
      i = 63;
      while(i-- > 0)
        userchars[i + 1] = userchars[i];
      userchars[0] = j;
      LcdChangeCharset(userchars);
      #endif // USERCHARSETCHANGE

      // egyszeri frisstsi zemmdban megjelents
      #if ((defined LCDMODEONCEBUSY) || (defined LCDMODEONCEWAIT) || (defined LCDMODEONCEIRQ)) 
      LcdRefreshAll();
	  #endif
    }
  }
}

void interrupt low_priority irql(void)
{
  #if (!defined LCDUSERTIMER) && (LCDTIMERPR18 == 0) && ((defined LCDMODEONCEIRQ) || (defined LCDMODECONTIRQ))
  LcdIntProcess();                      // interrupt md esetn frisstjk a kijelz tartalmt
  #endif
}

void interrupt irqh(void)
{
  static unsigned int msec = 0;

  #if (!defined LCDUSERTIMER) && ((LCDTIMERPR18 == -1) || (LCDTIMERPR18 == 1)) && (defined LCDMODEONCEIRQ) || (defined LCDMODECONTIRQ)
  LcdIntProcess();                      // interrupt md esetn frisstjk a kijelz tartalmt
  #endif

  #if CLOCKTIMERNUM == 0
  if(INTCONbits.TMR0IF)                 // timer0 interrupt ?
  {
    TIMER0COMPLESS;                     // timer0 kompartor hinynak ptlsa
    INTCONbits.TMR0IF = 0;              // nyugtzs
    msec++;
    if(msec >= 1000)
    {
      masodperc++;
      msec = 0; 
    }
    #if (defined LCDUSERTIMER)
    LcdIntProcess();                    // sajt megszaktskezelvel s idztskezelvel hasznlva
    #endif
  }
  #else
  if(PIR1bits.TMR1IF)                   // timer1 interrupt ?
  {
    TIMER1COMPLESS;                     // timer1 kompartor hinynak ptlsa
    PIR1bits.TMR1IF = 0;                // nyugtzs
    msec++;
    if(msec >= 1000)
    {
      masodperc++;
      msec = 0; 
    }
    #if (defined LCDUSERTIMER)
    LcdIntProcess();                    // sajt megszaktskezelvel s idztskezelvel hasznlva
    #endif
  }
  #endif
}
