// kszt: Roberto Benjami
// verzi:  v0.50 2014.02

#ifndef __CHARLCD_H
#define __CHARLCD_H

//------------------------------------------------------------------------------
// Karakteres LCD kiszolgl eljrsok
// - Inicializls LcdInit() fggvnnyel (ez prszz msec idt ignyel) 
// - A megjelentend szveget LcdText[] tmbbe tegyk be. 
//   Ez tartalmazza amit a kijelznek meg kell jelentenie. 
//   A #0 karakterek helyett szkzt rhat a kijelzre (belltstl fggen).
//
// zemmdok (az 5 zemmdbl csak egyet vlassz ki!):
//-------------------------------------
// #define LCDMODEONCEBUSY
// - Egyszeri frisstsi zemmd megszakts nlkl, BUSY flag figyelssel:
//   hasznlata:
//     1. Az LcdText[]-be berjuk a megjelentend szveget.
//     2. LcdRefreshAll() fggvny meghvsval tmsoljuk a kijelzbe.
//   korltozsok:
//     R/W lbat a foglaltsgi llapot visszaolvass miatt mindenkpp hasznlni kell (LCDRWUSED).
//     Automata villogtats nem mkdik, csak gy lehet a villogst megvalstani,
//     ha a villogsi temnek megfelel idben BlinkPhase vltozba betesszk 
//     az aktulis villogsi fzist, majd LcdRefreshAll() fggvnyt ismt meghvjuk.
//   megjegyzs: 
//     Az LcdRefreshAll() BLOKKOL tpus fggvny, addig nem tr vissza, 
//     amg a kijelz frisstse folyamatban van.
//     Figyelem! Kijelz nlkl, hibs vagy rosszul bekttt kijelzvel vgtelen ciklusba kerlhet a program.
//
//-------------------------------------
#define LCDMODEONCEDELAY
// - Egyszeri frisstsi zemmd megszakts nlkl, LCD rsi mveletek kztt vrakozsi ciklussal:
//   hasznlata:
//     1. Az LcdText[]-be berjuk a megjelentend szveget.
//     2. LcdRefreshAll() fggvny meghvsval tmsoljuk a kijelzbe.
//   korltozsok:
//     Automata villogtats nem mkdik, csak gy lehet a villogst megvalstani,
//     ha a villogsi temnek megfelel idben BlinkPhase vltozba betesszk 
//     az aktulis villogsi fzist, majd LcdRefreshAll() fggvnyt ismt meghvjuk.
//   megjegyzs: 
//     Lehetsg van a kijelz R/W lbt GND-re ktve egy I/O lbat megsprolni.
//     Az LcdRefreshAll() BLOKKOL tpus fggvny, addig nem tr vissza,
//     amg a kijelz frisstse folyamatban van.
//
//-------------------------------------
// #define LCDMODEONCEIRQ
// - Egyszeri frisstsi zemmd megszaktssal:
//   hasznlata:
//     1. Az LcdText[]-be berjuk a megjelentend szveget.
//     2. LcdRefreshAll() fggvny meghvsval tmsoljuk a kijelzbe.
//   korltozsok:
//     Automata villogtats nem mkdik, csak gy lehet a villogst megvalstani,
//     ha a villogsi temnek megfelel idben BlinkPhase vltozba betesszk 
//     az aktulis villogsi fzist, majd LcdRefreshAll() fggvnyt ismt meghvjuk.
//   megjegyzs:
//     Lehetsg van a kijelz R/W lbt GND-re ktve egy I/O lbat megsprolni.
//     Az LcdRefreshAll() NEM BLOKKOL tpus fggvny, csak elindtja a kijelz frisstst,
//     a frissts maga megszaktsbl fog megtrtnni.
//     A frissts befejeztt az LcdRefreshed() fggvnnyel (valjban ez egy vltoz) krdezhetjk le:
//     pl. a while(!LcdRefreshed()); addig vrakozik, amg a frissts folyamatban van.
//     nmagban nem okoz gondot, ha a frissts befejezse eltt jbl meghvjuk az LcdRefreshAll() fggvnyt.
//     Ilyenkor flbehagyja az elz frisstsi ciklust, s ellrl kezdi.
//     Ha viszont folyamatosan flbeszaktjuk, akkor lehet hogy a szveg vge sosem fog megjelenni mert nem jut el a vgig.
//     8 bites PIC esetn a kzs megszaktskiszolgl fggvnybe be kell illeszteni egy LcdIntProcess() fggvnyhvst.
//
//-------------------------------------
// #define  LCDMODECONTBUSY
// - Folyamatos frisstsi zemmd megszakts nlkl:
//   hasznlata:
//     1. Az LcdText[]-be berjuk a megjelentend szveget
//     2. LcdUpdateChar() fggvnyt folyamatosan hvogatva idvel t fog kerlni a kijelzre
//        (ezt a fggvnyt a f programhurokba rdemes berakni, hogy rendszeresen meghvdjon)
//   korltozsok:
//     R/W lbat a foglaltsgi llapot visszaolvass miatt mindenkpp hasznlni kell (LCDRWUSED).
//     Automata villogtats nem mkdik, csak gy lehet a villogst megvalstani,
//     ha a villogsi temnek megfelel idben BlinkPhase vltozba betesszk az aktulis villogsi fzist.
//     Kurzor nem hasznlhat.
//   megjegyzs: 
//     Az LcdUpdateChar() NEM BLOKKOL tpus fggvny, ha a kijelz foglalt -> azonnal visszatr,
//     ha szabad -> egy (STEREO mdban kett) karaktert r ki a kijelz(k)re.
//     
//-------------------------------------
// #define  LCDMODECONTIRQ
// - Folyamatos frisstsi zemmd megszaktssal:
//   hasznlata:
//     1. Az LcdText[]-be berjuk a megjelentend szveget
//     2. PIC16, PIC18 esetn a kzs megszaktskiszolgl programba beillesztjk
//        az LcdIntProcess() fggvnyhvst.
//   korltozsok:
//     Kurzor nem hasznlhat.
//   megjegyzs: 
//     Lehetsg van a kijelz R/W lbt GND-re ktve egy I/O lbat megsprolni.
//     Automata villogtats csak ebben az zemmdban hasznlhat.

//==============================================================================
// #include "hardwareprofile.h"
// Ha kls hardverprofilt hasznlunk akkor azt itt adhatjuk meg
// - bels hardverprofil esetn kommenteljk ki
// - kls hardverprofil esetn az ott megadott paramtereket ebben a file-ban kommenteljk ki
//------------------------------------------------------------------------------
#define LCD4BITMODE
// 4 bites md
// (ha definilva van, data0..data3 lbak nincsenek hasznlva)
//------------------------------------------------------------------------------
#define LCDRWUSED
// Csak LCDMODEONCEBUSY mdban van szksg van az R/W lbra a BUSY flag lekrdezse miatt.
// Ha kikommenteled a kijelz R/W lbt ksd a GND-re, gy egy I/O lbat megsprrolhatsz.
// Ha be van ktve az R/W lb, de az zemmd miatt nincs szksg r, a program fixen 0-ra lltja)
//------------------------------------------------------------------------------
// LCD kijelz I/O lbak:

#ifndef LCDEPORT     // ha hardwareprofile.h -ban E lb hozzrendelst megadjuk, akkor a tbbit is ott adjuk meg
// E
#define LCDEPORT    'B'
#define LCDEPINNUM   2
// E2
#define LCDE2PORT   'B'
#define LCDE2PINNUM  3
// R/W (interrupt mdban lehet nlklzni)
#define LCDRWPORT   'B'
#define LCDRWPINNUM  0
// RS
#define LCDRSPORT   'B'
#define LCDRSPINNUM  1

// D0
#define LCDDT0PORT  'D'
#define LCDDT0PINNUM 0
// D1
#define LCDDT1PORT  'D'
#define LCDDT1PINNUM 1
// D2
#define LCDDT2PORT  'D'
#define LCDDT2PINNUM 2
// D3
#define LCDDT3PORT  'D'
#define LCDDT3PINNUM 3

// D4
#define LCDDT4PORT  'D'
#define LCDDT4PINNUM 4
// D5
#define LCDDT5PORT  'D'
#define LCDDT5PINNUM 5
// D6
#define LCDDT6PORT  'D'
#define LCDDT6PINNUM 6
// D7
#define LCDDT7PORT  'D'
#define LCDDT7PINNUM 7

#endif  // LCDEPORT

//------------------------------------------------------------------------------
#define SystemClock 20000000
#define CpuClock    20000000
// Rendszer rajel frekvencia (szksges az idztsekhez s a timerek belltshoz)
// (ha a CpuClock megegyezik SystemClock-al, akkor CpuClock-ot nem ktelez megadni)

//==============================================================================
#define LCDLINES           2
// Sorok szma (1, 2, 4 lehet)
//------------------------------------------------------------------------------
#define LCDWIDTH          16
// Soronknti karakterek szma (16, 20, 24, 40 lehet)
//------------------------------------------------------------------------------
// #define LCDSTEREO
// 2 db azonos sorszm szimpla vezrls kijelzt is hasznlhatunk.
// Ekkor a szveg els fele az els, a msodik fele a msodik kijelzn fog megjelenni.
// A kijelzk E lbait E, E2 lbak defincii szerint kell bektni, a tbbi lbat pedig prhuzamosan.
//------------------------------------------------------------------------------
#define LCDTIMERNUM 1
// Timer interrrupt md: a felhasznlt timer kivlasztsa
// (lehetleg olyat, amelyiket nincs msra hasznlva :-)
// - AVR:   0, 1, 2
// - PIC16: 0, 1, 2
// - PIC18: 0, 1, 2, 3
// - PIC24: 1, 2, 3, 4, 5
//------------------------------------------------------------------------------
#define LCDTIMERPR18  -1
// PIC18 csak megszakts mdban: melyik priorits megszaktst hasznlja az idzthz
// lehetsges rtkei:
// - -1 : nincs a tbbszint priorits hasznlva (ilyenkor minden csak a HIGH interruptban megy)
// -  0 : alacsony priorits
// -  1 : magas priorits
//------------------------------------------------------------------------------
// #define LCDUSERTIMER
// Csak megszakts mdban, lehetsg van sajt idzts szerint hivogatni a frisst rutint.
// Ilyenkor nem trtnik meg a TIMER inicializlsa, azt neknk kell megoldanunk.
// Akkor rdemes ezt hasznlni, ha ms clra is hasznlunk idztt, ami a kijelz frisstsi
// temezse szerinti tempban jr.
//------------------------------------------------------------------------------
#define LCDFRAMEPERSEC 20
// Csak megszakts mdban: a kijelz frisstsi sebessge (FPS)
// ajnlott rtk: 20
//------------------------------------------------------------------------------
#define LCDEXECUTIONTIME 50
// Csak LCDMODEONCEDELAY mdban felhasznlva: a kijelz parancsvgrehajtsi ideje (usec)
// (A kijelz adatlapjn EXECUTION TIME talljuk. 40usec a tipikus ideje, legalbb ekkora idt vlasszunk!)
// ajnlott rtk 50
//------------------------------------------------------------------------------
// #define LCDBLINKCHAR
// Villogtathatak a karakterek
// - villogs bekapcsolsa: LcdBlinkChar(n); (n = karakter szma)
// - villogs kikapcsolsa: LcdUnBlinkChar(n); (n = karakter szma)
//------------------------------------------------------------------------------
#define LCDBLINKSPEED 5
// A villog karakterek ennyi ideig frame-ig lesznek sttek s vilgosak
// - csak LCDMODECONTIRQ zemmdban!
// - a tbbi zemmmdban sajt magunknak kell ellltani
//   a villogsi temet s BlinkPhase vltozba rakni !
// - ha LCDMODECONTIRQ zemmdban automatikus helyett
//   sajt villogsi temezst akarsz -> LCDBLINKSPEED 0 rtket adj!
//------------------------------------------------------------------------------
// #define LCDCURSOR
// Kurzorhasznlat engedlyezse (csak egyszeri frisstsi zemmdban)
// - kurzor pozci belltsa: LcdCursorPos = n (0 < n < kijelz(k) karaktereinek szma - 1)
// - kurzor bekapcsolsa: LcdCursorOn()
// - kurzor kikapcsolsa: LcdCursorOff()
// - villog kurzor bekapcsolsa: LcdCursorBlink()
// - villog kurzor kikapcsolsa: LcdCursorUnBlink()
//------------------------------------------------------------------------------
#define LCDZEROCHANGE
// Ha definilva van, az LcdText-ben lev #0 kd karakterek helyett #32 (SPACE) karaktert
// r ki a kijelzre (a szmtalakt fggvnyek #0 karaktert tesznek a szm vgre).
// Kommenteld ki, ha a #0 kd karaktert a felhasznl ltal definilt karakterhez akarod hasznlni.
// (a #0..#7 kd karakter a #8..#15 kdokon is elrhet, ezrt a kikommentelst nem javaslom)
//==============================================================================
// #define USERCHARSET
// Sajt karakterkszlet feltltse inicializlskor.
// Engedlyezve az USERxCHARy fogja definilni a karakterek formjt.
// Ezt t lehet szerkeszteni sajt ignyeink szerint.
//------------------------------------------------------------------------------
// #define USERCHARSETCHANGE
// Karakterkszlet futs alatti vltoztatsnak lehetsge.
// - LcdChangeCharset(char* pch) fggvnnyel lehet feltlteni az aktulis karakterkszletet.
//   a karakterkszletet USERCHARSETARRAY tpus vltozval lehet ltrehozni a RAM-ban.
//------------------------------------------------------------------------------
// Sajt karakterkszlet hasznlata esetn CGRAM-ba fel lehet tlteni 8db 5x8-as karaktert.
// Az albbi minta '0'..'7' szmot definil inverz kijelzssel.
// Ha az 5x8-es karaktermtrix bitje = 0 -> vilgos, 1 -> fekete (vilgos htter kijelz esetn).
// Ezeket elrni a 0..7, ill 8..15 karakterkdokon keresztl lehet.
// Javaslom a 8..15  kdokat hasznlni, mert a program a 0 kdot -> 32 (SPACE) kdd alakthatja.
// Ezt azrt teszi hogy a knyvtri talaktfggvnyek ltal berakott #0 karaktererek
// ne ltszdjanak.
// Figyelem: ha a legals sor fekete, akkor nem ltszik az als vonalas kurzor!

#define USER0CHAR0   0b11111
#define USER0CHAR1   0b11011
#define USER0CHAR2   0b10101
#define USER0CHAR3   0b10101
#define USER0CHAR4   0b10101
#define USER0CHAR5   0b10101
#define USER0CHAR6   0b11011
#define USER0CHAR7   0b11111

#define USER1CHAR0   0b11111
#define USER1CHAR1   0b11101
#define USER1CHAR2   0b11001
#define USER1CHAR3   0b10101
#define USER1CHAR4   0b11101
#define USER1CHAR5   0b11101
#define USER1CHAR6   0b11101
#define USER1CHAR7   0b11111

#define USER2CHAR0   0b11111
#define USER2CHAR1   0b10011
#define USER2CHAR2   0b10101
#define USER2CHAR3   0b11101
#define USER2CHAR4   0b11011
#define USER2CHAR5   0b10111
#define USER2CHAR6   0b10001
#define USER2CHAR7   0b11111

#define USER3CHAR0   0b11111
#define USER3CHAR1   0b10011
#define USER3CHAR2   0b11101
#define USER3CHAR3   0b10011
#define USER3CHAR4   0b11101
#define USER3CHAR5   0b11101
#define USER3CHAR6   0b10011
#define USER3CHAR7   0b11111

#define USER4CHAR0   0b11111
#define USER4CHAR1   0b11101
#define USER4CHAR2   0b11001
#define USER4CHAR3   0b10101
#define USER4CHAR4   0b10001
#define USER4CHAR5   0b11101
#define USER4CHAR6   0b11101
#define USER4CHAR7   0b11111

#define USER5CHAR0   0b11111
#define USER5CHAR1   0b10001
#define USER5CHAR2   0b10111
#define USER5CHAR3   0b10011
#define USER5CHAR4   0b11101
#define USER5CHAR5   0b11101
#define USER5CHAR6   0b10011
#define USER5CHAR7   0b11111

#define USER6CHAR0   0b11111
#define USER6CHAR1   0b11001
#define USER6CHAR2   0b10111
#define USER6CHAR3   0b10011
#define USER6CHAR4   0b10101
#define USER6CHAR5   0b10101
#define USER6CHAR6   0b11011
#define USER6CHAR7   0b11111

#define USER7CHAR0   0b11111
#define USER7CHAR1   0b10001
#define USER7CHAR2   0b11101
#define USER7CHAR3   0b11101
#define USER7CHAR4   0b11011
#define USER7CHAR5   0b10111
#define USER7CHAR6   0b10111
#define USER7CHAR7   0b11111

//******************************************************************************
// Innentl kezdve nem kell belenylni !
//
//==============================================================================
// Hasznlhat adatok:
//
// - char LcdText[] : ebbe a karaktereket tartalmaz tmbbe kell elhelyezni a megjelentend szveget
//
// - unsigned char BlinkPhase : villogsi fzis (ha 0 -> villog karakterek ltszanak, 1 -> nem ltszanak)
//     Megszaktsos folyamatos frisstsi zemmdban, ha LCDBLINKSPEED > 0) nem kell hasznlni,
//     ilyenkor automata mdban megy a villogtats
//     A tbbi zemmdban neknk kell a villogsi temezst biztostani)
//
// - unsigned char LcdCursorPos : kurzor pozci (egyszeri frisstsi zemmdban, ha engedlyezve van)
//
// - USERCHARSETARRAY : a futs kzbeni felhasznli karakterkszletet ilyen tpus vltozba lehet eltrolni
//                      ez egy 64karaktert trol tmb 
//==============================================================================
// Hasznlhat/hasznland fggvnyek:
//
// - LcdInit() : Az LCD inicializst, s a felhasznli karakterek feltltst vgzi (futsi ideje kb. 130msec).
//
// - LcdProcess() : LCDMODECONTBUSY zemmdban ezt kell rendszeresen meghvni, hogy frissljn a kijelz tartalma.
//
// - LcdIntProcess() : PIC16xxx, PIC18xxx megszaktsos zemmdban a kzs megszaktskiszolglbl kell ezt a fggvnyt meghvni.
//                     Lehetsg van sajt idztsbl is hivogatni a frisst rutint, akkor is ezt kell hasznlni (AVR s PIC24-en is).
//
// - LcdBlinkChar(n) : 'n'-edik karakter (0..karakterek szma-1) villogni fog
//
// - LcdUnBlinkChar(n) : 'n'-edik karakter (0..karakterek szma-1) nem fog villogni
//
// - LcdRefreshStart() : Megszaktsos zemmdban ezzel lehet az ideiglenesen lelltott frisstst jra elindtani.
//
// - LcdRefreshStop() : Megszaktsos zemmdban ezzel lehet a frisstst ideiglenesen lelltani.
//                      Pl. ha pontos idzts miatt nem akarjuk, hogy megszakts keletkezzen az LCD miatt.
//
// - LcdRefreshAll() : Egyszeri frisstsi zemmdban ha jra szeretnnk rni az LCD-t ezzel tehetjk meg.
//                     Akkor clszer ezt megtenni, amikor az LcdText tmbben teljesen sszellt a megjelentend szveg
//                     Megszakts nlkl addig a fggvnyben marad, amg az LCD rsa tart,
//                     megszaktsos mdban rgtn visszatr. Ekkor az rs befejztt az LcdRefreshed() fggvnnyel krdezhetjk le.
//
// - LcdRefreshed() : Megszaktsos egyszeri frisstsi zemmdban:
//                    ha a visszatr rtk == 0 -> LcdRefreshAll() fggvnyhvs utn mg tart a frissts
//                    pl. a while(!LcdRefreshed()); addig vrakozik, amg a frissts folyamatban van
//
// - LcdCursorOn()      : Kurzor bekapcsolsa.
// - LcdCursorOff()     : Kurzor kikapcsolsa.
// - LcdCursorBlink()   : Kurzor villogs bekapcsolsa.
// - LcdCursorUnBlink() : Kurzor villogs kikapcsolsa (egy als vonal marad a kurzor).
//
// - LcdChangeCharset(char* pch) : Futs alatt a felhasznli karakterkszlet cserje.
//                                 Paramterknt a karaktereket trol 64bjtos tmb cmt (USERCHARSETARRAY) kell megadni.
//
//------------------------------------------------------------------------------

// Szveg tmb (STEREO kijelz esetn dupla mret lesz)
#ifdef LCDSTEREO
extern volatile char LcdText[2UL * LCDWIDTH * LCDLINES + 1];
#else  // LCDSTEREO
extern volatile char LcdText[1UL * LCDWIDTH * LCDLINES + 1];
#endif // LCDSTEREO

// Villogs tmb, villogs ki/be
#ifdef LCDBLINKCHAR
#ifdef LCDSTEREO
extern volatile char LcdBlink[(2UL * LCDWIDTH * LCDLINES + 7) / 8];
#else  // LCDSTEREO
extern volatile char LcdBlink[(1UL * LCDWIDTH * LCDLINES + 7) / 8];
#endif // LCDSTEREO
extern volatile unsigned char BlinkPhase;// 0 = villog karakterek ltszanak, egybknt nem ltszik
#define LcdBlinkChar(s) LcdBlink[ s >> 3 ] |= (1 << ( s & 7))
#define LcdUnBlinkChar(s) LcdBlink[ s >> 3 ] &= ~(1 << ( s & 7))
#endif // LCDBLINKCHAR

// Felhasznli karakterkszlet
#ifdef USERCHARSET
typedef unsigned char USERCHARSETARRAY[64];
#if defined(__18CXX)
extern rom USERCHARSETARRAY userromcharset;
#else  // defined(__18CXX)
extern const USERCHARSETARRAY userromcharset; 
#endif // else defined(__18CXX)
#ifdef USERCHARSETCHANGE
void LcdChangeCharset(char* pch);
#endif // USERCHARSETCHANGE
#endif // USERCHARSET

// Kurzor
#ifdef LCDCURSOR
#define LcdCursorOn()         LcdCursorType |= 2
#define LcdCursorOff()        LcdCursorType &= ~2
#define LcdCursorBlink()      LcdCursorType |= 1
#define LcdCursorUnBlink()    LcdCursorType &= ~1
extern volatile unsigned char LcdCursorType;
extern volatile unsigned char LcdCursorPos;
#endif  // LCDCURSOR

// LCD inicializlsa
void LcdInit(void);

// Egy karakter frisstse (csak folyamatos frisstsi zemmdban, megszakts nlkl)
#ifdef LCDMODECONTBUSY
void LcdProcess(void);
#endif

// Teljes kijelztartalom frisstse (csak egyszeri frisstsi zemmdban)
#if ((defined LCDMODEONCEBUSY) || (defined LCDMODEONCEDELAY) || (defined LCDMODEONCEIRQ))
void LcdRefreshAll(void);
#endif

//------------------------------------------------------------------------------
#if ((defined LCDMODEONCEIRQ) || (defined LCDMODECONTIRQ))

#ifdef LCDUSERTIMER

// sajt megszaktskezelvel s idztskezelvel hasznlva
extern unsigned char LcdIrqStatus;
void LcdProcess(void);
#define LcdIntProcess()    if(!LcdIrqStatus)LcdProcess()
#define LcdRefreshStart()  LcdIrqStatus = 0
#define LcdRefreshStop()   LcdIrqStatus = 1
#ifdef  LCDMODEONCEIRQ
#define LcdRefreshed()     LcdIrqStatus
#endif // LCDMODEONCEIRQ

#else  // LCDUSERTIMER
// AVR: LcdRefreshStart(), LcdRefreshStop(), LcdRefreshed()
#if (defined(__AVR__))

#if LCDTIMERNUM == 0
#if defined OCR0 || defined OCR0A
#ifdef TIMSK0
#define LcdRefreshStart()  TIMSK0 = (1<<OCIE0A)
#define LcdRefreshStop()   TIMSK0 = 0
#define LcdRefreshed()     (!TIMSK0)
#else  // TIMSK0
#define LcdRefreshStart()  TIMSK |= (1<<OCIE0)
#define LcdRefreshStop()   TIMSK &= ~(1<<OCIE0)
#define LcdRefreshed()     (!(TIMSK & (1<<OCIE0)))
#endif // TIMSK0
#else  // defined OCR0 || defined OCR0A
#define LcdRefreshStart()  TIMSK = (1<<TOIE0)
#define LcdRefreshStop()   TIMSK = 0
#define LcdRefreshed()     (!TIMSK)
#endif // defined OCR0 || defined OCR0A

#elif LCDTIMERNUM == 1
// timer bekapcsols
#ifdef TIMSK1
#define LcdRefreshStart()  TIMSK1 = (1<<OCIE1A)
#define LcdRefreshStop()   TIMSK1 = 0
#define LcdRefreshed()     (!TIMSK1)
#else  // TIMSK1
#define LcdRefreshStart()  TIMSK |= (1<<OCIE1A)
#define LcdRefreshStop()   TIMSK &= ~(1<<OCIE1A)
#define LcdRefreshed()     (!(TIMSK & (1<<OCIE1A)))
#endif // TIMSK1

#elif LCDTIMERNUM == 2
#ifdef TIMSK2
#define LcdRefreshStart()  TIMSK2 = (1<<OCIE2A)
#define LcdRefreshStop()   TIMSK2 = 0
#define LcdRefreshed()     (!TIMSK2)
#else  // TIMSK2
#define LcdRefreshStart()  TIMSK |= (1<<OCIE2)
#define LcdRefreshStop()   TIMSK &= ~(1<<OCIE2)
#define LcdRefreshed()     (!(TIMSK & (1<<OCIE2)))
#endif // TIMSK2
#endif // LCDTIMERNUM
#endif // defined(__AVR__)

//------------------------------------------------------------------------------
// PIC16: LcdIntProcess(), LcdRefreshStart(), LcdRefreshStop(), LcdRefreshed()
// interruptba LcdIntProcess() fggvnyt be kell tenni
#if (defined(_PIC14) || defined(_PIC14E))
void LcdProcess(void);

#if LCDTIMERNUM == 0
#define LcdIntProcess()    if(INTCONbits.T0IE && INTCONbits.T0IF)LcdProcess()
#define LcdRefreshStart()  INTCONbits.T0IE = 1
#define LcdRefreshStop()   INTCONbits.T0IE = 0
#define LcdRefreshed()     (!INTCONbits.T0IE)
#elif LCDTIMERNUM == 1
#define LcdIntProcess()    if(PIR1bits.TMR1IF)LcdProcess()
#define LcdRefreshStart()  T1CONbits.TMR1ON = 1
#define LcdRefreshStop()   T1CONbits.TMR1ON = 0
#define LcdRefreshed()     (!T1CONbits.TMR1ON)
#elif LCDTIMERNUM == 2
#define LcdIntProcess()    if(PIR1bits.TMR2IF)LcdProcess()
#define LcdRefreshStart()  T2CONbits.TMR2ON = 1
#define LcdRefreshStop()   T2CONbits.TMR2ON = 0
#define LcdRefreshed()     (!T2CONbits.TMR2ON)
#endif // LCDTIMERNUM
#endif // defined(_PIC14)

//------------------------------------------------------------------------------
// PIC18: LcdIntProcess(), LcdRefreshStart(), LcdRefreshStop(), LcdRefreshed()
// LCDTIMERPR18 ltal meghatrozott interruptba LcdIntProcess() fggvnyt be kell tenni
#if ((defined(__18CXX)) || (defined(__PICC18__)))
void LcdProcess(void);

#if LCDTIMERNUM == 0
#define LcdIntProcess()    if(INTCONbits.TMR0IF)LcdProcess()
#define LcdRefreshStart()  T0CONbits.TMR0ON = 1
#define LcdRefreshStop()   T0CONbits.TMR0ON = 0
#define LcdRefreshed()     (!T0CONbits.TMR0ON)
#elif LCDTIMERNUM == 1
#define LcdIntProcess()    if(PIR1bits.TMR1IF)LcdProcess()
#define LcdRefreshStart()  T1CONbits.TMR1ON = 1
#define LcdRefreshStop()   T1CONbits.TMR1ON = 0
#define LcdRefreshed()     (!T1CONbits.TMR1ON)
#elif LCDTIMERNUM == 2
#define LcdIntProcess()    if(PIR1bits.TMR2IF)LcdProcess()
#define LcdRefreshStart()  T2CONbits.TMR2ON = 1
#define LcdRefreshStop()   T2CONbits.TMR2ON = 0
#define LcdRefreshed()     (!T2CONbits.TMR2ON)
#elif LCDTIMERNUM == 3
#define LcdIntProcess()    if(PIR2bits.TMR3IF)LcdProcess()
#define LcdRefreshStart()  T3CONbits.TMR3ON = 1
#define LcdRefreshStop()   T3CONbits.TMR3ON = 0
#define LcdRefreshed()     (!T3CONbits.TMR3ON)
#endif // LCDTIMERNUM
#endif // defined(__18CXX)

//------------------------------------------------------------------------------
// PIC30: LcdRefreshStart(), LcdRefreshStop(), LcdRefreshed()
#if (defined(__C30__))

#if LCDTIMERNUM == 1
#define LcdRefreshStart()  T1CONbits.TON = 1
#define LcdRefreshStop()   T1CONbits.TON = 0
#define LcdRefreshed()     (!T1CONbits.TON)
#elif LCDTIMERNUM == 2
#define LcdRefreshStart()  T2CONbits.TON = 1
#define LcdRefreshStop()   T2CONbits.TON = 0
#define LcdRefreshed()     (!T2CONbits.TON)
#elif LCDTIMERNUM == 3
#define LcdRefreshStart()  T3CONbits.TON = 1
#define LcdRefreshStop()   T3CONbits.TON = 0
#define LcdRefreshed()     (!T3CONbits.TON)
#elif LCDTIMERNUM == 4
#define LcdRefreshStart()  T4CONbits.TON = 1
#define LcdRefreshStop()   T4CONbits.TON = 0
#define LcdRefreshed()     (!T4CONbits.TON)
#elif LCDTIMERNUM == 5
#define LcdRefreshStart()  T5CONbits.TON = 1
#define LcdRefreshStop()   T5CONbits.TON = 0
#define LcdRefreshed()     (!T5CONbits.TON)
#endif // LCDTIMERNUM
#endif // defined(__C30__)

#endif // else LCDUSERTIMER

#endif // ((defined LCDMODEONCEIRQ) || (defined LCDMODECONTIRQ))

#endif // __CHARLCD_H
