//------------------------------------------------------------------------------
// Kszt: Roberto Benjami (robertodebenjami(kukac)gmail(pont)com)
// Verzi:  v0.50 2014.02

//------------------------------------------------------------------------------
// Mdostsok:
// 0.4 els kzztett verzi

// 0.41:
// - jav: Dupla vezrl felhasznli karakterkszlet feltlts javtsa (SETDDRAMADDR -> SETCGRAMADDR).
// - opt: LcdWrite2()-ben felesleges RS-t jra belltani, mikor LcdWrite()-ban mr belltsra kerlt.
// - opt: LcdWrite2()-ben felesleges az adatirnylbakat jra belltani, mikor LcdWrite()-ban mr belltsra kerlt.

// 0.42:
// - opt: Veremmveletek cskkentse miatt LcdWrite() paramter nlkliv alaktva.
//        (ch gy is ott van globlis vltozknt, RS lb belltsa, meg a hvs eltt trtnik)
// - jav: Egysoros kijelz esetn mr egy sorosknt is inicializl (LCD_LINES -> LCDLINES).

// 0.43
// - jav: C18 fordt "LCDWIDTH * LCDLINES + 1" kifejezst, ha > 127 rosszul rtkeli ki -> 1UL szorzval javtva
// - jav: C18 fordt "LCDWIDTH * LCDLINES + 7) / 8" kifejezst rosszul rtkelheti ki -> 1UL szorzval javtva

// 0.44
// - j:  Megszaktsos mdban lehetsg van a frisstst ki/bekapcsolni (pl. ha pontos idztsre van szksg)
//        a LcdRefreshStart(), LcdRefreshStop() fggvnyhvssal.
//        (ekkor az esetlegesen villog karakterek is az aktulis llapotban maradnak)

// 0.45
// - j:  Lehetsg van a folyamatos mellett, egyszeri frisstsi zemmdra is.
//        Ekkor LcdRefreshAll() hvsval lehet a kijelz tartalmt jrarni.
//        Megszaktsos mdban LcdRefreshed() visszatr rtkbl megllapthat befejezte-e a frisstst.
//        (megszakts nlkli mdban a fggvnyben marad a frissts vgig, gy erre nincs szksg)
// - jav: AVR timer2: #ifdef TIMER0_COMP_vect -> #ifdef TIMER2_COMP_vect
// - j:  ATMEGA8 compartor nlkli TIMER0-nak a hasznlati lehetsge
// - jav: FPS->CPS timer szmtshoz a DDRAM lltsi ciklust is bekalkullja
// - j:  LCDZEROCHANGETEXT defincival (ez a charlcd.c -ben van kivtelesen) az LcdText-ben is szkzre cserli a #0 karaktereket.

// 0.46
// - j:  LCDSTEREO defincit hasznlva 2db kijelzt is hasznlhatunk.

// 0.47
// - j:  LCDCURSOR defincit hasznlva lehetsg van a kurzor hasznlatra (csak egyszeri frisstsi zemmdban).

// 0.48
// - j:  USERCHARSETCHANGE defincit hasznlva lehetsg van futs alatt felhasznli karakterkszletet cserlni.

// 0.49
// - j:  HI-TECH C18 fordt hozzadsa
// - j:  jabb zemmd (megszakts nlkl egyszeri frisstsi zemmdban BUSY flag figyels helyett bellthat vrakozssal)
// - j:  Az 5 zemmd kztt az elnevezsvel lehet vlasztani

// 0.50
// - j:  sszefrhetetlen belltsok kiszrse
// - j:  PIC18: vlaszthat priorits nlki, alacsony, magas priorits hasznlata megszaktsos mdban
// - j:  Megszakts mdban sajt megszaktskezelssel megoldani az LCD frisstsi eljrsnak hivst
// - j:  TOUTPS - T2OUTPS fordtsi hibazenet esetn knny tlls a msik verzira
// - jav: Karakterkszlet nem 5x7, hanem 5x8 pixeles
// - jav: USERCHARSET s USERCHARSETCHANGE fggetlentse egymstl

//------------------------------------------------------------------------------
// Ha ez definilva van, a frissts sorn az Lcdtext[] tmbben is kicserlgeti a #0 karaktereket szkzre
// (ltalban nincs erre szksg, csak ha ms clra is fel szeretnnk hasznlni a szveget)
// #define LCDZEROCHANGETEXT
//------------------------------------------------------------------------------
// Szoftver szimultorhoz: kihagyja az LcdBusy fggvnyt (figyelem: engedlyezve a kijelz nem fog mkdni!)
// #define SOFTSIMBUSY
// Szoftver szimultorhoz: inicializlskor a vrakozsi ciklusok kihagysa (figyelem: engedlyezve a kijelz nem fog mkdni!)
// #define SOFTSIMFAST
//------------------------------------------------------------------------------
// C18 fordt proc include file-ban a TIMER2 eloszt megnevezshez hol TOUTPSx, hol meg T2OUTPSx nevet hasznltak.
// Ha fordts kzben TOUTPS vagy T2OUTPS definciit nem tallja, akkor itt vltoztasd meg!
// #define T2OUTPS
//------------------------------------------------------------------------------

// processzorcsald include
#if defined(__AVR__)
#include <avr/io.h>
#include <avr/interrupt.h>
#include <compat/ina90.h>
#elif (defined(_PIC14) || defined(_PIC14E))
#include <pic.h>
#elif defined(__PICC18__)
#include <htc.h>
#elif defined(__18CXX)
#include <p18cxxx.h>
#elif defined(__C30__)
#if defined(__dsPIC30F__)
#include <p30Fxxxx.h>
#elif defined(__dsPIC33F__)
#include <p33Fxxxx.h>
#elif defined(__PIC24F__)
#include <p24Fxxxx.h>
#elif defined(__PIC24FK__)
#include <p24Fxxxx.h>
#elif defined(__PIC24H__)
#include <p24Hxxxx.h>
#else
#error "ismeretlen processzortpus"
#endif
#endif // defined(xxx proci)

#include "charlcd.h"
#include "charlcdio.h"

//------------------------------------------------------------------------------
// sszefrhetetlen belltsok kiszrse
#if !((defined LCDMODEONCEBUSY) || (defined LCDMODEONCEDELAY) || (defined LCDMODEONCEIRQ) || (defined LCDMODECONTBUSY) || (defined LCDMODECONTIRQ)) 
#error "Valamelyik zemmdot vlaszd ki!"
#endif

#ifdef LCDMODEONCEBUSY
#if ((defined LCDMODEONCEDELAY) || (defined LCDMODEONCEIRQ) || (defined LCDMODECONTBUSY) || (defined LCDMODECONTIRQ)) 
#error "Csak 1 zemmdot llts be!"
#endif
#ifndef LCDRWUSED
#error "LCD MODEONCEBUSY zemmdban ktelez hasznlni az RW lbat!"
#endif
#ifdef LCDUSERTIMER
#error "LCD USERTIMER csak megszaktsos mdban hasznlhat"
#endif
#endif

#ifdef LCDMODEONCEDELAY
#if ((defined LCDMODEONCEBUSY) || (defined LCDMODEONCEIRQ) || (defined LCDMODECONTBUSY) || (defined LCDMODECONTIRQ))
#error "Csak 1 zemmdot llts be!"
#endif
#ifndef LCDEXECUTIONTIME
#error "LCD MODEONCEDELAY zemmdban LCDEXECUTIONTIME rtkt is meg kell adni!"
#endif
#ifdef LCDUSERTIMER
#error "LCD USERTIMER csak megszaktsos mdban hasznlhat"
#endif
#endif

#ifdef LCDMODEONCEIRQ
#if ((defined LCDMODEONCEBUSY) || (defined LCDMODEONCEDELAY) || (defined LCDMODECONTBUSY) || (defined LCDMODECONTIRQ))
#error "Csak 1 zemmdot llts be!"
#endif
#endif

#ifdef LCDMODECONTBUSY
#if ((defined LCDMODEONCEBUSY) || (defined LCDMODEONCEDELAY) || (defined LCDMODEONCEIRQ) || (defined LCDMODECONTIRQ))
#error "Csak 1 zemmdot llts be!"
#endif
#ifndef LCDRWUSED
#error "LCD MODECONTBUSY zemmdban ktelez hasznlni az RW lbat!"
#endif
#ifdef LCDCURSOR
#error "LCD MODECONTBUSY zemmdban LCD CURSOR nem hasznlhat!"
#endif
#ifdef LCDUSERTIMER
#error "LCD USERTIMER csak megszaktsos mdban hasznlhat"
#endif
#endif

#ifdef LCDMODECONTIRQ
#if ((defined LCDMODEONCEBUSY) || (defined LCDMODEONCEDELAY) || (defined LCDMODEONCEIRQ) || (defined LCDMODECONTBUSY))
#error "Csak 1 zemmdot llts be!"
#endif
#ifdef LCDCURSOR
#error "LCD MODECONTIRQ zemmdban LCD CURSOR nem hasznlhat!"
#endif
#endif

#if (LCDLINES != 1) && (LCDLINES != 2) && (LCDLINES != 4)
#error "A driver csak 1, 2, 4 soros kijelzvel hasznlhat!"
#endif

#if (LCDWIDTH > 40)
#error "A driver maximum 40 karakter szles kijelzvel hasznlhat!"
#endif

//------------------------------------------------------------------------------
// rendszerrajel
#ifndef SystemClock
#error  "Nincs rendszerrajel frekvencia definilva!"
#endif

// ha CPU rajel frekvencia nincs megadva akkor a rendszerrajellel megegyezik
#ifndef CpuClock
#define CpuClock SystemClock
#endif

// processzorcsald szerinti rajel osztsok
#if defined(__AVR__)
#define CpuMips (1UL*CpuClock)
#define DELAYNUM (CpuMips/1000/14)
#define LCDPROCCYCLENULL   109
#define LCDPROCCYCLENULLSTEREO   192
#define TimerSrcClock (1UL*SystemClock)
#elif (defined(_PIC14) || defined(_PIC14E))
#define CpuMips (1UL*CpuClock/4)
#define DELAYNUM (CpuMips/1000/10)
#define LCDPROCCYCLENULL   61
#define LCDPROCCYCLENULLSTEREO   100
#define TimerSrcClock (1UL*SystemClock/4)
#elif defined(__18CXX)
#define CpuMips (1UL*CpuClock/4)
#define DELAYNUM (CpuMips/1000/8)
#define LCDPROCCYCLENULL   67
#define LCDPROCCYCLENULLSTEREO   107
#define TimerSrcClock (1UL*SystemClock/4)
#elif defined(__PICC18__)
#define CpuMips (1UL*CpuClock/4)
#define DELAYNUM (CpuMips/1000/8)
#define LCDPROCCYCLENULL   61
#define LCDPROCCYCLENULLSTEREO   100
#define TimerSrcClock (1UL*SystemClock/4)
#elif defined(__C30__)
#if defined(__dsPIC30F__)
#define CpuMips (1UL*CpuClock/4)
#define DELAYNUM (CpuMips/1000/7)
#define LCDPROCCYCLENULL   90
#define LCDPROCCYCLENULLSTEREO   100
#define TimerSrcClock (1UL*SystemClock/4)
#elif defined(__dsPIC33F__)
#define CpuMips (1UL*CpuClock/2)
#define DELAYNUM (CpuMips/1000/7)
#define LCDPROCCYCLENULL   90
#define LCDPROCCYCLENULLSTEREO   159
#define TimerSrcClock (1UL*SystemClock/2)
#elif defined(__PIC24F__)
#define CpuMips (1UL*CpuClock/2)
#define DELAYNUM (CpuMips/1000/7)
#define LCDPROCCYCLENULL   90
#define LCDPROCCYCLENULLSTEREO   159
#define TimerSrcClock (1UL*SystemClock/2)
#elif defined(__PIC24FK__)
#define CpuMips (1UL*CpuClock/2)
#define DELAYNUM (CpuMips/1000/7)
#define LCDPROCCYCLENULL   90
#define LCDPROCCYCLENULLSTEREO   159
#define TimerSrcClock (1UL*SystemClock/2)
#elif defined(__PIC24H__)
#define CpuMips (1UL*CpuClock/2)
#define DELAYNUM (CpuMips/1000/7)
#define LCDPROCCYCLENULL   90
#define LCDPROCCYCLENULLSTEREO   159
#define TimerSrcClock (1UL*SystemClock/2)
#else
#error "ismeretlen processzortpus"
#endif
#endif // defined(xxx proci)

//------------------------------------------------------------------------------
// karakterenknti frisstsi frekvencia (csak interrupt mdban)
// (ha 80 karakteresnl nagyobb, akkor a fele, mert egyszerre 2 karaktert frisst)
#if (1UL * LCDLINES * LCDWIDTH > 160)
#error "Maximum 2x80 karakteres lehet a kijelz"
#endif

#if (1UL * LCDLINES * LCDWIDTH > 80)

#ifdef  LCDSTEREO
#error  "2 kijelzt hasznlva, egyenknt legfeljebb 80 karakteresek lehetnek"
#endif

#if     LCDLINES != 4
#error  "80 karakteresnl nagyobbkijelz, csak 4 sorosban ltezik!"
#endif

// a 80 karakteresnl nagyobbat, 2db 2 sorosnak tekintjk
#undef  LCDLINES
#define LCDLINES        2
#define LCDSTEREO
#endif

#define LCDCHARPERMODUL (1UL * LCDLINES * LCDWIDTH)
#define LCDCHARPERSEC   (1UL * LCDFRAMEPERSEC * (LCDLINES * LCDWIDTH + LCDLINES))

// LCD memriacmek (1..4 sorok kezdete)
#define SETDDRAMADDR1  0x80
#define SETDDRAMADDR2  0xC0
#define SETDDRAMADDR3  (0x80 + LCDWIDTH)
#define SETDDRAMADDR4  (0xC0 + LCDWIDTH)

#define SETCGRAMADDR   0x40

// megszakts zemmdban a timer belltsok
#if (!defined LCDUSERTIMER) && ((defined LCDMODEONCEIRQ) || (defined LCDMODECONTIRQ))

//==============================================================================
// timer interfsz
//==============================================================================

// timer kivlasztsa
#define TIMERNUM LCDTIMERNUM

// frekvencia megadsa
#define TIMECLK  LCDCHARPERSEC

// ennyivel kell elosztani a rendszerrajelet
#define TIMEDIV ((TimerSrcClock+TIMECLK/2)/TIMECLK)

// PIC24: timer IRQ prioritsa (1=legalacsonyabb, 7=legmagasabb)
#define TIMERPR24      1

// timer megszakts kiszolgl szubrutin max. futsi ideje (CPU utastsszm)
#define TIMESUBCIKL_AVR    50
#define TIMESUBCIKL_PIC16 200 
#define TIMESUBCIKL_PIC18 200
#define TIMESUBCIKL_PIC24  50

//==============================================================================
// timer
//==============================================================================

// AVR
#if defined(__AVR__)
#include <avr/interrupt.h>
#include <compat/ina90.h>

// a megszakts kiszolgl fggvny vgrehajtsi idejtl fggen
#if TIMEDIV < TIMESUBCIKL_AVR
#error "AVR: timer frekvencia tl magas"
#endif

// a megszaktst nem szksges nyugtzni
#define  TIMERCOMPLESS ;

//------------------------------------------------------------------------------
// AVR timer0
#if TIMERNUM == 0

// oszt
#if TIMEDIV < 256
#define TMCLKDIV         1
#define TMCLKSEL         1
#elif TIMEDIV < (256*8)
#define TMCLKDIV         8
#define TMCLKSEL         2
#elif TIMEDIV < (256*64)
#define TMCLKDIV        64
#define TMCLKSEL         3
#elif TIMEDIV < (256*256)
#define TMCLKDIV       256
#define TMCLKSEL         4
#elif TIMEDIV < (256*1024)
#define TMCLKDIV      1024
#define TMCLKSEL         5
#else
#error "AVR: timer frekvencia tl alacsony"
#endif // TIMEDIV

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

#if defined OCR0 || defined OCR0A
// kompartoros timer0
#ifdef  TCCR0A
#ifdef  TCCR0B // (A/B regiszteres TIMER0)
#define TIMERINIT {\
  OCR0A = TMCOMP;                       /* comparator */\
  TCCR0A = (1<<WGM01);                  /* MODE1 */\
  TCCR0B = (TMCLKSEL<<CS00);            /* frekvencia oszts */\
  sei();}
#else // TCCR0B (A regiszteres TIMER0)
#define TIMERINIT {\
  OCR0A = TMCOMP;                       /* comparator */\
  TCCR0A = (1<<CTC0)|(TMCLKSEL<<CS00);  /* CTC mode, frekvencia oszts */\
  sei();}
#endif // else TCCR0B
#else  // TCCR0A
#define TIMERINIT {\
  OCR0 = TMCOMP;                        /* comparator */\
  TCCR0 = (1<<WGM01)|(TMCLKSEL<<CS00);  /* CTC mode, frekvencia oszts */\
  sei();}
#endif // TCCR0A

// timer megszakts kiszolgl fggvny
#ifdef  TIMER0_COMP_vect
#define TIMERINTPROCESS  ISR (TIMER0_COMP_vect)
#else
#define TIMERINTPROCESS  ISR (TIMER0_COMPA_vect)
#endif

#else   // defined OCR0 || defined OCR0A
// kompartor nlkli timer0

#define TIMERINIT {\
  TCNT0 = 255 - TMCOMP;                 /* comparator helyett kezdrtk */\
  TCCR0 = TMCLKSEL<<CS00;               /* frekvencia oszts */\
  TIMSK |= (1<<TOIE0);                  /* overflow IRQ eng */\
  sei();}

#define TIMERINTPROCESS  ISR (TIMER0_OVF_vect)

#define LcdRefreshStart()  TIMSK = (1<<TOIE0)
#define LcdRefreshStop()   TIMSK = 0

// hardver kompartort ptolni kell
#undef  TIMERCOMPLESS
#define TIMERCOMPLESS      TCNT0 += (255 - TMCOMP)

#endif  // defined OCR0 || defined OCR0A

//------------------------------------------------------------------------------
// AVR timer1
#elif TIMERNUM == 1

// oszt
#if TIMEDIV < 65536
#define TMCLKDIV         1
#define TMCLKSEL         1
#elif TIMEDIV < (65536*8)
#define TMCLKDIV         8
#define TMCLKSEL         2
#elif TIMEDIV < (65536*64)
#define TMCLKDIV        64
#define TMCLKSEL         3
#elif TIMEDIV < (65536*256)
#define TMCLKDIV       256
#define TMCLKSEL         4
#elif TIMEDIV < (65536*1024)
#define TMCLKDIV      1024
#define TMCLKSEL         5
#else
#error "AVR: timer frekvencia tl alacsony"
#endif // TIMEDIV

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

// timer inicializls
#define TIMERINIT {\
  OCR1AH = TMCOMP >> 8;                 /* comparator HI */\
  OCR1AL = (unsigned char)TMCOMP;       /* comparator LO */\
  TCCR1A = (0<<WGM10);                  /* mode4 (CTC) */\
  TCCR1B = (1<<WGM12)|(TMCLKSEL<<CS10); /* mode4, Clk = ClkIO/1..8..64..256..1024 */\
  sei();}
  
// timer megszakts kiszolgl fggvny
#define TIMERINTPROCESS  ISR (TIMER1_COMPA_vect)

//------------------------------------------------------------------------------
// AVR timer2
#elif TIMERNUM == 2

// oszt
#if TIMEDIV < 256
#define TMCLKDIV         1
#define TMCLKSEL         1
#elif TIMEDIV < (256*8)
#define TMCLKDIV         8
#define TMCLKSEL         2
#elif TIMEDIV < (256*32)
#define TMCLKDIV        32
#define TMCLKSEL         3
#elif TIMEDIV < (256*64)
#define TMCLKDIV        64
#define TMCLKSEL         4
#elif TIMEDIV < (256*128)
#define TMCLKDIV       128
#define TMCLKSEL         5
#elif TIMEDIV < (256*256)
#define TMCLKDIV       256
#define TMCLKSEL         6
#elif TIMEDIV < (256*1024)
#define TMCLKDIV      1024
#define TMCLKSEL         7
#else
#error "AVR: timer a frekvencia tl alacsony"
#endif // TIMEDIV

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

// timer inicializls
#ifdef TCCR2A
#define TIMERINIT {\
  OCR2A = TMCOMP;                       /* comparator */\
  TCCR2A = (1<<WGM21);                  /* mode 1 (CTC) */\
  TCCR2B = (TMCLKSEL<<CS20);            /* oszt */\
  sei();}
#else  // TCCR2A
#define TIMERINIT {\
  OCR2  = TMCOMP;                       /* comparator */\
  TCCR2  = (1<<WGM21)|(TMCLKSEL<<CS20); /* mode (CTC), oszt */\
  sei();}
#endif // TCCR2A
  
// timer megszakts kiszolgl fggvny
#ifdef  TIMER2_COMP_vect
#define TIMERINTPROCESS ISR (TIMER2_COMP_vect)
#else
#define TIMERINTPROCESS ISR (TIMER2_COMPA_vect)
#endif

#else  // TIMERNUM
#error "AVR: csak a timer 0, 1, 2 vlaszthat"
#endif // TIMERNUM

// nem szksges a csldordulst jelz bitet trlni
#define TIMERIRQACK ;

// AVR
//==============================================================================
// PIC16
#elif (defined(_PIC14) || defined(_PIC14E))

// a megszakts kiszolgl fggvny vgrehajtsi idejtl fggen
#if TIMEDIV < TIMESUBCIKL_PIC16
#error "PIC16: timer frekvencia tl magas"
#endif

//------------------------------------------------------------------------------
// PIC16 timer0
#if TIMERNUM == 0

// oszt
#if TIMEDIV < 256
#define TMCLKDIV       1
#define TMCLKSEL       OPTION_REGbits.PSA = 1
#define TMCOMPCOR      2
#elif TIMEDIV < (256*2)
#define TMCLKDIV       2
#define TMCLKSEL       OPTION_REGbits.PS = 0; OPTION_REGbits.PSA = 0
#define TMCOMPCOR      1
#elif TIMEDIV < (256*4)
#define TMCLKDIV       4
#define TMCLKSEL       OPTION_REGbits.PS = 1; OPTION_REGbits.PSA = 0
#define TMCOMPCOR      0
#elif TIMEDIV < (256*8)
#define TMCLKDIV       8
#define TMCLKSEL       OPTION_REGbits.PS = 2; OPTION_REGbits.PSA = 0
#define TMCOMPCOR      0
#elif TIMEDIV < (256*16)
#define TMCLKDIV       16
#define TMCLKSEL       OPTION_REGbits.PS = 3; OPTION_REGbits.PSA = 0
#define TMCOMPCOR      0
#elif TIMEDIV < (256*32)
#define TMCLKDIV       32
#define TMCLKSEL       OPTION_REGbits.PS = 4; OPTION_REGbits.PSA = 0
#define TMCOMPCOR      0
#elif TIMEDIV < (256*64)
#define TMCLKDIV       64
#define TMCLKSEL       OPTION_REGbits.PS = 5; OPTION_REGbits.PSA = 0
#define TMCOMPCOR      0
#elif TIMEDIV < (256*128)
#define TMCLKDIV       128
#define TMCLKSEL       OPTION_REGbits.PS = 6; OPTION_REGbits.PSA = 0
#define TMCOMPCOR      0
#elif TIMEDIV < (256*256)
#define TMCLKDIV       256
#define TMCLKSEL       OPTION_REGbits.PS = 7; OPTION_REGbits.PSA = 0
#define TMCOMPCOR      0
#else
#error "PIC16: timer frekvencia tl alacsony"
#endif  // TIMEDIV

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

// timer kompartor hinynak ptlsa
#define TIMERCOMPLESS  TMR0 += (TMCOMPCOR-TMCOMP)

// timer inicializls
#define TIMERINIT {\
  OPTION_REGbits.T0CS = 0;              /* forrs rajel = systemclock */\
  TMCLKSEL;                             /* oszt */\
  INTCONbits.GIE = 1;                   /* globlis IRQ eng */\
  INTCONbits.PEIE = 1;                  /* perifria IRQ eng */\
  TMR0 = (255+TMCOMPCOR-TMCOMP);}       /* timer kezdrtk feltltse */

// timer bekapcsols (nem bekapcsolhat, csak IRQ-t lehet engedlyezni)
#undef  LcdRefreshStart()
#define LcdRefreshStart()  if(!INTCONbits.T0IE){TMR0 = (255+TMCOMPCOR-TMCOMP); INTCONbits.T0IE = 1;}

// timer megszakts nyugtzs
#define TIMERIRQACK INTCONbits.T0IF = 0

//------------------------------------------------------------------------------
// PIC16 timer1
#elif TIMERNUM == 1

// oszt
#if TIMEDIV < 65536
#define TMCLKDIV       1
#define TMCLKSEL       T1CONbits.T1CKPS = 0
#define TMCOMPCOR      1
#elif TIMEDIV < (65536*2)
#define TMCLKDIV       2
#define TMCLKSEL       T1CONbits.T1CKPS = 1
#define TMCOMPCOR      0
#elif TIMEDIV < (65536*4)
#define TMCLKDIV       4
#define TMCLKSEL       T1CONbits.T1CKPS = 2
#define TMCOMPCOR      0
#elif TIMEDIV < (65536*8)
#define TMCLKDIV       8
#define TMCLKSEL       T1CONbits.T1CKPS = 3
#define TMCOMPCOR      0
#else
#error "PIC16: timer frekvencia tl alacsony"
#endif  // TIMEDIV

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

// timer kompartor hinynak ptlsa
#define TIMERCOMPLESS  TMR1 += (65535+TMCOMPCOR-TMCOMP)

// timer inicializls
#define TIMERINIT {\
  T1CONbits.TMR1CS = 0;                 /* forrs rajel = systemclock */\
  TMCLKSEL;                             /* oszt */\
  PIE1bits.TMR1IE = 1;                  /* megszakts engedlyezs */\
  INTCONbits.GIE = 1;                   /* globlis IRQ eng */\
  INTCONbits.PEIE = 1;                  /* perifria IRQ eng */\
  TMR1 = 65535+TMCOMPCOR-TMCOMP;}       /* timer kezdrtk feltltse */

// timer bekapcsols
#undef  LcdRefreshStart()
#define LcdRefreshStart()  if(!T1CONbits.TMR1ON){TMR1 = 65535+TMCOMPCOR-TMCOMP; T1CONbits.TMR1ON = 1;}

// timer megszakts nyugtzs
#define TIMERIRQACK PIR1bits.TMR1IF = 0

//------------------------------------------------------------------------------
// PIC16 timer2
#elif TIMERNUM == 2

// oszt
#if TIMEDIV < 256
#define TMCLKDIV       1
#define TMCLKSEL       T2CONbits.T2CKPS = 0; T2CONbits.TOUTPS = 0
#elif TIMEDIV < (256*2) // ezt a verzit a 16f877 nem szereti
#define TMCLKDIV       2
#define TMCLKSEL       T2CONbits.T2CKPS = 0; T2CONbits.TOUTPS = 1
#elif TIMEDIV < (256*4)
#define TMCLKDIV       4
#define TMCLKSEL       T2CONbits.T2CKPS = 1; T2CONbits.TOUTPS = 0
#elif TIMEDIV < (256*4*2)
#define TMCLKDIV       8
#define TMCLKSEL       T2CONbits.T2CKPS = 1; T2CONbits.TOUTPS = 1
#elif TIMEDIV < (256*16*1)
#define TMCLKDIV       16
#define TMCLKSEL       T2CONbits.T2CKPS = 2; T2CONbits.TOUTPS = 0
#elif TIMEDIV < (256*16*2)
#define TMCLKDIV       32
#define TMCLKSEL       T2CONbits.T2CKPS = 2; T2CONbits.TOUTPS = 1
#elif TIMEDIV < (256*16*4)
#define TMCLKDIV       64
#define TMCLKSEL       T2CONbits.T2CKPS = 2; T2CONbits.TOUTPS = 3
#elif TIMEDIV < (256*16*8)
#define TMCLKDIV       128
#define TMCLKSEL       T2CONbits.T2CKPS = 2; T2CONbits.TOUTPS = 7
#elif TIMEDIV < (256*16*16)
#define TMCLKDIV       256
#define TMCLKSEL       T2CONbits.T2CKPS = 2; T2CONbits.TOUTPS = 15
#else
#error "PIC16: timer frekvencia tl alacsony"
#endif // TIMEDIV

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

// timer inicializls
#define TIMERINIT {\
  TMCLKSEL;                             /* oszt */\
  PIE1bits.TMR2IE = 1;                  /* timer engedlyezs */\
  INTCONbits.GIE = 1;                   /* globlis IRQ eng */\
  INTCONbits.PEIE = 1;                  /* perifria IRQ eng */\
  PR2 = TMCOMP;}

// timer megszakts nyugtzs
#define TIMERIRQACK PIR1bits.TMR2IF = 0

// mivel timer kompartor van, nem kell szoftverbl ptolni
#define TIMERCOMPLESS  ;

#else  // TIMERNUM
#error "PIC16: csak timer 0, 1, 2 vlaszthat"
#endif // TIMERNUM

// PIC16
//==============================================================================
// PIC18
#elif (defined(__18CXX) || defined(__PICC18__))

// PIC18: timer IRQ prioritsa (0 = alacsony, 1 = magas)
#if LCDTIMERPR18 == -1
// priorits nlkli megszakts
#define TIMERPR18     1
#define PR18ONOFF RCONbits.IPEN = 0
#define PR18GIE  INTCONbits.GIE = 1; INTCONbits.PEIE = 1
#elif LCDTIMERPR18 == 0
// alacsony priorits
#define TIMERPR18     0
#define PR18ONOFF RCONbits.IPEN = 1
#define PR18GIE  INTCONbits.GIEL = 1; INTCONbits.GIEH = 1
#elif LCDTIMERPR18 == 1
// magas priorits
#define TIMERPR18     1
#define PR18ONOFF RCONbits.IPEN = 1
#define PR18GIE  INTCONbits.GIEL = 1; INTCONbits.GIEH = 1
#else
#error "LCD TIMERPR18 csak -1, 0, 1 lehet!"
#endif

// a megszakts kiszolgl fggvny vgrehajtsi idejtl fggen
#if TIMEDIV < TIMESUBCIKL_PIC18
#error "PIC18: timer frekvencia tl magas"
#endif

//------------------------------------------------------------------------------
// PIC18 timer0
#if TIMERNUM == 0

// oszt
#if TIMEDIV < 65536
#define TMCLKDIV       1
#define TMCLKSEL       T0CONbits.PSA = 1  /* eloszt tilts */
#define TMCOMPCOR      7
#elif TIMEDIV < (65536*2)
#define TMCLKDIV       2
#define TMCLKSEL       T0CONbits.PSA = 0; T0CONbits.T0PS2 = 0; T0CONbits.T0PS1 = 0; T0CONbits.T0PS0 = 0  /* eloszt eng, oszts = 2 */
#define TMCOMPCOR      4
#elif TIMEDIV < (65536*4)
#define TMCLKDIV       4
#define TMCLKSEL       T0CONbits.PSA = 0; T0CONbits.T0PS2 = 0; T0CONbits.T0PS1 = 0; T0CONbits.T0PS0 = 1  /* eloszt eng, oszts = 4 */
#define TMCOMPCOR      2
#elif TIMEDIV < (65536*8)
#define TMCLKDIV       8
#define TMCLKSEL       T0CONbits.PSA = 0; T0CONbits.T0PS2 = 0; T0CONbits.T0PS1 = 1; T0CONbits.T0PS0 = 0  /* eloszt eng, oszts = 8 */
#define TMCOMPCOR      0
#elif TIMEDIV < (65536*16)
#define TMCLKDIV       16
#define TMCLKSEL       T0CONbits.PSA = 0; T0CONbits.T0PS2 = 0; T0CONbits.T0PS1 = 1; T0CONbits.T0PS0 = 1  /* eloszt eng, oszts = 16 */
#define TMCOMPCOR      0
#elif TIMEDIV < (65536*32)
#define TMCLKDIV       32
#define TMCLKSEL       T0CONbits.PSA = 0; T0CONbits.T0PS2 = 1; T0CONbits.T0PS1 = 0; T0CONbits.T0PS0 = 0  /* eloszt eng, oszts = 32 */
#define TMCOMPCOR      0
#elif TIMEDIV < (65536*64)
#define TMCLKDIV       64
#define TMCLKSEL       T0CONbits.PSA = 0; T0CONbits.T0PS2 = 1; T0CONbits.T0PS1 = 0; T0CONbits.T0PS0 = 1  /* eloszt eng, oszts = 64 */
#define TMCOMPCOR      0
#elif TIMEDIV < (65536*128)
#define TMCLKDIV       128
#define TMCLKSEL       T0CONbits.PSA = 0; T0CONbits.T0PS2 = 1; T0CONbits.T0PS1 = 1; T0CONbits.T0PS0 = 0  /* eloszt eng, oszts = 128 */
#define TMCOMPCOR      0
#elif TIMEDIV < (65536*256)
#define TMCLKDIV       256
#define TMCLKSEL       T0CONbits.PSA = 0; T0CONbits.T0PS2 = 1; T0CONbits.T0PS1 = 1; T0CONbits.T0PS0 = 1  /* eloszt eng, oszts = 256 */
#define TMCOMPCOR      0
#else
#error "PIC18: timer frekvencia tl alacsony"
#endif // TIMEDIV

unsigned char ttemp;                    // kompartor nlkli idzt miatt

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

#ifdef __18CXX
// timer kompartor hinynak ptlsa (C18)
#define TIMERCOMPLESS {_asm \
  movlb  ttemp \
  movlw  65535+TMCOMPCOR-TMCOMP \
  addwf  TMR0L, 0, 0 \
  movwf  ttemp, 1 \
  movlw  (65535+TMCOMPCOR-TMCOMP) >> 8 \
  addwfc TMR0H, 1, 0 \
  movff  ttemp, TMR0L \
_endasm }
#else  // __18CXX
// timer kompartor hinynak ptlsa (HTC18)
#define TIMERCOMPLESS { \
  ttemp = (65535+TMCOMPCOR-TMCOMP) + TMR0L; \
  WREG = ((65535+TMCOMPCOR-TMCOMP) >> 8); \
  asm("addwfc (TMR0H), 1, 0"); \
  TMR0L = ttemp; \
}

#endif // else __18CXX

// timer inicializls
#define TIMERINIT {\
  T0CONbits.T08BIT = 0;                 /* 16bites timer */\
  T0CONbits.T0CS = 0;                   /* forrs rajel = systemclock */\
  TMCLKSEL;                             /* oszt */\
  INTCON2bits.TMR0IP = TIMERPR18;       /* priorits */\
  INTCONbits.TMR0IE = 1;                /* megszakts engedlyezs */\
  PR18ONOFF;                            /* ktszint priorits ki vagy be */\
  PR18GIE;                              /* globlis IRQ */\
  TMR0L = 65535+TMCOMPCOR-TMCOMP;       /* timerL kezdrtk feltltse bitidre */\
  TMR0H = (65535+TMCOMPCOR-TMCOMP) >> 8;}/* timerH kezdrtk feltltse bitidre */

// timer megszakts nyugtzs
#define TIMERIRQACK INTCONbits.TMR0IF = 0

//------------------------------------------------------------------------------
// PIC18 timer1
#elif TIMERNUM == 1

// oszt
#if TIMEDIV < 65536
#define TMCLKDIV       1
#define TMCLKSEL       T1CONbits.T1CKPS1 = 0; T1CONbits.T1CKPS0 = 0 /* eloszt 1:1 */
#define TMCOMPCOR      5
#elif TIMEDIV < (65536*2)
#define TMCLKDIV       2
#define TMCLKSEL       T1CONbits.T1CKPS1 = 0; T1CONbits.T1CKPS0 = 1 /* eloszt 1:2 */
#define TMCOMPCOR      3
#elif TIMEDIV < (65536*4)
#define TMCLKDIV       4
#define TMCLKSEL       T1CONbits.T1CKPS1 = 1; T1CONbits.T1CKPS0 = 0 /* eloszt 1:4 */
#define TMCOMPCOR      2
#elif TIMEDIV < (65536*8)
#define TMCLKDIV       8
#define TMCLKSEL       T1CONbits.T1CKPS1 = 1; T1CONbits.T1CKPS0 = 1 /* eloszt 1:8 */
#define TMCOMPCOR      1
#else
#error "PIC18: timer frekvencia tl alacsony"
#endif // TIMEDIV

unsigned char ttemp;                    // kompartor nlkli idzt miatt

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

#ifdef __18CXX
// timer kompartor hinynak ptlsa (C18)
#define TIMERCOMPLESS  {_asm \
  movlb  ttemp \
  movlw  65535+TMCOMPCOR-TMCOMP \
  addwf  TMR1L, 0, 0 \
  movwf  ttemp, 1 \
  movlw  (65535+TMCOMPCOR-TMCOMP) >> 8 \
  addwfc TMR1H, 1, 0 \
  movff  ttemp, TMR1L \
_endasm }
#else  // __18CXX
// timer kompartor hinynak ptlsa (HTC18)
#define TIMERCOMPLESS { \
  ttemp = (65535+TMCOMPCOR-TMCOMP) + TMR1L; \
  WREG = ((65535+TMCOMPCOR-TMCOMP) >> 8); \
  asm("addwfc (TMR1H), 1, 0"); \
  TMR1L = ttemp; \
}
#endif // else __18CXX

// timer inicializls
#define TIMERINIT {\
  T1CONbits.RD16 = 1;                   /* 16bites rs/olv */\
  T1CONbits.TMR1CS = 0;                 /* forrs rajel = systemclock */\
  TMCLKSEL;                             /* oszt */\
  IPR1bits.TMR1IP = TIMERPR18;          /* priorits */\
  PIE1bits.TMR1IE = 1;                  /* megszakts engedlyezs */\
  PR18ONOFF;                            /* ktszint priorits ki vagy be */\
  PR18GIE;                              /* globlis IRQ */\
  TMR3L = 65535+TMCOMPCOR-TMCOMP;       /* timerL kezdrtk feltltse bitidre */\
  TMR3H = (65535+TMCOMPCOR-TMCOMP) >> 8;}/* timerH kezdrtk feltltse bitidre */

// timer megszakts nyugtzs
#define TIMERIRQACK PIR1bits.TMR1IF = 0

//------------------------------------------------------------------------------
// PIC18 timer2
#elif TIMERNUM == 2

// oszt (milyen j, hogy az oszt bitjeit nem tudjk egysgesen elnevezni :()
#ifdef T2OUTPS

#if TIMEDIV < 256
#define TMCLKDIV       1
#define TMCLKSEL       T2CONbits.T2CKPS1=0; T2CONbits.T2CKPS0=0; T2CONbits.T2OUTPS3=0; T2CONbits.T2OUTPS2=0; T2CONbits.T2OUTPS1=0; T2CONbits.T2OUTPS0=0
#elif TIMEDIV < (256*2)
#define TMCLKDIV       2
#define TMCLKSEL       T2CONbits.T2CKPS1=0; T2CONbits.T2CKPS0=1; T2CONbits.T2OUTPS3=0; T2CONbits.T2OUTPS2=0; T2CONbits.T2OUTPS1=0; T2CONbits.T2OUTPS0=1
#elif TIMEDIV < (256*4)
#define TMCLKDIV       4
#define TMCLKSEL       T2CONbits.T2CKPS1=0; T2CONbits.T2CKPS0=1; T2CONbits.T2OUTPS3=0; T2CONbits.T2OUTPS2=0; T2CONbits.T2OUTPS1=0; T2CONbits.T2OUTPS0=0
#elif TIMEDIV < (256*8)
#define TMCLKDIV       8
#define TMCLKSEL       T2CONbits.T2CKPS1=0; T2CONbits.T2CKPS0=1; T2CONbits.T2OUTPS3=0; T2CONbits.T2OUTPS2=0; T2CONbits.T2OUTPS1=0; T2CONbits.T2OUTPS0=1
#elif TIMEDIV < (256*16)
#define TMCLKDIV       16
#define TMCLKSEL       T2CONbits.T2CKPS1=1; T2CONbits.T2CKPS0=0; T2CONbits.T2OUTPS3=0; T2CONbits.T2OUTPS2=0; T2CONbits.T2OUTPS1=0; T2CONbits.T2OUTPS0=0
#elif TIMEDIV < (256*16*2)
#define TMCLKDIV       32
#define TMCLKSEL       T2CONbits.T2CKPS1=1; T2CONbits.T2CKPS0=0; T2CONbits.T2OUTPS3=0; T2CONbits.T2OUTPS2=0; T2CONbits.T2OUTPS1=0; T2CONbits.T2OUTPS0=1
#elif TIMEDIV < (256*16*4)
#define TMCLKDIV       64
#define TMCLKSEL       T2CONbits.T2CKPS1=1; T2CONbits.T2CKPS0=0; T2CONbits.T2OUTPS3=0; T2CONbits.T2OUTPS2=0; T2CONbits.T2OUTPS1=1; T2CONbits.T2OUTPS0=1
#elif TIMEDIV < (256*16*8)
#define TMCLKDIV       128
#define TMCLKSEL       T2CONbits.T2CKPS1=1; T2CONbits.T2CKPS0=0; T2CONbits.T2OUTPS3=0; T2CONbits.T2OUTPS2=1; T2CONbits.T2OUTPS1=1; T2CONbits.T2OUTPS0=1
#elif TIMEDIV < (256*16*16)
#define TMCLKDIV       256
#define TMCLKSEL       T2CONbits.T2CKPS1=1; T2CONbits.T2CKPS0=0; T2CONbits.T2OUTPS3=1; T2CONbits.T2OUTPS2=1; T2CONbits.T2OUTPS1=1; T2CONbits.T2OUTPS0=1
#else
#error "PIC18: timer frekvencia tl alacsony (C18)"
#endif // TIMEDIV
#else  // T2OUTPS
#if TIMEDIV < 256
#define TMCLKDIV       1
#define TMCLKSEL       T2CONbits.T2CKPS1=0; T2CONbits.T2CKPS0=0; T2CONbits.TOUTPS3=0; T2CONbits.TOUTPS2=0; T2CONbits.TOUTPS1=0; T2CONbits.TOUTPS0=0
#elif TIMEDIV < (256*2)
#define TMCLKDIV       2
#define TMCLKSEL       T2CONbits.T2CKPS1=0; T2CONbits.T2CKPS0=1; T2CONbits.TOUTPS3=0; T2CONbits.TOUTPS2=0; T2CONbits.TOUTPS1=0; T2CONbits.TOUTPS0=1
#elif TIMEDIV < (256*4)
#define TMCLKDIV       4
#define TMCLKSEL       T2CONbits.T2CKPS1=0; T2CONbits.T2CKPS0=1; T2CONbits.TOUTPS3=0; T2CONbits.TOUTPS2=0; T2CONbits.TOUTPS1=0; T2CONbits.TOUTPS0=0
#elif TIMEDIV < (256*8)
#define TMCLKDIV       8
#define TMCLKSEL       T2CONbits.T2CKPS1=0; T2CONbits.T2CKPS0=1; T2CONbits.TOUTPS3=0; T2CONbits.TOUTPS2=0; T2CONbits.TOUTPS1=0; T2CONbits.TOUTPS0=1
#elif TIMEDIV < (256*16)
#define TMCLKDIV       16
#define TMCLKSEL       T2CONbits.T2CKPS1=1; T2CONbits.T2CKPS0=0; T2CONbits.TOUTPS3=0; T2CONbits.TOUTPS2=0; T2CONbits.TOUTPS1=0; T2CONbits.TOUTPS0=0
#elif TIMEDIV < (256*16*2)
#define TMCLKDIV       32
#define TMCLKSEL       T2CONbits.T2CKPS1=1; T2CONbits.T2CKPS0=0; T2CONbits.TOUTPS3=0; T2CONbits.TOUTPS2=0; T2CONbits.TOUTPS1=0; T2CONbits.TOUTPS0=1
#elif TIMEDIV < (256*16*4)
#define TMCLKDIV       64
#define TMCLKSEL       T2CONbits.T2CKPS1=1; T2CONbits.T2CKPS0=0; T2CONbits.TOUTPS3=0; T2CONbits.TOUTPS2=0; T2CONbits.TOUTPS1=1; T2CONbits.TOUTPS0=1
#elif TIMEDIV < (256*16*8)
#define TMCLKDIV       128
#define TMCLKSEL       T2CONbits.T2CKPS1=1; T2CONbits.T2CKPS0=0; T2CONbits.TOUTPS3=0; T2CONbits.TOUTPS2=1; T2CONbits.TOUTPS1=1; T2CONbits.TOUTPS0=1
#elif TIMEDIV < (256*16*16)
#define TMCLKDIV       256
#define TMCLKSEL       T2CONbits.T2CKPS1=1; T2CONbits.T2CKPS0=0; T2CONbits.TOUTPS3=1; T2CONbits.TOUTPS2=1; T2CONbits.TOUTPS1=1; T2CONbits.TOUTPS0=1
#else
#error "PIC18: timer frekvencia tl alacsony (HTC18)"
#endif // TIMEDIV
#endif // else T2OUTPS

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

// mivel timer kompartor van, nem kell szoftverbl ptolni
#define TIMERCOMPLESS ;

// timer inicializls
#define TIMERINIT \
  TMCLKSEL;                             /* oszt */\
  PR2 = TMCOMP;                         /* kompartor */\
  IPR1bits.TMR2IP = TIMERPR18;          /* priorits */\
  PIE1bits.TMR2IE = 1;                  /* timer megszakts engedlyezs */\
  PR18ONOFF;                            /* ktszint priorits ki vagy be */\
  PR18GIE;                              /* globlis IRQ */

// timer megszakts nyugtzs
#define TIMERIRQACK PIR1bits.TMR2IF = 0

//------------------------------------------------------------------------------
// PIC18 timer3
#elif TIMERNUM == 3

// oszt
#if TIMEDIV < 65536
#define TMCLKDIV       1
#define TMCLKSEL       T3CONbits.T3CKPS0 = 0; T3CONbits.T3CKPS1 = 0 /* eloszt 1:1 */
#define TMCOMPCOR      5
#elif TIMEDIV < (65536*2)
#define TMCLKDIV       2
#define TMCLKSEL       T3CONbits.T3CKPS0 = 0; T3CONbits.T3CKPS1 = 1 /* eloszt 1:2 */
#define TMCOMPCOR      3
#elif TIMEDIV < (65536*4)
#define TMCLKDIV       4
#define TMCLKSEL       T3CONbits.T3CKPS0 = 1; T3CONbits.T3CKPS1 = 0 /* eloszt 1:4 */
#define TMCOMPCOR      2
#elif TIMEDIV < (65536*8)
#define TMCLKDIV       8
#define TMCLKSEL       T3CONbits.T3CKPS0 = 1; T3CONbits.T3CKPS1 = 1 /* eloszt 1:8 */
#define TMCOMPCOR      1
#else
#error "PIC18: timer frekvencia tl alacsony"
#endif // TIMEDIV

unsigned char ttemp;                    // kompartor nlkli idzt miatt

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

#ifdef __18CXX
// timer kompartor hinynak ptlsa (C18)
#define TIMERCOMPLESS  {_asm \
  movlb  ttemp \
  movlw  65535+TMCOMPCOR-TMCOMP \
  addwf  TMR3L, 0, 0 \
  movwf  ttemp, 1 \
  movlw  (65535+TMCOMPCOR-TMCOMP) >> 8 \
  addwfc TMR3H, 1, 0 \
  movff  ttemp, TMR3L \
_endasm }
#else  // __18CXX
// timer kompartor hinynak ptlsa (HTC18)
#define TIMERCOMPLESS { \
  ttemp = (65535+TMCOMPCOR-TMCOMP) + TMR3L; \
  WREG = ((65535+TMCOMPCOR-TMCOMP) >> 8); \
  asm("addwfc (TMR3H), 1, 0"); \
  TMR3L = ttemp; \
}

#endif // else __18CXX

// timer inicializls
#define TIMERINIT {\
  T3CONbits.RD16 = 1;                   /* 16bites rs/olv */\
  T3CONbits.TMR3CS = 0;                 /* forrs rajel = systemclock */\
  TMCLKSEL;                             /* oszt */\
  IPR2bits.TMR3IP = TIMERPR18;          /* priorits */\
  PIE2bits.TMR3IE = 1;                  /* megszakts engedlyezs */\
  PR18ONOFF;                            /* ktszint priorits ki vagy be */\
  PR18GIE;                              /* globlis IRQ */\
  TMR3L = 65535+TMCOMPCOR-TMCOMP;       /* timerL kezdrtk feltltse bitidre */\
  TMR3H = (65535+TMCOMPCOR-TMCOMP) >> 8;}/* timerH kezdrtk feltltse bitidre */

// timer megszakts nyugtzs
#define TIMERIRQACK PIR2bits.TMR3IF = 0

#else  // TIMERNUM
#error "PIC18: csak timer 0, 1, 2, 3 vlaszthat"
#endif // TIMERNUM

// PIC18
//==============================================================================
// PIC24
#elif defined(__C30__)

// a megszakts kiszolgl fggvny vgrehajtsi idejtl fggen
#if TIMEDIV < TIMESUBCIKL_PIC24
#error "PIC24: timer frekvencia tl magas"
#endif

// mivel timer kompartor van, nem kell szoftverbl ptolni
#define  TIMERCOMPLESS ;

//------------------------------------------------------------------------------
// PIC24 timer1
#if TIMERNUM == 1

// oszt
#if TIMEDIV < 65536
#define TMCLKDIV       1
#define TMCLKSEL       T1CONbits.TCKPS = 0
#elif TIMEDIV < (65536*8)
#define TMCLKDIV       8
#define TMCLKSEL       T1CONbits.TCKPS = 1
#elif TIMEDIV < (65536*64)
#define TMCLKDIV       64
#define TMCLKSEL       T1CONbits.TCKPS = 2
#elif TIMEDIV < (65536*256)
#define TMCLKDIV       256
#define TMCLKSEL       T1CONbits.TCKPS = 3
#else
#error "PIC24: timer frekvencia tl alacsony"
#endif  // TIMEDIV

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

// timer inicializls
#define TIMERINIT {\
  T1CONbits.TCS = 0;                    /* forrs rajel = systemclock */\
  TMCLKSEL;                             /* eloszt */\
  IPC0bits.T1IP = TIMERPR24;            /* priorits */\
  PR1 = TMCOMP;                         /* idzt belltsa a bitidhz */\
  IEC0bits.T1IE = 1;}                   /* timer IRQ engedlyezs */

// timer megszakts nyugtzs
#define TIMERIRQACK IFS0bits.T1IF = 0

// timer megszakts kiszolgl fggvny
#define TIMERINTPROCESS void __attribute__ ((interrupt, auto_psv)) _T1Interrupt(void)

//------------------------------------------------------------------------------
// PIC24 timer2
#elif TIMERNUM == 2

// oszt
#if TIMEDIV < 65536
#define TMCLKDIV       1
#define TMCLKSEL       T2CONbits.TCKPS = 0
#elif TIMEDIV < (65536*8)
#define TMCLKDIV       8
#define TMCLKSEL       T2CONbits.TCKPS = 1
#elif TIMEDIV < (65536*64)
#define TMCLKDIV       64
#define TMCLKSEL       T2CONbits.TCKPS = 2
#elif TIMEDIV < (65536*256)
#define TMCLKDIV       256
#define TMCLKSEL       T2CONbits.TCKPS = 3
#else
#error "PIC24: timer frekvencia tl alacsony"
#endif  // TIMEDIV

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

// timer inicializls
#define TIMERINIT {\
  T2CONbits.TCS = 0;                    /* forrs rajel = systemclock */\
  TMCLKSEL;                             /* oszt */\
  IPC1bits.T2IP = TIMERPR24;            /* priorits */\
  PR2 = TMCOMP;                         /* idzt belltsa a bitidhz */\
  IEC0bits.T2IE = 1;}                   /* timer IRQ engedlyezs */

// timer megszakts nyugtzs
#define TIMERIRQACK IFS0bits.T2IF = 0

// timer megszakts kiszolgl fggvny
#define TIMERINTPROCESS void __attribute__ ((interrupt, auto_psv)) _T2Interrupt(void)

//------------------------------------------------------------------------------
// PIC24 timer3
#elif TIMERNUM == 3

// oszt
#if TIMEDIV < 65536
#define TMCLKDIV       1
#define TMCLKSEL       T3CONbits.TCKPS = 0
#elif TIMEDIV < (65536*8)
#define TMCLKDIV       8
#define TMCLKSEL       T3CONbits.TCKPS = 1
#elif TIMEDIV < (65536*64)
#define TMCLKDIV       64
#define TMCLKSEL       T3CONbits.TCKPS = 2
#elif TIMEDIV < (65536*256)
#define TMCLKDIV       256
#define TMCLKSEL       T3CONbits.TCKPS = 3
#else
#error "PIC24: timer frekvencia tl alacsony"
#endif  // TIMEDIV

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

// timer inicializls
#if defined(__dsPIC30F__)
#define TIMERINIT {\
  T3CONbits.TCS = 0;                    /* forrs rajel = systemclock */\
  TMCLKSEL;                             /* oszt */\
  IPC1bits.T3IP = TIMERPR24;            /* priorits */\
  PR3 = TMCOMP;                         /* idzt belltsa a bitidhz */\
  IEC0bits.T3IE = 1;}                   /* timer IRQ engedlyezs */
#else
#define TIMERINIT {\
  T3CONbits.TCS = 0;                    /* forrs rajel = systemclock */\
  TMCLKSEL;                             /* oszt */\
  IPC2bits.T3IP = TIMERPR24;            /* priorits */\
  PR3 = TMCOMP;                         /* idzt belltsa a bitidhz */\
  IEC0bits.T3IE = 1;}                   /* timer IRQ engedlyezs */
#endif

// timer megszakts nyugtzs
#define TIMERIRQACK IFS0bits.T3IF = 0

// timer megszakts kiszolgl fggvny
#define TIMERINTPROCESS void __attribute__ ((interrupt, auto_psv)) _T3Interrupt(void)

//------------------------------------------------------------------------------
// PIC24 timer4
#elif TIMERNUM == 4

// oszt
#if TIMEDIV < 65536
#define TMCLKDIV       1
#define TMCLKSEL       T4CONbits.TCKPS = 0
#elif TIMEDIV < (65536*8)
#define TMCLKDIV       8
#define TMCLKSEL       T4CONbits.TCKPS = 1
#elif TIMEDIV < (65536*64)
#define TMCLKDIV       64
#define TMCLKSEL       T4CONbits.TCKPS = 2
#elif TIMEDIV < (65536*256)
#define TMCLKDIV       256
#define TMCLKSEL       T4CONbits.TCKPS = 3
#else
#error "PIC24: timer frekvencia tl alacsony"
#endif  // TIMEDIV

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

// timer inicializls
#if defined(__dsPIC30F__)
#define TIMERINIT {\
  T4CONbits.TCS = 0;                    /* forrs rajel = systemclock */\
  TMCLKSEL;                             /* oszt */\
  IPC5bits.T4IP = TIMERPR24;            /* priorits */\
  PR4 = TMCOMP;                         /* idzt belltsa a bitidhz */\
  IEC1bits.T4IE = 1;}                   /* timer IRQ engedlyezs */
#else
#define TIMERINIT {\
  T4CONbits.TCS = 0;                    /* forrs rajel = systemclock */\
  TMCLKSEL;                             /* oszt */\
  IPC6bits.T4IP = TIMERPR24;            /* priorits */\
  PR4 = TMCOMP;                         /* idzt belltsa a bitidhz */\
  IEC1bits.T4IE = 1;}                   /* timer IRQ engedlyezs */
#endif

// timer megszakts nyugtzs
#define TIMERIRQACK IFS1bits.T4IF = 0

// timer megszakts kiszolgl fggvny
#define TIMERINTPROCESS void __attribute__ ((interrupt, auto_psv)) _T4Interrupt(void)

//------------------------------------------------------------------------------
// PIC24 timer5
#elif TIMERNUM == 5

// oszt
#if TIMEDIV < 65536
#define TMCLKDIV       1
#define TMCLKSEL       T5CONbits.TCKPS = 0
#elif TIMEDIV < (65536*8)
#define TMCLKDIV       8
#define TMCLKSEL       T5CONbits.TCKPS = 1
#elif TIMEDIV < (65536*64)
#define TMCLKDIV       64
#define TMCLKSEL       T5CONbits.TCKPS = 2
#elif TIMEDIV < (65536*256)
#define TMCLKDIV       256
#define TMCLKSEL       T5CONbits.TCKPS = 3
#else
#error "PIC24: timer frekvencia tl alacsony"
#endif  // TIMEDIV

// timer kompartorba ennyit kell berakni hogy a kvnt frekvencia legyen
#define TMCOMP (((TimerSrcClock/TMCLKDIV)+TIMECLK/2)/TIMECLK-1)

// timer inicializls
#if defined(__dsPIC30F__)
#define TIMERINIT {\
  T5CONbits.TCS = 0;                    /* forrs rajel = systemclock */\
  TMCLKSEL;                             /* eloszt */\
  IPC5bits.T5IP = TIMERPR24;            /* priorits */\
  PR5 = TMCOMP;                         /* idzt belltsa a bitidhz */\
  IEC1bits.T5IE = 1;}                   /* timer IRQ engedlyezs */
#else
#define TIMERINIT {\
  T5CONbits.TCS = 0;                    /* forrs rajel = systemclock */\
  TMCLKSEL;                             /* eloszt */\
  IPC7bits.T5IP = TIMERPR24;            /* priorits */\
  PR5 = TMCOMP;                         /* idzt belltsa a bitidhz */\
  IEC1bits.T5IE = 1;}                   /* timer IRQ engedlyezs */
#endif

// timer megszakts nyugtzs
#define TIMERIRQACK IFS1bits.T5IF = 0

// timer megszakts kiszolgl fggvny
#define TIMERINTPROCESS void __attribute__ ((interrupt, auto_psv)) _T5Interrupt(void)

#else  // TIMERNUM
#error "PIC24: csak timer 1, 2, 3, 4, 5 vlaszthat"
#endif // TIMERNUM

#endif // defined(__C30__)

//==============================================================================
// timer (vge)
//==============================================================================

#endif // (!defined LCDUSERTIMER) && ((defined LCDMODEONCEIRQ) || (defined LCDMODECONTIRQ))
//==============================================================================
// ltalnos vltozk

// az LcdWrite fggvny hasznlja tmeneti trolsra (csak a felesleges veremmveletek elkerlse miatt)
volatile union
{
  struct
  {
    unsigned bit0: 1;
    unsigned bit1: 1;
    unsigned bit2: 1;
    unsigned bit3: 1;
    unsigned bit4: 1;
    unsigned bit5: 1;
    unsigned bit6: 1;
    unsigned bit7: 1;
  };
  unsigned char chr;
}ch;

// ebben a tmbben troljuk a megjelentend karaktereket
#ifdef LCDSTEREO
volatile char LcdText[2UL * LCDWIDTH * LCDLINES + 1];
#else
volatile char LcdText[1UL * LCDWIDTH * LCDLINES + 1];
#endif
volatile unsigned char LcdPos;                   // Frisstsnl az aktulis karakter pozcija

// LcdStatus lehetsges rtkei:
// - HOME: DDRAM = 0 lltsi fzis
// - LCHAR: karakterek kirsa fzis
// - DDR: DDRAM llts fzis
// - CURTYPE: kurzor tpus lltsa fzis
// - CURPOS: kurzorpozci belltsi fzis
// - CGR: CGRAM lltsi fzis
// - CHARGEN: felhasznli karakterkszlet feltltse fzis
// - REFREND: frissts befejezve
enum LS {HOME, LCHAR, DDR, CURTYPE, CURPOS, CGR, CHARGEN, REFREND} LcdStatus = LCHAR;

// A villog karaktereket ebben a tmbben 1 rtk bit jelzi
#ifdef LCDBLINKCHAR
#ifdef LCDSTEREO
volatile char LcdBlink[(2UL * LCDWIDTH * LCDLINES + 7) / 8];
#else  // LCDSTEREO
volatile char LcdBlink[(1UL * LCDWIDTH * LCDLINES + 7) / 8];
#endif // LCDSTEREO

// Villogsi fzis trolja
volatile unsigned char BlinkPhase = 0;  // 0 = villog karakterek ltszanak, 1 = nem ltszik
#endif // LCDBLINKCHAR

// Kurzor pozci s kurzor tpus
#ifdef LCDCURSOR
volatile unsigned char LcdCursorPos = 0;
volatile unsigned char LcdCursorType;
#endif

// sajt megszaktskezelvel s idztskezelvel hasznlva a frisstsi llapot ebben a vltozban lesz
#if (defined LCDUSERTIMER) && ((defined LCDMODEONCEIRQ) || (defined LCDMODECONTIRQ))
unsigned char LcdIrqStatus = 0;
#endif

// Felhasznli karakterkszlet
#ifdef USERCHARSETCHANGE
char*  uchp;
#endif

//==============================================================================
// LCD adatlbakra 4..7 bit kiraksa
#define LCDDT4TO7 \
  if(!ch.bit7) LCDDT7PIN0; if(ch.bit7) LCDDT7PIN1;\
  if(!ch.bit6) LCDDT6PIN0; if(ch.bit6) LCDDT6PIN1;\
  if(!ch.bit5) LCDDT5PIN0; if(ch.bit5) LCDDT5PIN1;\
  if(!ch.bit4) LCDDT4PIN0; if(ch.bit4) LCDDT4PIN1;

#ifdef LCD4BITMODE
// LCD adatlbakra 0..3 bit kiraksa (4 bites mdban)
#define LCDDT0TO3 \
  if(!ch.bit3) LCDDT7PIN0; if(ch.bit3) LCDDT7PIN1;\
  if(!ch.bit2) LCDDT6PIN0; if(ch.bit2) LCDDT6PIN1;\
  if(!ch.bit1) LCDDT5PIN0; if(ch.bit1) LCDDT5PIN1;\
  if(!ch.bit0) LCDDT4PIN0; if(ch.bit0) LCDDT4PIN1;
#else // LCD4BITMODE
// LCD adatlbakra 0..3 bit kiraksa (8 bites mdban)
#define LCDDT0TO3 \
  if(!ch.bit3) LCDDT3PIN0; if(ch.bit3) LCDDT3PIN1;\
  if(!ch.bit2) LCDDT2PIN0; if(ch.bit2) LCDDT2PIN1;\
  if(!ch.bit1) LCDDT1PIN0; if(ch.bit1) LCDDT1PIN1;\
  if(!ch.bit0) LCDDT0PIN0; if(ch.bit0) LCDDT0PIN1;
#endif // else LCD4BITMODE

//==============================================================================
#ifdef SOFTSIMFAST
#define EDELAY   ;
#define EDELAYCYCLE 0
#else  // SOFTSIMFAST


// E lb tartsi id
// AVR
#if defined(__AVR__)
#if   CpuMips >= 30000000
#define EDELAY  _NOP(); _NOP(); _NOP(); _NOP(); _NOP(); _NOP(); _NOP(); _NOP(); _NOP(); _NOP(); _NOP(); _NOP()
#define EDELAYCYCLE 12
#elif CpuMips >= 20000000
#define EDELAY  _NOP(); _NOP(); _NOP(); _NOP(); _NOP(); _NOP(); _NOP(); _NOP()
#define EDELAYCYCLE 8
#elif CpuMips >= 10000000
#define EDELAY  _NOP(); _NOP(); _NOP(); _NOP()
#define EDELAYCYCLE 4
#elif CpuMips >= 7500000
#define EDELAY  _NOP(); _NOP(); _NOP()
#define EDELAYCYCLE 3
#elif CpuMips >= 5000000
#define EDELAY  _NOP(); _NOP()
#define EDELAYCYCLE 2
#else
#define EDELAY  _NOP()
#define EDELAYCYCLE 1
#endif // CpuMips
//------------------------------------------------------------------------------
// PIC16
#elif (defined(_PIC14) || defined(_PIC14E))
#if   CpuMips >= 10000000
#define EDELAY  NOP(); NOP(); NOP(); NOP()
#define EDELAYCYCLE 4
#elif CpuMips >= 7500000
#define EDELAY  NOP(); NOP(); NOP()
#define EDELAYCYCLE 3
#elif CpuMips >= 5000000
#define EDELAY  NOP(); NOP()
#define EDELAYCYCLE 2
#else
#define EDELAY  NOP()
#define EDELAYCYCLE 1
#endif // CpuMips
//------------------------------------------------------------------------------
// PIC18
#elif ((defined(__18CXX)) || (defined(__PICC18__)))
#if   CpuMips >= 10000000
#define EDELAY  Nop(); Nop(); Nop(); Nop()
#define EDELAYCYCLE 4
#elif CpuMips >= 7500000
#define EDELAY  Nop(); Nop(); Nop()
#define EDELAYCYCLE 3
#elif CpuMips >= 5000000
#define EDELAY  Nop(); Nop()
#define EDELAYCYCLE 2
#else
#define EDELAY  Nop()
#define EDELAYCYCLE 1
#endif // CpuMips
//------------------------------------------------------------------------------
// PIC24
#elif defined(__C30__)
#if   CpuMips >= 40000000
#define EDELAY  Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop()
#define EDELAYCYCLE 16
#elif CpuMips >= 30000000
#define EDELAY  Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop()
#define EDELAYCYCLE 12
#elif CpuMips >= 20000000
#define EDELAY  Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop(); Nop()
#define EDELAYCYCLE 8
#elif CpuMips >= 10000000
#define EDELAY  Nop(); Nop(); Nop(); Nop()
#define EDELAYCYCLE 4
#elif CpuMips >= 7500000
#define EDELAY  Nop(); Nop(); Nop()
#define EDELAYCYCLE 3
#elif CpuMips >= 5000000
#define EDELAYCYCLE 2
#define EDELAY  Nop(); Nop()
#else
#define EDELAY  Nop()
#define EDELAYCYCLE 1
#endif // CpuMips
#endif // else defined(__AVR__)

#endif // else SOFTSIMFAST

//==============================================================================
// Processzorfggetlen rszek
//==============================================================================

//==============================================================================
// DelayMs
// - 1..255msec vrakozs (nem teljesen pontos de az LCD inicializlshoz elegend)
//==============================================================================
void DelayMs(unsigned char ms)
{
  volatile unsigned int dl;

  #ifndef SOFTSIMFAST
  while(ms--)
  {
    dl = DELAYNUM;
    while(dl--);
  }
  #endif
}

#ifdef LCDMODEONCEDELAY
//==============================================================================
// DelayLcd
// - Lcd rs vrakozs vrakozs (nem teljesen pontos)
//==============================================================================
// LCD rsok kztt ennyi utastsciklusnak kell legalbb lenni:
#define LCDEXECUTIONCYCLE ((CpuMips * LCDEXECUTIONTIME) / 1000000)

// ennyi a vals vgrehajtsi ideje az LCD r fggvnynek
#ifdef LCDSTEREO
#ifdef LCD4BITMODE
#define LCDPROCCYCLE (LCDPROCCYCLENULLSTEREO + 8 * EDELAYCYCLE + 4)
#else  // LCD4BITMODE
#define LCDPROCCYCLE (LCDPROCCYCLENULLSTEREO + 4 * EDELAYCYCLE)
#endif // else LCD4BITMODE
#else  // LCDSTEREO
#ifdef LCD4BITMODE
#define LCDPROCCYCLE (LCDPROCCYCLENULL + 4 * EDELAYCYCLE + 2)
#else  // LCD4BITMODE
#define LCDPROCCYCLE (LCDPROCCYCLENULL + 2 * EDELAYCYCLE)
#endif // else LCD4BITMODE
#endif // else LCDSTEREO

// ha LcdProc vgrehajtsi ideje >= LCDEXECUTIONTIME -> nincs szksg ksleltet ciklusra
#if LCDPROCCYCLE >= LCDEXECUTIONCYCLE
#define DelayLcd() ;
#else  // LCDPROCCYCLE >= LCDEXECUTIONCYCLE

// ennyit kell mg vrakozni az LCDEXECUTIONTIME-hoz
#define LCDDELAYCYCLE (LCDEXECUTIONCYCLE - LCDPROCCYCLE)

void DelayLcd(void)
{
  #if defined(__AVR__)
  static volatile unsigned char cl;
  #if (LCDDELAYCYCLE / 10) > 255
  #error "LCD EXECUTIONTIME tl nagy!"
  #else
  cl = LCDDELAYCYCLE / 10;
  #endif
  #elif defined(__C30__)
  static volatile unsigned int cl;
  #if (LCDDELAYCYCLE / 4) > 65535
  #error "LCD EXECUTIONTIME tl nagy!"
  #else
  cl = LCDDELAYCYCLE / 4;
  #endif
  #else // defined(__C30__)
  volatile unsigned char cl;
  #if (LCDDELAYCYCLE / 3) > 255
  #error "LCD EXECUTIONTIME tl nagy!"
  #else
  cl = LCDDELAYCYCLE / 3;
  #endif
  #endif // else defined(__C30__)
  while(--cl);
}

#endif // else LCDPROCCYCLE >= LCDEXECUTIONCYCLE

#endif // LCDMODEONCEDELAY

//==============================================================================
// LcdBusy (csak LCDMODEONCEBUSY mdban)
// - LCD vezrl foglaltsgnak ellenrzse
//   (nem vrja meg mg szabad lesz)
// visszatr rtk:
//   1 ha a Busy flag is be van lltva (foglalt)
//   0 ha szabad (lehet adatot kldeni)
//==============================================================================
#if (defined LCDMODEONCEBUSY) || (defined LCDMODECONTBUSY)
char LcdBusy(void)
{
  LCDDT4PININ; LCDDT5PININ; LCDDT6PININ; LCDDT7PININ;
  #if !defined LCD4BITMODE
  LCDDT0PININ; LCDDT1PININ; LCDDT2PININ; LCDDT3PININ;
  #endif // !LCD4BITMODE
  LCDRWPIN1;                            // adatirny: LCD -> mikrovezrl (read)
  LCDRSPIN0;                            // RS = 0
  EDELAY;
  LCDEPIN1;
  EDELAY;

  if(LCDDT7PIN)                         // busy flag
  {
    LCDEPIN0;
    #ifdef LCD4BITMODE
    EDELAY;
    LCDEPIN1;
    EDELAY;
    LCDEPIN0;
    EDELAY;
    #endif // LCD4BITMODE
    return 1;                           // foglalt
  }
  LCDEPIN0;
  #ifdef LCD4BITMODE
  EDELAY;
  LCDEPIN1;
  EDELAY;
  LCDEPIN0;
  #endif // LCD4BITMODE

  #ifdef LCDSTEREO
  EDELAY;
  LCDE2PIN1;
  EDELAY;
  if(LCDDT7PIN)                         // busy flag
  {
    LCDE2PIN0;
    #ifdef LCD4BITMODE
    EDELAY;
    LCDE2PIN1;
    EDELAY;
    LCDE2PIN0;
    #endif // LCD4BITMODE
    return 1;                           // foglalt
  }
  LCDE2PIN0;
  #ifdef LCD4BITMODE
  EDELAY;
  LCDE2PIN1;
  EDELAY;
  LCDE2PIN0;
  EDELAY;
  #endif // LCD4BITMODE
  #endif // LCDSTEREO

  return 0;                             // szabad
}
#endif // (defined LCDMODEONCEBUSY) || (defined LCDMODECONTBUSY)

//==============================================================================
// LcdWrite (I/O lbakon keresztl egy karaktert r az LCD-re)
// - RS lb = 0: config regiszter (parancs)
// - RS lb = 1: RAM (karakter)
// - ch globlis bltoz = adat
//==============================================================================
void LcdWrite(void)
{
  // ha nem hasznlunk BUSY mdot, mindig kimenet marad az sszes adatlb, ezrt nem kell lltgatni
  #if (defined LCDMODEONCEBUSY) || (defined LCDMODECONTBUSY)
  LCDRWPIN0;                            // adatirny: mikrovezrl -> LCD
  LCDDT4PINOUT; LCDDT5PINOUT; LCDDT6PINOUT; LCDDT7PINOUT;
  #if !defined LCD4BITMODE
  LCDDT0PINOUT; LCDDT1PINOUT; LCDDT2PINOUT; LCDDT3PINOUT; // 8 bites md
  #endif // !defined LCD4BITMODE
  #endif // !((defined LCDMODEONCEIRQ) || (defined LCDMODECONTIRQ))

  LCDDT4TO7;
  #ifdef LCD4BITMODE
  EDELAY;
  LCDEPIN1;
  EDELAY;
  LCDEPIN0;
  #endif
  LCDDT0TO3;

  EDELAY;
  LCDEPIN1;
  EDELAY;
  LCDEPIN0;
}

//==============================================================================
#ifdef LCDSTEREO
void LcdWrite2(void)
{
  LCDDT4TO7;
  #ifdef LCD4BITMODE
  EDELAY;
  LCDE2PIN1;
  EDELAY;
  LCDE2PIN0;
  #endif
  LCDDT0TO3;

  EDELAY;
  LCDE2PIN1;
  EDELAY;
  LCDE2PIN0;
}
#endif // LCDSTEREO

//------------------------------------------------------------------------------
#ifdef USERCHARSET
#ifdef __18CXX
// #if ((defined(__18CXX)) || (defined(__PICC18__)))
rom USERCHARSETARRAY userromcharset = 
#else
const USERCHARSETARRAY userromcharset = 
#endif
{
  USER0CHAR0, USER0CHAR1, USER0CHAR2, USER0CHAR3, USER0CHAR4, USER0CHAR5, USER0CHAR6, USER0CHAR7,
  USER1CHAR0, USER1CHAR1, USER1CHAR2, USER1CHAR3, USER1CHAR4, USER1CHAR5, USER1CHAR6, USER1CHAR7,
  USER2CHAR0, USER2CHAR1, USER2CHAR2, USER2CHAR3, USER2CHAR4, USER2CHAR5, USER2CHAR6, USER2CHAR7,
  USER3CHAR0, USER3CHAR1, USER3CHAR2, USER3CHAR3, USER3CHAR4, USER3CHAR5, USER3CHAR6, USER3CHAR7,
  USER4CHAR0, USER4CHAR1, USER4CHAR2, USER4CHAR3, USER4CHAR4, USER4CHAR5, USER4CHAR6, USER4CHAR7,
  USER5CHAR0, USER5CHAR1, USER5CHAR2, USER5CHAR3, USER5CHAR4, USER5CHAR5, USER5CHAR6, USER5CHAR7,
  USER6CHAR0, USER6CHAR1, USER6CHAR2, USER6CHAR3, USER6CHAR4, USER6CHAR5, USER6CHAR6, USER6CHAR7,
  USER7CHAR0, USER7CHAR1, USER7CHAR2, USER7CHAR3, USER7CHAR4, USER7CHAR5, USER7CHAR6, USER7CHAR7
};
#endif // USERCHARSET

//==============================================================================
// LcdInit
// - I/O lbak, TRIS regiszterek belltsa 
// - LCD kijelz bekapcsolsa s alapllapotba lltsa
//==============================================================================
void LcdInit(void)
{
  unsigned char i;
  // I/O lbak belltsa
  LCDEPIN0;
  LCDEPINOUT;

  #ifdef LCDSTEREO
  LCDE2PIN0;
  LCDE2PINOUT;
  #endif

  LCDRSPIN0;
  LCDRSPINOUT;

  // ha R/W lbat is hasznljuk
  #ifdef LCDRWUSED
  LCDRWPIN0;
  LCDRWPINOUT;
  #endif // LCDRWUSED

  // 0011 (3x)
  LCDRSPIN0;
  LCDDT7PIN0;   LCDDT6PIN0;   LCDDT5PIN1;   LCDDT4PIN1;
  LCDDT7PINOUT; LCDDT6PINOUT; LCDDT5PINOUT; LCDDT4PINOUT; 

  #if !defined LCD4BITMODE
  LCDDT3PIN0;   LCDDT2PIN0;   LCDDT1PIN0;   LCDDT0PIN0;
  LCDDT3PINOUT; LCDDT2PINOUT; LCDDT1PINOUT; LCDDT0PINOUT;
  #endif // !defined LCD4BITMODE

  DelayMs(100);

  // 0011 (3x)
  for(i = 0; i < 3u; i++)
  {
    LCDEPIN1;
    #ifdef LCDSTEREO
    LCDE2PIN1;
    #endif
    EDELAY;
    LCDEPIN0;
    #ifdef LCDSTEREO
    LCDE2PIN0;
    #endif
    DelayMs(5);
  }
        
  #ifdef  LCD4BITMODE
  // 0010
  LCDDT7PIN0; LCDDT6PIN0; LCDDT5PIN1; LCDDT4PIN0;
  LCDEPIN1;
  #ifdef LCDSTEREO
  LCDE2PIN1;
  #endif
  EDELAY;
  LCDEPIN0;
  #ifdef LCDSTEREO
  LCDE2PIN0;
  #endif
  DelayMs(5);

  LCDRSPIN0;
  #if  LCDLINES == 1
  ch.chr = 0x20; 
  LcdWrite();
  #ifdef LCDSTEREO
  LcdWrite2();
  #endif
  #else  // LCDLINES == 1
  ch.chr = 0x28; 
  LcdWrite();
  #ifdef LCDSTEREO
  LcdWrite2();
  #endif // LCDSTEREO
  #endif // LCDLINES
  #endif // LCD4BITMODE
        
  DelayMs(2);
  #if !defined LCD4BITMODE
  #if  LCDLINES == 1
  ch.chr = 0x30;
  LcdWrite();
  #ifdef LCDSTEREO
  LcdWrite2();
  #endif
  #else  // LCDLINES == 1
  ch.chr = 0x38;
  LcdWrite();
  #ifdef LCDSTEREO
  LcdWrite2();
  #endif // LCDSTEREO
  #endif // LCDLINES
  #endif // !LCD4BITMODE

  DelayMs(2);
  ch.chr = 0b00000110;                  // minden rsnl cm nvelse, szveg shiftels ki
  LcdWrite();
  #ifdef LCDSTEREO
  LcdWrite2();
  #endif

  DelayMs(2);
  ch.chr = 0b00001100;                  // kijelz bekapcs, kurzor ki, kurzor villogs ki
  LcdWrite();
  #ifdef LCDSTEREO
  LcdWrite2();
  #endif

  #ifdef USERCHARSET
  DelayMs(2);
  ch.chr = SETCGRAMADDR;                // CGRAM = 0
  LcdWrite();
  #ifdef LCDSTEREO
  LcdWrite2();
  #endif

  for(i = 0; i < 64; i++)
  {
    DelayMs(2);
    LCDRSPIN1;
	ch.chr = userromcharset[i];
    LcdWrite();
    #ifdef LCDSTEREO
    LcdWrite2();
    #endif
  }

  DelayMs(2);
  LCDRSPIN0;
  ch.chr = SETDDRAMADDR1;               // DDRAM = els sor eleje
  LcdWrite();            
  #ifdef LCDSTEREO
  LcdWrite2();
  #endif // LCDSTEREO
  #endif // USERCHARSET
  LCDRSPIN1;

  // szveg trlse
  #ifdef LCDSTEREO
  for(i = 0; i < (2UL * LCDWIDTH * LCDLINES); i++) LcdText[i] = ' ';
  #else
  for(i = 0; i < (1UL * LCDWIDTH * LCDLINES); i++) LcdText[i] = ' ';
  #endif

  // villogs tmb trlse
  #ifdef LCDBLINKCHAR
  #ifdef LCDSTEREO
  for(i = 0; i < ((2UL * LCDWIDTH * LCDLINES + 7) / 8); i++) LcdBlink[i] = 0;
  #else  // LCDSTEREO
  for(i = 0; i < ((1UL * LCDWIDTH * LCDLINES + 7) / 8); i++) LcdBlink[i] = 0;
  #endif // LCDSTEREO
  #endif // LCDBLINKCHAR

  LcdPos = 0;

  #if (!defined LCDUSERTIMER) && ((defined LCDMODEONCEIRQ) || (defined LCDMODECONTIRQ))
  TIMERINIT;
  #ifdef LCDMODECONTIRQ
  LcdRefreshStart();
  #endif // LCDMODECONTIRQ
  #endif // (!defined LCDUSERTIMER) && ((defined LCDMODEONCEIRQ) || (defined LCDMODECONTIRQ))
}


//==============================================================================
// Blinker (villogtat, csak megszaktsos folyamatos frisstsi zemmdban)
#if (defined LCDMODECONTIRQ) && (defined LCDBLINKCHAR) && (LCDBLINKSPEED > 0)
#define BLINKER() {             \
  if(!BlinkTimer--)             \
  {                             \
    BlinkPhase = !BlinkPhase;   \
    BlinkTimer = LCDBLINKSPEED; \
  }                             \
}
#define AUTOBLINKER
#else  // (defined LCDMODECONTIRQ) && (defined LCDBLINKCHAR) && (LCDBLINKSPEED > 0)
#define BLINKER() ;
#endif // else (defined LCDMODECONTIRQ) && (defined LCDBLINKCHAR) && (LCDBLINKSPEED > 0)

//==============================================================================
// LcdProcess (egy karaktert frisst a kijelzn)
// Elfelttel: LcdInit() inicializlni kell
// Input:           LcdText[], villog mdban LcdBlink[]
// ttekints:      Ha szabad az LCD, egy karaktert tmsol az LcdText[] tmbbl 
//                  az LCD kijelzre 
// Megjegyzs:      Nincs vrokozsi id, ezrt USB-s alkalmazsnl ezzel frissthet 
//                  a kijelz.
//==============================================================================
#ifdef TIMERINTPROCESS
TIMERINTPROCESS
#else  // TIMERINTPROCESS
void LcdProcess(void)
#endif // else TIMERINTPROCESS
{
  // Automatikus blinker frame szmllja a villogs temezshez
  #ifdef AUTOBLINKER
  static char BlinkTimer = LCDBLINKSPEED;
  #endif

//------------------------------------------------------------------------------
  // megszakts md specialitsai
  #if (!defined LCDUSERTIMER) && ((defined LCDMODEONCEIRQ) || (defined LCDMODECONTIRQ))
  // kompartor nlkli idzt tlltsa
  TIMERCOMPLESS;
  // megszakts nyugtzsa
  TIMERIRQACK;
  #endif

//------------------------------------------------------------------------------
  // LCD foglaltsgfigyelses zemmd
  #if (((defined LCDMODEONCEBUSY) || (defined LCDMODECONTBUSY)) && (!defined SOFTSIMBUSY))
  if(LcdBusy()) return;                 // LCD foglalt ?
  #endif

  //----------------------------------------------------------------------------
  if(LcdStatus == LCHAR)
  {
    LCDRSPIN1;                          // karakter megy majd a kijelzre
    // ----------------------------------- egy karakter fissts
    ch.chr = LcdText[LcdPos];
    
    #ifdef LCDZEROCHANGE
    if (ch.chr == 0)
    {
      ch.chr = ' ';                     // #0 kd karakter -> szkz karakter
      #ifdef LCDZEROCHANGETEXT
      LcdText[LcdPos] = ' ';            // LcdText-ben is #0 -> 'SPACE' csere
      #endif
    }
    #endif // LCDZEROCHANGE

    #ifdef LCDBLINKCHAR
    if((BlinkPhase) && (LcdBlink[LcdPos >> 3] & (1 << (LcdPos & 7))))
      ch.chr = ' ';                     // ha villogsi fzis == 1, s az adott karakter is villogtatva van -> szkz
	#endif // LCDBLINKCHAR

    LcdWrite();

    // ----------------------------------- stereo kijelz esetn, a msik is rgtn rhat
    #ifdef LCDSTEREO

    ch.chr = LcdText[LcdPos + LCDLINES * LCDWIDTH];
    #ifdef LCDZEROCHANGE
    if (ch.chr == 0)
    {
      ch.chr = ' ';
      #ifdef LCDZEROCHANGETEXT
      LcdText[LcdPos + LCDLINES * LCDWIDTH] = ' '; // LcdText-ben is #0 -> 'SPACE' csere
      #endif
    }
    #endif // LCDZEROCHANGE

    #ifdef LCDBLINKCHAR
    if((BlinkPhase) && (LcdBlink[(LcdPos + LCDLINES * LCDWIDTH) >> 3] & (1 << ((LcdPos + LCDLINES * LCDWIDTH) & 7))))
      ch.chr = ' ';
    #endif // LCDBLINKCHAR

    LcdWrite2();
    #endif // LCDSTEREO
    //------------------------------------

    LcdPos++;

    //------------------------------------ 1 soros
    #if LCDLINES == 1
    if(LcdPos == LCDWIDTH)              // 1 soros 1.sor vge?
    {
	  #ifdef LCDCURSOR
      LcdStatus = CURPOS;               // kurzor pozci bellts
	  #else // LCDCURSOR
	  #ifdef LCDMODEONCEIRQ
      LcdRefreshStop();                 // ksz az LCD frisstse, lellthat
      #else  // LCDMODEONCEIRQ
      LcdStatus = REFREND;              // ksz az LCD frisstse, LcdRefresh while ciklusa befejezdhet
      #endif // else LCDMODEONCEIRQ
	  #endif // LCDCURSOR

      #if ((defined LCDMODECONTBUSY) || (defined LCDMODECONTIRQ))
      LcdStatus = DDR;                  // folyamatos frisstsi zemmdban DDRAM llts lesz majd
	  #endif
	}
    //------------------------------------ 2 soros
    #elif LCDLINES == 2
    if(LcdPos == LCDWIDTH)              // 2 soros, 1.sor vge?
    {
      LcdStatus = DDR;                  // DDRAM llts lesz majd
    }
	else if(LcdPos == LCDWIDTH * 2)     // 2 soros, 2.sor vge?
    {
	  #ifdef LCDCURSOR
      LcdStatus = CURPOS;               // kurzor pozci bellts
	  #else // LCDCURSOR
	  #ifdef LCDMODEONCEIRQ
      LcdRefreshStop();                 // ksz az LCD frisstse, lellthat
      #else  // LCDMODEONCEIRQ
      LcdStatus = REFREND;              // ksz az LCD frisstse, LcdRefresh while ciklusa befejezdhet
      #endif // else LCDMODEONCEIRQ
	  #endif // LCDCURSOR

      #if ((defined LCDMODECONTBUSY) || (defined LCDMODECONTIRQ))
      LcdStatus = DDR;                  // folyamatos frisstsi zemmdban DDRAM llts lesz majd
	  #endif
    }
    //------------------------------------ 4 soros
    #elif LCDLINES == 4
 
    //------------------------------------ 4 soros szimpla vezrls
    if(LcdPos == LCDWIDTH)              // 4 soros, 1.sor vge?
    {
      LcdStatus = DDR;                  // DDRAM llts lesz majd
    }
	else if(LcdPos == LCDWIDTH * 2)     // 4 soros, 2.sor vge?
    {
      LcdStatus = DDR;                  // DDRAM llts lesz majd
    }
    else if(LcdPos == LCDWIDTH * 3)     // 4 soros, 3.sor vge?
    {
      LcdStatus = DDR;                  // DDRAM llts lesz majd
    }
    else if(LcdPos == LCDWIDTH * 4)     // 4 soros, 4.sor vge?
    {
	  #ifdef LCDCURSOR
      LcdStatus = CURPOS;               // kurzor pozci bellts
	  #else // LCDCURSOR
	  #ifdef LCDMODEONCEIRQ
      LcdRefreshStop();                 // ksz az LCD frisstse, lellthat
      #else  // LCDMODEONCEIRQ
      LcdStatus = REFREND;              // ksz az LCD frisstse, LcdRefresh while ciklusa befejezdhet
      #endif // else LCDMODEONCEIRQ
	  #endif // LCDCURSOR

      #if ((defined LCDMODECONTBUSY) || (defined LCDMODECONTIRQ))
      LcdStatus = DDR;                  // folyamatos frisstsi zemmdban DDRAM llts lesz majd
	  #endif
    }
    #endif // LCDLINES

  } // LcdStatus

  //----------------------------------------------------------------------------
  else if(LcdStatus == DDR)             // DDRAM lltgats
  {
    // ----------------------------------- DDRAM lltgats (sorok vgein), villogtatsi temezs
    LCDRSPIN0;                          // parancs megy majd a kijelzre

    // ----------------------------------- 1 soros kijelz
	#if LCDLINES == 1
	ch.chr = SETDDRAMADDR1;             // 1 soros, 1.sor vge -> DDRAM = 1.sor eleje
    LcdWrite();
    #ifdef LCDSTEREO
    LcdWrite2();
    #endif
    LcdPos = 0;
	BLINKER();

	// ----------------------------------- 2 soros kijelz
	#elif LCDLINES == 2
    if(LcdPos == LCDWIDTH)
    {                                   // 2 soros, 1.sor vge
      ch.chr = SETDDRAMADDR2;           // DDRAM = 2.sor eleje
      LcdWrite();
      #ifdef LCDSTEREO
      LcdWrite2();
      #endif
	}
    else
    {                                   // 2 soros, 2.sor vge
	  ch.chr = SETDDRAMADDR1;           // DDRAM = 1.sor eleje
      LcdWrite();
      #ifdef LCDSTEREO
      LcdWrite2();
      #endif
      LcdPos = 0;
	  BLINKER();
    }

	// ----------------------------------- 4 soros kijelz
    #elif LCDLINES == 4

	// 4 soros szimpla vezrls (max 80 karakteres)
    if(LcdPos == LCDWIDTH)              // 1. sor vge ?
	{ 
	  ch.chr = SETDDRAMADDR2;           // DDRAM = 2.sor eleje
      LcdWrite();
      #ifdef LCDSTEREO
      LcdWrite2();
      #endif
	}
    else if(LcdPos == (LCDWIDTH * 2))   // 2. sor vge ?
	{
	  ch.chr = SETDDRAMADDR3;           // DDRAM = 3.sor eleje
      LcdWrite();
      #ifdef LCDSTEREO
      LcdWrite2();
      #endif
	}
    else if(LcdPos == (LCDWIDTH * 3))   // 3. sor vge ?
	{
	  ch.chr = SETDDRAMADDR4;           // DDRAM = 4.sor eleje
      LcdWrite();
      #ifdef LCDSTEREO
      LcdWrite2();
      #endif
	}
    else if(LcdPos == (LCDWIDTH * 4))   // 4. sor vge ?
    {
	  ch.chr = SETDDRAMADDR1;           // DDRAM = 1.sor eleje
      LcdWrite(); 
      #ifdef LCDSTEREO
      LcdWrite2();
      #endif
      LcdPos = 0;
	  BLINKER();
    }
    #endif // LCDLINES
    LcdStatus = LCHAR;                  // a kvetkez hvsnl mr karakter megy a kijelzre
  }

  //----------------------------------------------------------------------------
  else if(LcdStatus == HOME)            // DDRAM = 0
  {
    LCDRSPIN0;                          // parancs megy majd a kijelzre
    ch.chr = SETDDRAMADDR1;             // DDRAM = 1.sor eleje
    LcdWrite();
    #ifdef LCDSTEREO
    LcdWrite2();
    #endif
    LcdPos = 0;
    LcdStatus = LCHAR;                  // a kvetkez hvsnl mr karakter megy a kijelzre
  }

  #ifdef LCDCURSOR
  //----------------------------------------------------------------------------
  else if(LcdStatus == CURPOS)          // kurzor pozci lltsi fzis
  {
    LCDRSPIN0;                          // parancs megy majd a kijelzre

	// ----------------------------------- 1 soros kijelz
    #if LCDLINES == 1
    ch.chr = SETDDRAMADDR1 + LcdCursorPos;// DDRAM = 1.sor + kurzor pozci
    LcdWrite();

    #elif LCDLINES == 2
	// ----------------------------------- 2db 2 soros kijelz
	#ifdef LCDSTEREO
	if(LcdCursorPos < LCDCHARPERMODUL)
	{                                   // a kurzor az 1.modulban van
      if (LcdCursorPos < LCDWIDTH)
        ch.chr = SETDDRAMADDR1 + LcdCursorPos;// DDRAM = 1.sor + kurzor pozci
      else
        ch.chr = SETDDRAMADDR2 - LCDWIDTH + LcdCursorPos;// DDRAM = 2.sor - 1*sorhossz + kurzor pozci
    }
	else
	{                                   // a kurzor az 2.modulban van
      if (LcdCursorPos < LCDCHARPERMODUL + LCDWIDTH)
        ch.chr = SETDDRAMADDR1 - LCDCHARPERMODUL + LcdCursorPos;// DDRAM = 1.sor - modulkarakterszm + kurzor pozci
      else
        ch.chr = SETDDRAMADDR2 - LCDCHARPERMODUL - LCDWIDTH + LcdCursorPos;// DDRAM = 2.sor - modulkarakterszm - 1*sorhossz + kurzor pozci
	}
    LcdWrite();
    LcdWrite2();
    #else  // LCDSTEREO

	// ----------------------------------- 2 soros kijelz
    if (LcdCursorPos < LCDWIDTH)
      ch.chr = SETDDRAMADDR1 + LcdCursorPos;// DDRAM = 1.sor + kurzor pozci
    else
      ch.chr = SETDDRAMADDR2 - LCDWIDTH + LcdCursorPos;// DDRAM = 2.sor - 1*sorhossz + kurzor pozci
    LcdWrite();
    #endif // else LCDSTEREO

	// ----------------------------------- 2db 4 soros kijelz
    #elif LCDLINES == 4
	#ifdef LCDSTEREO

	if(LcdCursorPos < LCDCHARPERMODUL)
	{                                   // a kurzor az 1.modulban van
	  if(LcdCursorPos < LCDWIDTH)
	  {
        ch.chr = SETDDRAMADDR1 + LcdCursorPos;// DDRAM = 1.sor + kurzor pozci
	  }
	  else if(LcdCursorPos < 2 * LCDWIDTH)
	  {
        ch.chr = SETDDRAMADDR2 - LCDWIDTH + LcdCursorPos;// DDRAM = 2.sor - 1*sorhossz + kurzor pozci
	  }
	  else if(LcdCursorPos < 3 * LCDWIDTH)
	  {
        ch.chr = SETDDRAMADDR3 - 2*LCDWIDTH + LcdCursorPos;// DDRAM = 3.sor - 2*sorhossz + kurzor pozci
	  }
	  else
	  {
        ch.chr = SETDDRAMADDR4 - 3*LCDWIDTH + LcdCursorPos;// DDRAM = 4.sor - 3*sorhossz + kurzor pozci
	  }
    }
    else
	{                                   // a kurzor az 2.modulban van
	  if(LcdCursorPos < LCDWIDTH + LCDCHARPERMODUL)
	  {
        ch.chr = SETDDRAMADDR1 - LCDCHARPERMODUL + LcdCursorPos;// DDRAM = 1.sor + kurzor pozci
	  }
	  else if(LcdCursorPos < 2 * LCDWIDTH + LCDCHARPERMODUL)
	  {
        ch.chr = SETDDRAMADDR2 - LCDCHARPERMODUL - LCDWIDTH + LcdCursorPos;// DDRAM = 2.sor - 1*sorhossz + kurzor pozci
	  }
	  else if(LcdCursorPos < 3 * LCDWIDTH + LCDCHARPERMODUL)
	  {
        ch.chr = SETDDRAMADDR3 - LCDCHARPERMODUL - 2*LCDWIDTH + LcdCursorPos;// DDRAM = 3.sor - 2*sorhossz + kurzor pozci
	  }
	  else
	  {
        ch.chr = SETDDRAMADDR4 - LCDCHARPERMODUL - 3*LCDWIDTH + LcdCursorPos;// DDRAM = 4.sor - 3*sorhossz + kurzor pozci
	  }
    }
    LcdWrite();
    LcdWrite2();
  
	// ----------------------------------- 4 soros dupla vezrls kijelz (2db 2soros)
    #else  // LCDSTEREO
	if(LcdCursorPos < LCDWIDTH)
	{
      ch.chr = SETDDRAMADDR1 + LcdCursorPos;// DDRAM = 1.sor + kurzor pozci
	}
	else if(LcdCursorPos < 2 * LCDWIDTH)
	{
      ch.chr = SETDDRAMADDR2 - LCDWIDTH + LcdCursorPos;// DDRAM = 2.sor - 1*sorhossz + kurzor pozci
	}
	else if(LcdCursorPos < 3 * LCDWIDTH)
	{
      ch.chr = SETDDRAMADDR3 - 2*LCDWIDTH + LcdCursorPos;// DDRAM = 3.sor - 2*sorhossz + kurzor pozci
	}
	else
	{
      ch.chr = SETDDRAMADDR4 - 3*LCDWIDTH + LcdCursorPos;// DDRAM = 4.sor - 3*sorhossz + kurzor pozci
	}
    LcdWrite();

    #endif // else LCDSTEREO
    #endif // LCDLINES 

    LcdStatus = CURTYPE;                // a kvetkez hvsnl kurzortpus bellts
  }

  //----------------------------------------------------------------------------
  else if(LcdStatus == CURTYPE)         // kurzor tpus lltsi fzis
  {
    LCDRSPIN0;                          // parancs megy majd a kijelzre

    #ifdef LCDSTEREO
	if(LcdCursorPos < LCDCHARPERMODUL)
	{ // els modulban van
      ch.chr = LcdCursorType | 0b00001100;
      LcdWrite();                       // kurzor a bellts
	  ch.chr = 0b00001100;
      LcdWrite2();                      // kurzor kikapcs
	}
	else
	{ // msodik modulban van a kurzor
	  ch.chr = 0b00001100;
      LcdWrite();                       // kurzor kikapcs
      ch.chr = LcdCursorType | 0b00001100;
      LcdWrite2();                      // kurzor a bellts
	}

	#else  // LCDSTEREO
    ch.chr = LcdCursorType | 0b00001100;
    LcdWrite();
    #endif // LCDSTEREO

    #ifdef LCDMODEONCEIRQ
    LcdRefreshStop();                   // ksz az LCD frisstse, lellthat
    #else  // LCDMODEONCEIRQ
    LcdStatus = REFREND;                // ksz az LCD frisstse, LcdRefresh while ciklusa befejezdhet
    #endif // else LCDMODEONCEIRQ
  }

  #endif // LCDCURSOR


  //----------------------------------------------------------------------------
  // Karakterkszlet frissts
  #ifdef USERCHARSETCHANGE
  else if(LcdStatus == CGR)             // CGRAM cm belltsi fzis
  {
    LCDRSPIN0;                          // parancs megy a kijelzre
    ch.chr = SETCGRAMADDR;              // CGRAM = 0
    LcdWrite();
    #ifdef LCDSTEREO
    LcdWrite2();
    #endif
    LcdPos = 0;                         // karakter genertor karakter szmll
    LcdStatus = CHARGEN;                // karakter genertor feltltse kvetkezik
  }

  //----------------------------------------------------------------------------
  else if(LcdStatus == CHARGEN)         // karakter genertor feltltse
  {
    LCDRSPIN1;                          // karakter megy a kijelzre
    ch.chr = *uchp++;                   // karakter ler tmb
    LcdWrite();
    #ifdef LCDSTEREO
    LcdWrite2();
    #endif
    LcdPos++;
    if(LcdPos >= 64)
    {                                   // karaktergenertor feltlts befejezdtt
      #if ((defined LCDMODEONCEBUSY) || (defined LCDMODEONCEDELAY))
      #ifdef LCDCURSOR
      LcdStatus = CURPOS;               // egyszeri frisstsi md, megszakts nlkl kurzorral: kurzor pozci bellts
      #else  // LCDCURSOR
      LcdStatus = REFREND;              // egyszeri frisstsi md, megszakts nlkl: ksz az LCD karaktergenertor frisstse -> LcdRefresh while ciklusa befejezdhet
      #endif // else LCDCURSOR
      #endif // ((defined LCDMODEONCEBUSY) || (defined LCDMODEONCEDELAY))

      #ifdef LCDMODEONCEIRQ
      LcdStatus = HOME;                 // egyszeri frisstsi md megszaktssal: DDRAM = 0 lesz a kvetkez krben
      #endif // LCDMODEONCEIRQ

      #if ((defined LCDMODECONTBUSY) || (defined LCDMODECONTIRQ))
      LcdStatus = HOME;                 // folyamatos frisstsi md: DDRAM = 0 lesz a kvetkez krben
      #ifdef AUTOBLINKER
      #if LCDCHARPERMODUL <= 24
	  BLINKER();                        // hogy a villogsi temezs ne maradjon ki
	  BLINKER();                        // 1x16, 1x20-as kijelzknl a 64 byte feltltse kb annyi ideig tart mint ngy frame
	  BLINKER();
	  BLINKER();
      #elif LCDCHARPERMODUL <= 48
	  BLINKER();                        // hogy a villogsi temezs ne maradjon ki
	  BLINKER();                        // 2x16, 2x20-as kijelzknl a 64 byte feltltse kb annyi ideig tart mint kt frame
      #else  // LCDCHARPERMODUL
	  BLINKER();                        // nagyobb kijelzknl a 64 byte feltltse kb annyi ideig tart mint egy frame
      #endif // LCDCHARPERMODUL
	  #endif // AUTOBLINKER
      #endif // (defined LCDMODECONTBUSY) || (defined LCDMODECONTIRQ)
    }
  }

  #endif // USERCHARSETCHANGE
}

#if ((defined LCDMODEONCEBUSY) || (defined LCDMODEONCEDELAY) || (defined LCDMODEONCEIRQ))
//==============================================================================
// LcdRefreshAll (csak egyszeri frisstsi zemmdban: a teljes kijelztartalom frisstse)
// Elfelttel: LcdInit() inicializlni kell
// Input:           LcdText[], villog mdban LcdBlink[]
// ttekints:      LcdText[] teljes tartalmt tmsolja az LCD kijerlzre 
//                  megszakts nlkli md:
//                    addig tart a fggvm lefutsa, amg az tmsols tart (blokkol fggvny!)
//                  megszaktsos md:
//                    csak elindtja a msolst, a karakterek kirsa megszaktsbl fog megtrtnni,
//                    a teljes tartalom kirsa utn lelltja a frisstst
// Megjegyzs:      
//==============================================================================
void LcdRefreshAll(void)
{
  #ifdef LCDMODEONCEIRQ
  #ifdef USERCHARSETCHANGE
  if(!LcdRefreshed())
  { // frissts folyamatban van mg
    if((LcdStatus == CGR) || (LcdStatus == CHARGEN))
    { // karaktergenertor frissts van folyamatban, semmit nem kell csinlni
    } // mert a karaktergenertor vgeztvel a kijelz tartalmat is jrarja
    else
    { // szveg frissts van mg folyamatban -> ellrl kezdeni
      LcdStatus = HOME;
      LcdRefreshStart();                // mehet (ha pont most llt volna le)
    }
  }
  else
  { // nincs frissts alatt
    LcdStatus = HOME;                   // megszakts, kijelz frisstst ellrl kezdeni
    LcdRefreshStart();                  // mehet
  }
  #else  // USERCHARSETCHANGE
  LcdStatus = HOME;                     // megszakts, karakterkszlet mdosts nlkl
  LcdRefreshStart();
  #endif // USERCHARSETCHANGE
  #endif // LCDMODEONCEIRQ

  #ifdef LCDMODEONCEBUSY
  LcdStatus = HOME;                     // megszakts nlkl
  while(LcdStatus != REFREND)
    LcdProcess();                       // megvrjuk amg kirdik
  #endif

  #ifdef LCDMODEONCEDELAY
  LcdStatus = HOME;                     // megszakts nlkl
  while(LcdStatus != REFREND)
  {
    DelayLcd();                         // Lcd rs vrakozs
    LcdProcess();                       // megvrjuk amg kirdik
  }
  #endif
}
#endif //  ((defined LCDMODEONCEBUSY) || (defined LCDMODEONCEDELAY) || (defined LCDMODEONCEIRQ))

#ifdef USERCHARSETCHANGE
//==============================================================================
// LcdChangeCharset (a 8db felhasznl ltal definilt karakterkszlet kirsa)
// Elfelttel: LcdInit(), USERCHARSETCHANGE
// Input:           pch*: a 64 bjtos karaktertbla cme a RAM-ban
// ttekints:      Egyszeri frisstsi zemmdban:
//                  megszakts nlkli md:
//                    addig tart a fggvm lefutsa, amg az tmsols tart (blokkol fggvny, 
//                    csak a karakterkszletet msolja t, a kijelz tartalmat nem!)
//                  megszaktsos md:
//                    csak elindtja a msolst, a karakterkszlet s a kijelz tartalmnak kirsa 
//                    (a karakterkszlet utn a szveget is jrarja) megszaktsbl fog megtrtnni,
//                    a teljes tartalom kirsa utn lelltja a frisstst
//
//                  Folyamatos frisstsi zemmdban:
//                  megszakts nlkli md: 
//                    A kijelzre trtn kirs a fprogramhurokban az LcdProcess() fggvnyhvssal fog megtrtnni (ha a kijelz szabad).
//                    Ha a teljes karakterkszletet kirta, akkor automatikusan a tartalom kirsra tr t.
//                  megszaktsos md:
//                    csak elindtja a msolst, a karakterkszlet s a kijelz tartalmnak kirsa megszaktsbl fog megtrtnni,
//                    a teljes tartalom kirsa utn automatikusan a tartalom kirsra tr t.
// Megjegyzs:
//==============================================================================
void LcdChangeCharset(char* pch)
{
  LcdStatus = CGR;
  uchp = pch;

  #ifdef LCDMODEONCEIRQ
  LcdRefreshStart();                    // egyszeri frisstsi zemmd, megszaktsban
  #endif

  #ifdef LCDMODEONCEBUSY
  while(LcdStatus != REFREND)           // egyszeri frisstsi zemmd, megszakts nlkl
    LcdProcess();                       // megvrjuk amg kirdik
  #endif

  #ifdef LCDMODEONCEDELAY
  while(LcdStatus != REFREND)           // egyszeri frisstsi zemmd vrakozsos md
  {
    DelayLcd();                         // Lcd rs vrakozs
    LcdProcess();                       // megvrjuk amg kirdik
  }
  #endif
}
#endif // USERCHARSETCHANGE
