//******************************************************************************
// 8 bites 18Fxxx helloworld demo az charlcd tesztelshez
// kszt: Roberto Benjami (robertodebenjami(at)gmail(dot)com)
//
// charlcd.h szksges belltsai:
// - LCDMODECONTIRQ zemmd
// - a tbbi bellts brmi lehet, csak a felhasznlt mikrovezrl is tmogassa
//   (pl.a belltott I/O lb s a TIMER ltezzen)
// - adott esetben az I/O lbak analgrl -> digitlisra trtn tlltsrl gondoskodjunk!
// - kt kijelz (LCDSTEREO) hasznlata esetn, csak az els kijelzn fog megjelenni az felirat
//   (ha hosszabb szveget runk az LcdText-be, akkor a msodik kijelzre is t fog lgni)
//******************************************************************************

#include <p18cxxx.h>
#include <string.h>
#include "charlcd.h"

void YourHighPriorityISRCode(void);
void YourLowPriorityISRCode(void);

void main(void)
{
  LcdInit();                            // mkdsre brjuk az LCD-t
  //                             "01020304050607080910111213141516"
  memcpypgm2ram((char *)LcdText, "   Hello world                  ", 32); // kezdkperny feltltse

  while(1)
  {
  }
}

#pragma code high_vector_section = 0x8
void InterruptVectorHigh(void)
{
  _asm goto YourHighPriorityISRCode _endasm
}

#pragma code low_vector_section = 0x18
void InterruptVectorLow(void)
{
  _asm goto YourLowPriorityISRCode _endasm
}

#pragma code

#pragma interrupt YourHighPriorityISRCode
void YourHighPriorityISRCode(void)
{
  #if ((LCDTIMERPR18 == -1) || (LCDTIMERPR18 == 1))
  LcdIntProcess();                      // HI s priorits nlkli interrupt md esetn frisstjk a kijelz tartalmt
  #endif
}

#pragma interruptlow YourLowPriorityISRCode
void YourLowPriorityISRCode(void)
{
  #if LCDTIMERPR18 == 0
  LcdIntProcess();                      // LO interrupt md esetn frisstjk a kijelz tartalmt
  #endif
}
