//******************************************************************************
// LCD kijelz sebessgt mr program
// kszt: Roberto Benjami (robertodebenjami(at)gmail(dot)com)
//
// Mkdse:
// - TIMER1 segtsgvel megmri mennyi ideig tart az LCD frisstse BUSY flag figyelses zemmdban.
//   Kirja az ebbl add kpkocka/msodperc (FPS) s a karakter/msodperc (CPS) rtkt.
//
// charlcd.h szksges belltsai:
// - Egyszeri frisstsi zemmd megszakts nlkl, BUSY flag figyelssel (LCDMODEONCEBUSY)
//******************************************************************************

#include <avr/io.h>
#include <avr/interrupt.h>
#include <string.h>
#include <stdlib.h>
#include "charlcd.h"

#if (1UL * LCDWIDTH * LCDLINES < 80)
#define  FPSPOZ     0
#define  CPSPOZ     16
#else  // (1UL * LCDWIDTH * LCDLINES) < 80
#define  FPSPOZ     82
#define  CPSPOZ     98
#endif // else (1UL * LCDWIDTH * LCDLINES) < 80

#ifndef LCDMODEONCEBUSY
//#error "Rossz belltsok az lcdchar.h-ban"
#endif

//******************************************************************************
unsigned int t1cycle;                   // 16 bites TIMER1 rtke ide kerl

//----------------------------------------------------------------------------
// TIMER 1 rsa, olvassa (paramter: rs konstans vagy 16bites vltoz, olvass 16bites vltoz)
#define SETTIMER1(t1)   {TCNT1H = t1 >> 8; TCNT1L = t1;}
#define GETTIMER1(t1)   {t1 = TCNT1L; t1 += TCNT1H << 8;}

//----------------------------------------------------------------------------
#define DELAYNUM (CpuClock/1000/14)
void delaymms(unsigned char ms)
{
  volatile unsigned int dm;

  while(ms--)
  {
    dm = DELAYNUM;
    while(dm--);
  }
}

//----------------------------------------------------------------------------
void lcdspeedscreen(void)
{
  static unsigned long ul;
  if(!(TIFR1 & (1 << TOV1)))
  {
    memcpy((char *)LcdText + FPSPOZ, "FPS:      ", 10);
    memcpy((char *)LcdText + CPSPOZ, "CPS:      ", 10);
    ul = (SystemClock/64UL) / ((unsigned long)t1cycle);
    ultoa(ul, (char *)LcdText +  FPSPOZ + 4, 10);
    ultoa(ul * (1UL * LCDLINES * LCDWIDTH), (char *)LcdText +  CPSPOZ + 4, 10);
  }
  else
  {
    memcpy((char *)LcdText + FPSPOZ, "FPS: ovf  ", 10);
    memcpy((char *)LcdText + CPSPOZ, "CPS: ovf  ", 10);
    TIFR1 &= ~(1 << TOV1);
  }
}

//----------------------------------------------------------------------------
void init(void)
{
  // 1. idzt inicializlsa
  // 64-es oszts:
  #define TMCLKSEL         3
  TCCR1B = (TMCLKSEL<<CS10);            // Clk = ClkIO/1..8..64..256..1024
}

//******************************************************************************
int main(void)
{
  // ha szksg van AD lb digitlis I/O lbra trtn tkapcsolsra
  #ifdef InitAD
  InitAD();
  #endif

  LcdInit();                            // mkdsre brjuk az LCD-t

  #if (1UL * LCDWIDTH * LCDLINES) < 80 
  // 2x16 karakteres -------------------
  //                         "01020304050607080910111213141516"
  // memcpy((char *)LcdText, " LCD CPU used       meter       ", 32); // kezdkperny feltltse
  #else  // (1UL * LCDWIDTH * LCDLINES) < 80
  // 4x40 karakteres -------------------
  //                                   "0204060810121416182022242628303234363840"
  memcpy((char *)LcdText +   0, "****************************************", 40); // kezdkperny feltltse
  memcpy((char *)LcdText +  40, "*            LCD speed meter           *", 40); // kezdkperny feltltse
  memcpy((char *)LcdText +  80, "*                                      *", 40); // kezdkperny feltltse
  memcpy((char *)LcdText + 120, "****************************************", 40); // kezdkperny feltltse
  #endif // else (1UL * LCDWIDTH * LCDLINES) < 80

  init();

  while(1)
  {
    // mrs ---------------------------
    SETTIMER1(0);
    TIFR1 &= ~(1 << TOV1);
    //T1CONbits.TMR1ON = 1;               // bekapcs
    LcdRefreshAll();
    //T1CONbits.TMR1ON = 0;               // kikapcs
    GETTIMER1(t1cycle);

    // megjelents -----------------------
    lcdspeedscreen();
	delaymms(100);                        // 100ms vrakozs
  }
}
