//******************************************************************************
// LCD kijelz sebessgt mr program
// kszt: Roberto Benjami (robertodebenjami(at)gmail(dot)com)
//
// Mkdse:
// - TIMER1 segtsgvel megmri mennyi ideig tart az LCD frisstse BUSY flag figyelses zemmdban.
//   Kirja az ebbl add kpkocka/msodperc (FPS) s a karakter/msodperc (CPS) rtkt.
//
// charlcd.h szksges belltsai:
// - Egyszeri frisstsi zemmd megszakts nlkl, BUSY flag figyelssel (LCDMODEONCEBUSY)
//******************************************************************************

#include <p18cxxx.h>
#include <string.h>
#include <stdlib.h>
#include "GenericTypeDefs.h"
#include "charlcd.h"

#if (1UL * LCDWIDTH * LCDLINES < 80)
#define  FPSPOZ     0
#define  CPSPOZ     16
#else  // (1UL * LCDWIDTH * LCDLINES) < 80
#define  FPSPOZ     82
#define  CPSPOZ     98
#endif // else (1UL * LCDWIDTH * LCDLINES) < 80

#ifndef LCDMODEONCEBUSY
#error "Rossz belltsok az lcdchar.h-ban"
#endif

//******************************************************************************
unsigned int t1cycle;                   // 16 bites TIMER1 rtke ide kerl

//----------------------------------------------------------------------------
// TIMER 1 rsa, olvassa (paramter: rs konstans vagy 16bites vltoz, olvass 16bites vltoz)
#define SETTIMER1(t1)   {TMR1H = t1 >> 8; TMR1L = t1;}
#define CPTIMER1(t1)    {TMR1H = ((WORD_VAL*)&t1)->byte.HB; TMR1L = t1;}
#define GETTIMER1(t1)   {(((WORD_VAL*)&t1)->byte.LB) = TMR1L; (((WORD_VAL*)&t1)->byte.HB) = TMR1H;}

//----------------------------------------------------------------------------
void lcdspeedscreen(void)
{
  static unsigned long ul;
  if(!PIR1bits.TMR1IF)
  {
    memcpypgm2ram((char *)LcdText + FPSPOZ, "FPS:      ", 10);
    memcpypgm2ram((char *)LcdText + CPSPOZ, "CPS:      ", 10);
    ul = (SystemClock/4UL) / ((unsigned long)t1cycle << 3);
    ltoa(ul, (char *)LcdText +  FPSPOZ + 4);
    ltoa(ul * (1UL * LCDLINES * LCDWIDTH), (char *)LcdText +  CPSPOZ + 4);
  }
  else
  {
    memcpypgm2ram((char *)LcdText + FPSPOZ, "FPS: ovf  ", 10);
    memcpypgm2ram((char *)LcdText + CPSPOZ, "CPS: ovf  ", 10);
    PIR1bits.TMR1IF = 0;
  }
}

//----------------------------------------------------------------------------
void init(void)
{
  // 1. idzt inicializlsa
  T1CONbits.T1OSCEN = 0;                // rakvarc tilts
  T1CONbits.TMR1CS = 0;                 // forrs rajel = CPU clk
  T1CONbits.T1CKPS = 3;                 // eloszt : 1:8
  T1CONbits.TMR1ON = 0;                 // kikapcs
}

//******************************************************************************
void main(void)
{
  unsigned char c;

  // ha szksg van AD lb digitlis I/O lbra trtn tkapcsolsra
  #ifdef InitAD
  InitAD();
  #endif

  LcdInit();                            // mkdsre brjuk az LCD-t

  #if (1UL * LCDWIDTH * LCDLINES) < 80 
  // 2x16 karakteres -------------------
  //                         "01020304050607080910111213141516"
  // memcpypgm2ram((char *)LcdText, " LCD CPU used       meter       ", 32); // kezdkperny feltltse
  #else  // (1UL * LCDWIDTH * LCDLINES) < 80
  // 4x40 karakteres -------------------
  //                                   "0204060810121416182022242628303234363840"
  memcpypgm2ram((char *)LcdText +   0, "****************************************", 40); // kezdkperny feltltse
  memcpypgm2ram((char *)LcdText +  40, "*            LCD speed meter           *", 40); // kezdkperny feltltse
  memcpypgm2ram((char *)LcdText +  80, "*                                      *", 40); // kezdkperny feltltse
  memcpypgm2ram((char *)LcdText + 120, "****************************************", 40); // kezdkperny feltltse
  #endif // else (1UL * LCDWIDTH * LCDLINES) < 80

  init();

  while(1)
  {
    // mrs ---------------------------
    SETTIMER1(0);
    T1CONbits.TMR1ON = 1;               // bekapcs
    LcdRefreshAll();
    T1CONbits.TMR1ON = 0;               // kikapcs
    GETTIMER1(t1cycle);

    // megjelents -----------------------
    lcdspeedscreen();
  }
}
