#include <avr/io.h>
#include "m_delay_10ms.h"
#include "spiout.h"
#include "admeasure.h"

//-------------------------------------
void Init() {
//-------------------------------------
	DDRB   =  0b11111011;       //ADC PB2 bemenet, tobbi kimenet!
	DIDR0 |=  (1<<ADC1D);		// ADC1D enable
}

//-------------------------------------
unsigned short CreateBar(unsigned char v) {
//-------------------------------------
 unsigned char i;
 unsigned short val;

  val = 0;
  for(i=0;i<v;i++) {
		val |= 1;
		val <<= 1;
  }
  return val;
}


//-------------------------------------
int main(void) {
//-------------------------------------
	unsigned long adc = 0;
	unsigned short tmp = 0;

	Init();
	ADInit();

	for(;;)  {						//vgtelen ciklus
		SPIReset();		
		adc = MeasureADC(1);		//mrs ADC1-en
		if(adc>=512) {
			adc -= 512;	
		}
		else {
			adc = 0;
		}
		
		tmp = CreateBar(adc/32);     // 512/32 => 16 szegmens
		SPIOut(tmp>>8);
		SPIOut(tmp);
		LatchOut();
		m_delay_10ms(2);
	}
 }
