#ifndef _ADXL345
#define _ADXL345

#include <avr/io.h> 
#include "integer.h" 
#include "ioports.h" 

#define SW_SPI

//IO 
#define ADXL345_DDR			DDRD
#define ADXL345_PORT		PORTD
#define ADXL345_PIN			PIND

#define ADXL345_CS_PIN		PIN4_bm
#define ADXL345_SCK_PIN		PIN5_bm
#define ADXL345_MOSI_PIN	PIN6_bm
#define ADXL345_MISO_PIN	PIN7_bm

#define INIT_ADXL_PORT()	ADXL345_DDR|= ADXL345_SCK_PIN|ADXL345_MOSI_PIN|ADXL345_CS_PIN;ADXL345_PORT|=ADXL345_SCK_PIN|ADXL345_CS_PIN

#define ADXL_CS_LO()		ADXL345_PORT&=~ADXL345_CS_PIN
#define ADXL_CS_HI()		ADXL345_PORT|=ADXL345_CS_PIN
#define ADXL_SCK_LO()		ADXL345_PORT&=~ADXL345_SCK_PIN
#define ADXL_SCK_HI()		ADXL345_PORT|=ADXL345_SCK_PIN
#define ADXL_MOSI_LO()		ADXL345_PORT&=~ADXL345_MOSI_PIN
#define ADXL_MOSI_HI()		ADXL345_PORT|=ADXL345_MOSI_PIN

#define SPI_READ       		0x80
#define SPI_WRITE      		0x00


//registers
#define ADXL345_RA_DEVCE_ID         0x00		//device ID 0b11100101
#define ADXL345_RA_THRESH_TAP       0x1D		//62,5 milig/LSB 0xFF->16g  ezt az rtket kell meghaladnia anorml TAP gyorsulsrtknek
#define ADXL345_RA_OFSX             0x1E
#define ADXL345_RA_OFSY             0x1F
#define ADXL345_RA_OFSZ             0x20		
#define ADXL345_RA_DUR              0x21		//0x30-> 30 msec//ennyi ideig kell az rtknek a 0x1D-ben definilt rtk felett lennie 625usec/LSB
#define ADXL345_RA_LATENT           0x22		//0x40->80 msec//az els TAP lezajlsa (amikor mr nincs az rtk a 0x1D-ben belltott felett) utni vrakozs 1,25msec/LSB
#define ADXL345_RA_WINDOW           0x23		//0xFF->318,75msec //a latens id letelte utn a window id alatt kell betnie a msodik TAP-nek 1,25msec/LSB
#define ADXL345_RA_THRESH_ACT       0x24		//aktivitst rzkel kszb 62,5 milig/LSB 0xFF->16g, 0 esetn nincs ilyen mkds
#define ADXL345_RA_THRESH_INACT     0x25		//Inaktivitst rzkel kszb 62,5 milig/LSB 0xFF->16g, 0 esetn nincs ilyen mkds
#define ADXL345_RA_TIME_INACT       0x26		//ennyi ideig kell a gyorsulsnak kisebbnek lenni, mint az elz regiszter rtke 1sec/LSB
#define ADXL345_RA_ACT_INACT_CTL    0x27		//ACT, INACT X,Y,Z engedlyezs D7 ACT ac/dc, D3 INACT ac/dc 0 esetn a THRESH_ACT s THRESH_INACT registerekkel hasonltja 1 esetn meg meg kell nzni 24. oldal
#define ADXL345_RA_THRESH_FF        0x28		//szabadess regiszter 62,5 milig/LSB 300-600 milig ajnlott (0x05-0x09)
#define ADXL345_RA_TIME_FF          0x29		//szabadess id regiszter minimum id amg minden tengelyen kisebb a gyorsuls, mint a RA_THRESH_FF regiszter rtk 5msec/LSB
#define ADXL345_RA_TAP_AXES         0x2A		//0b0000011 Y s Z//TAP_X,TAP_Y,TAP_Z engedlyezs
#define ADXL345_RA_ACT_TAP_STATUS   0x2B		//READ	//sttusz bjt 
#define ADXL345_RA_BW_RATE          0x2C		//0-> 10Hz //mrsi gyakorisg (D4..D0), D4 bit-> LOW-POWER_bit 0->norml operation, 1->reduce POWER
#define ADXL345_RA_POWER_CTL        0x2D		//0b00001001 measure & 4 Hz//mrs kontroll reg
#define ADXL345_RA_INT_ENABLE       0x2E		//0b01100000 single & double tap//interruptuk engedlyezse
#define ADXL345_RA_INT_MAP          0x2F		//0b00100000->single tap->INT1, double tap->INT2 //Melyik esemny melyik INT-re megy, ha 0 akkor INT1, ha 1 akkor INT2
#define ADXL345_RA_INT_SOURCE       0x30		//READ	//intterrupt forrs
#define ADXL345_RA_DATA_FORMAT      0x31		//0b0001010 //adat formtum
#define ADXL345_RA_DATAX0           0x32
#define ADXL345_RA_DATAX1           0x33
#define ADXL345_RA_DATAY0           0x34
#define ADXL345_RA_DATAY1           0x35
#define ADXL345_RA_DATAZ0           0x36
#define ADXL345_RA_DATAZ1           0x37
#define ADXL345_RA_FIFO_CTL         0x38
#define ADXL345_RA_FIFO_STATUS      0x39	//READ	

//ADXL345_RA_ACT_INACT_CTL    bitek 0x27
#define ADXL345_AIC_ACT_AC_BIT      7
#define ADXL345_AIC_ACT_X_BIT       6
#define ADXL345_AIC_ACT_Y_BIT       5
#define ADXL345_AIC_ACT_Z_BIT       4
#define ADXL345_AIC_INACT_AC_BIT    3
#define ADXL345_AIC_INACT_X_BIT     2
#define ADXL345_AIC_INACT_Y_BIT     1
#define ADXL345_AIC_INACT_Z_BIT     0

//ADXL345_RA_TAP_AXES   bitek	    0x2A
#define ADXL345_TAPAXIS_SUP_BIT     0b00001000
#define ADXL345_TAPAXIS_X_BIT       0b00000100
#define ADXL345_TAPAXIS_Y_BIT       0b00000010
#define ADXL345_TAPAXIS_Z_BIT       0b00000001

//ADXL345_RA_ACT_TAP_STATUS   bitek 0x2B
#define ADXL345_TAPSTAT_ACTX_BIT    0b01000000
#define ADXL345_TAPSTAT_ACTY_BIT    0b00100000
#define ADXL345_TAPSTAT_ACTZ_BIT    0b00010000
#define ADXL345_TAPSTAT_ASLEEP_BIT  0b00001000
#define ADXL345_TAPSTAT_TAPX_BIT    0b00000100
#define ADXL345_TAPSTAT_TAPY_BIT    0b00000010
#define ADXL345_TAPSTAT_TAPZ_BIT    0b00000001

//ADXL345_RA_BW_RATE 	bitek		0x2C
#define ADXL345_BW_LOWPOWER_BIT     0b00010000

//ADXL345_RA_BW_RATE 				0x2C
#define ADXL345_RATE_3200           0b00001111
#define ADXL345_RATE_1600           0b00001110
#define ADXL345_RATE_800            0b00001101
#define ADXL345_RATE_400            0b00001100
#define ADXL345_RATE_200            0b00001011
#define ADXL345_RATE_100            0b00001010
#define ADXL345_RATE_50             0b00001001
#define ADXL345_RATE_25             0b00001000
#define ADXL345_RATE_12P5           0b00000111
#define ADXL345_RATE_6P25           0b00000110
#define ADXL345_RATE_3P13           0b00000101
#define ADXL345_RATE_1P56           0b00000100
#define ADXL345_RATE_0P78           0b00000011
#define ADXL345_RATE_0P39           0b00000010
#define ADXL345_RATE_0P20           0b00000001
#define ADXL345_RATE_0P10           0b00000000

//ADXL345_RA_POWER_CTL 				0x2D
#define ADXL345_LINK				0b00100000	//32
#define ADXL345_AUTOSLEEP			0b00010000	//16
#define ADXL345_MEASURE				0b00001000	//8
#define ADXL345_SLEEP				0b00000100	//4
#define ADXL345_1HZ					0b00000011	//3
#define ADXL345_2HZ					0b00000010	//2
#define ADXL345_4HZ					0b00000001	//1
#define ADXL345_8HZ					0b00000000	//0

//ADXL345_RA_INT_SOURCE    bitek	0x2E,0x2F,0x30
#define ADXL345_INT_DATA_READY_BIT  0b10000000
#define ADXL345_INT_SINGLE_TAP_BIT  0b01000000
#define ADXL345_INT_DOUBLE_TAP_BIT  0b00100000
#define ADXL345_INT_ACTIVITY_BIT    0b00010000
#define ADXL345_INT_INACTIVITY_BIT  0b00001000
#define ADXL345_INT_FREE_FALL_BIT   0b00000100
#define ADXL345_INT_WATERMARK_BIT   0b00000010
#define ADXL345_INT_OVERRUN_BIT     0b00000001

//ADXL345_RA_DATA_FORMAT			0x31
#define ADXL345_SELFTEST			0b10000000
#define ADXL345_SPI_3_WIRE			0b01000000
#define ADXL345_INT_0_ACTIVE		0b00100000
#define ADXL345_FULL_RES			0b00001000
#define ADXL345_RANGE_16g			0b00000011
#define ADXL345_RANGE_8g			0b00000010
#define ADXL345_RANGE_4g			0b00000001
#define ADXL345_RANGE_2g			0b00000000

//ADXL345_RA_FIFO_CTL   bitek 		0x38
#define ADXL345_FIFO_MODE_BIT       0b10000000
#define ADXL345_FIFO_MODE_LENGTH    0b00000100
#define ADXL345_FIFO_TRIGGER_BIT    0b00100000
#define ADXL345_FIFO_SAMPLES_BIT    0b00010000

#define ADXL345_FIFO_SAMPLES_LENGTH 5

//ADXL345_RA_FIFO_CTL   			0x38
#define ADXL345_FIFO_MODE_BYPASS    0b00000000
#define ADXL345_FIFO_MODE_FIFO      0b01000000
#define ADXL345_FIFO_MODE_STREAM    0b10000000
#define ADXL345_FIFO_MODE_TRIGGER   0b11000000

typedef struct
{	
	int x;
	int y;
	int z;
}ADXL345_DATA;

typedef union INT_BYTE
{
    INT val;
    BYTE byte[2];
    struct
    {
		BYTE LB;
		BYTE HB;
    } Byte; 
} INT_BYTE;

ADXL345_DATA adxl_data; 

// a gyorsuls szenzor init rtkei
#define THRESH_TAP 						0x9F                                                       //Tap threshold value	62,5 mg/LSB
#define DUR 							0x30                                                       //Tap duration value 	625usec/LSB
#define LATENT 							0x80                                                       //Tap Latency value		1,25 ms/LSB
#define WINDOW 							0xFF                                                       //Tap window value		1,25 ms/LSB
#define THRESH_ACT 						0                                                          //Activity threshold value
#define THRESH_INACT 					0                                                          //Inactivity threshold value
#define TIME_INACT 						0                                                          //Inactivity time value
#define ACT_INACT_CTL 					0                                                          //Axis enable control for activity and inactivity detection value
#define THRESH_FF 						0                                                          //Free-fall threshold value
#define TIME_FF 						0                                                          //Free-fall time value
#define TAP_AXES 						ADXL345_TAPAXIS_X_BIT | ADXL345_TAPAXIS_Y_BIT | ADXL345_TAPAXIS_Z_BIT          //Axis control for single tap/double tap value 
#define RATE 							ADXL345_BW_LOWPOWER_BIT | ADXL345_RATE_3P13                                    //ADXL345_RATE_100 Data rate and power mode control value 100Hz
#define POWER_CTL 						ADXL345_MEASURE | 0b00000001													//Power-saving features control value 0b00001001                                                 						
#define INT_ENABLE 						ADXL345_INT_SINGLE_TAP_BIT | ADXL345_INT_DOUBLE_TAP_BIT                         //Interrupt enable control value
#define INT_MAP 						0b00100000 	                                                					//Interrupt mapping control value
#define DATA_FORMAT 					ADXL345_INT_0_ACTIVE | ADXL345_FULL_RES |  ADXL345_RANGE_8g 					//Data format control value
#define FIFO_CTL 						0  

#define XMIN							-40		//ezek az rtkek adjk meg, hogy mely x,y ablakbn legyen aktv a kijelzs
#define XMAX							40		//vltoztathat rtkek a kalibrls utn 
#define YMIN							-30
#define YMAX							30
#define ZMIN							170		//a Z rtkeket nem hasznlja a program
#define ZMAX							210


void adxl345_reg_write(BYTE reg,BYTE data);
BYTE adxl345_reg_read(BYTE reg);
void adxl345_init();
void adxl345_get_xyz(ADXL345_DATA *data);

#endif
