#include "OLED_karora_328.h"
#include <avr/sleep.h>
#include <avr/interrupt.h>
#include <util/delay.h> 
#include "eeprom_tolt.h"
#include "xprintf.h"
#include "ssd1306.h" 
#include "ADXL345.h"
#include "clock.h" 
#include "menu.h"
#include "string.h" 

extern FONT font;
extern BYTE font_size;
BOOL van_res;
extern BOOL inverse;

MENU_STRUCT *setup_menu;
TYPE_MENU is_menu = SETUP;
extern BYTE contrast;

ADXL345_DATA acc;

void init_port()
{
	ONTART_INIT();
	ONTART_ON();
	
	EICRA|=(1 << ISC11) | (1 << ISC01);
	EIMSK|=(1 << INT1) | (1 << INT0);
	INIT_ADXL_PORT();

	TIMER1_OFF;
	USART0_OFF;
	AC_OFF;
}

void init_timer(void)
{
	TCCR0A=(1<<WGM01);										//MODE 2	CTC  
	TCCR0B=(1<<CS02)|(1<<CS00);								// oszts 1024
	TCNT0=0;
	OCR0A=77;
	TIMSK0|=(1<<OCIE0A);

	ASSR |= (1<<AS2);
	OCR2A=0;
	TCNT2=0;
	//TCCR2B|=(1<<CS21)|(1<<CS20);	//oszts 32 gy msodpercenknt 4x kel fel
	TCCR2B|=(1<<CS22)|(1<<CS20);
	while(ASSR&0x07);
	TIMSK2|=(1<<TOIE2);

}

void init_all()
{
	init_port();
	init_timer();
	sei();
	init_LY096BG30();
	oled_cls(0x00);
	render();
	adxl345_init();
}

void get_adxl_xyz()
{
	adxl345_get_xyz(&acc);
	if((acc.x > XMIN) && (acc.x < XMAX))
	{
		if((acc.y > YMIN) && (acc.y < YMAX))
		{	
			light_timer=def_light_timer;
			if(!bent) 
			{
				adxl345_reg_write(ADXL345_RA_BW_RATE,ADXL345_RATE_100);	//100Hz gyakorisg mrs
				write_command(DISPLAY_ON);
			}	
			bent=TRUE;
		}
	}
	if(bent && (!light_timer))
	{
		bent=FALSE;
		be_OK=0;
		adxl345_reg_write(ADXL345_RA_BW_RATE,RATE);
	}
	tap_status=_NO;
}

void uc_sleep()
{
	get_adxl_xyz();
	if(light_timer) return;
	while(!light_timer)
	{
		write_command(DISPLAY_OFF); 
		set_sleep_mode(SLEEP_MODE_PWR_SAVE);		
		sleep_mode();	
		OCR2A=0;
		//TCCR2B|=(1<<CS21)|(1<<CS20);	//oszts 32 gy msodpercenknt 4x kel fel
		TCCR2B|=(1<<CS22)|(1<<CS20);
		while(ASSR&0x07); 

		get_adxl_xyz();
	}
}

void kiir(char* c)
{
	print_message(c,0,7);
	render();		
}

void draw_header()
{
	static WORD bat[7] = {3600,3700,3800,3900,4000,4100,4500};
	BYTE i=0;

	akku_u=((WORD)akku*37)/2;
	while(akku_u >  bat[i]) {i++;}
	i++;
	font=akku_font;
	if(blinking) {i=32;font=normal_font;}
	xsprintf(header_buffer,"%c",i);
	print_message(header_buffer,122,0);
	
	render(122,0,127,7,TRUE);
	font=normal_font;
}

void megjelenit()
{
	if(OK)
	{
		OK=FALSE;
		draw_header();
		if(akku_u > LOW_BATT)
		{
			switch(clock_type)
			{
				case DIGIT_CLOCK: {digit_clock(); break;}
				case BIN_CLOCK: {bin_clock(); break;}
				case ANALOG_CLOCK: {analog_clock(); break;}
				case TEXT_CLOCK: {text_clock(); break;}
			}
			render();
		}
	}
}

BOOL kopp_e()
{
	BYTE acc_stat;
	BOOL ret=FALSE;

	tap_status=_NO;
	if(_1kopp)  			//egy kopp mr biztos trtnt                                                               
  	{
		ret=TRUE;
    	_delay_ms(600);     //vrunk, hogy van-e msodik kopp is                                                             
		if(_2kopp)
		{
			acc_stat=adxl345_reg_read(ADXL345_RA_INT_SOURCE);
			if(acc_stat & ADXL345_INT_DOUBLE_TAP_BIT) tap_status|=KOPP2;
		
		} else { tap_status|=KOPP1;}
		acc_stat=adxl345_reg_read(ADXL345_RA_INT_SOURCE);
		acc_stat=adxl345_reg_read(ADXL345_RA_ACT_TAP_STATUS);	//beolvassuk a STATUS regisztert
		//megnzzuk a koppants melyik tengelyeken trtnt (unsigned) 
		if(acc_stat & ADXL345_TAPSTAT_TAPX_BIT) tap_status|=_X;
		if(acc_stat & ADXL345_TAPSTAT_TAPY_BIT) tap_status|=_Y;
		if(acc_stat & ADXL345_TAPSTAT_TAPZ_BIT) tap_status|=_Z;
		//xsprintf(header_buffer,"%08b",tap_status);
		//kiir(header_buffer);
		_1kopp =FALSE;
		_2kopp =FALSE;
		light_timer=DEF_MODE_TIMER;
		EIMSK|=(1 << INT1) | (1 << INT0);
  	}
	return ret;
}

void set_time()
{
	BYTE p_min=min;
	BYTE p_hour=hour;
	BOOL bent=TRUE;
	BYTE x,y=51,dx=20,dy=3;
	
	void draw_time()
	{
		font_size=4;
		font=led_font;
		xsprintf(header_buffer,"%02d:%02d",p_hour,p_min);
		print_message(header_buffer,0,23);
		switch(time_mode)
		{
			case HOUR10:{x=0;break;}
			case HOUR1:	{x=23;break;}
			case MIN10:	{x=70;break;}
			case MIN1:	{x=92;break;}
		}
		rectangle(0,y,120,y+dy,CLEAR_MODE,TRUE);
		rectangle(x,y,x+dx,y+dy,OR_MODE,TRUE);
		render();
		font=normal_font;
	}


	time_mode=HOUR10;
	oled_cls(0x00);
	font=normal_font;
	strcpy_P(header_buffer,(PGM_P)pgm_read_word(&setup_menu_str[2]));
	inverse=TRUE;
	print_message(header_buffer,30,1);
	inverse=FALSE;
	draw_time();
	while(bent)
	{
		if(kopp_e())
		{
			if((tap_status & KOPP2))	
			{	
				if(tap_status & _Z)	//belps a menpontba
				{		
					bent=FALSE;
					hour=p_hour;
					min=p_min;
					sec=0;
					oled_cls(0x00);
				} else
				if(tap_status & _X)	// 2 kopp az X mentn-> tmegy a kivlaszts amsikra
				{
					if(time_mode < MIN1) time_mode++; else time_mode=HOUR10;
				} else
				if(tap_status & _Y)	// 2 kopp az X mentn-> tmegy a kivlaszts amsikra
				{
					if(time_mode > HOUR10) time_mode--; else time_mode=MIN1;
				}
			} else
			{
				if(tap_status & _X)	// egy kopp az X mentn->a kivlasztott rtk n
				{
					switch(time_mode)
					{
						case HOUR10:{p_hour+=10;if(p_hour > 23) p_hour=0;break;}
						case HOUR1: {p_hour++;if(p_hour > 23) p_hour=0;break;}
						case MIN10:	{p_min+=10;if(p_min > 59) p_min=0;break;}
						case MIN1:	{p_min++;if(p_min > 59) p_min=0;break;}
					}
				}
				if(tap_status & _Y)	// egy kopp az Y mentn->a kivlasztott rtk cskken
				{
					switch(time_mode)
					{
						case HOUR10:{if(p_hour >= 10) p_hour-=10; else p_hour=20;break;}
						case HOUR1:	{if(p_hour > 0) p_hour--; else p_hour=23;break;}
						case MIN10:	{if(p_min >= 10) p_min-=10; else p_min=50;break;}
						case MIN1:	{if(p_min > 0) p_min--; else p_min=59;break;}
					}
				}
			}
			draw_time();
		}
		tap_status=_NO;
		if(OK)
		{
			draw_header();
			OK=FALSE;
			uc_sleep();
		}
	}
	font=normal_font;
	oled_cls(0x00);
}

void set_date()
{
	BYTE p_year=year-2000;
	BYTE p_month=month;
	BYTE p_day=day;
	BOOL bent=TRUE;
	BYTE x,y=50,dx=15,dy=3;
	
	void draw_date()
	{
		font_size=3;
		font=led_font;
		xsprintf(header_buffer,"%02d",p_year);
		print_message(header_buffer,0,28);
		xsprintf(header_buffer,"%02d",p_month);
		print_message(header_buffer,45,28);
		xsprintf(header_buffer,"%02d",p_day);
		print_message(header_buffer,90,28);
		switch(date_mode)
		{
			case YEAR10:	{x=0;break;}
			case YEAR1:		{x=18;break;}
			case MONTH10:	{x=45;break;}
			case MONTH1:	{x=62;break;}
			case DAY10:		{x=90;break;}
			case DAY1:		{x=108;break;}
		}
		rectangle(0,y,127,y+dy,CLEAR_MODE,TRUE);
		rectangle(x,y,x+dx,y+dy,OR_MODE,TRUE);
		arc(36,y-4,36,y-4,0,1,0xFF,OR_MODE);
		arc(82,y-4,82,y-4,0,1,0xFF,OR_MODE);
		render();
		font=normal_font;
	}


	time_mode=HOUR10;
	oled_cls(0x00);
	font=normal_font;
	strcpy_P(header_buffer,(PGM_P)pgm_read_word(&setup_menu_str[3]));
	inverse=TRUE;
	print_message(header_buffer,30,2);
	inverse=FALSE;
	draw_date();
	while(bent)
	{
		if(kopp_e())
		{
			if((tap_status & KOPP2))	
			{	
				if(tap_status & _Z)	//belps a menpontba
				{		
					bent=FALSE;
					year=2000+p_year;
					month=p_month;
					day=p_day;
					oled_cls(0x00);
				} else
				if(tap_status & _X)	// 2 kopp az X mentn-> tmegy a kivlaszts amsikra
				{
					if(date_mode < DAY1) date_mode++; else date_mode=YEAR10;
				} else
				if(tap_status & _Y)	// 2 kopp az X mentn-> tmegy a kivlaszts amsikra
				{
					if(date_mode > YEAR10) date_mode--; else date_mode=DAY1;
				}
			} else
			{
				if(tap_status & _X)	// egy kopp az X mentn->a kivlasztott rtk n
				{
					switch(date_mode)
					{
						case YEAR10:	{p_year+=10;if(p_year > 90) p_year=17;break;}
						case YEAR1:		{p_year++;if(p_year > 99) p_year=17;break;}
						case MONTH10:	{p_month+=10;if(p_month > 12) p_month=1;break;}
						case MONTH1:	{p_month++;if(p_month > 12) p_month=1;break;}
						case DAY10:		{p_day+=10;if(p_day > 31) p_day=1;break;}
						case DAY1:		{p_day++;if(p_day > 31) p_day=1;break;}
					}
				}
				if(tap_status & _Y)	// egy kopp az Y mentn->a kivlasztott rtk cskken
				{
					switch(date_mode)
					{
						case YEAR10:	{if(p_year > 10) p_year-=10; else p_year=90;break;}
						case YEAR1:		{if(p_year > 17) p_year--; else p_year=17;break;}
						case MONTH10:	{if(p_month > 10) p_month-=10; else p_month=1;break;}
						case MONTH1:	{if(p_month > 1) p_month--; else p_month=12;break;}
						case DAY10:		{if(p_day > 10) 	p_day-=10;else p_day=31;break;}
						case DAY1:		{if(p_day > 1) p_day--; else p_day=31;break;
						}
					}
				}
			}
			draw_date();
		}
		tap_status=_NO;
		if(OK)
		{
			draw_header();
			OK=FALSE;
			uc_sleep();
		}
	}
	font=normal_font;
	oled_cls(0x00);
}

void set_cont()
{
	BYTE p_contrast=contrast/10;
	BOOL bent=TRUE;
	
	void draw_contrast()
	{
		contrast=p_contrast*10+1;
		font_size=4;
		font=led_font;
		xsprintf(header_buffer,"%02d",p_contrast);
		print_message(header_buffer,54,23);
		render();
		font=normal_font;
		set_contrast();
	}


	oled_cls(0x00);
	font=normal_font;
	strcpy_P(header_buffer,(PGM_P)pgm_read_word(&setup_menu_str[4]));
	inverse=TRUE;
	print_message(header_buffer,30,1);
	inverse=FALSE;
	draw_contrast();
	while(bent)
	{
		if(kopp_e())
		{
			if((tap_status & KOPP2))	
			{	
				if(tap_status & _Z)	//belps a menpontba
				{		
					bent=FALSE;
					contrast=p_contrast;
					oled_cls(0x00);
				}
			} else
			{
				if(tap_status & _X)	// egy kopp az X mentn->a kivlasztott rtk n
				{
					if(p_contrast < 25) p_contrast++; else p_contrast=0;
				}
				if(tap_status & _Y)	// egy kopp az Y mentn->a kivlasztott rtk cskken
				{
					if(p_contrast > 1) p_contrast--;
				}
			}
			draw_contrast();
		}
		tap_status=_NO;
		if(OK)
		{
			draw_header();
			OK=FALSE;
			uc_sleep();
		}
	}
	font=normal_font;
	oled_cls(0x00);
}


void set_light_len()
{
	BYTE p_length=def_light_timer;
	BOOL bent=TRUE;
	
	void draw_length()
	{
		font_size=4;
		font=led_font;
		xsprintf(header_buffer,"%02d",p_length);
		print_message(header_buffer,54,23);
		render();
		font=normal_font;
	}


	oled_cls(0x00);
	font=normal_font;
	strcpy_P(header_buffer,(PGM_P)pgm_read_word(&setup_menu_str[5]));
	inverse=TRUE;
	print_message(header_buffer,30,1);
	inverse=FALSE;
	draw_length();
	while(bent)
	{
		if(kopp_e())
		{
			if((tap_status & KOPP2))	
			{	
				if(tap_status & _Z)	//kilps a menpontbl
				{		
					bent=FALSE;
					def_light_timer=p_length;
					oled_cls(0x00);
				}
			} else
			{
				if(tap_status & _X)	// egy kopp az X mentn->a kivlasztott rtk n
				{
					if(p_length < 15) p_length++; else p_length=3;
				}
				if(tap_status & _Y)	// egy kopp az Y mentn->a kivlasztott rtk cskken
				{
					if(p_length > 4) p_length--;
				}
			}
			draw_length();
		}
		tap_status=_NO;
		if(OK)
		{
			draw_header();
			OK=FALSE;
			uc_sleep();
		}
	}
	font=normal_font;
	oled_cls(0x00);
}

void tech()
{
	BYTE p_length=def_light_timer;
	BOOL bent=TRUE;
	
	void draw_tech()
	{
		font=normal_font;
		xsprintf(header_buffer,"%5d,%5d,%5d",acc.x,acc.y,acc.z);
		print_message(header_buffer,0,7);

		xsprintf(header_buffer,"akku=%4dmV",akku_u);
		print_message(header_buffer,0,0);
		render();
	}


	oled_cls(0x00);
	font=normal_font;
	strcpy_P(header_buffer,(PGM_P)pgm_read_word(&setup_menu_str[6]));
	inverse=TRUE;
	print_message(header_buffer,30,1);
	inverse=FALSE;
	while(bent)
	{
		adxl345_get_xyz(&acc);
		if(!Timer)
		{
			draw_tech();
			Timer=10;	//100msec
		}	
		if(kopp_e())
		{
			if((tap_status & KOPP2))	
			{	
				if(tap_status & _Z)	//kilps a menpontbl
				{		
					bent=FALSE;
					def_light_timer=p_length;
					oled_cls(0x00);
				}
			} 
			draw_tech();
		}
		tap_status=_NO;
		if(OK)
		{
			draw_header();
			OK=FALSE;
			uc_sleep();
		}
	}
	font=normal_font;
	oled_cls(0x00);
}


void set_menu()
{
	void draw_date()
	{
		font=normal_font;
		xsprintf(header_buffer,"%04d.%02d.%02d",year,month,day);
		print_message(header_buffer,0,0);
	}
	oled_cls(0x00);
	font=normal_font;
	setup_menu=new_menu(setup_menu_str,6,0);
	if(setup_menu != 0)
	{
		for(BYTE i=0; i < 6;i++)
			add_menu_item(setup_menu,i,30,2+i);	
	}
	display_menu(setup_menu);
	draw_date();
	render(); 
	while(is_menu == SETUP)
	{
		if(kopp_e())
		{
			if((tap_status & KOPP2))	
			{	
				if(tap_status & _Z)	//belps a menpontba
				{		
					switch(setup_menu->akt_item)
					{
						case EXIT_ : {is_menu=EXIT_MENU;break;}
						case SET_TIME : {set_time();break;}
						case SET_DATE : {set_date();break;}
						case SET_CONT : {set_cont();break;}
						case SET_LEN  : {set_light_len();break;}
						case TECH 	  : {tech();break;}
					}
				}
			} else
			{
				if(tap_status & _X)	// egy kopp az X mentn->men lptets+
				{
					plus_menu(setup_menu);
				}
				if(tap_status & _Y)	// egy kopp az Y mentn->men lptets-
				{
					minus_menu(setup_menu);
				}
			}
			display_menu(setup_menu);
			draw_date();
			render();
		}
		tap_status=_NO;
		if(OK)
		{
			draw_header();
			OK=FALSE;
			uc_sleep();
		}
	}
	menu_destroy(setup_menu);
	oled_cls(0x00);
}

void get_action()
{
	tap_status=_NO;
	if(!kopp_e()) return;
	if((tap_status & KOPP2))	
	{
		if(tap_status & _Z)	//a megjelentend ra tipust lpteti
		{
			oled_cls(0x00);
			if(clock_type < TEXT_CLOCK) clock_type++; else clock_type=DIGIT_CLOCK;
			if(clock_type == ANALOG_CLOCK) perc=61;
			if(clock_type == TEXT_CLOCK) perc=62;
			OK=TRUE;
			megjelenit();		
		} else	
		if(tap_status & _Y)	//belps a setup menbe
		{
			is_menu=SETUP;
			set_menu();
			oled_cls(0x00);
			if(clock_type == ANALOG_CLOCK) perc=61;
			if(clock_type == TEXT_CLOCK) perc=62;
		}
	}
	tap_status=_NO;
}

int main()
{
	init_all();
	alapadatokat_eprombol_tolt();
	while(1)
	{
		if(light_timer && OK) megjelenit();
		uc_sleep();
		get_action();
		if(low_batt_off) 
		{
			alapadatokat_epromba_tolt();
			ONTART_OFF();
		}
		adxl345_get_xyz(&acc);
	}
}

ISR(TIMER0_COMPA_vect)
{
	static BYTE szam;
	BYTE n;

	szam++;	
	if(!(szam%10)) 
	{
		ADMUX = (1<<REFS1)|(1<<REFS0)|(1<<ADLAR)|AKKU;				// 1.100 mV a referencia fesz,  balra igaztott 8 bit
		ADCSRA= (1<<ADEN)|(1<<ADSC)|(1<<ADIE)|(1<<ADPS2)|(1<<ADPS1);  //ADC eng, oszt 64, Konverzi indts, ADC interrupt eng
	
	}
	//------------------ ltalnos softveres timer(ek) ---------------
	n = Timer;
	if (n) Timer = --n;
}

ISR(ADC_vect)
{
	akku = ADCH;
	ADCSRA 	= 0;
}

ISR(INT0_vect)	//Az ADXL INT2 lba  2 kopp
{
	_2kopp=TRUE;
	EIMSK&=~(1 << INT0);
}


ISR(INT1_vect)	//Az ADXL INT1 lba 1 kopp
{
	_1kopp=TRUE;
	EIMSK&=~(1 << INT1);
}



ISR(TIMER2_OVF_vect)
{	
	static WORD pont;	
	
	if(PONT)	//amennyiben az ra siet, akkor a OLED_karora_328.h-ban a #define PONT 0 rtkt vltoztatni kell
	{		 	//elszr a PONT legyen 0, gy kell nzni pl. egy htig, hogy mennyit siet az ra, tegyk fel, hogy 10s
				//ki kell szmolni, hogy hny msodpercenknt siet egyet. a pldban 7 nap alatt, vagyis 7*24*3600/10. Ennek az rtkt
				//kell berni a #define PONT 60480, a max rtk 65535 lehet. A program ennyi msodperc utn egyet kihagy a lptetsbl.
				//lehet hardveresen is lasstani, be kell ltetni a kt db kondenztort PB6, s PB7	pinek s a GND kz. (2,2 pF, 3,3 pF...)

		if(++pont != PONT) sec++; else pont=0;
	} else sec++;
	if(light_timer) light_timer--;
	if(sec == 60) 
	{
		sec=0;
		if(++min == 60)
		{
			min=0;
			if(++hour == 24) 
			{
				hour=0;
				date_calc();
			}
		}
	}
	OK=TRUE;
	if(akku_u <= LOW_BATT) 
	{
		blinking=sec & 0x01; 
	}
	else {blinking=0;lb_time=LOW_BATT_TIMER;}
	if(akku_u < LOW_BATT_OFF) 
	{
		if(lb_time) {lb_time--;} else {lb_time=LOW_BATT_TIMER;low_batt_off=TRUE;}
	}
}

	
