#include "integer.h" 
#include "ioports.h" 


#define ONTART_DDR			DDRB
#define ONTART_PORT			PORTB
#define ONTART_PIN			PIN1_bm
#define ONTART_INIT()		ONTART_DDR|=ONTART_PIN
#define ONTART_ON()			ONTART_PORT|=ONTART_PIN
#define ONTART_OFF()		ONTART_PORT&=~ONTART_PIN

#define OLED_VCC_DDR		DDRD
#define OLED_VCC_PORT		PORTD
#define OLED_VCC_PIN		PIN0_bm
#define OLED_VCC_INIT()		OLED_VCC_DDR|=OLED_VCC_PIN
#define OLED_VCC_ON()		OLED_VCC_PORT|=OLED_VCC_PIN
#define OLED_VCC_OFF()		OLED_VCC_PORT&=~OLED_VCC_PIN


#define DEF_LIGHT_TIMER		3
#define DEF_MODE_TIMER		10
volatile BYTE def_light_timer=DEF_LIGHT_TIMER;

volatile BYTE hour=22;
volatile BYTE min=25;
BYTE perc=70;
volatile BYTE sec=40;
volatile WORD year=2017;
volatile BYTE month=3;
volatile BYTE day=04;
volatile BOOL OK=FALSE;
volatile BYTE light_timer=DEF_LIGHT_TIMER;
#define PONT 				28500
char header_buffer[24];

volatile BYTE Timer;		// 100Hz decrement timer 

#define AKKU				0//PIN0_bm
volatile BYTE akku;
WORD akku_u;

#define LOW_BATT			3600
#define LOW_BATT_OFF		3300
#define LOW_BATT_TIMER		60
volatile BYTE lb_time=LOW_BATT_TIMER;
volatile BOOL blinking = FALSE;
volatile BOOL low_batt_off = FALSE;

#define KOPP1			0b00100000
#define KOPP2			0b00010000

volatile BOOL _1kopp =FALSE;
volatile BOOL _2kopp =FALSE;
volatile BOOL bent = FALSE;
BYTE be_OK=0;
#define BE_OK_NUM		0

#define TIMER0_OFF		PRR|=(1<<PRTIM0)
#define TIMER0_ON		PRR&=~(1<<PRTIM0)
#define TIMER1_OFF		PRR|=(1<<PRTIM1)
#define TIMER1_ON		PRR&=~(1<<PRTIM1)
#define USART0_OFF		PRR|=(1<<PRUSART0)
#define USART0_ON		PRR&=~(1<<PRUSART0)
#define ADC_OFF			PRR|=(1<<PRADC)
#define ADC_ON			PRR&=~(1<<PRADC)
#define AC_OFF			ACSR=(1<<ACD)


BYTE tap_status = 0;
#define KOPP1			0b00100000
#define KOPP2			0b00010000
#define _X				0b00000100
#define _Y				0b00000010
#define _Z				0b00000001
#define _NO				0b00000000

typedef enum 
{		
   	HOUR10=0,
	HOUR1,
	MIN10,
	MIN1
} TIME_MODE;
TIME_MODE time_mode = HOUR10;

typedef enum 
{		
   	YEAR10=0,
	YEAR1,
	MONTH10,
	MONTH1,
	DAY10,
	DAY1
} DATE_MODE;
DATE_MODE date_mode = YEAR10;

typedef enum 
{		
   	DIGIT_CLOCK=0,
	BIN_CLOCK,
	ANALOG_CLOCK,
	TEXT_CLOCK,
} CLOCK_TYPE;
CLOCK_TYPE clock_type = DIGIT_CLOCK;

#define LEAP_YEAR()		(!(year % 4) && ((year % 100) || !(year % 400)) ? TRUE : FALSE)

void date_calc()
{	
	static BYTE day_of_month[12]={31,28,31,30,31,30,31,31,30,31,30.31};

	if(day < day_of_month[month-1]) 	//ha az adott hnapra vonatkoz max napot mg nem rtk el akkor btran nvelhetjk a napok szmt	
	{
		day++;	
	} else					
	{
		if(month == 2)		//ha elrtk, ekkor megnzzk februr van-e
		{
			if(day == 28)	//ha a napok szma pont 28 akkor meg kell nzni szk v-e
			{
				if(LEAP_YEAR()) day++; else {month++;day=1;}	//ha szk v, akkor napokat nvelni, he nem akkor a kv. hnap els napja
			} else {month++;day=1;}	//ha a napok szma 29, akkor is a kv nap els napja
		} else 
		{			// ha nem a februr, akkor a tbbi hnap utols napja-> nap=1
		 	day=1;
		 	if(month == 12) 	//ha ppen december, akkor az vet lptetni, hnap=1
		 	{
				month=1;
			  	year++;
			} else month++;		//ha nem december, akkor a hnapot nvelni
		 }	
	}		
}



