#ifndef SSD1306
#define SSD1306

#include "integer.h" 
#include "ioports.h" 

//#define SW_SPI
#define HW_SPI

#define OLED_CTRL_DDR 		DDRC
#define OLED_CTRL_PORT 		PORTC
#define DC_PIN				PIN3_bm
#define RES_PIN				PIN4_bm
#define CS_PIN				PIN5_bm

#define OLED_SPI_DDR 		DDRB
#define OLED_SPI_PORT 		PORTB
#define SS_PIN				PIN2_bm
#define MOSI_PIN			PIN3_bm
#define MISO_PIN			PIN4_bm//ez most nem kell, mert olvasunk vissza
#define SCK_PIN				PIN5_bm

#define CS_H()				OLED_CTRL_PORT|=CS_PIN
#define CS_L()				OLED_CTRL_PORT&=~CS_PIN
#define RES_H()				OLED_CTRL_PORT|=RES_PIN
#define RES_L()				OLED_CTRL_PORT&=~RES_PIN
#define DC_H()				OLED_CTRL_PORT|=DC_PIN
#define DC_L()				OLED_CTRL_PORT&=~DC_PIN


#ifdef SW_SPI
	#define CLK_H()			OLED_SPI_PORT|=SCK_PIN
	#define CLK_L()			OLED_SPI_PORT&=~SCK_PIN
	#define SDA_H()			OLED_SPI_PORT|=MOSI_PIN
	#define SDA_L()			OLED_SPI_PORT&~=MOSI_PIN
#endif

#ifdef HW_SPI
	#define	OLED_SPI_INIT()		SPCR = (1<<SPE)|(1<<MSTR);SPSR=0//SPSR=(1<<SPI2X)
	#define send_oled_spi(dat) 	SPDR=(dat); loop_until_bit_is_set(SPSR,SPIF)		
#endif


#define OLED_WIDTH 		128
#define OLED_HEIGHT 	64

#define DISPLAY_OFF		0xae
#define DISPLAY_ON		0xaf
#define START_LINE_L	0x00	//0x00->0x0f
#define START_LINE_H	0x10	//0x10->0x1f
#define MEM_ADDR_MODE	0x20    //00,Horizontal Addressing Mode;01,Vertical Addressing Mode;10,Page Addressing Mode (RESET);11,Invalid
#define SET_COL_ADDR	0x21
#define SET_PAGE_ADDR	0x22
#define SET_START_LINE	0x40	//0x40-0x7F
#define ALL_ON_RESUME	0xa4
#define NORMAL			0xa6
#define INVERSE			0xa7
#define SET_MUL_RATIO	0xa8
#define PAGE_START_ADDR	0xb0
#define SET_CONTRAST 	0x81
#define SCAN_0_127		0xc8
#define SCAN_127_0		0xc0	
#define CHARGE_PUMP		0x8d	//a kv byte 0x14 ON	
#define DISP_OFFSET		0xd3	
#define SET_COM_PINS	0xda
#define SET_PRE_CHARGE	0xd9
#define SET_CLOCK_DIV	0xd5
#define SEG_RE_MAP		0xa0	
#define SET_VCOM		0xdb


typedef enum 
{
	normal_font=0,
	akku_font,
	led_font,
} FONT;


typedef enum 
{
	OR_MODE=0,
	AND_MODE,
	CLEAR_MODE,
	XOR_MODE,
} PUT_MODE;

#define SIN45   	46341   // sin(45) * 2^16)
#define ONEP25  	81920   // 1.25 * 2^16

typedef union _DWORD_VAL
{
    DWORD Val;
    WORD w[2];
    BYTE v[4];
    struct
    {
     	WORD LW;
     	WORD HW;
    } word;
    struct
    {
		BYTE LB;
		BYTE HB;
		BYTE UB;
	BYTE MB;
    } byte; 
} DWORD_VAL;


//#define abs(_x) ((_x) < 0 ? -(_x) : (_x)) 



void oled_delay_us (WORD us);
void oled_delay_ms (WORD ms);
void init_LY096BG30();
void write_command(BYTE command);
void write_data(BYTE data);
void set_contrast();

void print_message(const char* message,BYTE x,BYTE y);
void oled_cls(BYTE fill);
void oled_clsxy(BYTE x0,BYTE y0,BYTE x1,BYTE y1,BOOL fill);
void render();
void renderxy(BYTE x0,BYTE y0,BYTE x1,BYTE y1);
void setpixel(int x, int y, BYTE mode);
void hline(BYTE x0,BYTE y0,BYTE x1,BYTE mode);
void vline(BYTE x0,BYTE y0,BYTE y1,BYTE mode);
void line(int x0,int y0,int x1,int y1, BYTE mode);
void rectangle(int x0,int y0,int x1,int y1,BYTE mode,BOOL fill);
void circle(int cx, int cy, int radius, BYTE mode);
void arc(BYTE xL, BYTE yB, BYTE xR, BYTE yT, BYTE r1, BYTE r2, BYTE octant,BYTE mode);



#endif
