#include "clock.h"
#include "xprintf.h"
#include <math.h>
#include "SSD1306.h" 
#include <avr/pgmspace.h>
#include <avr/interrupt.h> 

extern char header_buffer[24];
char buf[24];
extern FONT font;
extern BYTE font_size;
extern BOOL inverse;
extern volatile BYTE hour;
extern volatile BYTE min;
extern volatile BYTE sec;

extern volatile WORD year;
extern volatile BYTE month;
extern volatile BYTE day;

static char o0[] PROGMEM  = "nulla";	//0
static char o1[] PROGMEM  = "egy";		
static char o2[] PROGMEM  = "kett";
static char o3[] PROGMEM  = "hrom";
static char o4[] PROGMEM  = "ngy";
static char o5[] PROGMEM  = "t";
static char o6[] PROGMEM  = "hat";
static char o7[] PROGMEM  = "ht";
static char o8[] PROGMEM  = "nyolc ";
static char o9[] PROGMEM  = "kilenc";
static char o10[] PROGMEM  ="tiz";				//10
static char o11[] PROGMEM  = "tizenegy";		
static char o12[] PROGMEM  = "tizenkett";
static char os1[] PROGMEM  = "";
static char on[] PROGMEM  = "negyed ";
static char of[] PROGMEM  = "fl";
static char ohn[] PROGMEM  = "3 negyed";
static char os2[] PROGMEM  = "";
static char om[] PROGMEM  = "mlt";		//18
static char ol[] PROGMEM  = "mlva lesz";//54
static char opont[] PROGMEM  = "pontosan";//55

static char r_egy[] PROGMEM  = "I";		//21
static char r_negy[] PROGMEM  = "IV";
static char r_ot[] PROGMEM  = "V";
static char r_kilenc[] PROGMEM  = "IX";
static char r_tiz[] PROGMEM  = "X";
static char r_negyven[] PROGMEM  = "XL";
static char r_otven[] PROGMEM  = "L";
static char roman_ora[] PROGMEM  = "ra  :        ";
static char roman_perc[] PROGMEM  = "perc :        ";
static char roman_mp[] PROGMEM  = " mp  :        ";

PGM_P ora_stringek[31] PROGMEM = {o0,o1,o2,o3,o4,o5,o6,o7,o8,o9,o10,o11,o12,os2,on,of,ohn,os2,om,ol,opont,
								  r_egy,r_negy,r_ot,r_kilenc,r_tiz,r_negyven,r_otven,roman_ora,roman_perc,roman_mp};

extern BYTE perc;

void myfunc(PGM_P s)
{
    strcpy_P(buf, s);
} 

void digit_clock()
{
	font=led_font;
	font_size=5;
	xsprintf(header_buffer,"%02d",hour);
	print_message(header_buffer,0,23);
	xsprintf(header_buffer,"%02d",min);
	print_message(header_buffer,75,23);
	if(sec & 1)	arc(64,54,64,54,0,3,0xFF,CLEAR_MODE); else arc(64,54,64,54,0,3,0xFF,OR_MODE);
	font=normal_font;
	xsprintf(header_buffer,"%02d",sec);
	print_message(header_buffer,58,4);
}

void analog_clock()
{
	static BYTE _min ;
	static BYTE _hour;
	static BYTE _sec;
	BYTE x00 =63,y00=33;

	line(x00,y00,x00+24*sin(_sec*(M_PI/30)),y00-24*cos(_sec*(M_PI/30)),CLEAR_MODE);
	line(x00,y00,x00+22*sin(_min*(M_PI/30)),y00-22*cos(_min*(M_PI/30)),CLEAR_MODE);
	line(x00,y00,x00+17*sin((60*_hour+_min)*(M_PI/360)),y00-17*cos((60*_hour+_min)*(M_PI/360)),CLEAR_MODE);
	cli();
	line(x00,y00,x00+24*sin(sec*(M_PI/30)),y00-24*cos(sec*(M_PI/30)),OR_MODE);
	line(x00,y00,x00+22*sin(min*(M_PI/30)),y00-22*cos(min*(M_PI/30)),OR_MODE);
	line(x00,y00,x00+17*sin((60*hour+min)*(M_PI/360)),y00-17*cos((60*hour+min)*(M_PI/360)),OR_MODE);
			
	if( min != perc)
	{
		for(BYTE i = 0; i < 12; i++)
			circle(x00+28*sin(i*(M_PI/6)),y00+28*cos(i*(M_PI/6)),2,OR_MODE);
		perc=min;
	}
	_min 	= min;
	_hour 	= hour;
	_sec 	= sec;
	sei();
}

void bin_clock()
{
	BYTE t[4];
	
	BYTE xek[6] ={20,36,52,68,84,100};
	BYTE yok[4] ={56,40,24,8};
	BYTE R = 6;
	static BYTE perc =0;

	void func(BYTE x)
	{
		for(BYTE i = 3; i > 0; i--)
		{
			t[i]=x/(1 << i);
			x=x-(t[i] << i);	
		}
		t[0]=x;
	}

	void megjelenit(BYTE id, BYTE p)
	{
		for(BYTE s = 0; s < p; s++)
		{
			if(t[s])
			{
				arc(xek[id],yok[s],xek[id],yok[s],0,R,0xFF,OR_MODE);
			} else
			{
				arc(xek[id],yok[s],xek[id],yok[s],0,R,0xFF,CLEAR_MODE);
				arc(xek[id],yok[s],xek[id],yok[s],R,R,0xFF,OR_MODE);
			}
		}
	}
	//if(perc != min)
	{

		func(hour/10); 	megjelenit(0,2);
		func(hour%10);	megjelenit(1,4);
		func(min/10);	megjelenit(2,3);
		func(min%10);	megjelenit(3,4);
		func(sec/10);	megjelenit(4,3);
		func(sec%10);	megjelenit(5,4);
		//render();
		perc=min;
	}	
}

void text_clock(void)
{
	BYTE ora,pj,kell_ora;
	WORD x = 64,y = 3, dy;
	BYTE textwidth = 3;
	
	dy=1;
	if(perc != min)
	{
		font=normal_font;
		oled_clsxy(0,8,127,63,FALSE);
		render();
		kell_ora = FALSE;
		ora=hour;
		perc=min;
		if(ora > 12) ora-=12;
		pj=0;
		while(perc > 15)
		{
			perc-=15;
			pj++;
		}		
		if(perc < 8)
		{	
			if(pj) ora++;
			if(perc) 
			{
				myfunc((PGM_P)pgm_read_word(&ora_stringek[perc])); 		//mlt 
				strcpy(&buf[strlen(buf)]," perccel");
				print_message(buf,x-strlen(buf)*textwidth,y);
				
				myfunc((PGM_P)pgm_read_word(&ora_stringek[18])); 		
				print_message(buf,x-strlen(buf)*textwidth,y+dy);
				if(!pj) kell_ora=TRUE;
			} 
			else 
			{
				myfunc((PGM_P)pgm_read_word(&ora_stringek[20])); 
				print_message(buf,x-strlen(buf)*textwidth,y);
				
				kell_ora=TRUE;
				pj=0;
			}			
		} 
		else 
		{
			perc=15-perc;
			ora++;											
			if(perc)
			{													//mlva lesz 
				myfunc((PGM_P)pgm_read_word(&ora_stringek[perc])); 		
				strcpy(&buf[strlen(buf)]," perc");
				print_message(buf,x-strlen(buf)*textwidth,y);
							
				myfunc((PGM_P)pgm_read_word(&ora_stringek[19])); 	
				print_message(buf,x-strlen(buf)*textwidth,y+dy);
				pj++;
			}
			else
			{
				myfunc((PGM_P)pgm_read_word(&ora_stringek[20]));			// pontosan (negyed, fl, hromnegyed)
				print_message(buf,x-strlen(buf)*textwidth,y);
				pj++;
			}
		}	
		if(pj == 4) kell_ora=TRUE;		
		if(kell_ora)														//	
		{		
			myfunc((PGM_P)pgm_read_word(&ora_stringek[(ora > 12 ? ora-12 : ora)])); 
			strcpy(&buf[strlen(buf)]," ra");
			print_message(buf,x-strlen(buf)*textwidth,y+2*dy);
		}
		else	
		{
			myfunc((PGM_P)pgm_read_word(&ora_stringek[13 + pj]));	
			print_message(buf,x-strlen(buf)*textwidth,y+2*dy);
		
			myfunc((PGM_P)pgm_read_word(&ora_stringek[(ora > 12 ? ora-12 : ora)])); 
			print_message(buf,x-strlen(buf)*textwidth,y+3*dy);
		}
		perc=min;			
	}
}
