#include <avr/eeprom.h>
#include "eeprom_tolt.h"
#include "integer.h" 

extern volatile BYTE def_light_timer;
extern volatile BYTE hour;
extern volatile BYTE min;
extern volatile BYTE sec;
extern volatile WORD year;
extern volatile BYTE month;
extern volatile BYTE day;

extern BYTE clock_type;
extern BYTE contrast;

void alapadatokat_epromba_tolt(void)
{
	eeprom_write_byte((BYTE*)0, def_light_timer); 
	eeprom_write_byte((BYTE*)1, contrast); 
	eeprom_write_byte((BYTE*)2, year-2000); 
	eeprom_write_byte((BYTE*)3, month); 
	eeprom_write_byte((BYTE*)4, day); 
	eeprom_write_byte((BYTE*)5, hour);
	eeprom_write_byte((BYTE*)6, min); 
	eeprom_write_byte((BYTE*)7, sec);
	eeprom_write_byte((BYTE*)8, clock_type);
	if(hour > 23) hour = 0;
	if(min > 59) min = 0;
	if(sec > 59) sec = 0;
	if(year < 2016) year = 2016;
	if(month > 12) month = 1; 
	if(day > 31) day = 1;
}

void alapadatokat_eprombol_tolt(void)
{
	if(eeprom_read_byte((BYTE*)0) == 0xFF) alapadatokat_epromba_tolt();
	def_light_timer=eeprom_read_byte((BYTE*)0); 
	contrast=eeprom_read_byte((BYTE*)1); 
	year=2000+eeprom_read_byte((BYTE*)2); 
	month=eeprom_read_byte((BYTE*)3); 
	day=eeprom_read_byte((BYTE*)4); 
	hour=eeprom_read_byte((BYTE*)5); 
	min=eeprom_read_byte((BYTE*)6); 
	sec=eeprom_read_byte((BYTE*)7); 
	clock_type=eeprom_read_byte((BYTE*)8); 
}



