RGBColor hsv_to_rgb(double H, double S, double V)
{
    double h = std::floor(H / 60.0),
           f = H / 60.0 - h;
    uint16_t p = uint16_t(255.0*V*(1.0 - S)),
             q = uint16_t(255.0*V*(1.0 - S*f)),
             t = uint16_t(255.0*V*(1.0 - S*(1.0 - f))),
             v = uint16_t(255.0*V);

    if(h == 0.0 || h == 6.0)
    {
        return RGBColor(v, t, p);
    }
    if(h == 1.0)
    {
        return RGBColor(q, v, p);
    }
    if(h == 2.0)
    {
        return RGBColor(p, v, t);
    }
    if(h == 3.0)
    {
        return RGBColor(p, q, v);
    }
    if(h == 4.0)
    {
        return RGBColor(t, p, v);
    }
    // (h == 5.0)
    return RGBColor(v, p, q);
}
