#include <avr/io.h>
#include <stdlib.h>
#include "menu.h"
#include "SSD1306.h"


extern char header_buffer[24];
extern BOOL inverse;


MENU_STRUCT *new_menu(PGM_P *s,BYTE max_item,BYTE akt_item)
{
	MENU_STRUCT *menu;
	menu = (MENU_STRUCT *)malloc(sizeof(MENU_STRUCT));
	if(menu == 0) return 0;
	menu->str=s;
	menu->item_num=0;
	menu->max_item=max_item;
	menu->akt_item=akt_item;

	return(menu);
}

void set_aktiv(MENU_STRUCT *m,BYTE num)
{
	if(m == 0) return;
	m->akt_item=num;
}

void add_menu_item(MENU_STRUCT *m,BYTE stnum,BYTE x,BYTE y)
{
	MENU_ITEM *menu_item;
	if(m->max_item > m->item_num)
	{
		menu_item = (MENU_ITEM *)malloc(sizeof(MENU_ITEM));
		if(menu_item == 0) return;
		menu_item->str_num=stnum;
		menu_item->x=x;
		menu_item->y=y;
		m->item[m->item_num]=menu_item;
		m->item_num++;	
	}	
}

void display_menu(MENU_STRUCT *m)
{
	if(m == 0) return;
	strcpy_P(header_buffer,(PGM_P)pgm_read_word(&m->str[0]));
	print_message(header_buffer,m->item[0]->x,m->item[0]->y-1);
	for(BYTE i=0;i<m->item_num ;i++)
	{
		strcpy_P(header_buffer,(PGM_P)pgm_read_word(&m->str[i+1]));
		if(m->akt_item == i) {inverse=TRUE;} else {inverse=FALSE;}
		print_message(header_buffer,m->item[i]->x,m->item[i]->y);
	}	
	inverse=FALSE;
}

void plus_menu(MENU_STRUCT *m)
{
	if(m == 0) return;
	if(m->akt_item < m->item_num-1) {m->akt_item++;} else {m->akt_item=0;}
}

void minus_menu(MENU_STRUCT *m)
{
	if(m == 0) return;
	if(m->akt_item > 0) {m->akt_item--;} else {m->akt_item=m->item_num-1;}
}

void menu_destroy(MENU_STRUCT *m)
{
	if(m == 0) return;
	for(BYTE i=0; i < m->item_num;i++)
	{
		if(m->item[i] !=0) {free(m->item[i]);}
	}
	free(m);
}






