#include <avr/io.h>
#include <avr/pgmspace.h>
#include "integer.h"


typedef struct 
{ 
	BYTE str_num;
	BYTE x;
	BYTE y;	
} MENU_ITEM;


typedef struct 
{ 
	PGM_P *str;
	BYTE max_item;
	BYTE akt_item;
	BYTE item_num;
	MENU_ITEM *item[6];
} MENU_STRUCT;


MENU_STRUCT *new_menu(PGM_P *s,BYTE max_item,BYTE akt_item);
void menu_destroy(MENU_STRUCT *m);
void add_menu_item(MENU_STRUCT *m,BYTE stnum, BYTE x,BYTE y);
void set_aktiv(MENU_STRUCT *m,BYTE num);
void plus_menu(MENU_STRUCT *m);
void minus_menu(MENU_STRUCT *m);
void display_menu(MENU_STRUCT *m);


typedef enum 
{
	EXIT_=0,
	SET_TIME,
	SET_DATE,
	SET_CONT,
	SET_LEN,
	TECH,
} SETUP_MENU;


typedef enum 
{	
	NO_MENU=0,
	EXIT_MENU,
	SETUP,
} TYPE_MENU; 











