#include "ADXL345.h"
//#include <util/delay.h>

#ifdef SW_SPI

#define delay()			asm("NOP");asm("NOP")

void adxl345_reg_write(BYTE reg, BYTE data)
{
	BYTE mask;

	ADXL_CS_LO();
	delay();
	ADXL_SCK_LO();
	delay();
	ADXL_MOSI_LO();		//write bit
	delay();
	ADXL_SCK_HI();
	delay();
	ADXL_SCK_LO();
	delay();
	ADXL_MOSI_LO();	//multiple bit
	delay();
	ADXL_SCK_HI();
	delay();
	mask=0x20;	
	for(BYTE i=0; i< 6; i++)
	{
		ADXL_SCK_LO();
		delay();
		if(reg & mask) ADXL_MOSI_HI(); else ADXL_MOSI_LO();
		ADXL_SCK_HI();
		delay();
		mask>>=1;
	}
	mask=0x80;	
	delay();
	for(BYTE i=0; i< 8; i++)
	{
		ADXL_SCK_LO();
		delay();
		if(data & mask) ADXL_MOSI_HI(); else ADXL_MOSI_LO();
		ADXL_SCK_HI();
		delay();
		mask>>=1;
	}
	ADXL_CS_HI();
}

BYTE adxl345_reg_read(BYTE reg)
{
	BYTE mask;
	BYTE data;

	ADXL_CS_LO();
	delay();
	ADXL_SCK_LO();
	delay();
	ADXL_MOSI_HI();		//read bit
	delay();
	ADXL_SCK_HI();
	delay();
	ADXL_SCK_LO();
	delay();
	ADXL_MOSI_LO();		//multiple bit
	delay();
	ADXL_SCK_HI();
	delay();
	mask=0x20;	
	for(BYTE i=0; i < 6; i++)
	{
		ADXL_SCK_LO();
		delay();
		if(reg & mask) ADXL_MOSI_HI(); else ADXL_MOSI_LO();
		delay();
		ADXL_SCK_HI();
		delay();
		mask>>=1;
	}
	data=0;
	mask=0x80;
	for(BYTE i=0; i< 8; i++)
	{
		ADXL_SCK_LO();
		delay();
		ADXL_SCK_HI();
		delay();
		if(ADXL345_PIN & ADXL345_MISO_PIN) data|=mask;
		delay();
		mask>>=1;
	}
	ADXL_CS_HI();
	delay();
	return data;
}

void adxl345_get_xyz(ADXL345_DATA *data)
{
	BYTE buff[6];
	BYTE mask;
	INT_BYTE i;


	ADXL_CS_LO();
	delay();
	ADXL_SCK_LO();
	delay();
	ADXL_MOSI_HI();		//read bit
	delay();
	ADXL_SCK_HI();
	delay();
	ADXL_SCK_LO();
	delay();
	ADXL_MOSI_HI();	//multiple bit
	delay();
	ADXL_SCK_HI();
	delay();
	mask=0x20;	
	for(BYTE i=0; i < 6; i++)
	{
		ADXL_SCK_LO();
		delay();
		if(ADXL345_RA_DATAX0 & mask) ADXL_MOSI_HI(); else ADXL_MOSI_LO();
		delay();
		ADXL_SCK_HI();
		delay();
		mask>>=1;
	}
	for(BYTE b=0; b< 6; b++)
	{
		buff[b]=0;
		mask=0x80;
		for(BYTE i=0; i< 8; i++)
		{
			ADXL_SCK_LO();
			delay();
			ADXL_SCK_HI();
			delay();
			if(ADXL345_PIN & ADXL345_MISO_PIN) buff[b]|=mask;
			delay();
			mask>>=1;
		}
	}	
	i.byte[1]=buff[1];
	i.byte[0]=buff[0];
	data->x=i.val;
	i.byte[1]=buff[3];
	i.byte[0]=buff[2];
	data->y=i.val;
	i.byte[1]=buff[5];
	i.byte[0]=buff[4];
	data->z=i.val;
	//_delay_us(5);
	ADXL_CS_HI();
}

#endif

#ifdef HW_SPI

	void adxl345_reg_write(BYTE reg, BYTE data)
	{
	
	{
	
	BYTE adxl345_reg_read(BYTE reg)
	{
	
	}
	
	void adxl345_get_xyz(ADXL345_DATA *data)
	{
	
	}
#endif

#define OFFS_X			0		//46
#define OFFS_Y			0		//39
#define OFFS_Z			0		//128

void adxl345_init()
{
	adxl345_reg_write(ADXL345_RA_THRESH_TAP,THRESH_TAP );		//0x1D
	adxl345_reg_write(ADXL345_RA_OFSX,OFFS_X);					//0x1E 	az X irányú offszet beállítása 15,6 mili g az egység 0..127 pozitív, 128..255 negyatív
	adxl345_reg_write(ADXL345_RA_OFSY,OFFS_Y);					//0x1F	az Y irányú offszet beállítása 15,6 mili g az egység 0..127 pozitív, 128..255 negyatív
	adxl345_reg_write(ADXL345_RA_OFSZ,OFFS_Z);					//0x20	az Z irányú offszet beállítása 15,6 mili g az egység 0..127 pozitív, 128..255 negyatív a 128 a legnagyobb absolut értékű negatív szám
	adxl345_reg_write(ADXL345_RA_DUR,DUR);						//0x21
	adxl345_reg_write(ADXL345_RA_LATENT,LATENT);				//0x22
	adxl345_reg_write(ADXL345_RA_WINDOW,WINDOW);				//0x23	
	adxl345_reg_write(ADXL345_RA_THRESH_ACT,THRESH_ACT); 		//0x24
	adxl345_reg_write(ADXL345_RA_THRESH_INACT,THRESH_INACT);	//0x25
	adxl345_reg_write(ADXL345_RA_TIME_INACT,TIME_INACT);		//0x26
	adxl345_reg_write(ADXL345_RA_ACT_INACT_CTL,ACT_INACT_CTL);	//0x27
	adxl345_reg_write(ADXL345_RA_THRESH_FF,THRESH_FF);			//0x28
	adxl345_reg_write(ADXL345_RA_TIME_FF,TIME_FF);		 		//0x29	
  	adxl345_reg_write(ADXL345_RA_TAP_AXES,TAP_AXES);			//0x2A
	adxl345_reg_write(ADXL345_RA_BW_RATE,ADXL345_RATE_100);					//0x2C
	adxl345_reg_write(ADXL345_RA_POWER_CTL ,POWER_CTL);			//0x2D
	adxl345_reg_write(ADXL345_RA_INT_ENABLE ,INT_ENABLE);		//0x2E
	adxl345_reg_write(ADXL345_RA_INT_MAP,INT_MAP);				//0x2F
	adxl345_reg_write(ADXL345_RA_DATA_FORMAT,DATA_FORMAT);		//0x31
	adxl345_reg_write(ADXL345_RA_FIFO_CTL ,FIFO_CTL);			//0x38
	adxl345_reg_write(ADXL345_RA_DATAZ1 ,0);

}
