#include <avr/io.h>
#include <util/delay.h> 
#include <avr/pgmspace.h>
#include <avr/interrupt.h> 
#include "SSD1306.h" 

FONT font = normal_font;
static BYTE oled_buff[OLED_WIDTH][OLED_HEIGHT/8];
BOOL inverse = FALSE;
BYTE contrast = 31;


// lookup table, here you can modify the font
static const BYTE NormalFont[112][5] PROGMEM  = {
{0x00, 0x00, 0x00, 0x00, 0x00},// (space)
{0x00, 0x00, 0x5F, 0x00, 0x00},// !
{0x00, 0x07, 0x00, 0x07, 0x00},// "
{0x14, 0x7F, 0x14, 0x7F, 0x14},// #
{0x24, 0x2A, 0x7F, 0x2A, 0x12},// $
{0x23, 0x13, 0x08, 0x64, 0x62},// %
{0x36, 0x49, 0x55, 0x22, 0x50},// &
{0x00, 0x05, 0x03, 0x00, 0x00},// '
{0x00, 0x1C, 0x22, 0x41, 0x00},// (
{0x00, 0x41, 0x22, 0x1C, 0x00},// )
{0x08, 0x2A, 0x1C, 0x2A, 0x08},// *
{0x08, 0x08, 0x3E, 0x08, 0x08},// +
{0x00, 0x50, 0x30, 0x00, 0x00},// ,
{0x08, 0x08, 0x08, 0x08, 0x08},// -
{0x00, 0x30, 0x30, 0x00, 0x00},// .
{0x20, 0x10, 0x08, 0x04, 0x02},// /
{0x3E, 0x51, 0x49, 0x45, 0x3E},// 0
{0x00, 0x42, 0x7F, 0x40, 0x00},// 1
{0x42, 0x61, 0x51, 0x49, 0x46},// 2
{0x21, 0x41, 0x45, 0x4B, 0x31},// 3
{0x18, 0x14, 0x12, 0x7F, 0x10},// 4
{0x27, 0x45, 0x45, 0x45, 0x39},// 5
{0x3C, 0x4A, 0x49, 0x49, 0x30},// 6
{0x01, 0x71, 0x09, 0x05, 0x03},// 7
{0x36, 0x49, 0x49, 0x49, 0x36},// 8
{0x06, 0x49, 0x49, 0x29, 0x1E},// 9
{0x00, 0x36, 0x36, 0x00, 0x00},// :
{0x00, 0x56, 0x36, 0x00, 0x00},// ;
{0x00, 0x08, 0x14, 0x22, 0x41},// <
{0x14, 0x14, 0x14, 0x14, 0x14},// =
{0x41, 0x22, 0x14, 0x08, 0x00},// >
{0x02, 0x01, 0x51, 0x09, 0x06},// ?
{0x32, 0x49, 0x79, 0x41, 0x3E},// @
{0x7E, 0x11, 0x11, 0x11, 0x7E},// A
{0x7F, 0x49, 0x49, 0x49, 0x36},// B
{0x3E, 0x41, 0x41, 0x41, 0x22},// C
{0x7F, 0x41, 0x41, 0x22, 0x1C},// D
{0x7F, 0x49, 0x49, 0x49, 0x41},// E
{0x7F, 0x09, 0x09, 0x01, 0x01},// F
{0x3E, 0x41, 0x41, 0x51, 0x32},// G
{0x7F, 0x08, 0x08, 0x08, 0x7F},// H
{0x00, 0x41, 0x7F, 0x41, 0x00},// I
{0x20, 0x40, 0x41, 0x3F, 0x01},// J
{0x7F, 0x08, 0x14, 0x22, 0x41},// K
{0x7F, 0x40, 0x40, 0x40, 0x40},// L
{0x7F, 0x02, 0x04, 0x02, 0x7F},// M
{0x7F, 0x04, 0x08, 0x10, 0x7F},// N
{0x3E, 0x41, 0x41, 0x41, 0x3E},// O
{0x7F, 0x09, 0x09, 0x09, 0x06},// P
{0x3E, 0x41, 0x51, 0x21, 0x5E},// Q
{0x7F, 0x09, 0x19, 0x29, 0x46},// R
{0x46, 0x49, 0x49, 0x49, 0x31},// S
{0x01, 0x01, 0x7F, 0x01, 0x01},// T
{0x3F, 0x40, 0x40, 0x40, 0x3F},// U
{0x1F, 0x20, 0x40, 0x20, 0x1F},// V
{0x7F, 0x20, 0x18, 0x20, 0x7F},// W
{0x63, 0x14, 0x08, 0x14, 0x63},// X
{0x03, 0x04, 0x78, 0x04, 0x03},// Y
{0x61, 0x51, 0x49, 0x45, 0x43},// Z
{0x00, 0x00, 0x7F, 0x41, 0x41},// [
{0x02, 0x04, 0x08, 0x10, 0x20},// "\"
{0x41, 0x41, 0x7F, 0x00, 0x00},// ]
{0x04, 0x02, 0x01, 0x02, 0x04},// ^
{0x40, 0x40, 0x40, 0x40, 0x40},// _
{0x00, 0x01, 0x02, 0x04, 0x00},// `
{0x20, 0x54, 0x54, 0x54, 0x78},// a
{0x7F, 0x48, 0x44, 0x44, 0x38},// b
{0x38, 0x44, 0x44, 0x44, 0x20},// c
{0x38, 0x44, 0x44, 0x48, 0x7F},// d
{0x38, 0x54, 0x54, 0x54, 0x18},// e
{0x08, 0x7E, 0x09, 0x01, 0x02},// f
{0x08, 0x14, 0x54, 0x54, 0x3C},// g
{0x7F, 0x08, 0x04, 0x04, 0x78},// h
{0x00, 0x44, 0x7D, 0x40, 0x00},// i
{0x20, 0x40, 0x44, 0x3D, 0x00},// j
{0x00, 0x7F, 0x10, 0x28, 0x44},// k
{0x00, 0x41, 0x7F, 0x40, 0x00},// l
{0x7C, 0x04, 0x18, 0x04, 0x78},// m
{0x7C, 0x08, 0x04, 0x04, 0x78},// n
{0x38, 0x44, 0x44, 0x44, 0x38},// o
{0x7C, 0x14, 0x14, 0x14, 0x08},// p
{0x08, 0x14, 0x14, 0x18, 0x7C},// q
{0x7C, 0x08, 0x04, 0x04, 0x08},// r
{0x48, 0x54, 0x54, 0x54, 0x20},// s
{0x04, 0x3F, 0x44, 0x40, 0x20},// t
{0x3C, 0x40, 0x40, 0x20, 0x7C},// u
{0x1C, 0x20, 0x40, 0x20, 0x1C},// v
{0x3C, 0x40, 0x30, 0x40, 0x3C},// w
{0x44, 0x28, 0x10, 0x28, 0x44},// x
{0x0C, 0x50, 0x50, 0x50, 0x3C},// y
{0x44, 0x64, 0x54, 0x4C, 0x44},// z
{0x00, 0x08, 0x36, 0x41, 0x00},// {
{0x00, 0x00, 0x7F, 0x00, 0x00},// |
{0x00, 0x41, 0x36, 0x08, 0x00},// }
{0x08, 0x08, 0x2A, 0x1C, 0x08},// ->
{0x08, 0x1C, 0x2A, 0x08, 0x08}, // <-
{32,84,86,85,108}, // 
{56,84,86,85,24},	// 
{56,68,70,69,56}, // 
{56,69,68,69,56}, // 
{56,70,69,70,57}, // 
{60,64,66,65,124}, // 
{60,65,64,65,124},	// 
{60,66,65,66,125},	// 
{120,20,18,22,121},	// 
{126,74,75,75,66},	// 
{60,66,70,67,60}, // 
{60,67,66,67,60}, // 
{60,66,67,66,61},	// 
{62,64,66,65,62},	// 
{62,65,64,65,62},	// 
{62,67,64,67,63},	// 
};

static const BYTE AkkuFont[9][5] PROGMEM  = {
{0,0,0,0,0}, 		// 				0  semmi
{126,43,17,43,126}, // akku-1		0  char
{126,67,65,67,126}, // akku0		1  char
{126,99,97,99,126}, // akku1		2  char	
{126,115,113,115,126}, // akku2		3  char	
{126,123,121,123,126}, // akku3		4  char
{126,127,125,127,126}, // akku4		5 char
{126,127,127,127,126}, // akku5		6 char	
{12,31,124,95,76} // hlzat		7 char

};

BYTE font_size = 2;	// csak a led_font esetn van jelentsge
BOOL van_res   = TRUE;


//OLED hardver utastsok
void oled_delay_us (WORD us)
{
  WORD i = 0;
  for (; i < us; i++)
    _delay_us (1);
}

//delay_ms max: 65535ms
void oled_delay_ms (WORD ms)
{ 
  while (ms>0)
  {
    ms--;
    _delay_ms(1);
   }
}
 
void write_command(BYTE command)
{
	DC_L();

#ifdef SW_SPI
	for(BYTE i=0;i<8;i++)
	{
		CLK_L();
     	if(command & 0x80) SDA_H(); else SDA_L();
		CLK_H();
        command <<= 1;
	}
#endif

#ifdef HW_SPI
	send_oled_spi(command);
#endif
}

void write_data(BYTE data)
{
	DC_H();

#ifdef SW_SPI
	for(BYTE i=0;i<8;i++)
	{
		CLK_L();
        if(data & 0x80) SDA_H(); else SDA_L();
	CLK_H();
        data <<= 1;
	}
#endif

#ifdef HW_SPI
	send_oled_spi(data);
#endif
}

void init_LY096BG30()
{
	OLED_CTRL_DDR|=CS_PIN;
	OLED_CTRL_DDR|=RES_PIN;
	OLED_CTRL_DDR|=DC_PIN;
	
	OLED_SPI_DDR|=SS_PIN;
	OLED_SPI_DDR|=SCK_PIN;
	OLED_SPI_DDR|=MOSI_PIN;			//SS,SPI port SCK s MOSI OUT, Az SS azrt, hogy ne zavarjon be.
	

#ifdef SW_SPI
	CLK_L();
	SDA_L();
#endif

#ifdef HW_SPI
	//SPIC.CTRL=SPI_ENABLE_bm|SPI_MASTER_bm|SPI_MODE_0_gc|SPI_PRESCALER_DIV4_gc|SPI_CLK2X_bm;
	OLED_SPI_INIT();
#endif

	CS_H();
	RES_H();
	
	oled_delay_ms(1);
	RES_L();
	oled_delay_ms(10);
	RES_H();
	oled_delay_ms(100);
	CS_L();
	write_command(DISPLAY_OFF);   //display off
	write_command(SET_CLOCK_DIV);//--set display clock divide ratio/oscillator frequency
	write_command(0x80);//--set divide ratio
	write_command(SET_MUL_RATIO);//--set multiplex ratio(1 to 64)
	write_command(0x3f);//
	write_command(DISP_OFFSET);//-set display offset
	write_command(0x00);//-not offset
	write_command(SET_START_LINE| 0x00);//--set start line address
	write_command(CHARGE_PUMP);//--set DC-DC enable
	write_command(0x14);//ha a bels DC/DC-t hasznljuk a VCC ellltsra
	//write_command(0x10);//ha kls step up van a VCC ellltsra
	write_command(MEM_ADDR_MODE);	//Set Memory Addressing Mode	
	write_command(0x00);	//00,Horizontal Addressing Mode;01,Vertical Addressing Mode;10,Page Addressing Mode (RESET);11,Invalid
	write_command(SEG_RE_MAP|0x01);
	write_command(SCAN_0_127);	//Set COM Output Scan Direction
	write_command(SET_COM_PINS);//--set com pins hardware configuration
	write_command(0x12);
	write_command(SET_CONTRAST);//--set contrast control register
	write_command(contrast);
	write_command(SET_PRE_CHARGE);//--set pre-charge period
	write_command(0xf1);
	write_command(SET_VCOM);//--set vcomh
	write_command(0x20);//0x20,0.77xVcc
	write_command(ALL_ON_RESUME);
	write_command(SET_COL_ADDR);
	write_command(0x00);
	write_command(OLED_WIDTH-1);
	write_command(SET_PAGE_ADDR);
	write_command(0x00);
	write_command(7);
	write_command(NORMAL);//--set normal display
	write_command(DISPLAY_ON);//--turn on oled panel 

	//CS_H();
	
	oled_delay_ms(100);
}


void set_contrast()
{
	//CS_L();
	write_command(SET_CONTRAST);
	write_command(contrast);
	//CS_H();
}


//OLED grafikai utastsok

char ekezetes_fv(char c)
{
	if(c > 128)
	{
		if(c == '') c = 96+32; else
		if(c == '') c = 97+32; else
		if(c == '') c = 98+32; else
		if(c == '') c = 99+32; else
		if(c == '') c = 100+32; else
		if(c == '') c = 101+32; else
		if(c == '') c = 102+32; else
		if(c == '') c = 103+32; else
		if(c == '') c = 104+32; else
		if(c == '') c = 105+32; else
		if(c == '') c = 106+32; else
		if(c == '') c = 107+32; else
		if(c == '') c = 108+32; else
		if(c == '') c = 109+32; else
		if(c == '') c = 110+32; else
		if(c == '') c = 111+32;
	}
	return c;
}


void oled_cls(BYTE fill)
{
	for(BYTE y=0;y<OLED_HEIGHT/8;y++)
	{
		for(BYTE x=0;x<OLED_WIDTH;x++)
		{
			oled_buff[x][y]=fill;
		}
	}
}

void oled_clsxy(BYTE x0,BYTE y0,BYTE x1,BYTE y1,BOOL fill)	//x,y pixelben rtend
{
	for(BYTE y=y0;y<y1+1;y++)
	{
		for(BYTE x=x0;x<x1+1;x++)
		{
			if(fill) 
			{ 
				oled_buff[x][y/8]|= (1<<(y%8));
			}else
			{
				oled_buff[x][y/8]&= ~(1<<(y%8));
			}
		}
	}
}

void render()
{
	for(BYTE y=0;y < OLED_HEIGHT/8;y++)
  	{
		write_command(0xb0|y);
    	write_command(0x00);
    	write_command(0x10);
    	for(BYTE x=0;x < OLED_WIDTH;x++)
    	{
      		write_data(oled_buff[x][y]);
    	}
  	}
}

void renderxy(BYTE x0,BYTE y0,BYTE x1,BYTE y1)		//x,y pixelben rtend
{
	write_command(0x21);
	write_command(x0);
	write_command(x1);
	for(BYTE y=(y0+1)/8;y<(y1)/8;y++)
  	{
		write_command(0xb0|y);
    	for(BYTE x=x0;x<x1+1;x++)
    	{
      		write_data(oled_buff[x][y]);
    	}
  	}
}


void print_message(const char * message,BYTE x,BYTE y)// Write message to LCD (C string type)
{   
	char c;
	//BYTE z;

	switch(font)
	{
		case normal_font :
		{
			while (*message)
			{     
				c=ekezetes_fv(*message++); 
				for (BYTE i = 0; i < 5; i++ )
    			{
					if(inverse)
					{
						oled_buff[x++][y]=255-(pgm_read_byte(&NormalFont[c-32][i]));
					} else
					{
						oled_buff[x++][y]=(pgm_read_byte(&NormalFont[c-32][i]));
					}
				}
				if(inverse) oled_buff[x++][y]=255; else oled_buff[x++][y]=0;
			}
			break;
		}
		case akku_font :
		{
			while (*message)
			{     
				c=(*message++); 
				for (BYTE i = 0; i < 5; i++ )
    			{
					if(inverse)
					{
						oled_buff[x++][y]=255-(pgm_read_byte(&AkkuFont[c][i]));// <<1;
					} else 
					{
						oled_buff[x++][y]=(pgm_read_byte(&AkkuFont[c][i]));// <<1;
					}
				}
			}
			break;
		}
		case led_font :
		{
			while (*message)
			{     
				c=ekezetes_fv(*message++); 
				for (BYTE i = 0; i < 5; i++)
    			{
					if(inverse)
					{
						BYTE led=(pgm_read_byte(&NormalFont[c-32][i]));
						BYTE p = 0x01;
						for(BYTE j=0; j < 8 ;j++) 
						{
							if(led & p) rectangle(x+i*font_size,y+j*font_size,x+i*font_size+font_size-1-van_res,y+j*font_size+font_size-1-van_res,CLEAR_MODE,TRUE);
							else rectangle(x+i*font_size,y+j*font_size,x+i*font_size+font_size-1-van_res,y+j*font_size+font_size-1-van_res,OR_MODE,TRUE);
							p*=2;
						}
					} else
					{
						BYTE led=(pgm_read_byte(&NormalFont[c-32][i]));
						BYTE p = 0x01;
						for(BYTE j=0; j < 8 ;j++) 
						{
							if(led & p) rectangle(x+i*font_size,y+j*font_size,x+i*font_size+font_size-1-van_res,y+j*font_size+font_size-1-van_res,OR_MODE,TRUE);
							else rectangle(x+i*font_size,y+j*font_size,x+i*font_size+font_size-1-van_res,y+j*font_size+font_size-1-van_res,CLEAR_MODE,TRUE);
							p*=2;
						}
						
					}
				}
				x+=(font_size*6-2);
				if(inverse) oled_buff[x++][y]=255; else oled_buff[x++][y]=0;
			}
			break;
		}
	}
}

void setpixel(int x, int y, BYTE mode)
{
	if(!((x >= 0) && (x < OLED_WIDTH) && (y >= 0) && (y < OLED_HEIGHT))) return;
	switch (mode)
	{
		case XOR_MODE :
		{
			oled_buff[x][y/8] ^= (1<<(y%8));
			break;
		}
		case AND_MODE :
		{
			oled_buff[x][y/8] &= (1<<(y%8));
			break;
		}
		case OR_MODE :
		{
			oled_buff[x][y/8] |= (1<<(y%8));
			break;
		}
		case CLEAR_MODE :
		{
			oled_buff[x][y/8] &= ~(1<<(y%8));
			break;
		}

	}
}

void hline(BYTE x0,BYTE y0,BYTE x1,BYTE mode)
{
	BYTE xmin, xmax;
	
	xmin = (x0 <= x1) ? x0 : x1;
	xmax = (x0 > x1) ? x0 : x1;

	BYTE x = xmax-xmin+1;
	while(x--)
	{
		setpixel(xmin+x,y0,mode);
	}	
}

void vline(BYTE x0,BYTE y0,BYTE y1,BYTE mode)
{
	BYTE ymin, ymax;	
	ymin = (y0 <= y1) ? y0 : y1;
	ymax = (y0 > y1) ? y0 : y1;

	BYTE y = ymax-ymin+1;
	while(y--)
	{
		setpixel(x0,ymin+y,mode);
	}
}

void line(int x0,int y0,int x1,int y1, BYTE mode)
{
   	int dx = abs(x1-x0);
   	int dy = abs(y1-y0); 
   	int sx, sy, err, e2;

	
   	if(x0 < x1) sx = 1; else sx = -1;
   	if(y0 < y1) sy = 1; else sy = -1;
   	err = dx-dy;
 	while(1)
   	{
    	setpixel(x0,y0,mode);
     	if((x0 == x1) && (y0 == y1)) return;
     	e2 = 2*err;
     	if(e2 > -dy)
	 	{
       		err = err - dy;
       		x0  = x0 + sx;
     	}
     	if(e2 < dx)
	 	{
       		err = err + dx;
       		y0 = y0 + sy;
	 	}
   } 
}

void rectangle(int x0,int y0,int x1,int y1,BYTE mode,BOOL fill)
{
	int xmin, xmax, ymin, ymax, x;	
	xmin = (x0 <= x1) ? x0 : x1;
	xmax = (x0 > x1) ? x0 : x1;
	ymin = (y0 <= y1) ? y0 : y1;
	ymax = (y0 > y1) ? y0 : y1;
		
	hline(xmin,ymin,xmax,mode);
	vline(xmin,ymin,ymax,mode);
	vline(xmax,ymin,ymax,mode);
	hline(xmin,ymax,xmax,mode);
	if(fill)
	{
		for(x=xmin+1;x<xmax;x++)
			vline(x,ymin,ymax,mode);
	}
}

// The '(x != 0 && y != 0)' test in the last line of this function
// may be omitted for a performance benefit if the radius of the
// circle is known to be non-zero.
void plot4points(int cx, int cy, int x, int y, BYTE mode)
{
  setpixel(((cx + x)), cy + y,mode);
  if (x != 0) setpixel(((cx - x)), cy + y,mode);  	//11*(cx - x)/10 ez amiatt van, mert a pixel
  if (y != 0) setpixel(((cx + x)), cy - y,mode);	//x s y irny mrete eltr dx=96 pont = 20mm =96/20=4,8
  if (x != 0 && y != 0) setpixel(((cx - x)), cy - y,mode);	//dy=68 pont = 16 mm  =68/16=4,25; 4,8/4,25=1,1294-> 1,1
}


void plot8points(int cx, int cy, int x, int y, BYTE mode)
{
  plot4points(cx, cy, x, y,mode);
  if (x != y) plot4points(cx, cy, y, x,mode);
}


void circle(int cx, int cy, int radius, BYTE mode)
{
  int error = -radius;
  int x = radius;
  int y = 0;
 
  //cx=(cx*230)>>8;
  while (x >= y)
  {
    plot8points(cx, cy, x, y,mode);
 
    error += y;
    ++y;
    error += y;
 
    if (error >= 0)
    {
      --x;
      error -= x;
      error -= x;
    }
  }
}

void arc(BYTE xL, BYTE yB, BYTE xR, BYTE yT, BYTE r1, BYTE r2, BYTE octant,BYTE mode)
{
//	Draws the octant arc of the beveled figure with the given centers, 
//  radii and octant mask.
//  When octant = 0xFF and the following are true:
//  1. xL = xR, yT = yB , r1 = 0 and r2 = z, a filled circle is drawn with a radius of z.
//  2. radii have values (where r1 < r2), a full ring with thickness of (r2-r1) is drawn.
//  3. xL != xR, yT != yB , r1 = 0 and r2 = 0 (where xR > xL and yB > yT) a rectangle is 
//    drawn. xL, yT specifies the left top corner and xR, yB specifies the right bottom corner.
//  When octant != 0xFF the figure drawn is the subsection of the 8 section figure where 
//  each non-zero bit of the octant value specifies the octants that will be drawn.
//	Input: xL - x location of the lower left center in the x,y coordinate.
//		 yB - y location of the lower left center in the x,y coordinate.
//		 xR - x location of the upper right center in the x,y coordinate.
//		 yT - y location of the upper right center in the x,y coordinate.
//		 r1 - The smaller radius of the two concentric cicles that defines the thickness
//			  of the object.
//	     r2 - The larger of radius the two concentric circles that defines the thickness 
//	     	  of the object.
//		 octant - Bitmask of the octant that will be drawn.
//				  Moving in a clockwise direction from x = 0, y = +radius
//                 - bit0 : first octant 
//                 - bit1 : second octant
//                 - bit2 : third octant 
//                 - bit3 : fourth octant
//                 - bit4 : fifth octant
//                 - bit5 : sixth octant
//                 - bit6 : seventh octant
//                 - bit7 : eight octant



	SHORT       y1Limit, y2Limit;
    SHORT       x1, x2, y1, y2;
    SHORT       err1, err2;
    SHORT       x1Cur, y1Cur, y1New;
    SHORT       x2Cur, y2Cur, y2New;
    DWORD_VAL   temp;

    temp.Val = SIN45 * r1;
    y1Limit = temp.w[1];
    temp.Val = SIN45 * r2;
    y2Limit = temp.w[1];

    temp.Val = (DWORD) (ONEP25 - ((LONG) r1 << 16));
    err1 = (SHORT) (temp.w[1]);

    temp.Val = (DWORD) (ONEP25 - ((LONG) r2 << 16));
    err2 = (SHORT) (temp.w[1]);

    x1 = r1;
    x2 = r2;
    y1 = 0;
    y2 = 0;

    x1Cur = x1;
    y1Cur = y1;
    y1New = y1;
    x2Cur = x2;
    y2Cur = y2;
    y2New = y2;

    while(y2 <= y2Limit)
    {   // just watch for y2 limit since outer circle
        // will have greater value.
        // Drawing of the rounded panel is done only when there is a change in the
        // x direction. Bars are drawn to be efficient.
        // detect changes in the x position. Every change will mean a rectangle_vastag will be drawn
        // to cover the previous area. y1New records the last position of y before the
        // change in x position.
        // y1New & y2New records the last y positions, must remember this to
        // draw the correct rectangle_vastags (non-overlapping).
        y1New = y1;
        y2New = y2;

        if(y1 <= y1Limit)
        {
            if(err1 > 0)
            {
                x1--;
                err1 += 5;
                err1 += (y1 - x1) << 1;
            }
            else
            {
                err1 += 3;
                err1 += y1 << 1;
            }

            y1++;
        }
        else
        {
            y1++;
            if(x1 < y1)
                x1 = y1;
        }

        if(err2 > 0)
        {
            x2--;
            err2 += 5;
            err2 += (y2 - x2) << 1;
        }
        else
        {
            err2 += 3;
            err2 += y2 << 1;
        }

        y2++;

        if((x1Cur != x1) || (x2Cur != x2))
        {
            if(octant & 0x01)
            {
                rectangle(xR + y2Cur, yT - x2Cur, xR + y1New, yT - x1Cur,mode,TRUE);    // 1st octant
            }

            if(octant & 0x02)
            {
                rectangle(xR + x1Cur, yT - y1New, xR + x2Cur, yT - y2Cur,mode,TRUE);    // 2nd octant
            }

            if(octant & 0x04)
            {
                rectangle(xR + x1Cur, yB + y1Cur, xR + x2Cur, yB + y2New,mode,TRUE);    // 3rd octant
            }

            if(octant & 0x08)
            {
                rectangle(xR + y1Cur, yB + x1Cur, xR + y2New, yB + x2Cur,mode,TRUE);    // 4th octant
            }

            if(octant & 0x10)
            {
                rectangle(xL - y1New, yB + x1Cur, xL - y2Cur, yB + x2Cur,mode,TRUE);    // 5th octant
            }

            if(octant & 0x20)
            {
                rectangle(xL - x2Cur, yB + y2Cur, xL - x1Cur, yB + y1New,mode,TRUE);    // 6th octant
            }

            if(octant & 0x40)
            {
                rectangle(xL - x2Cur, yT - y2New, xL - x1Cur, yT - y1Cur,mode,TRUE);    // 7th octant
            }

            if(octant & 0x80)
            {
                rectangle(xL - y2New, yT - x2Cur, xL - y1Cur, yT - x1Cur,mode,TRUE);    // 8th octant
            }

            // update current values
            x1Cur = x1;
            y1Cur = y1;
            x2Cur = x2;
            y2Cur = y2;
        }
    }                           // end of while loop
	
    // draw the width and height
    if((xR - xL) || (yB - yT))
    {

        // draw right
        if(octant & 0x02)
        {
            rectangle(xR + r1, yT, xR + r2, (yB + yT) >> 1,mode,TRUE);
        }

        if(octant & 0x04)
        {
            rectangle(xR + r1, ((yB + yT) >> 1), xR + r2, yB,mode,TRUE);
        }

        // draw bottom
        if(octant & 0x10)
        {
            rectangle(xL, yB + r1, ((xR + xL) >> 1), yB + r2,mode,TRUE);
        }

        if(octant & 0x08)
        {
            rectangle(((xR + xL) >> 1), yB + r1, xR, yB + r2,mode,TRUE);
        }

        if(xR - xL)
        {

            // draw top
            if(octant & 0x80)
            {
                rectangle(xL, yT - r2, ((xR + xL) >> 1), yT - r1,mode,TRUE);
            }

            if(octant & 0x01)
            {
                rectangle(((xR + xL) >> 1), yT - r2, xR, yT - r1,mode,TRUE);
            }
        }

        if(yT - yB)
        {

            // draw left
            if(octant & 0x40)
            {
                rectangle(xL - r2, yT, xL - r1, ((yB + yT) >> 1),mode,TRUE);
            }

            if(octant & 0x20)
            {
                rectangle(xL - r2, ((yB + yT) >> 1), xL - r1, yB,mode,TRUE);
            }
        }
    }

}
