#include "OLED_karora_328.h"
#include <avr/sleep.h>
#include <avr/interrupt.h>
#include <util/delay.h> 
#include "xprintf.h"
#include "ssd1306.h" 
#include "ADXL345.h"


extern FONT font;
ADXL345_DATA acc;
extern BOOL inverse;

void init_port()
{
	ONTART_INIT();
	ONTART_ON();
	
	EICRA|=(1 << ISC11) | (1 << ISC01);
	EIMSK|=(1 << INT1) | (1 << INT0);
	INIT_ADXL_PORT();
}

void init_timer(void)
{
	TCCR0A=(1<<WGM01);										//MODE 2	CTC  
	TCCR0B=(1<<CS02)|(1<<CS00);								// oszts 1024
	TCNT0=0;
	OCR0A=77;
	TIMSK0|=(1<<OCIE0A);

	ASSR |= (1<<AS2);
	OCR2A=0;
	TCNT2=0;
	TCCR2B|=(1<<CS22)|(1<<CS20);
	while(ASSR&0x07);
	TIMSK2|=(1<<TOIE2);
}

void init_all()
{
	init_port();
	init_timer();
	sei();
	init_LY096BG30();
	oled_cls(0x00);
	font=normal_font;
	render();
	adxl345_init();
}

void draw_header()
{
	static WORD bat[7] = {3600,3700,3800,3900,4000,4100,4500};
	BYTE i=0;

	OK=FALSE;	
	akku_u=((WORD)akku*37)/2;
	while(akku_u >  bat[i]) {i++;}
	i++;
	font=akku_font;
	xsprintf(header_buffer,"%c",i);
	print_message(header_buffer,122,0);
	font=normal_font;
	xsprintf(header_buffer,"%02d:%02d:%02d",hour,min,sec);
	print_message(header_buffer,0,0);
	xsprintf(header_buffer,"%4dmV",akku_u);
	print_message(header_buffer,84,0);
	inverse=TRUE;
	print_message(" TESZT ! ",37,1);
	inverse=FALSE;
}

void kiir(char* c)
{
	print_message(c,0,7);
		
}

BOOL kopp_e()
{
	BYTE acc_stat;
	BOOL ret=FALSE;

	tap_status=_NO;
	if(_1kopp)  			//egy kopp mr biztos trtnt                                                               
  	{
		ret=TRUE;
    	_delay_ms(600);     //vrunk, hogy van-e msodik kopp is                                                             
		if(_2kopp)
		{
			acc_stat=adxl345_reg_read(ADXL345_RA_INT_SOURCE);
			if(acc_stat & ADXL345_INT_DOUBLE_TAP_BIT) tap_status|=KOPP2;
		
		} else { tap_status|=KOPP1;}
		acc_stat=adxl345_reg_read(ADXL345_RA_INT_SOURCE);
		acc_stat=adxl345_reg_read(ADXL345_RA_ACT_TAP_STATUS);	//beolvassuk a STATUS regisztert
		//megnzzuk a koppants melyik tengelyeken trtnt (unsigned) 
		if(acc_stat & ADXL345_TAPSTAT_TAPX_BIT) tap_status|=_X;
		if(acc_stat & ADXL345_TAPSTAT_TAPY_BIT) tap_status|=_Y;
		if(acc_stat & ADXL345_TAPSTAT_TAPZ_BIT) tap_status|=_Z;
		
		xsprintf(header_buffer,"%08b",tap_status);				//fellrl  4 sorban binris formban kirjuk a sttuszt 
		print_message(header_buffer,40,4);
		
		_1kopp =FALSE;
		_2kopp =FALSE;
		light_timer=DEF_MODE_TIMER;
		EIMSK|=(1 << INT1) | (1 << INT0);
  	}
	return ret;
}

void get_action()
{
	if(!kopp_e()) return;
	if((tap_status & KOPP1))	
	{
		if(tap_status & _X)	print_message("1 kopp X",40,3);
		if(tap_status & _Y)	print_message("1 kopp Y",40,3);
		if(tap_status & _Z)	print_message("1 kopp Z",40,3);
	} else 
	if((tap_status & KOPP2))	
	{
		if(tap_status & _X)	print_message("2 kopp X",40,3);
		if(tap_status & _Y)	print_message("2 kopp Y",40,3);
		if(tap_status & _Z)	print_message("2 kopp Z",40,3);
	}
}

int main()
{
	init_all();
	Timer=50;
	while(1)
	{
		get_action();
		if(OK) draw_header();	//msodpercenknt kirja a fejlcet
					//megnzi volt-e kopp
		if(!Timer)		//a TIMER0 100 Hz megszaktsban vltozik
		{
			adxl345_get_xyz(&acc);	//lekrdezi az x,y,z irny gyorsulst
			xsprintf(header_buffer,"X=%3d,Y=%3d,Z=%3d",acc.x/4,acc.y/4,acc.z/4);	
			print_message(header_buffer,0,7);
			Timer=10;	//50*10 msec idnknt megjelenti a gyorsuls rtkeket az als sorban
		}	
		render();
	}
}

ISR(TIMER0_COMPA_vect)	//100Hz-es megszakts
{
	static BYTE szam;
	BYTE n;
	
	szam++;	
	if(!(szam%100)) 
	{
		//msodpercenknt mri az akku feszltsget
		ADMUX = (1<<REFS1)|(1<<REFS0)|(1<<ADLAR)|AKKU;					// 1.100 mV a referencia fesz,  balra igaztott 8 bit
		ADCSRA= (1<<ADEN)|(1<<ADSC)|(1<<ADIE)|(1<<ADPS2)|(1<<ADPS1);  	//ADC eng, oszt 64, Konverzi indts, ADC interrupt eng
	}
	//------------------ ltalnos softveres timer(ek) ---------------
	n = Timer;
	if (n) Timer = --n;
}

ISR(ADC_vect)
{
	akku = ADCH;
	ADCSRA 	= 0;
}

ISR(INT0_vect)	//Az ADXL INT2 lba  2 kopp
{
	_2kopp=TRUE;
	EIMSK&=~(1 << INT0);
}

ISR(INT1_vect)	//Az ADXL INT1 lba 1 kopp
{
	_1kopp=TRUE;
	EIMSK&=~(1 << INT1);
}

ISR(TIMER2_OVF_vect)
{	
	sec++;
	if(sec == 60) 
	{
		sec=0;
		if(++min == 60)
		{
			min=0;
			if(++hour == 24) 
			{
				hour=0;
			}
		}
	}
	OK=TRUE;
}
