----------------------------------------------------------------------------------
-- Developer:bbatka (Kiss Attila) verzi:2022-01-02 
-- 
-- Create Date:    20:41:19 10/25/2008 
-- Design Name: 
-- Module Name:    villi - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision:2022-01-02 
-- Revision:
-- Additional Comments: High 'Z' (DACLK, MCLK, CS1, LED) When GTS1=0 md:2022-01-02
--
----------------------------------------------------------------------------------
Library ieee;
Use ieee.std_logic_1164.ALL;
Use ieee.STD_LOGIC_ARITH.ALL;
Use ieee.std_logic_unsigned.ALL;

Entity k1 is
 port( LED: out std_logic_vector(15 downto 0);--SRAM cmzs
      CLK: in std_logic;
		SCLK: inout std_logic;--Segd rajel
		SCLKI: inout std_logic;--Inverz Segd rajel		
		GTS1: in std_logic;--Engedlyez lb
		DACLK: inout std_logic;--ADC rajele
		ClkSel: in std_logic_vector(3 downto 0);
		--CS1: out std_logic;--SRAM Chip Select, nincs kivezetve, dsPIC kezeli, P1 pin ill. P40
		--LED_ZOLD: out std_logic; 
		MCLK: inout std_logic);--Msodlagos rajel,SRAM WE jel, nincs kivezetve, dsPIC kezeli, P27 pin ill. P35
end;

Architecture rtl of k1 is
signal count: std_logic_vector(16 downto 0):="00000000000000000";
signal count2: std_logic_vector(0 downto 0):="0";
signal count3: std_logic_vector(0 downto 0):="0";
signal ADC_div: std_logic_vector(8 downto 0):="000001111";
signal ADCClk: std_logic:='0';

begin

 SCLK <= CLK when ClkSel="0000" else ADCClk;--SRAM WE rsengedly jel is
 --LED <= count(16 downto 1);--Egyszer 16bites szmll
 DACLK <= count2(0) after 0ns When GTS1='1' Else 'Z';--(2022-01-01 High 'Z')(2022-01-03 Count3(0))
 MCLK <= count2(0) after 0ns When GTS1='1' Else 'Z';--SRAM WE rsengedly jel is --(2022-01-01)
 --CS1 <= count2(0) after 0ns When GTS1='1' Else 'Z';--(2022-01-01)
 SCLKI <= not(SCLK);
 --LED_ZOLD <= count(16);
 LED <= count(16 downto 1) When GTS1='1' Else "ZZZZZZZZZZZZZZZZ";--(2022-01-01)
 
--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 process(SCLK)
 begin
  if SCLK'event and SCLK='1' then
   if GTS1='1' then 
   count <= count+1;
	else
	count <= "00000000000000000";-- SRAM Cmzs nullzsa
	end if;
  end if;
 end process;
--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
process(SCLK)
 begin
  if SCLK'event and SCLK='1' then --Kettvel val leosztott jel
   if GTS1='1' then   
	count2 <= count2+1;
	else
	count2 <= "0";--Msodlagos rajel nullzs	
	end if;
  end if;
 end process;
--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
process(SCLK)
 begin
  if SCLK'event and SCLK='0' then --Kettvel val leosztott jel
   if GTS1='1' then   
	count3 <= count3+1;
	else
	count3 <= "0";--Msodlagos rajel nullzs	
	end if;
  end if;
 end process;
--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ClkDivP: process(CLK,GTS1)
 begin
  if GTS1='0' then  
  ADCClk <= '0';
  ADC_div <= "000001001";
  elsif CLK='0' and CLK'event then
	if ADC_div="000000000" then
		ADCClk <= not(ADCClk);
		case ClkSel is
			when "0001" =>								  -- Div4  12,5Mhz 50Mhz rajelnl
			when "0010" => ADC_div <= "000000001";  -- Div8 (rtk+1)*2=oszts rtk
			when "0011" => ADC_div <= "000000100";  -- Div20		
 			when "0100" => ADC_div <= "000001001";  -- Div40
			when "0101" => ADC_div <= "000010011";  -- Div80
			when "0110" => ADC_div <= "000110001";  -- Div200
			when "0111" => ADC_div <= "001100011";  -- Div400
			when "1000" => ADC_div <= "011000111";  -- Div800
			when "1001" => ADC_div <= "111110011";  -- Div2000
			when others => ADC_div <= "111110011";  -- Div2000  25000Hz 50MHz rajelnl
		end case;
	else
		ADC_div <= (unsigned(ADC_div)-1);
	end if;
	end if;
end process;
--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 process(CLK,GTS1)
 begin
  if CLK='0' and CLK'event then
   if GTS1='0' then   
	MCLK <= 'Z';
	DACLK <= 'Z';
	--CS1 <= 'Z';
	LED(0) <= 'Z';
	LED(1) <= 'Z';
	LED(2) <= 'Z';
	LED(3) <= 'Z';
	LED(4) <= 'Z';
	LED(5) <= 'Z';
	LED(6) <= 'Z';
	LED(7) <= 'Z';
	LED(8) <= 'Z';
	LED(9) <= 'Z';
	LED(10) <= 'Z';
	LED(11) <= 'Z';
	LED(12) <= 'Z';
	LED(13) <= 'Z';
	LED(14) <= 'Z';
	LED(15) <= 'Z';	
	end if;
 end if;
 end process;
 
end;



