//
// Recording the operating time of a workstation, creating the HMI via HTML. To do this, visit https://randomnerdtutorials.com/esp32-access-point-ap-web-server/
// Board: Node32s
// 0x50 EEPROM

// Memory map
//  0 - unsigned int, 2 byte - Number of records, can be deleted.
//  2 - unsigned int, 2 byte - Number of ESP32 activations, cannot be deleted in HMI.
//  4 - unsigned int, 2 byte - Number of HTML page queries, cannot be deleted in HMI.
//  6 - unsigned int, 2 byte - Number of records. When the record counter is cleared, the previous value is stored (cancellation option).
// 10 - 1. Rekord     1 record is 6 bytes long.
// Record structure - 6 bytes for start time, month-day-hour-minute, duration, 1-1-1-1-2 bytes. The duration in sec. If the duration is 0, it has been switched off during operation.
// If the duration is 50,000, it is not a job but a turn-on time.

#include <ErriezDS1302.h>             // https://erriez.github.io/ErriezDS1302, https://github.com/Erriez/ErriezDS1302
#include <WiFi.h>
#include <Wire.h>
#include "SparkFun_External_EEPROM.h" // Click here to get the library: http://librarymanager/All#SparkFun_External_EEPROM
ExternalEEPROM myMem;

#define DS1302_CLK_PIN      0
#define DS1302_IO_PIN       4
#define DS1302_CE_PIN       5
ErriezDS1302 rtc = ErriezDS1302(DS1302_CLK_PIN, DS1302_IO_PIN, DS1302_CE_PIN);

// The name and password of your own server that appears in the wi-fi list
const char* ssid     = "ESP32-Access-Point";
const char* password = "123456789";

// Set web server port number to 80
WiFiServer server(80);

// Variable to store the HTTP request
String header;
String tmpString ="";
const int input33 = 33;
unsigned long startMillis;
bool buttonState=true;
bool prevButtonState=true;
bool readingButton;
unsigned long lastDebounceTime=0;
unsigned int debounceDelay=50;
uint16_t recordCounter;  // Number of records
uint16_t powerOnCounter; // Number of turns on
uint16_t loadCounter;    // Number of queries
uint16_t duration=0;     // Duration of work
uint16_t blank=0;        // Blank field to create the list
String stamp="mmddhhmm"; // month, day, hour, minute
String stampDuration="12345";   // Duration converted to minutes: seconds
String clientTime="00000000"; // Client-side time, scripted using a script
uint8_t rtcTime[5];      // RTC time converted to month, day, hour, minute format
struct tm dt;            // RTC's own format
bool list=false;         // List creation parameters
bool powa=false;
uint8_t listType=0;      // 0 - no list, 1 - list all, 2 - list work, 3 - list ON, 4 - list time limit
bool clr=false;
bool cancel=false;
bool resetCounter=false;
bool timeSetting=false;  // The exact time to write to RTC in the times[] variable
int counter=0;           // Work register for processing the GET method
int timeLimit=60;        // Parameter for creating a Timelimit list (milliseconds).

String htmlData;
uint16_t lineNumber;
char tmpChar;
String listTypeString;

//A vázlat 695861 bájt (53%)-ot használ a program tárhelyből. A maximum 1310720 bájt.
//A globális változók 39116 bájt (11%)-ot használnak a dinamikus memóriából, 288564 bájtot hagyva a helyi változóknak. A maximum 327680 bájt.


void setup() {
  Serial.begin(115200);
  //htmlData.reserve(65500);
  pinMode(LED_BUILTIN, OUTPUT);
  pinMode(input33, INPUT_PULLUP);
  digitalWrite(LED_BUILTIN, 1);   // Power ON signal
  delay(500);
  digitalWrite(LED_BUILTIN, 0);
  delay(500);
  Wire.begin();
  if (myMem.begin() == false){
    Serial.println("No memory detected. Freezing.");
    while (1);
  }
  Serial.println("Memory detected!");
  Serial.print("Mem size in bytes: ");
  Serial.println(myMem.length());
  digitalWrite(LED_BUILTIN, 1);   // External memory OK signal
  delay(500);
  digitalWrite(LED_BUILTIN, 0);
  delay(500);

  // Connect to Wi-Fi network with SSID and password
  Serial.print("Setting AP (Access Point)…");
  WiFi.softAP(ssid, password);    // Remove the password parameter, if you want the AP (Access Point) to be open

  IPAddress IP = WiFi.softAPIP();
  Serial.print("AP IP address: ");
  Serial.println(IP);
  
  server.begin();
  while (!rtc.begin()) {
      Serial.println("No RTC detected. Freezing.");
      while (1);
  }
  digitalWrite(LED_BUILTIN, 1);   // RTC detected signal
  delay(500);
  digitalWrite(LED_BUILTIN, 0);

  myMem.get(0, recordCounter);      // Reading counter values
  myMem.get(2, powerOnCounter);
  myMem.get(4, loadCounter);
  powerOnCounter++;
  myMem.put(2, powerOnCounter);
  blank=50000;
  saveRecord();
  blank=0;
  Serial.print("Record: ");
  Serial.print(recordCounter);
  Serial.print(" PowerON: ");
  Serial.print(powerOnCounter);
  Serial.print("  Load: ");
  Serial.println(loadCounter);
}

void loop(){
  if (clr==true){ // List clear
    clr=false;
    myMem.put(6, recordCounter);  // Store the previous record counter.
    recordCounter=1;              // New record counter.
    myMem.put(0, recordCounter);
  }
  if (timeSetting==true){ // Time in rtc.
    timeSetting=false;
    settingDateTime();    // Enter the received time in the RTC.
    readingDateTime();    // Update local time.
  }
  if (cancel==true){ // Restore the previous record counter.
    myMem.get(6, recordCounter);      // Reading previous counter values
    myMem.put(0, recordCounter);
  }  
  if (resetCounter==true){ // Reset load and power on counter.
    powerOnCounter=0;
    loadCounter=0;
    myMem.put(2, powerOnCounter);
    myMem.put(4, loadCounter);
  }  
  chkInput();
  
  WiFiClient client = server.available();   // Listen for incoming clients

  if (client) {                             // If a new client connects,
    Serial.println("New Client.");          // print a message out in the serial port
    String currentLine = "";                // make a String to hold incoming data from the client
    while (client.connected()) {            // loop while the client's connected
      chkInput();
      if (client.available()) {             // if there's bytes to read from the client,
        char c = client.read();             // read a byte, then
        Serial.write(c);                    // print it out the serial monitor
        header += c;
        if (c == '\n') {                    // if the byte is a newline character
          // if the current line is blank, you got two newline characters in a row.
          // that's the end of the client HTTP request, so send a response:
          if (currentLine.length() == 0) {
            // HTTP headers always start with a response code (e.g. HTTP/1.1 200 OK)
            // and a content-type so the client knows what's coming, then a blank line:
            loadCounter++;
            myMem.put(4, loadCounter);
            client.println("HTTP/1.1 200 OK");
            client.println("Content-type:text/html");
            client.println("Connection: close");
            client.println();

            counter=header.indexOf("GET");
            if (counter>=0) {
              header=header.substring(counter+3,counter+20);
            }
            //0 - no list, 1 - list all, 2 - list work, 3 - list ON, 4 - list time limit
            listTypeString="No list.";
            if (header.indexOf("lista") >= 0) {
              Serial.println("LIST all");
              list=true;
              listType=1;
              listTypeString="all";
              timeLimit=0;
            }
            if (header.indexOf("listp") >= 0) {
              Serial.println("LIST power");
              list=true;
              listType=3;
              listTypeString="power ON";
            }
            if (header.indexOf("listw") >= 0) {
              Serial.println("LIST work");
              list=true;
              listType=2;
              listTypeString="work";
              timeLimit=0;
            }
            if (header.indexOf("listt") >= 0) {   // Watch a time limit on the list. e.g. only a period longer than 1 minute should be visible
              Serial.println("LIST 60 work");
              list=true;
              listType=4;
              listTypeString="time limit 60 sec";
              timeLimit=60;
            }
            if (header.indexOf("clear") >= 0) {
              Serial.println("CLEAR");
              clr=true;  // Clear list.
            }
            if (header.indexOf("cancel") >= 0) {
              Serial.println("Cancel");
              cancel=true;  // Resetting previous record counter.
            }
            if (header.indexOf("RESET") >= 0) {
              Serial.println("Reset load and power on counter");
              resetCounter=true;
            }
            counter=header.indexOf("ct=");
            if (counter >= 0) {
              unsigned long ttmp;
              Serial.print("DateTime: ");
              timeSetting=true;
              clientTime=header.substring(counter+3,counter+11);
              ttmp=clientTime.toInt();  //  Convert a string to a numeric value.
              // The format is month, day, hour, minute. It is 7 or 8 characters numerically (the month can be 1 or 2 characters), but since it is not a string but a number,
              // it can be determined that the month consists of 1 or 2 digits by checking to see if it is less than 10,000,000.              
              if (ttmp<10000000) clientTime=String("0")+clientTime;   // If the month is only 1 character, it must be preceded by a 0.
              Serial.println(ttmp);
              Serial.println(clientTime);
            }
            
            // Display the HTML web page
            client.println("<!DOCTYPE html><html>");
            client.println("<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
            client.println("<link rel=\"icon\" href=\"data:,\">");
            // CSS to style the on/off buttons 
            // Feel free to change the background-color and font-size attributes to fit your preferences
            client.println("<style>html { font-family: Helvetica; display: inline-block; margin: 0px auto; text-align: center;}");
            client.println(".button { background-color: #329696; border: none; color: white; padding: 16px 30px;");
            client.println("text-decoration: none; font-size: 20px; margin: 2px; cursor: pointer;}");
            client.println(".button1 { background-color: #C80000; border: none; color: white; padding: 16px 30px;");
            client.println("text-decoration: none; font-size: 20px; margin: 2px; cursor: pointer;}");
            client.println(".button2 { background-color: #0A0AF0; border: none; color: white; padding: 10px 20px;");
            client.println("text-decoration: none; font-size: 14px; margin: 2px; cursor: pointer;}");
            client.println("</style></head>");
            
            // Web Page Heading
            client.println("<body><h1>Data logger</h1>");
            if (list==true){
              list=false;
              Serial.print("recordCounter: ");
              Serial.println(recordCounter);
// PRINT LIST
              lineNumber=1;
              htmlData="Data logger list. List type: ";
              htmlData.concat(listTypeString);
              tmpChar=13;
              htmlData.concat(tmpChar);
              tmpChar=10;
              htmlData.concat(tmpChar);
              if (recordCounter>1){
                client.println("<ol>");
                for (int i=1;i<recordCounter;i++){
                  //Serial.print(i);
                  //Serial.print(" ");
                  for (byte j=0;j<4;j++){
                    rtcTime[j]=myMem.read(i*6+j);
                  }
                  myMem.get(i*6+4,duration);
                  if (duration>49000){
                    powa=true;
                    stampDuration="  Power ON"; 
                  }else{
                    powa=false;
                    if (duration%60<=9){
                      stampDuration=String("  "+String(duration/60)+":0"+String(duration%60)); 
                    }else{
                      stampDuration=String("  "+String(duration/60)+":"+String(duration%60)); 
                    }
                    if (duration==0) tmpString=" OFF";
                  }
                  stamp=" ";
                  if (rtcTime[0]<=9){
                    stamp=stamp+String("0"+String(rtcTime[0]));
                  }else{
                    stamp=stamp+String(rtcTime[0]);
                  }
                  stamp=stamp+".";
                  if (rtcTime[1]<=9){
                    stamp=String(stamp+"0"+String(rtcTime[1]));
                  }else{
                    stamp=String(stamp+String(rtcTime[1]));
                  }
                  stamp=stamp+" ";
                  if (rtcTime[2]<=9){
                    stamp=String(stamp+"0"+String(rtcTime[2]));
                  }else{
                    stamp=String(stamp+String(rtcTime[2]));
                  }
                  stamp=stamp+":";
                  if (rtcTime[3]<=9){
                    stamp=String(stamp+"0"+String(rtcTime[3]));
                  }else{
                    stamp=String(stamp+String(rtcTime[3]));
                  }
                  tmpString="";
                  //0 - no list, 1 - list all, 2 - list work, 3 - list ON, 4 - list time limit
                  if (listType==1) tmpString=stamp+stampDuration;
                  if (listType==2 and powa==false) tmpString=stamp+stampDuration;
                  if (listType==3 and powa==true)  tmpString=stamp+stampDuration;
                  if (listType==4 and powa==false and timeLimit<duration) tmpString=stamp+stampDuration;
                  if (tmpString.length()>0){
                    client.println("<li>" + tmpString + "</li>");
                    if (lineNumber<10) htmlData.concat(" ");
                    if (lineNumber<100) htmlData.concat(" ");
                    htmlData.concat(lineNumber);
                    htmlData.concat(". ");
                    htmlData.concat(tmpString);
                    tmpChar=13;
                    htmlData.concat(tmpChar);
                    tmpChar=10;
                    htmlData.concat(tmpChar);
                    lineNumber++;
                  }
                }
                client.println("</ol>");
                lineNumber--;
                Serial.print("htmlDataSize: ");
                Serial.println(htmlData.length());
                //Serial.print(htmlData);
              } // end list
            }

            //tmpString=String(12341234);
            client.println("<p><a href=\"/clear\"><button class=\"button1\">Clear list</button></a><a href=\"/listt\"><button class=\"button\">List 60sec</button></a></p>");
            client.println("<p><a href=\"/lista\"><button class=\"button\">List all</button></a><a href=\"/listp\"><button class=\"button\">List on</button></a><a href=\"/listw\"><button class=\"button\">List</button></a></p>");
            client.println("<textarea name='text' id='tdata' hidden rows='"+String(lineNumber)+"'>"+htmlData+"</textarea>");
            client.println("<input type='button' class=\"button2\" value='Download actual list' onclick='saveCSV()'/>");
            client.println("</form>");
            client.println("<form action='/get'>");
            client.println("Date and Time: <input type='text' id='ct' name='ct'>");
            client.println("<input type='submit' class=\"button2\" value='Send Date and Time'>");
            client.println("</form>");
            tmpString = String(loadCounter);
            client.println("<p>Load Counter: " + tmpString + "</p>");
            tmpString = String(powerOnCounter);
            client.println("<p>Power ON Counter: " + tmpString + "</p>");
            client.println("<p>Current Time: <span id='time-month'></span>.<span id='time-day'> </span> <span id='time-hour'> </span>:<span id='time-minute'> </span>:<span id='time-seconds'> </span> </p>");
            client.println("<script>");
            client.println("setInterval(getClock, 1000);");
            client.println("function getClock() {");
            client.println("const dt = new Date()");
            client.println("var dt1 = dt.getMonth()+1");
            client.println("var dt2 = dt.getDate()");
            client.println("var dt3 = dt.getHours()");
            client.println("var dt4 = dt.getMinutes()");
            client.println("var dt5 = dt.getSeconds()");
            client.println("document.getElementById('time-month').innerHTML=dt1");
            client.println("document.getElementById('time-day').innerHTML=dt2");
            client.println("document.getElementById('time-hour').innerHTML=dt3");
            client.println("document.getElementById('time-minute').innerHTML=dt4");
            client.println("document.getElementById('time-seconds').innerHTML=dt5");
            client.println("document.getElementById('ct').value=dt1*1000000+dt2*10000+dt3*100+dt4");
            client.println("}");
            client.println("function saveCSV () {");
            client.println("csv=document.getElementById('tdata').value;");
            client.println("var myBlob = new Blob([csv], {type: 'text/csv'});");
            client.println("var url = window.URL.createObjectURL(myBlob);");
            client.println("var anchor = document.createElement('a');");
            client.println("anchor.href = url;");
            readingDateTime();
            tmpString="Log";
            if (rtcTime[0]<10) tmpString.concat("0");
            tmpString.concat(rtcTime[0]);
            if (rtcTime[1]<10) tmpString.concat("0");
            tmpString.concat(rtcTime[1]);
            if (rtcTime[2]<10) tmpString.concat("0");
            tmpString.concat(rtcTime[2]);
            if (rtcTime[3]<10) tmpString.concat("0");
            tmpString.concat(rtcTime[3]);
            tmpString.concat(".txt");
            Serial.print("FileName: ");
            Serial.println(tmpString);
            client.println("anchor.download = '"+tmpString+"';");
            client.println("anchor.click();");
            client.println("window.URL.revokeObjectURL(url);");
            client.println("anchor.remove();");
            client.println("}");
            client.println("</script>");
            client.println("</body></html>");
            // The HTTP response ends with another blank line
            client.println();
            // Break out of the while loop
            break;
          } else { // if you got a newline, then clear currentLine
            currentLine = "";
          }
        } else if (c != '\r') {  // if you got anything else but a carriage return character,
          currentLine += c;      // add it to the end of the currentLine
        }
      }
    }
    // Clear the header variable
    header = "";
    // Close the connection
    client.stop();
    Serial.println("Client disconnected.");
    Serial.println("");
  }  // end if (client)
} // end loop

void chkInput(){
  readingButton=digitalRead(input33);
  digitalWrite(LED_BUILTIN,!digitalRead(input33));    // Button signal
  if (readingButton==LOW) {
    if ((millis() - lastDebounceTime) > debounceDelay) {
      buttonState=false;
    }
  }
  if (readingButton==HIGH) {
    lastDebounceTime=millis();
    buttonState=true;
  }
  if (buttonState!=prevButtonState){
    prevButtonState=buttonState;
    if(buttonState==true){
      Serial.println("OFF");
      duration=(millis()-startMillis)/1000;
      myMem.put((recordCounter-1)*6+4, duration);
      Serial.print("duration: ");
      Serial.println(duration);
    }else{
      Serial.println("ON");
      startMillis=millis();
      saveRecord();
    }
  }
}

void saveRecord(){
  readingDateTime();
  if (!rtc.read(&dt)) {
      Serial.println(F("RTC read failed"));
  } else {
      // Print formatted date/time: "Sat Feb 29 12:34:56 2020"
      Serial.println(asctime(&dt));
  }
  myMem.write(recordCounter*6, rtcTime[0]);
  myMem.write(recordCounter*6+1, rtcTime[1]);
  myMem.write(recordCounter*6+2, rtcTime[2]);
  myMem.write(recordCounter*6+3, rtcTime[3]);
  myMem.put(recordCounter*6+4, blank);
  recordCounter++;
  myMem.put(0, recordCounter);
}

void readingDateTime(){
  rtc.read(&dt);
  rtcTime[0]=dt.tm_mon+1;
  rtcTime[1]=dt.tm_mday;
  rtcTime[2]=dt.tm_hour;
  rtcTime[3]=dt.tm_min;
}

void settingDateTime(){
  Serial.print(clientTime);
  Serial.println(" SAVE");
  uint8_t tmp;
  String stmp="00";
  stmp=clientTime.substring(0,2);  // month
  tmp=stmp.toInt();
  dt.tm_mon = tmp-1; // Month: 0..11
  stmp=clientTime.substring(2,4);  // day
  tmp=stmp.toInt();
  dt.tm_mday = tmp;
  stmp=clientTime.substring(4,6);  // hour
  tmp=stmp.toInt();
  dt.tm_hour = tmp;
  stmp=clientTime.substring(6,8);  // min
  tmp=stmp.toInt();
  dt.tm_min = tmp;
  dt.tm_sec = 0;
  dt.tm_year = 122;   //2022-1900; // Year since 1900

  // Calculate day of the week: 0=Sunday .. 6=Saturday
  time_t t = mktime(&dt);
  dt.tm_wday = localtime(&t)->tm_wday;
  // Write date/time
  while (!rtc.write(&dt)) {
      Serial.println(F("RTC write failed"));
  }
}

// END
