#include <p16F883.inc>
	__CONFIG    _CONFIG1, _LVP_OFF & _FCMEN_OFF & _IESO_OFF & _BOR_OFF & _CPD_OFF & _CP_ON & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT
	__CONFIG    _CONFIG2, _WRT_OFF & _BOR21V

;**********************************************************************************************
; Portok deklarlsa							
;**********************************************************************************************
	#define				LCD_B7		PORTB,5
	#define				LCD_B6		PORTB,4
	#define				LCD_B5		PORTB,3
	#define				LCD_B4		PORTB,2
	#define				LCD_E		PORTC,5
	#define				LCD_RS		PORTC,4
	
	#define				T_LCD_B7	TRISB,5
	#define				T_LCD_B6	TRISB,4
	#define				T_LCD_B5	TRISB,3
	#define				T_LCD_B4	TRISB,2
	#define				T_LCD_E		TRISC,5
	#define				T_LCD_RS	TRISC,4
;**********************************************************************************************
	#define				ARAM1		PORTA,0		;AN0
	#define				ARAM2		PORTA,1		;AN1
	#define				V_ref		PORTA,2		;AN2
	#define				CC_Poti		PORTA,5		;AN4
	#define				T_ARAM1		TRISA,0		;AN0
	#define				T_ARAM2		TRISA,1		;AN1
	#define				T_V_ref		TRISA,2		;AN2
	#define				T_CC_Poti	TRISA,5		;AN4

;	PIN1 = GND
;	PIN2 = ARAM1	+
;	PIN3 = ARAM1	-
;	PIN4 = ARAM2	+
;	PIN5 = ARAM2	-
;	PIN6 = Vbat
;	PIN7 = Vref
;	PIN8 = PWM
;	PIN9 = Poti


;EEPROM
;	00 = PWM		default .140	0x8C
;	01 = Poti		default .212	0xD4
;	02 = CC_Offset		default .53	0x35
;   	03 = Aram1_Offset	default .53	0x35
;  	04 = Aram2_Offset	default .53	0x35
;   	05 = CMD_Offset		default .18	0x1E
;   	06 = Char_Offset	default .5	0x14

;**********************************************************************************************
;  LCD sorok cmei								;
;**********************************************************************************************
LCD_LINE0			EQU		0x00				; Els sor
LCD_LINE1			EQU		0x40				; Msodik sor
;**********************************************************************************************

	cblock	0x20
	Poti
	Poti_EE
	Opa
	PWM_EE
	LCD_TEMP
	TEMP
	HUNDREDS
	TENS
	ONES
	TIZ
	CC_Offset
	Aram1_Offset
	Aram2_Offset
	CMD_Offset
	Char_Offset
	Delay1
	Delay2
	Aram1
	Aram2
	Fesz
	STAT
	Multiplicand			; Szorzand
	Multiplier:2			; Szorz
	Product:2			; Eredmny
	Divisor				; Oszt
	Dividend:2			; Osztand
	Quotient:2			; Hnyados
	Remainder:2
	Counter
	endc

	cblock	0x70
	W_Save
	STATUS_Save
	endc

	org 0
	goto	Start

	org 4									; Megszakts memriacme
	goto	ISR								; Ha megszakts rkezik, a program ide ugrik
;;**********************************************************************************************
;/////////////////////////////////////////////////////////////////////////////////////////////
;----------------------------------------------------------------------------------------------
;\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
;**********************************************************************************************


;**********************************************************************************************
;  Megszakts vektor szubrutin rsz
;**********************************************************************************************
ISR:   							; Megszakts
     		movwf     	W_Save              	; Elmentjk a W regisztert
     		movf		STATUS, W		; Elmentjk a 
     		movwf    	STATUS_Save		; sttusz regisztert
		clrf		STATUS			; Visszalpnk a Bank0-ra s trljk a status biteket
     		btfsc     	PIR1,TMR1IF		; A Timer1 okozta a megszaktst?
     		goto      	ServiceTimer1
  		btfsc     	INTCON,T0IF		; A Timer1 okozta a megszaktst?
     		goto      	ServiceTimer0		; Elugrunk a Timer1 megszaktsra
     		goto      	ExitISR          	; Kilpnk a megszaktsbl
;***************************** 		Timer 1 megszakts 				******************************
ServiceTimer1:						;
			clrf		TMR1L
			clrf		TMR1H		; fels bitjeit
			bsf		STAT,1
	   		bcf       	PIR1,TMR1IF    	; Trljk a Timer1 megszakts flagat
			goto      	ExitISR	
;-----------------------------------------------------------------------------------------------------
;***************************** 		Timer 0 megszakts 				******************************
ServiceTimer0:
     		bcf       	INTCON,T0IF   		; Trljk a Timer0 megszakts flagat
		bsf		PORTC,3
 		bcf		PORTC,3
    		goto      	ExitISR	
;-----------------------------------------------------------------------------------------------------
;***************************** 			Kilpnk a megszaktsbl 			**************************
ExitISR:	            
     		movf      	STATUS_Save, W       	; Visszalltjuk az elmentet
     		movwf     	STATUS		 	; rtkeket
     		swapf     	W_Save,f            	; swap hatsra
     		swapf     	W_Save,w		; nem vltoznak a Status bitjei
     		retfie					;
;**********************************************************************************************
;  Megszakts vektor szubrutin rsz vge
;**********************************************************************************************


Start:
;-------------------------------- Bank 1 -----------------------------------------------
	bsf			STATUS, RP0				; Set bank 1
	bsf			OSCCON,IRCF2
	bsf			OSCCON,IRCF1
	bsf			OSCCON,IRCF0
	movlw			0XFF					; 10 bit resolution
	movwf			PR2						; bank 1
  	movlw     		0x00            			; Left Justified, Vdd-Vss referenced
    	movwf     		ADCON1
	bcf			TRISC,2					; PWM
	bsf			T_ARAM1
	bsf			T_ARAM2
	bsf			T_V_ref
	bsf			T_CC_Poti
	movlw			B'00000001'				; Timer1 engedlyezs
	movwf			PIE1
	movlw			B'00000111'
	movwf			OPTION_REG
;-------------------------------- Bank 3 -----------------------------------------------
	bsf			STATUS, RP1
	clrf			ANSEL
	bsf			ANSEL,0
	bsf			ANSEL,1
	bsf			ANSEL,2
	bsf			ANSEL,4
	clrf			ANSELH
;-------------------------------------------------------------------------------------------
	bcf			STATUS, RP0
	bcf			STATUS, RP1				; Set Bank 0
	movlw			B'01000000'	
	movwf			INTCON	 
	movlw			B'00110000'		; T1CON regiszter
 	movwf			T1CON
	movlw			B'00111100'
	movwf			CCP1CON			; bank 0
	movlw			B'00000100'		; Timer2 enabled with prescale 1
	movwf			T2CON			; bank 0
	movlw			.10
	movwf			TIZ
	clrf			Counter
	
	movlw		0X00
	call		Read_eeprom
	movwf		PWM_EE
	movwf		CCPR1L
	movlw		0X01
	call		Read_eeprom
	movwf		Poti_EE
	movlw		0X02
	call		Read_eeprom
	movwf		CC_Offset
	movlw		0X03
	call		Read_eeprom
	movwf		Aram1_Offset
	movlw		0X04
	call		Read_eeprom
	movwf		Aram2_Offset
	movlw		0X05
	call		Read_eeprom
	movwf		CMD_Offset
	movlw		0X06
	call		Read_eeprom
	movwf		Char_Offset


	call		LCDINIT			; Initialize LCDisplay	
	call		LCD_OUT
	clrf		TMR1L
	clrf		TMR1H
	bsf		INTCON,GIE
	bsf		T1CON,0
	clrf		STAT
;	clrf		TMR0		
;-------------------------------------------------------------------------------------------	

Loop:
	movlw     	B'10001001'			;AN2
	call		AD_CONV
	movwf		Fesz
Manual_CHK
	btfsc		STAT,1
	call		LCD_refresh	
	movlw     	B'10010001'			;AN4
	call		AD_CONV
	movwf		Poti
	movlw     	B'10000001'			;AN0
	call		AD_CONV
	movwf		Aram1
	movlw     	B'10000101'			;AN1
	call		AD_CONV
	movwf		Aram2
	subwf		Aram1,W				;Aram2 a W-ben, Ha a W nagyobb, akkor a C=0
	btfss		STATUS,C			;Ha az Aram2 nagyobb, mint az Aram1, akkor C=0
	movf		Aram2,W
	btfsc		STATUS,C			;Ha az Aram1 nagyobb, mint az Aram2, akkor C=1
	movf		Aram1,W
	movwf		Opa				;Az Opa vltozba azt az rtket rjuk, amelyik a nagyobb.
	movf		Poti,W
	subwf		Poti_EE,W
	btfss		STATUS,C
	call		Szabalyoz
	movf		Poti,w				;	   C=0 ha poti > Aram
	subwf		Opa,w				; f-W      C=0 ha W>f
	btfsc		STATUS,C
	goto		Novel_Manual
	movf		CCPR1L, W
	sublw		.0				; L=0 W=0 C=1 ha W<=L
	btfss		STATUS,C
	decf		CCPR1L, f
	goto		Loop

Novel_Manual
	movf		CCPR1L, W
	subwf		PWM_EE,W
	btfsc		STATUS,C
	incf		CCPR1L, f
	goto 		Manual_CHK


;SUBRUTINOK
;****************************************************************************************************************
LCD_refresh
	movlw		LCD_LINE0+2				
	call		LCDSDDA			
	movf		Fesz,w
	call		Hex2Dec
	movf		HUNDREDS, W
	call		LCDPUTCHAR
	movf		TENS, W
	call		LCDPUTCHAR
	movlw		'.'
	call		LCDPUTCHAR
	movf		ONES, W
	call		LCDPUTCHAR
	movlw		'V'
	call		LCDPUTCHAR
	movlw		' '
	call		LCDPUTCHAR
	movlw		'C'
	call		LCDPUTCHAR
	movlw		'C'
	call		LCDPUTCHAR
	movlw		'='
	call		LCDPUTCHAR
	bcf		STATUS,C


	bcf		STAT,5
	movf   		CC_Offset,W			; 
	movwf   	Divisor				; 
 	movlw   	.100				; 
	movwf   	Multiplicand			;
	movf		Poti,W
	call		Multiply			;
	call    	Devide				;
	movf		Quotient, W	
	btfsc		Quotient+1,0
	bsf			STAT,5
	call		Hex2Dec
	movf		HUNDREDS, W
	call		LCDPUTCHAR
	movlw		'.'
	call		LCDPUTCHAR
	movf		TENS, W
	call		LCDPUTCHAR
	movf		ONES, W
	call		LCDPUTCHAR


	movlw		LCD_LINE1+2		; Msodik sorra			
	call		LCDSDDA			; mozgatjuk a kurzort
	bcf		STAT,5
	movf   		Aram1_Offset,W		; 
	movwf   	Divisor			; 
 	movlw   	.100			; 
	movwf   	Multiplicand		;
	movf		Aram1,W
	call		Multiply		;
	call    	Devide			;
	movf		Quotient, W	
	btfsc		Quotient+1,0
	bsf		STAT,5
	call		Hex2Dec
	movf		HUNDREDS, W
	call		LCDPUTCHAR
	movlw		'.'
	call		LCDPUTCHAR
	movf		TENS, W
	call		LCDPUTCHAR
	movf		ONES, W
	call		LCDPUTCHAR
	movlw		'A'
	call		LCDPUTCHAR
	movlw		' '
	call		LCDPUTCHAR
	movlw		' '
	call		LCDPUTCHAR
	movlw		' '
	call		LCDPUTCHAR
	movlw		'-'
	call		LCDPUTCHAR

	bcf		STAT,5
	movf   		Aram2_Offset,W		; 
	movwf   	Divisor			; 
 	movlw   	.100			; 
	movwf   	Multiplicand		;
	movf		Aram2,W
	call		Multiply		;
	call    	Devide			;
	movf		Quotient, W	
	btfsc		Quotient+1,0
	bsf		STAT,5
	call		Hex2Dec
	movf		HUNDREDS, W
	call		LCDPUTCHAR
	movlw		'.'
	call		LCDPUTCHAR
	movf		TENS, W
	call		LCDPUTCHAR
	movf		ONES, W
	call		LCDPUTCHAR
	bcf		STAT,1
	return

;****************************************************************************************
LCD_OUT
	movlw		LCD_LINE0		; Els sorra			
	call		LCDSDDA			; mozgatjuk a kurzort
	movlw		"V"
	call		LCDPUTCHAR
	movlw		"="
	call		LCDPUTCHAR
	movlw		"0"
	call		LCDPUTCHAR
	movlw		"0"
	call		LCDPUTCHAR
	movlw		"."
	call		LCDPUTCHAR
	movlw		"0"
	call		LCDPUTCHAR
	movlw		"V"
	call		LCDPUTCHAR
	movlw		" "
	call		LCDPUTCHAR
	movlw		"C"
	call		LCDPUTCHAR
	movlw		"C"
	call		LCDPUTCHAR
	movlw		"="
	call		LCDPUTCHAR
	movlw		"0"
	call		LCDPUTCHAR
	movlw		"."
	call		LCDPUTCHAR
	movlw		"0"
	call		LCDPUTCHAR
	movlw		"0"
	call		LCDPUTCHAR
	movlw		"A"
	call		LCDPUTCHAR
;-------------------------------------------------------------------------------------------
	movlw		LCD_LINE1		; Msodik sorra			
	call		LCDSDDA			; mozgatjuk a kurzort
	movlw		" "
	call		LCDPUTCHAR
	movlw		"+"
	call		LCDPUTCHAR
	movlw		"0"
	call		LCDPUTCHAR
	movlw		"."
	call		LCDPUTCHAR
	movlw		"0"
	call		LCDPUTCHAR
	movlw		"0"
	call		LCDPUTCHAR
	movlw		"A"
	call		LCDPUTCHAR
	movlw		" "
	call		LCDPUTCHAR
	movlw		" "
	call		LCDPUTCHAR
	movlw		" "
	call		LCDPUTCHAR
	movlw		"-"
	call		LCDPUTCHAR
	movlw		"0"
	call		LCDPUTCHAR
	movlw		"."
	call		LCDPUTCHAR
	movlw		"0"
	call		LCDPUTCHAR
	movlw		"0"
	call		LCDPUTCHAR
	movlw		"A"
	call		LCDPUTCHAR
	return

;-------------------------------------------------------------------------------------------
LCD_Check
	btfsc		STAT,1
	call		LCD_refresh	
	return
;-------------------------------------------------------------------------------------------
Szabalyoz:
			movf		Poti_EE,W
			movwf		Poti
			return
;------------------------------------------------- AD Konvertalas ---------------------------------------
AD_CONV
    			movwf     	ADCON0         	
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			nop
			bsf 		ADCON0,GO 		;Start conversion
			btfsc 		ADCON0,GO 		;Is conversion done?
			goto 		$-1
			movf		ADRESH,w
			return
;------------------------------------------------- EEPROM READ ---------------------------------------
Read_eeprom
		bsf	STATUS, RP1	
		movwf	EEADR
		bsf	STATUS, RP0
		bcf	EECON1, EEPGD
		bsf	EECON1, RD
		bcf	STATUS, RP0
		movf	EEDAT,W
		bcf	STATUS, RP1
		return

;=============================================================================
; LCDINIT
;=============================================================================
;Parancs	|	  Binris	    |
;-------------------------------------------
;Kijelz trls	    	| 0 0 0 0 | 0 0 0 1 |
;Kijelz kurzor alaph.	| 0 0 0 0 | 0 0 1 X |
;Karakterbeviteli md 	| 0 0 0 0 | 0 1 N S |
;Kijelz Be/Ki s Kurzor| 0 0 0 0 | 1 D U B |
;Kijelz/kurzor eltols | 0 0 0 1 | C R X X |
;Funkcik      		| 0 0 1 8 | 2 K X X |
;CGRAM cm belltsa   | 0 1 A A | A A A A |
;Kijelz cmnek bell. | 1 A A A | A A A A |

;	X : Mindegy
;	N : Nvel
;	S : Eltol
;	D : Kurzor bekapcsolsa
;   	U : Alhzs
;   	B : Villogtats
;   	C : Kijelz eltols
;   	R : Jobbra tol
;   	8 : 8 bites zemmd
;   	2 : 2 soros zemmd
;	K : 5X10 pixel (5X7 pixel = 0)
;   	A : Adat
;=============================================================================
; LCDINIT
;=============================================================================
LCDINIT
			bsf		STATUS, RP0				; tvlts a 
			bcf		STATUS, RP1				; Bank1-re
			bcf		T_LCD_B7				; LCD 7-es bitje kimenet
			bcf		T_LCD_B6				; LCD 6-es bitje kimenet
			bcf		T_LCD_B5				; LCD 5-es bitje kimenet
			bcf		T_LCD_B4				; LCD 4-es bitje kimenet
			bcf		T_LCD_E					; LCD E    bitje kimenet
			bcf		T_LCD_RS				; LCD RS   bitje kimenet
			bcf		STATUS, RP0				; Visszavltunk a 
			bcf		STATUS, RP1				; Bank 0-ra
			call		Delay_40ms
			movlw		B'00101000'				; 4 bites 2 soros 5X7 pixeles funkci
			call		LCDPUTCMD				; Elkldjk a parancsot
			movlw		B'00101000'				; 4 bites 2 soros 5X7 pixeles funkci
			call		LCDPUTCMD				; Elkldjk a parancsot
			movlw		B'00001100'				; Kijelz be, kurzor be, alhzs ki, villogtats ki
			call		LCDPUTCMD				; Parancs elkldse
			call		LCDCLEAR				; Trljk a kijelzt
			return
;=============================================================================
LCDCLEAR									;
			movlw		0x01        				; Trljk az LCD-t 
			call		LCDPUTCMD				;
			return							;
;=============================================================================
LCDSDDA										;
			iorlw		0x80					; Funkci bellts
			call		LCDPUTCMD				;
			return							;
;=============================================================================
LCDPUTCHAR									;
			movwf		LCD_TEMP	 		    	; Elmentjk a kiiratni kvnt karaktert
			call		Delay_20us
			bsf		LCD_RS					; LCD-t data mode-ba
			bsf		LCD_E					; LCD E-line High
			bcf		LCD_B7
			bcf		LCD_B6
			bcf		LCD_B5
			bcf		LCD_B4
			btfsc		LCD_TEMP,7				; Majd egyenknt vgignzzk,
			bsf		LCD_B7					; hogy a kiirni kvnt
			btfsc		LCD_TEMP,6				; karakter bitjei
			bsf		LCD_B6					; milyen llapotban vannak
			btfsc		LCD_TEMP,5				; Elszr a fels 4 bitet
			bsf		LCD_B5					;
			btfsc		LCD_TEMP,4				;
			bsf		LCD_B4					;
			bcf		LCD_E					; LCD E-line Low
			bsf		LCD_E					; LCD E-line High
			swapf		LCD_TEMP, f				; Megcserljk a kiirand karakter bitjeit
			bcf		LCD_B7
			bcf		LCD_B6
			bcf		LCD_B5
			bcf		LCD_B4
			btfsc		LCD_TEMP,7				; Als 4 bitet
			bsf		LCD_B7					; ratjuk ki
			btfsc		LCD_TEMP,6				; hasonl mdsuerrel
			bsf		LCD_B6					; mint a fels 4 bit
			btfsc		LCD_TEMP,5				; esetn
			bsf		LCD_B5					;
			btfsc		LCD_TEMP,4				;
			bsf		LCD_B4					;
			bcf		LCD_E					; LCD E-line Low
			return							;
;=============================================================================
LCDPUTCMD									;
			movwf		LCD_TEMP				; Elmentjk a kiiratni kvnt karaktert
			call		Delay_1ms
			bcf		LCD_RS					; LCD-t command mode-ba
			bsf		LCD_E					; LCD E-line High
			bcf		LCD_B7
			bcf		LCD_B6
			bcf		LCD_B5
			bcf		LCD_B4
			btfsc		LCD_TEMP,7				; Majd egyenknt vgignzzk,
			bsf		LCD_B7					; hogy a kiirni kvnt
			btfsc		LCD_TEMP,6				; karakter bitjei
			bsf		LCD_B6					; milyen llapotban vannak
			btfsc		LCD_TEMP,5				; Elszr a fels 4 bitet
			bsf		LCD_B5					;
			btfsc		LCD_TEMP,4				;
			bsf		LCD_B4					;
			bcf		LCD_E					; LCD E-line Low
			bsf		LCD_E					; LCD E-line High
			swapf		LCD_TEMP, f				; Megcserljk a kiirand karakter bitjeit
			bcf		LCD_B7
			bcf		LCD_B6
			bcf		LCD_B5
			bcf		LCD_B4
			btfsc		LCD_TEMP,7				; Als 4 bitet
			bsf		LCD_B7					; ratjuk ki
			btfsc		LCD_TEMP,6				; hasonl mdsuerrel
			bsf		LCD_B6					; mint a fels 4 bit
			btfsc		LCD_TEMP,5				; esetn
			bsf		LCD_B5					;
			btfsc		LCD_TEMP,4				;
			bsf		LCD_B4					;
			bcf		LCD_E					; LCD E-line Low
			call		Delay_1ms
			return							;
;=============================================================================

Hex2Dec:
		movwf		TEMP
  		movlw  		d'0'                ;  initialize each of the variables to "0"
  		movwf  		HUNDREDS
  		movwf  		TENS
  		movwf  		ONES

hundredsloop:			         	    ;  return here each time to test for temp >= 100
  		movlw  		d'100'              ;  is temp >= 100?
  		subwf  		TEMP, W
  		btfss  		STATUS, C           ;  if status.c set, then "yes"
   		goto  		tensloop
  		movwf  		TEMP    	    ;  save the result
  		incf   		HUNDREDS, f         ;  increment the number of 100s
  		goto   		hundredsloop

tensloop:                       		    ;  return here each time to test for temp >= 10
  		movlw  		d'10'               ;  is temp >= 10?
  		subwf  		TEMP, w
  		btfss  		STATUS, C           ;  if status.c set, then "yes"
   		goto  		doones
  		movwf  		TEMP        	    ;  save the result
  		incf   		TENS, f             ;  increment the number of 10s
  		goto   		tensloop

doones:                         		    ;  remainder is the number of ones
  		movf  		TEMP, w
  		addwf  		ONES, f
		btfss	    	STAT,5
		goto		Hex2Dec_End

Hex2Dec_High
		movf		ONES,W
		addlw		.6
		movwf		ONES
		movwf		TEMP
		movf		TIZ,W					
		subwf		TEMP,W
		btfss		STATUS,C
		goto		$+3
		incf		TENS		
		movwf		ONES

		movf		TENS,W
		addlw		.5
		movwf		TEMP
		movwf		TENS
		movf		TIZ,W					
		subwf		TEMP,W
		btfss		STATUS,C
		goto		$+3
		incf		HUNDREDS		
		movwf		TENS	

		movf		HUNDREDS,W
		addlw		.2
		movwf		HUNDREDS

Hex2Dec_End		
		movlw		0x30
		addwf		HUNDREDS,f
		addwf		TENS,f
		addwf		ONES,f
		bcf			STAT,5
		return


Multiply 
 	bcf	STATUS, C
  	clrf   	Product                ;  Initialize Variables
  	clrf   	Product + 1
  	movwf  	Multiplier
  	clrf   	Multiplier + 1

Loop_M:
 	 rrf    Multiplicand, f        ;  Shift Down Multiplicand, Carry Loaded with LSB
 	 btfss  STATUS, C
 	 goto   AddSkip                ;  LSB was Zero, Skip Over Adding.  
 	 movf   Multiplier + 1, w      ;  Add MSByte First
 	 addwf  Product + 1, f
 	 movf   Multiplier, w          ;  Add LSByte Next
	 addwf  Product, f
 	 btfsc  STATUS, C              ;  Carry Set from LSByte Add?  
	 incf  	Product + 1, f         ;   Yes, Increment the MSByte
AddSkip:
  	bcf    	STATUS, C              ;  Shift Up the Multiplier
  	rlf    	Multiplier, f
  	rlf    	Multiplier + 1, f
  	movf   	Multiplicand, f        ;  Finished?  
 	btfss  	STATUS, Z              ;  Zero and it is
  	goto   	Loop_M
    return                     	   ;  Finished, Loop Forever

Devide:
   movf   Product+1,w            ;  Initialize Variables
   movwf  Dividend + 1
   movwf  Remainder + 1
   movf   Product,w
   movwf  Dividend   ; osztando
   movwf  Remainder  ; maradek
   clrf   Quotient + 1
   clrf   Quotient


DivideLoop:                     ;  Return Here for Each Repeated Addition
  movf   Remainder + 1, w       ;  Subtract Divisor from Remainder and see if >= 0
  movwf  TEMP
  movf   Divisor, w
  subwf  Remainder, w
  btfss  STATUS, C              ;  If Carry Set, Low Byte of Remainder >= Divisor
  decf   TEMP, f
  btfsc  TEMP, 7                ;  If MSB of (Remainder - Divisor) != 1 then Subtract
  goto   DivideEnd               ;   Else, if set then Finished

  movwf  Remainder              ;  Save Results of Subtraction
  movf   TEMP, w
  movwf  Remainder + 1

  incf   Quotient, f            ;  Increment the Quotient
  btfsc  STATUS, Z
  incf   Quotient + 1, f

  goto   DivideLoop

DivideEnd:
  return


Delay_40ms
	movlw		.119
	movwf       	Delay1
	movwf		Delay2
Delay_40ms_loop
	decfsz		Delay1,f
	goto		Delay_40ms_loop
	movlw		.119
	movwf    	Delay1
	decfsz		Delay2,f
	goto		Delay_40ms_loop
	return

Delay_1ms
	movf		CMD_Offset,W
	movwf       	Delay1
	movwf		Delay2
Delay_1ms_loop
	decfsz		Delay1,f
	goto		Delay_1ms_loop
	movlw		.10
	movwf       	Delay1
	decfsz		Delay2,f
	goto		Delay_1ms_loop
	return

Delay_20us
	movf		Char_Offset,W
	movwf       	Delay1
Delay_50us_loop
	decfsz		Delay1,f
	goto		Delay_50us_loop
	return

	end