#include <ESP8266WiFi.h>

// Cseréld ki saját hálózati hitelesítő adataiddal
const char* ssid     = "admin"; 
const char* password = "admin";

// Kivánt statikus IP cím beállítás
IPAddress staticIP(192, 168, 1, 125); // kivánt statikus IP cím
IPAddress gateway(192, 168, 1, 1); // átjáró IP címe
IPAddress subnet(255, 255, 255, 0); // alhálózati maszk

WiFiServer server(80);

String header;
String output1State = "leeresztett";
String output2State = "leeresztett";
String le;
String fel;
const int output1 = 4;  //1 le
const int output2 = 14; //1 fel
const int output3 = 12; //2 le
const int output4 = 13; //2 fel

unsigned long currentTime = millis();
unsigned long previousTime = 0;
const long timeoutTime = 2000;
unsigned long startido = 0;

int id = 22000; //működési idő (22000ms = 22s)változtasd meg a redőny futási idelyéhez

void setup() {
  Serial.begin(74880);
  pinMode(output1, OUTPUT);
  pinMode(output2, OUTPUT);
  pinMode(output3, OUTPUT);
  pinMode(output4, OUTPUT);
  digitalWrite(output1, LOW);
  digitalWrite(output2, LOW);
  digitalWrite(output3, LOW);
  digitalWrite(output4, LOW);

  // Csatlakozás Wi-Fi hálózathoz felhasználónévvel és jelszóval.
  Serial.print("Kapcsolódás. ");
  Serial.println(ssid);
  WiFi.begin(ssid, password);
  WiFi.config(staticIP, gateway, subnet);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  
  // Kiírja a helyi IP-címet és elindítja a webszervert.
  Serial.println("");
  Serial.println("Csatlakoztatva a WiFi-hez. ");
  server.begin();
  Serial.print("IP cím: ");
  Serial.println(WiFi.localIP());
}

void loop() {
  WiFiClient client = server.available();   
  if (client) {                             
    Serial.println("New Client.");          
    String currentLine = "";                
    currentTime = millis();
    previousTime = currentTime;
    while (client.connected() && currentTime - previousTime <= timeoutTime) { 
      currentTime = millis();
      if (client.available()) {             
        char c = client.read();            
        Serial.write(c);                   
        header += c;
        if (c == '\n') {                    
          if (currentLine.length() == 0) {
            client.println("HTTP/1.1 200 OK");
            client.println("Content-type:text/html");
            client.println("Connection: close");
            client.println();

            // Be és kikapcsolja a reléket
            if (header.indexOf("GET /1/fel") >= 0) {
              Serial.println("GPIO 1 fel");
              output1State = "felhuzott";
              digitalWrite(output1, LOW);
              delay (100);
              digitalWrite(output2, HIGH);
              startido = millis();
            }
            else if (header.indexOf("GET /1/le") >= 0) {
              Serial.println("GPIO 1 le");
              output1State = "leeresztett";
              digitalWrite(output2, LOW);
              delay (100);
              digitalWrite(output1, HIGH);
              startido = millis();
            }
            else if (header.indexOf("GET /2/fel") >= 0) {
              Serial.println("GPIO 2 fel");
              output2State = "felhuzott";
              digitalWrite(output3, LOW);
              delay (100);
              digitalWrite(output4, HIGH);             
              startido = millis();
            }
            else if (header.indexOf("GET /2/le") >= 0) {
              Serial.println("GPIO 2 le");
              output2State = "leeresztett";
              digitalWrite(output4, LOW);
              delay (100);
              digitalWrite(output3, HIGH);
              startido = millis();
            }
            else if (header.indexOf("GET /1/stop") >= 0) {
              Serial.println("GPIO 1 stop");
              output1State = "megállított";
              digitalWrite(output1, LOW);
              digitalWrite(output2, LOW);
            }
            else if (header.indexOf("GET /2/stop") >= 0) {
              Serial.println("GPIO 2 stop");
              output2State = "megállított";
              digitalWrite(output3, LOW);
              digitalWrite(output4, LOW);
            }

            // HTML weboldal megjelenítése
            client.println("<!DOCTYPE html><html>");
            client.println("<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
            client.println("<link rel=\"icon\" href=\"data:,\">");
            client.println("<meta charset=utf-8>");
            
            //Gombok formázása, módosíthatod a háttérszínt és a betűméretet.
            client.println("<style>html { font-family: Helvetica; display: inline-block; margin: 0px auto; text-align: center;}");
            client.println(".button { background-color: #008000; border: none; color: white; padding: 16px 40px;");
            client.println("text-decoration: none; font-size: 30px; margin: 2px; cursor: pointer;}");
            client.println(".button2 {background-color: #0000FF;}");
            client.println(".button3 {background-color: #FF0000;}</style></head>");

            // Weboldal címsora
            client.println("<body><h1>Redőny működtetés</h1>");

            // Aktuális állapot kijelzése és a BE/KI gombok a GPIO 1-hez
            client.println("<p>1.Szoba - " + output1State + "</p>");
            // Ha az output1State ki van kapcsolva, akkor a BE gomb látható.
            if (output1State == "leeresztett") {
              client.println("<p><a href=\"/1/fel\"><button class=\"button\">FEL</button></a></p>");
            } else {
              client.println("<p><a href=\"/1/le\"><button class=\"button button2\">LE</button></a></p>");
            }
            client.println("<p>Megállít!</p>");
            client.println("<p><a href=\"/1/stop\"><button class=\"button button3\">ÁLJ</button></a></p>");

            // Aktuális állapot kijelzése és a BE/KI gombok a GPIO 2-höz
            client.println("<p>2.Szoba -  " + output2State + "</p>");
            // Ha az output2State ki van kapcsolva, akkor a BE gomb látható.
            if (output2State == "leeresztett") {
              client.println("<p><a href=\"/2/fel\"><button class=\"button\">FEL</button></a></p>");
            } else {
              client.println("<p><a href=\"/2/le\"><button class=\"button button2\">LE</button></a></p>");
            }
            client.println("<p>Megállít!</p>");
            client.println("<p><a href=\"/2/stop\"><button class=\"button button3\">ÁLJ</button></a></p>");
            client.println("</body></html>"); 
            client.println();
            break;
          } else { 
            currentLine = "";
          }
        } else if (c != '\r') { 
          currentLine += c;      
        }
      }
    }
    header = "";
    client.stop();
    Serial.println("Client disconnected.");
    Serial.println("");
  }
  //Relék késleltetés utáni kikapcsolása
  if (millis() - startido >= id) {
    if ( fel || le && output1 == HIGH && output2 == HIGH ||  output3 == HIGH && output4 == HIGH) {
      digitalWrite(output1, LOW);
      digitalWrite(output2, LOW);
      digitalWrite(output3, LOW);
      digitalWrite(output4, LOW);
    }
  }
}

