#include <util/delay.h>

//-------------------------------
//Ezt a rszt mdostsd
#define DEBUG_SERIAL_DDR	DDRD
#define DEBUG_SERIAL_PORT	PORTD
#define DEBUG_SERIAL_P		PD4
//-------------------------------

#define DEBUG_SERIAL_LOW()	DEBUG_SERIAL_PORT&=~(1<<DEBUG_SERIAL_P)
#define DEBUG_SERIAL_HIGH()	DEBUG_SERIAL_PORT|=(1<<DEBUG_SERIAL_P)

#define WAIT_ONE_BIT	{_delay_us(52.08);_delay_us(52.08);}	//104.166us = 9600bps

//-------------------------------------
void DebugInit() {
//-------------------------------------
	DEBUG_SERIAL_DDR |= (1<<DEBUG_SERIAL_P);	//output
	DEBUG_SERIAL_HIGH();
}

//-------------------------------------
void DebugSendBit(unsigned char b) {
//-------------------------------------
	if(b)  	DEBUG_SERIAL_HIGH();
	  else  DEBUG_SERIAL_LOW();
	WAIT_ONE_BIT;//wait one bit
	DEBUG_SERIAL_HIGH();
}

//-------------------------------------
void DebugSendByte(unsigned char data) {
//-------------------------------------
	DebugSendBit(0);	//startbit
	DebugSendBit(data&1);
	DebugSendBit(data&2);
	DebugSendBit(data&4);
	DebugSendBit(data&8);
	DebugSendBit(data&16);
	DebugSendBit(data&32);
	DebugSendBit(data&64);
	DebugSendBit(data&128);
	DebugSendBit(1);	//stop bit
}

//-------------------------------------
void DebugSendStr(const char *data) {
//-------------------------------------
	while(*data) {
		DebugSendByte(*data++);
	}
}

//-------------------------------------
void DebugClear() {
//-------------------------------------
	DebugSendByte(27);
}

//-------------------------------------
void DebugNL() {
//-------------------------------------
	DebugSendByte(13);
	DebugSendByte(10);
}

//-------------------------------------
void DebugSendU8(unsigned char data) {
//-------------------------------------
	DebugSendByte('0'+data/100);data%=100;
	DebugSendByte('0'+data/10);	data%=10;
	DebugSendByte('0'+data);
}
