	list	P=PIC12F629
	include  "P12F629.INC"

	__CONFIG _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT

#define egyes b'00010000' ; kzps 1-es pont - GP4-es lb
#define kettes b'00000001' ; egyik kettes tl - GP0-s lb
#define kettesb b'00000100' ; msik kettes tl - GP2-es lb
#define kettesc b'00000010' ; kzps kettes vonal - GP1-es lb
#define harmas (egyes  | kettes)
#define harmasb (egyes | kettesb)
#define negyes (kettes | kettesb)
#define otos (kettes | kettes | egyes)
#define hatos (kettes | kettesb | kettesc)
#define hetes (kettes | kettesb | kettesc | egyes)
#define hangsz b'00100000' ; hangszr a GP5-re ktve
#define hangszb d'5'

ck	equ	20h			
delay1  equ 21h
delay2  equ 22h
delay3  equ 23h
szam_0  equ 24h
kikapcsolo equ 25h
on_count equ 26h
periodusido equ 27h
timer equ 28h


PROG CODE 0
	goto	start
start:
	bsf		STATUS, RP0	
	call	3ffh		
	movwf	OSCCAL		
	movlw	b'00001000'
	movwf	TRISIO
	movlw	b'00000000'
	movwf	OPTION_REG
	movlw	b'00001000'	
	movwf	IOC
	bcf		STATUS, RP0	;
	clrf	GPIO
	movlw	b'00000111'
	movwf	CMCON		
	movlw	b'00001000'	;
	movwf	INTCON		;

	;bcf     STATUS,RP0
	;movlw   b'11010000'

 	;option

 	btfsc STATUS,3 ; 0 a harmadik bit?
 	goto poweronreset ; ha bekapcsols vol6t , akkor a reset rutinhoz ugrik


 	btfsc kikapcsolo,0 ; 0 a kikapcsol als bit?
 	goto kikapcs ; ha bit 1-es, akkor kikapcsol

 	call delay100ms  ; ksleltets a nyomgomp pergsnek kikszblsre
 	bsf kikapcsolo,0 ; ha a kvetkez pr sorban jel rkezik a nyomgombtl, akkor kikapcsols

 	movfw  TMR0  ; timer olvassa a vletlenszm generlshoz
 	movwf  timer ;az elsnek olvasott valdi vletlenszm trolsa

	call  villogtat_1 ; LED-ek villogtatsa, csak a jtk kredvrt :) + ksleltets + hang
	clrf  kikapcsolo  ; innentl a gombnyoms nem vlt ki kikapcsolst
	call  villogtat_1 ; LED-ek villogtatsa, csak a jtk kredvrt :) + ksleltets + hang

	movfw  timer  ; elkszts a vletlenszm osztshoz
	call osztas ; osztsi maradk a szam_0 vltozban
	movwf szam_0 ; w-ban (0...11)
	call  szamok ; konvertls (egyes-hatos)
	movwf GPIO ; a trolt rtk kijelzse, vagyis a LED-ek llapotnak belltsa
  
	movlw d'6' ; vrakozs
	movwf ck ; enyiszer fut le a ciklus
	call delay20s ; ksleltets
	decfsz ck,1 ; ck cskkentlse 0-ig
	goto $-2 ; visszaugrs 2 sort, ha mg nem nulla

	goto kikapcs ; elg hossz id telt el, kikapcsols
;*********************************************
beep_1:

	; hang ellltsi rutin
 	movlw d'200' ; 200 ciklusos lesz
 	movwf delay1
bp1:
	movlw d'80' ; ettl fgg a peridusid
	addwf szam_0,w ; s persze a szmtl is, hogy tbbfle hangmagassg legyen
	movwf periodusido ; eltesszk a vltozba az aktulis rtket
  

	swapf  delay1,w ; kiszmolunk egy msik lehetsges frekvencit is
	andlw d'15' ; ez nem a szmtl, hanem kls ciklustl fgg
	iorlw d'80'
	;btfsc on:count,0
	btfsc timer,6 ; ez dnti el, hogy a kt kiszmolt frekvencia kzl melyik szljon ppen


	decfsz periodusido,1 ; peridusid vrakoz ciklusa
	goto $-1
	movlw hangsz ; a hanszr bitje a GPIO porton
	xorwf GPIO,1 ; hangszr bit invertlsa
	decfsz delay1,1 ; 0-ig fogunk szmolni
	goto bp1 ; vissza a ciklus elejre

	bcf GPIO,hangszb ; a vgn a hangszr kikapcsp (biztos, ami biztos alapon :))
	retlw 0 ; visszatrs a fggvnybl
;********************************************
villogtat_1:

	movlw d'11' ; ez egy ennyiszer lefut ciklus lesz
	movwf ck ; szm a cilusvltozba

jmp1:

	; vletlenszm generls (ez csak a villogs miatt kell)
	call sorsol ; szm: 0...11 a szam_0 vltozban
	movwf szam_0 ; a dobott rtk kijelzse
 	call szamok ; konvertls a LED-ek portra ktse szerinti fotmra
	movwf GPIO ; LED-ek bekapcsolsa

	;call delay100ms ; vrakozs - ez volt korbban
	call beep_1 ;most hangot is adunk ki
	decfsz ck,1 ;ismtls amg a ciklusvltoz nullra cskken
	goto jmp1 ; vissza a ciklus elejre

	retlw 0 ; visszatrs a fggvmnybl
;***************************

poweronreset:

	 ; ide ugrik, ha a program resettel kezdett (pl.: elemcsre)
	clrf on_count ;bekapcsolsszmll nullzs
	movlw hetes ; sszes LED bekapcsols (hetest dobtam! :))
	movwf GPIO ; bekapcsoljuk a LED-eket
kikapcs:

	call delay100ms ; ksleltests a gombpergs s hasonlk miatt
	call beep_1 ; hanszr csippants + mg ksleltets
	incf on_count,1 ;bekapcsols szmols (valjban kikapcsolst szmolunk, de mostmr mindegy)
	clrf kikapcsolo ; kikapcsol nullzsa, hiszen mindjrt kikapcsolunk
	clrf GPIO ; kimenetetk nullzsa, LED-ek s a hangszr kikapcsolsa
	sleep ; alv zemmd, kikapcsols a kvetkez reset-ig
;***********************************
sorsol:

	; vletlenszm generls
	movwf TMR0 ; a beptett TIMER rtkt olvassuk vletlenszmnak
  
osztas:

	movwf szam_0
	movlw d'12' ;12-vel fogunk osztani
	bcf STATUS,C ; C-biz nullzsa, megint csak biztos, ami biztos alapon :)
	subwf szam_0,w ; levonjuk az osztt
	BTFSC STATUS,C ; addig amg sz osztand el nem fogy
	goto osztas ; vissza a ciklus elejre, ha az osztand mg nem 0	
	; az osztsi maradk a szam_0 vltozba kerlt	
	retlw 0 ; kilps a fggvnybl

;***********************************
szamok:

	; itt valstjuk a meg a szm- LED-ek llapota konverzit
	incf W,1
	addwf PCL,f
	retlw egyes
	retlw kettes
	retlw harmas
	retlw negyes
	retlw otos
	retlw hatos
	retlw egyes
	retlw kettesb
	retlw harmasb
	retlw negyes
	retlw otos
	retlw hatos
;********************************
delay20s:

	 ; ez az egyik ksleltet ciklus, semmi mst nem csinl, csak futnak a ciklusok s kzbentelik az id
	clrf delay3
	goto d2

delay100ms:

	; 100ms ksleltets
	movlw 1
	movwf delay3
d2:
	movlw d'70'
	movwf delay2
d1:

	clrf delay1
	decfsz delay1,f
	goto $-1  

	decfsz delay2,f
	goto d1
	decfsz delay3,f
	goto d2

	retlw 0
;**********************************************

OSCVAL	CODE
OscCalVal
	retlw	0
	end

