// Returns 0 for one wire device presence, 1 for none
int8 ow_reset(void)
{
   int8 presence;

   output_low(DQ);
   delay_us(488);          // Min. 480uS
   output_float(DQ);
   delay_us(72);           // Takes 15 to 60uS for devices to respond//72
   presence = input(DQ);
   delay_us(424);          // Wait for end of timeslot//424


   return(presence); 
}

/******************************************************************************/
// Read bit on one wire bus
int8 read_bit(void)
{
   output_low(DQ);
   delay_us(1);         // 1uS min. Original code relied on 8051 being slow
   output_float(DQ);
   delay_us(20);        // Wait at least 15mS from start of time slot
   
   return(input(DQ));   // Delay to finish time slot (total 60 to 120uS)
} // must be done next.

/******************************************************************************/
void write_bit(int8 bitval)
{
   output_low(DQ);

   if(bitval == 1) {
      delay_us(1);      // 1uS min. Original code relied on 8051 being slow
      output_float(DQ);
   }
   delay_us(105);       // Wait for end of timeslot//105
   
   output_float(DQ); 
}

/******************************************************************************/
int8 read_byte(void)
{
   int8 i;
   int8 val = 0;

   for(i=0;i<8;i++)
   {
      if(read_bit()) val |= (0x01 << i);
      delay_us(120);  // To finish time slot//120
   }

   return val;
}

/******************************************************************************/
void write_byte(int8 val)
{
   int8 i;
   int8 temp;

   for (i=0;i<8;i++)
   {
      temp = val >> i;
      temp &= 0x01;
      write_bit(temp);
   }

   delay_us(105);//105
}

/******************************************************************************/
// One wire crc
int8 ow_crc(int8 x)
{
   dowcrc = dscrc_table[dowcrc^x];
   
   return dowcrc; 
}

/******************************************************************************/

int8 Next(void)
{
   int8 m = 1;             // ROM Bit index
   int8 n = 0;             // ROM Byte index
   int8 k = 1;             // Bit mask
   int8 x = 0;
   int8 discrepMarker = 0;
   int8 g;                 // Output bit
   int8 nxt;               // Return value
   short flag;

   nxt = FALSE;            // Reset next flag to false

   dowcrc = 0;             // Reset the dowcrc

   flag = ow_reset();

   if (flag||doneFlag)     // If no parts return false
   {
      lastDiscrep = 0;     // Reset the search
      return FALSE;
   }

   write_byte(0xF0);       // Send SearchROM command

   do
   {
      x = 0;
      if (read_bit() == 1)
      x = 2;
      delay_us(120);//120
      if (read_bit() == 1)
      x |= 1;   // And it's complement

      if (x == 3)                   // There are no devices on the one wire bus
      break;
      else
      {
         if (x > 0)                 // All devices coupled have 0 or 1
            g = x >> 1;             // Bit write value for search


         else
         {
            if (m < lastDiscrep)
               g = ((Rom_Bit[n] & k) > 0);
            // If equal to last pick 1
            else
               g = (m == lastDiscrep);  // If not then pick 0

               // If 0 was picked then record position with mask k
               if (g == 0) discrepMarker = m;
         }

         // Isolate bit in Rom_Bit[n] with mask k
         if (g == 1)
         Rom_Bit[n] |= k;
         else
         Rom_Bit[n] &= ~k;

         write_bit(g);  // ROM search write

         m++;           // Increment bit counter m
         k = k << 1;    // and shift the bit mask k
         // If the mask is 0 then go to new ROM
         if (k == 0)
         {  // Byte n and reset mask
            ow_crc(Rom_Bit[n]);      // Accumulate the crc
            n++;
            k++;
         }
      }
   } while (n < 8);  // Loop through until through all ROM bytes 0-7

   if (m < (65||dowcrc))   // If search was unsuccessful then
      lastDiscrep = 0;     // reset the last Discrepancy to zero

   else  // Search was successful, so set lastDiscrep, lastOne, nxt
   {
      lastDiscrep = discrepMarker;
      doneFlag = (lastDiscrep == 0);
      nxt = TRUE; // Indicates search not yet complete, more parts remain
   }

   return nxt;
}


/******************************************************************************/

int8 First(void)
{
   lastDiscrep = 0;
   doneFlag = FALSE;
   
   return Next(); // Call Next and return it's return value;
}

/******************************************************************************/
void FindDevices(void)
{
   int8 m;
   if(!ow_reset())
   {
      if(First())    // Begins when at least one part found
      {
         numROMs = 0;
      
         do
         {
            numROMs++;

            for (m=0;m<8;m++)
            {
               FoundROM[numROMs][m] = Rom_Bit[m];   // Identifies ROM no. on device
            }


         } while (Next() && (numROMs<10));   // Continues until no additional
                                             // devices found.
      }

   }

}


/******************************************************************************/

int8 Send_MatchRom(void)
{
   int8 i;
   if (ow_reset()) return FALSE;          // 0 if device present
   write_byte(0x55);                      // Match ROM

   for (i=0;i<8;i++)
   {
      write_byte(FoundRom[numROMs][i]);   // Send ROM code
   }

   return TRUE;
} 
/******************************************************************************/ 
