#include <16F886.h>
#device adc=8

#FUSES NOWDT                    //No Watch Dog Timer
#FUSES HS                       //High speed Osc (> 4mhz for PCM/PCH) (>10mhz for PCD)
#FUSES NOPUT                    //No Power Up Timer
#FUSES MCLR                   //Master Clear pin enable
#FUSES PROTECT                  //Code protected from reads
#FUSES NOCPD                    //No EE protection
#FUSES NOBROWNOUT               //No brownout reset
#FUSES noIESO                     //Internal External Switch Over mode enabled
#FUSES NOFCMEN                  //Fail-safe clock monitor disabled
#FUSES NOLVP                    //No low voltage prgming, B3(PIC16) or B5(PIC18) used for I/O
#FUSES NODEBUG                  //No Debug mode for ICD
#FUSES NOWRT                    //Program memory not write protected
#FUSES BORV21                   //Brownout reset at 2.1V

#use delay(clock=20000000)
//#use rs232(baud=9600,parity=N,xmit=PIN_C6,rcv=PIN_C7,bits=8)

#define DQ PIN_C7 // DS18B20

float temperature;

#include "DS18B20.h"                  
#include "DS18B20.c"

void main()
{
  int8 i;
  int8 scratch[10];
  output_float(DQ);
  FindDevices();
  ow_reset();

   lcd_init();
   delay_us(100);
   
	lcd_putc ("\f");


  while(1)
  {


    if (!ow_reset())     // If a device is present
      {
         write_byte(0xCC); // Skip Rom command
         write_byte(0x44); // Temperature convert command
         output_float(DQ);
         delay_ms(10);    // Max. conv. time is 750mS for 12 bit
         ow_reset();
    
         for (numRoms=1;numRoms<=8;numRoms++)
         {
            if (Send_MatchRom())
            {
               write_byte(0xBE); // Read scratch pad command
               dowcrc = 0;       // Reset the crc to start a new calculation
   
               for (i=0;i<=7;i++)
               {
                   scratch[i] = read_byte();
                   ow_crc(scratch[i]);     // Accumulate the crc
               }
   
               scratch[8] = read_byte();   // Received crc byte
               ow_reset();
            
               if (scratch[8] == dowcrc)
               {
                  temperature = (signed int16) make16(scratch[1],scratch[0]);
                  
                  if (temperature >= 0)
                     temperature = (temperature + 8)/16.0;
               
                  else
                     temperature = (temperature - 8)/16.0;
                     
                  
                  //************************************************
                  If (numRoms==1)
                  {
										lcd_gotoxy(1,1);
										printf(lcd_putc, "%.1fC ",temperature);
                  }//innentl rtelem szeren a tbbi szenzor...
                  
               }
               
            }
         }
      }

  
  }//end while

}


