#include <built_in.h>

sbit SDA at GPIO.B0;
sbit SCL at GPIO.B1;
sbit LED at GPIO.B2;
sbit SWITCH at GPIO.B5;
#define dTime 10

void i2cclk() {
  SCL = 1;  Delay_us(dTime);
  SCL = 0;  Delay_us(dTime);
}

 void i2cstart() {
  SCL = 0;  Delay_us(dTime);
  SDA = 1;  Delay_us(dTime);
  SCL = 1;  Delay_us(dTime);
  SDA = 0;  Delay_us(dTime);
  SCL = 0;  Delay_us(dTime);
}

void i2cstop() {
  SDA = 0;  Delay_us(dTime);
  SCL = 1;  Delay_us(dTime);
  SDA = 1;  Delay_us(dTime);
  SCL = 0;  Delay_us(dTime);
  SDA = 0;  Delay_us(dTime);
}

void i2csend(char a) {
  int i;
  for(i=0; i<8; i++) {
    if (a & 0x80) {
      SDA = 1;
    } else {
      SDA = 0;
    }
    Delay_us(dTime);
    i2cclk();
    a <<= 1;
  }
  SDA = 1;  // ACK::::
  Delay_us(dTime);
  i2cclk();
}


unsigned int ioByte = 1;
unsigned int N = 0x09B4;

void setFreq() {
  i2cstart();
  i2csend(0xC2);  // TSA5511 address - write
  i2csend(Hi(N));  // FreqH
  i2csend(Lo(N));  // FreqL   --> 0x9B4 x 50kHz =
  i2csend(0xEE);  // charge-pump current and test bits
  i2csend(ioByte); // I/O pins
  i2cstop();
}

void main() {
  CMCON = 7; //comparator off
  ANSEL = 0; // all pins digital

  TRISIO = 0b00100000; // set GP5 as input, other pins as output

  setFreq();
  while(1) {
    delay_ms(100);
    if (!SWITCH) {  // SWITCH push check
      ioByte ^= 1;
      LED ^= 1;
      setFreq();
      while(!SWITCH) { // SWITCH release check
        delay_ms(10);
      }
    }
  };
}