#include "include.h"

#define LED		LATBbits.LATB14

_CONFIG2(0xF8FE);
_CONFIG1(0x3F7F);

unsigned char packet[PACKET_LENGTH];

void IOInit()
{
	AD1PCFG = 0xFFFF;
	
	// RB14 for LED Output
	TRISBbits.TRISB14 = 0;
	LATBbits.LATB14 = 0;
}

int main()
{
	int i,j;
		
	IOInit();
	
	DummyDelay(1000, 10);
	
	RFM12BInit(FREQ_868_MHZ, TX_MODE);
	
	while (1)
	{
		for (i = 0; i < PACKET_LENGTH; i++)
		{
			packet[i] = 0x30 + i;
		}
		
		RFM12BSendPacket(packet, 16);
		
		DummyDelay(1000, 10);
		
		LED = !LED;
	}
	
	return 0;
}
