#ifndef RFM12B_H_GUARD
#define RFM12B_H_GUARD

	#define TX_MODE	1
	#define RX_MODE	2
	
	#define FREQ_434_MHZ	1
	#define FREQ_868_MHZ	2
	#define FREQ_915_MHZ	3	
	
	#define PACKET_LENGTH	16

	// !! These pins have to be changed according the actual configuration !!
	#define nIRQ			PORTBbits.RB5			// nIRQ Pin - This pin has to be changed according the actual configuration
		
	#define SS_LO			LATBbits.LATB10 = 0		// Drive Slave Select Low
	#define SS_HI			LATBbits.LATB10 = 1		// Drive Slave Select High

	
	/* Initialize all aspects of the radio module */
	void RFM12BInit(char frequency, char mode);
	
	/* SPI initialization */
	void SPIInit();
	
	/* RFM12B Module Initialization */
	void RFM12BModuleInit(int frequency, int mode);
	
	/* Set mode to transmit */
	void RFM12BTXMode();
	
	/* Set mode to recieve */
	void RFM12BRXMode();
	
	/* Reset RFM12B RX FIFO */
	void RFM12BFIFOReset();
	
	/* Send a command to the RFM12B module */
	unsigned int RFM12BWriteCommand(unsigned int command);
	
	/* Send a transmit command to the RFM12B module */
	void RFM12BSendMessage(unsigned char message);
	
	/* Transmit a whole packet */
	void RFM12BSendPacket(unsigned char packet[], unsigned int length);
	
	/* Receive one byte */
	unsigned int RFM12BReceiveByte();
	
#endif
