#include "include.h"

_CONFIG2(0xF8FE);
_CONFIG1(0x3F7F);

#define LED LATBbits.LATB10

void IOInit()
{
	AD1PCFG = 0xFFFF;
	
	// RB10 Led Output
	TRISBbits.TRISB10 = 0;
	LATBbits.LATB10 = 1;
}

int main()
{
	int i,j;
	
	IOInit();
	
	DummyDelay(1000, 10);
	
	RFM12BInit(FREQ_868_MHZ, RX_MODE);
	
	while (1)
	{
		int i;
		unsigned int data_in;
		
		for (i = 0; i < PACKET_LENGTH; i++)
		{
			data_in = RFM12BReceiveByte();
			
			if (data_in == 0x0030)
			{
				LED = !LED;
			}
		}
		
		RFM12BFIFOReset();
	}

	return 0;
}
