#include <p18f4520.h>
#include <myeeprom.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <delays.h>

int ctoi(char val)
{
	char str[10] = "\0";
	int y;
	sprintf(str,"%c",val);
	y = atoi(str);
	return(y);
}

void Number_write(int val, long addr, short helyiertek)
{
	char str[10] = "\0";
	long addr2;
	int I = 0;
	switch(helyiertek)
	{
		case 0:
		case 1:
		default:
			sprintf(str,"%d",val);
			break;
		case 2:
			sprintf(str,"%02d",val);
			break;
		case 3:
			sprintf(str,"%03d",val);
			break;
		case 4:
			sprintf(str,"%04d",val);
			break;
	}

	addr2 = addr + (long)strlen(str);

	for(addr; addr < addr2; addr++)
	{
		random_write(0x00, addr,str[I]);
		I++;
	}
}

void String_write(char* str, long addr)
{
	int I = 0;
	long addr2 = addr + (long)strlen(str) + (long)1;

	for(addr; addr < addr2; addr++)
	{
		random_write(0x00, addr,str[I]);
		I++;
	}
}

int Number_read(long addr1, long addr2)
{
	char str[10] = "\0";
	int I        =   0 ;

	for(addr1; addr1 < addr2+1; addr1++)
	{
		str[I] = random_read(0x00, addr1);
		I++;
	}
	return atoi(str);
}

void String_read(char* str, long addr1, long addr2)
{
	int I  =   0 ;
	for(I; I< strlen(str); I++)
		str[I] = '\0';
	I = 0;

	for(addr1; addr1 < addr2+1; addr1++)
	{
		str[I] = random_read(0x00, addr1);
		I++;
	}
}

void wait12( void )
{
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
	Nop();
}

void random_write(char dev_adr, long mem_adr, char dat)
{
	i2c_start();
	i2c_out_byte(0xa0 | (dev_adr << 1));
	i2c_nack();
	i2c_out_byte((mem_adr >> 8) & 0xff);
	i2c_nack();
	i2c_out_byte(mem_adr & 0xff);
	i2c_nack();
	i2c_out_byte(dat);
	i2c_nack();
	i2c_stop();
	wait12();
	Delay1KTCYx(20);
}

char random_read(char dev_adr, long mem_adr)
{
   char y;
   i2c_start();
   i2c_out_byte(0xa0 | (dev_adr << 1));
   i2c_nack();
   i2c_out_byte((mem_adr >> 8) & 0xff);
   i2c_nack();
   i2c_out_byte(mem_adr & 0xff);
   i2c_nack();
   i2c_start();
   i2c_out_byte(0xa1 | (dev_adr << 1));
   i2c_nack();
   y=i2c_in_byte();
   i2c_stop();
   return(y);
}

char i2c_in_byte(void)
{
	char i_byte, n;
	i2c_high_sda();
	for (n=0; n<8; n++)
	{
		i2c_high_scl();

		if (SDA_PIN) 
			i_byte = (i_byte << 1) | 0x01; 
      	else
			i_byte = i_byte << 1;
		i2c_low_scl();
	}
	return(i_byte);
}

void i2c_out_byte(char o_byte)
{
   char n;
   for(n=0; n<8; n++)
   {
      if(o_byte&0x80)
         i2c_high_sda();
      else
         i2c_low_sda();
      i2c_high_scl();
      i2c_low_scl();
      o_byte = o_byte << 1;
   }
   i2c_high_sda();
}

void i2c_nack(void)
{
   i2c_high_sda();
   i2c_high_scl();
   i2c_low_scl();
}

void i2c_ack(void)
{
   i2c_low_sda();
   i2c_high_scl();
   i2c_low_scl();
   i2c_high_sda();
}


void i2c_start(void)
{
   i2c_low_scl();
   i2c_high_sda();
   i2c_high_scl();
   i2c_low_sda();
   i2c_low_scl();
}

void i2c_stop(void)
{
   i2c_low_scl();
   i2c_low_sda();
   i2c_high_scl();
   i2c_high_sda();
}

void i2c_high_sda(void)
{
	SDA_DIR = 1;
	wait12();
}

void i2c_low_sda(void)
{
	SDA_PIN = 0;
	SDA_DIR = 0;
  	wait12();
}

void i2c_high_scl(void)
{
	SCL_DIR = 1;
	wait12();
}

void i2c_low_scl(void)
{
	SCL_PIN = 0;
	SCL_DIR = 0;
	wait12();
}

int num_to_char(int val)
{
   int ch;
   if (val < 10)
     ch=val+'0';
   else
   {
     val=val-10;
     ch=val + 'A';
   }
   return(ch);
}
