;********************************************************************
;* Title                        : Nixie-DCF                         *
;* Version                      : 0.1   05. Juni 2005               *
;* Author                       : Uwe Nagel, Parkstr. 46,           *
;*                                D-68766 Hockenheim                *
;* Assembler                    : MPASM (c) Microchip               *
;*                                                                  *
;********************************************************************
; 0.1    15.06.02 aus DCF.ASM entstanden
; 1.0    05.06.05 erste verffentlichte Version
; 1.1    18.09.09 adjust,date and 6 tube mode  by Sooty  
; 1.2	 21.03.10 improved pic16f628 compatibile version by Sooty
;********************************************************************

#define TITEL "-Nixie-Uhr V1.2-"

	title		TITEL
	__CONFIG _CP_OFF & _WDT_ON & _PWRTE_ON & _XT_OSC
	errorlevel	-302		; keine bank select message
	radix	dec

	include	<p16f628a.inc> 
	include "pic16cxy.inc"

;****** Variablen ***************************************************
 cblock	0x20 	; pic16f628 compatibile (0c original)
	save_w		; w und
	save_STATUS	; STATUS whrend interrupt
	flag		; diverse Bits
	temp
	precount	; Vorteiler durch 16
	zweihund
	puls_zeit	; misst Pulsdauer
	
;*** diese Zeit wird angezeigt
	dispSec, dispMin, dispStd, dispTag, dispMon, dispJahr, dispWtag, dispStat
;*** hier kommt die gerade empfangene Zeit rein
	dcfMin, dcfStd, dcfTag, dcfMon, dcfJahr, dcfWtag, dcfStat
;*** zum Vergleich, die letzte Minute
	dcf1Min, dcf1Std, dcf1Tag, dcf1Mon, dcf1Jahr, dcf1Wtag
	filter
;*** setup variables
	date_on, disp_on, btn1, btn2, btn3,sbtn1,sbtn2, stored
 endc


;****** bits in flag ************************************************
#define	neusync flag,0
#define	alt     flag,1
#define	sekunde	flag,2
#define	comm	flag,7
#define dcfsign	flag,4

;****** Konstanten **************************************************
;#define	TICKS	109	; NTSC-Quartz (ungenau)
;#define	TICKS	122	; 4 MHz (ungenau)
#define	TICKS	100	; 3,276800 MHz (genau)
;#define	TICKS	128	; 4,194304 MHz (genau)

;********************************************************************
;* Programmcode ...
;********************************************************************
	org	0
	goto	main

;********************************************************************
;* interrupt :
;********************************************************************
	org	4
interrupt
	movwf	save_w		; W und STATUS sichern
	swapf	STATUS,w
	bcf STATUS,6		; pic16f628 compatibile
	bcf STATUS,7		; STATUS 6,7 must be 0
	movwf	save_STATUS

	bcf	STATUS,RP0	; Whle register page 0

	jnb	INTCON,T0IF,end_t0_isr ; ist es timer interrupt ?

	call	scan

	decfsz	precount,f
	goto	end_t0_isr
	
	movlw	16
	movwf	precount
 bsf PORTA,2



;****** filtern des Signals um kurze Strungen zu unterdrcken ***************
; increment filter if port=1 and filter if less than 8
; decrement filter if port=0 and filter if greater than 0


	btfss	PORTA,0
	goto	port_is_0
port_is_1
	incf	filter,f
	btfsc	filter,3	; <8 ?
port_is_0
	decf	filter,f
	btfsc	filter,7
	clrf	filter

; set dcfsign if filter becomes 6
; clear dcfsign if filter becomes 1
; 0 1 2 3 4 5 6 7   6 5 4 3 2 1 0
; 0 0 0 0 0 0 1 1   1 1 1 1 1 0 0

	movf	filter,w
	xorlw	6
	btfsc	STATUS,Z
	bsf	dcfsign
	xorlw	6^1
	btfsc	STATUS,Z
	bcf	dcfsign

	jb	alt,NoPos
	jnb	dcfsign,NoPos

;** positive Flanke...
 bsf PORTA,1
	bsf	alt
	clrf	puls_zeit

	jnb	neusync,noNeg

	clrf	dispSec
	movf	dcfMin,w
	movwf	dispMin
	movf	dcfStd,w
	movwf	dispStd
	movf	dcfTag,w
	movwf	dispTag
	movf	dcfWtag,w
	movwf	dispWtag
	movf	dcfMon,w
	movwf	dispMon
	movf	dcfJahr,w
	movwf	dispJahr
	movf	dcfStat,w
	movwf	dispStat

	movlw	TICKS
	movwf	zweihund
	bcf	neusync
	bsf	sekunde
	goto	end_t0_isr
	
NoPos:	jnb	alt,noNeg
	jb	dcfsign,noNeg	; jnb f. neg Pulse

;** fallende Flanke
	bcf	alt
 bcf	PORTA,1
	movf	puls_zeit,w
	addlw	-TICKS*3/20
 ;btfss STATUS,C
 ;bcf PORTA,3
 ;btfsc STATUS,C
 ;bsf PORTA,3
	rrf	dcfJahr,f
	rrf	dcfMon,f
	rrf	dcfTag,f
	rrf	dcfStd,f
	rrf	dcfMin,f
	rrf	dcfStat,f

noNeg:	decfsz	zweihund,f
	goto	timeOut

;** Sekunde abgelaufen
	movlw	TICKS
	movwf	zweihund

	call	tick
	bsf	sekunde


timeOut:
	incf	puls_zeit,f	; 1,5 s keine steigende Flanke ?
	movf	puls_zeit,w
	addlw	256-(TICKS*3/2)
	btfss	STATUS,C
	goto	end_t0_isr
	clrf	puls_zeit
	call	sec59


end_t0_isr
 bcf PORTA,2
	bcf	INTCON,T0IF     ; lsche timer interrupt flag
	swapf	save_STATUS,w
	movwf	STATUS
	swapf	save_w,f
	swapf	save_w,w
	retfie


;****** multiplexen des Displays *********************************************
scan	btfsc 	PORTB,3
	call 	button1
	btfsc 	PORTA,3
	call	button2	
	btfsc 	PORTA,4
	call	button3	

	btfss 	PORTB,3
	clrf 	btn1
	movlf 	0xff,PORTB
	btfss	disp_on,0
	return
		
	movf	precount,w
	andlw	0x07
	addwf	PCL,f
	goto	scan0
	goto	scan1
	goto	scan2
	goto	scan3
	goto	scan4
	goto	scan5
	goto	scan6
	goto	scan7

scan0 btfss date_on,0	
	goto 	scann0
	btfss 	dispSec,5
	goto 	scann0 
	btfsc 	dispSec,4
	goto 	scan10   
scann0	movf	dispSec,w	
	andlw	0xf0
	iorlw	0x0f
	movwf	PORTB
	andlw	0xf0
	iorlw	0x03	
	movwf	PORTB
	return			
scan1	btfss date_on,0	
	goto 	scann1	
	btfss dispSec,5
	goto 	scann1
 	btfsc 	dispSec,4
	goto 	scan11  
scann1 swapf	dispSec,w
	andlw	0xf0
	iorlw	0x0f	
	movwf	PORTB
	andlw	0xf0
	iorlw	0x02
	movwf	PORTB	
	return
scan2	btfss date_on,0	
	goto 	scann2	
	btfss dispSec,5
	goto 	scann2 
	btfsc 	dispSec,4
	goto 	scan12 
scann2	movf	dispMin,w
	andlw	0xf0
	iorlw	0x0f
	movwf	PORTB
	andlw	0xf0
	iorlw	0x01
	movwf	PORTB	
	return
scan3 	btfss date_on,0	
	goto 	scann3	
	btfss dispSec,5
	goto 	scann3 
	btfsc 	dispSec,4
	goto 	scan13 
scann3	swapf	dispMin,w
	andlw	0xf0
	iorlw	0x0f
	movwf	PORTB
	andlw	0xf0
	iorlw	0x06
	movwf	PORTB	
	return
scan4		btfss date_on,0	
	goto 	scann4	
	btfss dispSec,5
	goto 	scann4 
	btfsc 	dispSec,4
	goto 	scan14 
scann4	movf	dispStd,w			
	andlw	0xf0
	iorlw	0x0f
	movwf	PORTB
	andlw	0xf0
	iorlw	0x05	
	movwf	PORTB
	return
scan5 	btfss date_on,0	
	goto 	scann5		
	btfss dispSec,5
	goto 	scann5 
	btfsc 	dispSec,4
	goto 	scan15
scann5	swapf	dispStd,w
	andlw	0xf0
	iorlw	0x0f
	movwf	PORTB
	andlw	0xf0
	iorlw	0x04	
	movwf	PORTB
	return	
scan6	movf	dispTag,w					
	andlw	0xf0
	iorlw	0x0f	
	movwf	PORTB
	andlw	0xf0
	iorlw	0x07	
	movwf	PORTB
	return
scan7	swapf	dispTag,w
	andlw	0xf0
	movwf	PORTB
	andlw	0xf0
	iorlw	0x00	
	movwf	PORTB
	return		


scan10   movf	dispTag,w	
	andlw	0xf0
	iorlw	0x0f
	movwf	PORTB
	andlw	0xf0
	iorlw	0x03	
	movwf	PORTB
	return			
scan11	swapf	dispTag,w
	andlw	0xf0
	iorlw	0x0f
	movwf	PORTB
	andlw	0xf0
	iorlw	0x02
	movwf	PORTB	
	return
scan12	movf	dispMon,w
	andlw	0xf0
	iorlw	0x0f
	movwf	PORTB
	andlw	0xf0
	iorlw	0x01
	movwf	PORTB	
	return
scan13	swapf	dispMon,w
	andlw	0xf0
	iorlw	0x0f
	movwf	PORTB
	andlw	0xf0
	iorlw	0x06
	movwf	PORTB	
	return
scan14	movf	dispJahr,w			
	andlw	0xf0
	iorlw	0x0f
	movwf	PORTB
	andlw	0xf0
	iorlw	0x05
	movwf	PORTB
	return
scan15	swapf	dispJahr,w
	andlw	0xf0
	iorlw	0x0f
	movwf	PORTB
	andlw	0xf0
	iorlw	0x04	
	movwf	PORTB
	return		
;****** Hauptprogramm ***********************************************
main    

	MOVLW 7				;pic16f628 compatibile settings
	MOVWF CMCON			;comparators off

	bsf	STATUS,RP0	; select Register-Page 1
                  
	movlf	0x00,OPTION_REG	; TMR0 internal clock/2 = 1600Hz @ 3,2768MHz Quarz
				;                         2048Hz @ 4,194304 MHz
	movlf	b'00011001',TRISA	; porta3,4=button2,3 ; porta0=dcf in
	movlf	0x08,TRISB	; portb0..2,4..7output ; portb3=button1

; buttons -> button1= display on/off  button2= show date on/off button3= adjust time (fast forward)  

	bcf	STATUS,RP0	; select Register-Page 0

	clrf	flag
	clrf	puls_zeit
	movlf	TICKS,zweihund

	clrf	dispSec
;	clrf	dispMin
;	clrf	dispStd
 movlw	0x12
 movwf	dispStd
 movlw	0x34
 movwf	dispMin

	clrf	btn1
	clrf	btn2
	clrf	btn3
	clrf	sbtn1
	clrf	sbtn2
	clrf	dispWtag
	clrf	dispJahr
	
	movlw 0x0f	;initial value display on, date off
	movwf	disp_on
	movlw 0xf0
	movwf	date_on
	movlw	1
	movwf	dispMon
	movwf	dispTag
	movlf	0xa0,INTCON	; Enable  TMR0-Int




;------

mainloop:
	clrwdt	
;	movlw	dispTag
;	movwf	FSR
;	call	tickTag
	goto	mainloop


;********************************************************************
;55555555 54444444 44433333 33333222 22222221 11111111
;87654321 09876543 21098765 43210987 65432109 87654321   Sekunde
;PJJJJJJJ JMMMMMWW WTTTTTTP SSSSSSPm mmmmmm1a ooaR0000   DCF-Bits
;
;JJJJJJJJ 000MMMMM 00tttttt 00ssssss 0mmmmmmm 1aooaR00 00000www
; Jahr     Monat    Tag      Stunde   Minute   STATUS   Wtag
;********************************************************************

; jetzt werden die empfangenen Bits erstmal umsortiert 
; 
sec59:	rlf	dcfMon,w
	rlf	dcfJahr,f	; =Jahr
	rlf	dcfTag,w
	rlf	dcfMon,w
	andlw	0x07
	movwf	dcfWtag		; =Wochentag Mo..So = 1..7
	rrf	dcfMon,f
	rrf	dcfMon,f
	movlw	0x1f
	andwf	dcfMon,f	; =Monat
	rrf	dcfTag,f
	movlw	0x3f
	andwf	dcfTag,f	; =Tag
	rrf	dcfStd,w
	rrf	dcfMin,f
	rrf	dcfStat,f
	rrf	dcfMin,f
	rrf	dcfStat,f	; =STATUS
	movlw	0x7f
	andwf	dcfMin,f	; =Minute
	rrf	dcfStd,f
	rrf	dcfStd,f
	movlw	0x3f
	andwf	dcfStd,f	; =Stunde

	movlw	dcf1Min
	movwf	FSR
	call	tickMin		; letzte Zeit weiterrechnen

	movf	dcfMin,w	; und mit gerade empfangener
	xorwf	dcf1Min,w	; Zeit vergleichen
	skpz
	goto	ungleich
	movf	dcfStd,w
	xorwf	dcf1Std,w
	skpz
	goto	ungleich
	movf	dcfTag,w
	xorwf	dcf1Tag,w
	skpz
	goto	ungleich
	movf	dcfMon,w
	xorwf	dcf1Mon,w
	skpz
	goto	ungleich
	movf	dcfJahr,w
	xorwf	dcf1Jahr,w
	skpz
	goto	ungleich

;*** zwei aufeinanderfolgende Zeiten haben zueinander gepasst
;*** die aktuelle Zeit bei nchster Sekunde ins Display kopieren

	bsf	neusync
	return

ungleich:
;*** zwei aufeinanderfolgende Zeiten haben nicht eine Minute unterschied
;*** merken wir die gerade empfangene Zeit fr die nchste Minute
	movf	dcfMin,w
	movwf	dcf1Min
	movf	dcfStd,w
	movwf	dcf1Std
	movf	dcfTag,w
	movwf	dcf1Tag
	movf	dcfMon,w
	movwf	dcf1Mon
	movf	dcfJahr,w
	movwf	dcf1Jahr
	return

;------ hier wird die Zeit weitergezhlt
tick:	movlw	dispSec
	movwf	FSR

	call	IncDec	; Sekunde
	movlw	0x60
	xorwf	INDF,w
	skpz
	return
	clrf	INDF	; Sekunde=0

	incf	FSR,f	; ->Minute
tickMin:
	call	IncDec	; Minute
	movlw	0x60
	xorwf	INDF,w
	skpz
	return
	clrf	INDF	; Minute=0

	incf	FSR,f	; -> Stunde
	call	IncDec	; Stunde
	movlw	0x24
	xorwf	INDF,w
	skpz
	return
	clrf	INDF	; Stunde=0

	incf	FSR,f	; ->Tag
tickTag:
	call	IncDec	; Tag

	incf	FSR,f	; ->Monat
	movlw	8
	subwf	INDF,w
	movf	INDF,w
	skpnc
	addlw	-7
	andlw	0x01	
	addlw	0x31	; Monatslnge+1=31 oder 32
	movwf	temp
	movf	INDF,w
	xorlw	2	; Februar ?
	skpz
	goto	nofeb
	movlw	0x30	; im Ferbruar nur 30
	movwf	temp
	incf	FSR,f	; ->Jahr
	movf	INDF,w	; Jahr
	decf	FSR,f	; ->Monat
	andlw	0x13	; erfasst Jahr 0,4,8, 20...
	skpnz		
	goto	nofeb	; Schaltjahr
	xorlw	0x12	; erfasst 12, 16
	skpnz
	goto	nofeb	; Schaltjahr
	movlw	0x29	; kein Schaltjahr, nur 28 Tage
	movwf	temp
nofeb:	decf	FSR,f	; -> Tag
	movf	temp,w
	xorwf	INDF,w
	skpz
	return
	movlw	1
	movwf	INDF	; Tag=1

	incf	FSR,f	; -> Monat
	call	IncDec	
	movf	INDF,w
	xorlw	0x13
	skpz
	return
	movlw	1
	movwf	INDF	; Monat=1

	incf	FSR,f	; -> Jahr
	call	IncDec	
	return

IncDec:	incf	INDF,f
	movf	INDF,w
	andlw	0x0f
	xorlw	0x0a
	skpz
	return
	movlw	0x06
	addwf	INDF,f
	return

button3:
	incf btn3,f
	btfsc btn3,6	
	call plus1min
	return

button2:
	incf btn2,f
	btfsc btn2,7
	call slow2
	return

button1:
	incf btn1,f
	btfsc btn1,7	
	call slow1
	return

plus1min:
	clrf 	dispSec
	clrf	btn3
	movlw	dispMin
	movwf	FSR
	call	IncDec	; Minute
	movlw	0x60
	xorwf	INDF,w
	skpz
	return
	clrf	INDF	; Minute=0

	incf	FSR,f	; -> Stunde
	call	IncDec	; Stunde
	movlw	0x24
	xorwf	INDF,w
	skpz
	return
	clrf	INDF	; Stunde=0

	incf	FSR,f	; ->Tag

	return


slow1:
	clrf btn1
	incf sbtn1,f
	btfsc sbtn1,3	
	call on_off_disp
	return
slow2:
	clrf btn2
	incf sbtn2,f
	btfsc sbtn2,3	
	call on_off_date
	return
on_off_date:
	clrf btn2
	clrf sbtn2
	swapf date_on,f
	return
on_off_disp:
	clrf btn1
	clrf sbtn1
	swapf disp_on,f
	return
	
	end

