/*

Lowlevel delay routines

For Microchip 18Fxxx or 18Cxxx and Hi-Tech C

Designed by Shane Tolmie of KeyGhost corporation.  Freely distributable.
Questions and comments to shane@workingtex.com
PICuWEB - Program PIC micros with C. Site has FAQ and sample source code.
http://www.workingtex.com/htpic/

Example C:

#define PIC_CLK 4000000

unsigned int timeout_int, timeout_char;

DelayUs(40);  //do NOT do DelayUs(N) of N<5 @ 4Mhz or else it executes DelayUs(255) !!!!
DelayUs(255); //max

dly250n;      //delay 250ns
dly1u;        //delay 1us

timeout_char=timeout_char_us(1147);
while(timeout_char-- && (RA1==0));  //wait up to 1147us for port RA1 to go high
				    //  - this is the max timeout

timeout_int=timeout_int_us(491512);
while(timeout_int-- && (RA1==0));   //wait up to 491512us for port RA1 to go high
				    //  - this is the max timeout

*/

#ifndef __DELAY_H
#define __DELAY_H

#include "hw.h"

extern unsigned char delayus_variable;

#if (PIC_CLK == 4000000)
	#define dly125n please remove; for 32Mhz+ only
	#define dly250n please remove; for 16Mhz+ only
	#define dly500n please remove; for 8Mhz+ only
	#define dly1u Nop()
	#define dly2u dly1u;dly1u
	#define	dly3u	dly2u;dly1u
	#define	dly4u	dly2u;dly2u
	#define	dly5u	dly2u;dly2u;dly1u
#elif (PIC_CLK == 8000000)
//	#define dly125n please remove; for 32Mhz+ only
//	#define dly250n please remove; for 16Mhz+ only
	#define dly100n dly500n
	#define dly200n dly500n
	#define dly500n Nop()
	#define dly1u dly500n;dly500n
	#define dly2u dly1u;dly1u
	#define	dly3u	dly2u;dly1u
	#define	dly4u	dly2u;dly2u
	#define	dly5u	dly2u;dly2u;dly1u
#elif (PIC_CLK == 16000000)
	#define dly125n please remove; for 32Mhz+ only
	#define dly250n Nop()
	#define dly500n dly250n;dly250n
	#define dly1u dly500n;dly500n
	#define dly2u dly1u;dly1u
	#define	dly3u	dly2u;dly1u
	#define	dly4u	dly2u;dly2u
	#define	dly5u	dly2u;dly2u;dly1u
#elif (PIC_CLK == 20000000)
	#define dly200n Nop()
	#define dly400n dly200n;dly200n
	#define dly600n dly200n;dly200n;dly200n
	#define dly1u	dly400n;dly400n;dly200n
	#define dly2u	dly1u;dly1u
	#define dly3u	dly2u;dly1u
	#define dly4u	dly2u;dly2u
	#define dly5u	dly2u;dly2u;dly1u
#elif (PIC_CLK == 32000000)
	#define dly125n Nop()
	#define dly500n dly125n;dly125n;dly125n;dly125n
	#define dly1u	dly500n;dly500n
	#define dly2u	dly1u;dly1u
	#define dly3u	dly2u;dly1u
	#define dly4u	dly2u;dly2u
	#define dly5u	dly2u;dly2u;dly1u
#elif (PIC_CLK == 40000000)
	#define dly100n Nop()
	#define dly200n dly100n;dly100n
	#define dly400n dly200n;dly200n
	#define dly600n dly200n;dly200n;dly200n
	#define dly1u	dly400n;dly400n;dly200n
	#define dly2u	dly1u;dly1u
	#define dly3u	dly2u;dly1u
	#define dly4u	dly2u;dly2u
	#define dly5u	dly2u;dly2u;dly1u
#else
	#error delay.h - please define pic_clk correctly
#endif

//function prototypes
/*void DelayBigUs(unsigned int cnt);*/
void DelayMs(unsigned char cnt);
void DelayBigMs(unsigned int cnt);
void DelayS(unsigned char cnt);

#endif
