unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, xpman;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    Button2: TButton;
    Button3: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Button4: TButton;
    Shape1: TShape;
    Shape2: TShape;
    CheckBox1: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

  private
    { Private declarations }
  public
    procedure OnPlugged(pHandle:Longint);
    procedure OnChanged();
    procedure OnRead(pHandle:Longint);
    procedure WriteSomeData();
    Procedure OnUnplugged(pHandle:Longint);
  end;

var
  Form1: TForm1;
 // vendor and product IDs
 VendorID, ProductID:Integer;

 MyHandle:Longint;               // USB HID handle assigned to our device
 MyVendorName:String[255];    // USB HID device vendor name
 MyProductName:String[255];   // USB HID product name
 MySerialNumber:String[50];   // USB HID device serial number
 MyReleaseNumber:String;      // USB HID device release number


 BufferIn:array[0..64] of byte;
 BufferOut:array[0..64] of byte;


 List_Counter:Longint;


implementation

{$R *.dfm}


uses unit2;



//USB azonostk lekrdezse, listzsa
procedure TForm1.Button1Click(Sender: TObject);
begin
 // get the USB device handle for this vendor & product ID
 MyHandle:= GetHandle(VendorID, ProductID);

  If MyHandle = 0 Then  ListBox1.Items.Add('Az eszkz nincs csatlakoztatva.')
  Else
   begin ////////
      ListBox1.Items.Add('HID Handle # ' + inttostr(MyHandle));


       // Show VID#, PID#, and serial# as frame caption
      ListBox1.Items.Add('VID #' + IntToHex(GetVendorID(MyHandle),3) + '  PID' +IntToHex(GetProductID(MyHandle),3)) ;

     // showmessage(inttostr(myhandle));

     // ezek miatt elvrzik a program memriacm rs/olvass miatt
     // GetVendorName(MyHandle, MyVendorName, 255);
     // GetProductName( MyHandle, MyProductName, 255);
     // GetSerialNumber( MyHandle, MySerialNumber, 50);


       // itt az IntToHex fggvnyben sajnos meg kell adni a vrt rtknek a hosszt, szval ez a rsz mg nem teljesen j...
      MyReleaseNumber:= IntToHex(GetVersion(MyHandle),2);
       Case Length(MyReleaseNumber) of
         1: MyReleaseNumber:= '000'+MyReleaseNumber;
         2: MyReleaseNumber:= '00'+MyReleaseNumber;
         3: MyReleaseNumber:= '0'+MyReleaseNumber;
         End;
      MyReleaseNumber:=copy(MyReleaseNumber, 1, 2) + '.' + copy(MyReleaseNumber, 3, 2);


      // a vltozk rtknek hinyban nincsenek kiratva:
      {
      ListBox1.Items.Add('MFG: ' + MyVendorName);
      ListBox1.Items.Add('Product: ' + MyProductName);
      ListBox1.Items.Add(' Serial #: ' + MySerialNumber);
      ListBox1.Items.Add(' Release #: ' + MyReleaseNumber); }
    End ///////
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
    BufferOut[0]:= 0;
    BufferOut[1]:= 128;     // LED Toggle kdja
    WriteSomeData;     // Adat kivitele USB-re (64 bjt. Itt csak egy bjt hordoz inft a PIC-nek)
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  VendorID:= strtoint(edit1.Text);
  ProductID:=strtoint(Edit2.Text);       // A kt text boxban llthatjuk be az USB azonostk rtkt.
                                // gyeljnk a formtumra, mert nincs hibakezels
  MyHandle:= GetHandle(VendorID, ProductID); // Eszkz elzetes vizsglata
  If MyHandle = 0 Then
   begin
    ConnectToHID(Application.Handle);
    MyHandle:=GetHandle(VendorID, ProductID);
    If MyHandle=0 Then
     begin
      ListBox1.Items.Add('Nem tallok eszkzt!');
      DisconnectFromHID;
     end
    Else ListBox1.Items.Add('Csatlakozva');
   end
  Else  ListBox1.Items.Add('Az eszkz mr Csatlakozva van.');

end;

procedure TForm1.Button4Click(Sender: TObject);
begin
// Levlaszts

  MyHandle:= GetHandle(VendorID, ProductID); // Eszkz elzetes vizsglata
      
  If MyHandle <> 0 Then
   begin
    DisconnectFromHID;
    ListBox1.Items.Add('Levlasztva');
    end
  Else  ListBox1.Items.Add('Nincs csatlakozva eszkz!');

end;



procedure TForm1.FormCreate(Sender: TObject);
begin
 List_Counter:=0;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    Button2.OnClick(Sender);
    DisconnectFromHID;
end;



//*****************************************************************
// a HID device has been plugged in...
//*****************************************************************
Procedure TForm1.OnPlugged(pHandle:Longint);
 begin
   If (GetVendorID(pHandle) = VendorID) And (GetProductID(pHandle)=ProductID) Then
   begin
     // ' ** YOUR CODE HERE **
     end;
 end;


//*****************************************************************
// controller changed notification - called
// after ALL HID devices are plugged or unplugged
//*****************************************************************
Procedure TForm1.OnChanged();
var DeviceHandle:Longint;
begin

   // get the handle of the device we are interested in, then set
   // its read notify flag to true - this ensures you get a read
   // notification message when there is some data to read...
   DeviceHandle:= GetHandle(VendorID, ProductID);
   SetReadNotify(DeviceHandle, True);
end;





//*****************************************************************
// on read event... USB vtel esemnykezelse(A vtelkor ez a rutin hvdik meg automatikusan)
//*****************************************************************
Procedure TForm1.OnRead(pHandle:Longint);
begin
   // read the data (don't forget, pass the whole array)...
   If Read(pHandle, BufferIn[0]) Then
    begin  // 1.
    If (BufferIn[2] = 112) Or (BufferIn[1] = 112) Then    //Ezt a kdot kldi vissza a PIC a belltott temben.
     begin //2.
        If shape1.Brush.Color =clred Then   shape1.Brush.Color:=clblack
        Else     shape1.Brush.Color:=clred;
     end;  //2.
      
    
    If BufferIn[2] = 113 Then   // &H71 Ezt a kdot kldi vissza a PIC ha a LED1 bekapcsolva van.
        shape2.Brush.Color:=clred;
    If BufferIn[2] = 114 Then    //&H72 Ezt a kdot kldi vissza a PIC ha a LED1 kikapcsolva van.
        shape2.Brush.Color:=clblack;

    inc(List_Counter);

    If Checkbox1.Checked Then Listbox1.Items.Add(inttostr(List_Counter)+': ' + char(BufferIn[2]));
    
    If List_Counter = 999 Then
     begin
      List_Counter:= 0;
      If checkbox1.Checked=true Then Listbox1.Clear;
     end;
    
    
      // ** YOUR CODE HERE **
      // first byte is the report ID, e.g. BufferIn(0)
     // the other bytes are the data from the microcontrolller...

   end;   //1.


end;


//*****************************************************************
// this is how you write some data...
//*****************************************************************
Procedure TForm1.WriteSomeData();
begin
//  BufferOut(0) = 0   ' first by is always the report ID

 // write the data (don't forget, pass the whole array)...
   WriteEx(VendorID, ProductID, BufferOut[0]);
end;


Procedure TForm1.OnUnplugged(pHandle:Longint);
begin
   If (GetVendorID(pHandle) = VendorID) And (GetProductID(pHandle) = ProductID) Then
   begin
      // ** YOUR CODE HERE **
   end;

end;


end.
