unit Unit2;
interface

uses Forms;

// HID interface API declarations...
// az eljrsok el kerlt a VBben egy "hid" sz

 Function Connect(pHostWin:Longint):Boolean; stdcall; external 'mcHID.dll'
 Function Disconnect():Boolean;  stdcall; external 'mcHID.dll'
 Function GetItem(pIndex:Longint):Longint;  stdcall; external 'mcHID.dll'
 Function GetItemCount():Longint; stdcall; external 'mcHID.dll'
 Function Read(pHandle:Longint; var pData:Byte):Boolean; stdcall; external 'mcHID.dll'
 Function Write(pHandle:Longint; var pData:Byte):Boolean; stdcall; external 'mcHID.dll'
 Function ReadEx( pVendorID:Longint;  pProductID:Longint; var pData:Byte): Boolean; stdcall; external 'mcHID.dll'
 Function WriteEx( pVendorID:Longint;  pProductID:Longint; var pData:Byte):Boolean; stdcall; external 'mcHID.dll'
 Function GetHandle( pVendoID:Longint;  pProductID:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetVendorID( pHandle:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetProductID( pHandle:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetVersion( pHandle:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetVendorName( pHandle:Longint;  pText:String;  pLen:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetProductName( pHandle:Longint;  pText:String;  pLen:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetSerialNumber( pHandle:Longint;  pText:String;  pLen:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetInputReportLength(pHandle:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetOutputReportLength( pHandle:Longint):Longint; stdcall; external 'mcHID.dll'
 Procedure SetReadNotify( pHandle:Longint;  pValue:Boolean); stdcall; external 'mcHID.dll'
 Function IsReadNotifyEnabled( pHandle:Longint):Boolean; stdcall; external 'mcHID.dll'
 Function IsAvailable( pVendorID:Longint;  pProductID:Longint):Boolean; stdcall; external 'mcHID.dll'


  //VB-ben CallWindowProc volt a neve
 Function CallWindowProcA(lpPrevWndFunc:Longint; hwnd:Longint; Msg:Longint; wParam:Longint; lParam:Longint):Longint; stdcall; external 'user32'

  //VB-ben SetWindowLong volt a neve
 Function SetWindowLongA(hwnd:Longint; nIndex:Longint; dwNewLong:Longint):Longint; stdcall; external 'user32'

 Function ConnectToHID(pHostWin:Longint):Boolean;
 Function DisconnectFromHID():Boolean;
 Function WinProc(pHWnd:Longint; pMsg:Longint; wParam:Longint; lParam:Longint):Longint;

 var   FPrevWinProc:Longint;    //Handle to previous window procedure
       FWinHandle:Longint;      //Handle to message window

implementation


uses unit1;

// windows API Constants
Const WM_APP= 32768;
Const GWL_WNDPROC=-4;

 // read and write buffers
 Const BufferInSize = 64;
 Const BufferOutSize = 64;

// HID message constants
Const WM_HID_EVENT = WM_APP + 200;
Const NOTIFY_PLUGGED = 1;
Const NOTIFY_UNPLUGGED = 2;
Const NOTIFY_CHANGED = 3;
Const NOTIFY_READ = 4;


//Set up a windows hook to receive notification
//messages from the HID controller DLL - then connect
//to the controller
Function ConnectToHID(pHostWin:Longint):Boolean;
begin
   FWinHandle:= pHostWin;
   Result:= Connect(FWinHandle);
 //  FPrevWinProc:= SetWindowLongA(FWinHandle, GWL_WNDPROC, integer(addr(WinProc)));  // EZ NEM AKAR VGREHAJTDNI NORMLISAN
end;

//Unhook from the HID controller and disconnect...
Function DisconnectFromHID():Boolean;
begin
   Result:=Disconnect;
   SetWindowLongA(FWinHandle, -4, FPrevWinProc);
end;


// This is the procedure that intercepts the HID controller messages...
Function WinProc(pHWnd:Longint; pMsg:Longint; wParam:Longint; lParam:Longint):Longint;
begin

   If pMsg = WM_HID_EVENT Then
    begin
       //HID device has been plugged message...
       if wParam = NOTIFY_PLUGGED then form1.OnPlugged(lParam);

        //HID device has been unplugged
        if wParam = NOTIFY_UNPLUGGED then Form1.OnUnplugged(lParam);

        //controller has changed...
        if wParam = NOTIFY_CHANGED then Form1.OnChanged;

        //read event...
        if wParam = NOTIFY_READ then Form1.OnRead(lParam);
    End;

   // next...
   Result:= CallWindowProcA(FPrevWinProc, pHWnd, pMsg, wParam, lParam);
end;

end.
 