unit Unit2;
interface

uses SysUtils, Forms;

// HID interface API declarations...
// az eljrsok el kerlt a VBben egy "hid" sz

 Function HIDConnect(pHostWin:Longint):Boolean; stdcall; external 'mcHID.dll' name 'Connect'
 Function Disconnect():Boolean;  stdcall; external 'mcHID.dll'
 Function GetItem(pIndex:Longint):Longint;  stdcall; external 'mcHID.dll'
 Function GetItemCount():Longint; stdcall; external 'mcHID.dll'
 Function Read(pHandle:Longint; pData:PByte):Boolean; stdcall; external 'mcHID.dll'
 Function Write(pHandle:Longint; pData:PByte):Boolean; stdcall; external 'mcHID.dll'
 Function ReadEx( pVendorID:Longint;  pProductID:Longint; pData:PByte): Boolean; stdcall; external 'mcHID.dll'
 Function WriteEx( pVendorID:Longint;  pProductID:Longint; pData:PByte):Boolean; stdcall; external 'mcHID.dll'
 Function HIDGetHandle( pVendoID:Longint;  pProductID:Longint):Longint; stdcall; external 'mcHID.dll'  name 'GetHandle'
 Function GetVendorID( pHandle:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetProductID( pHandle:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetVersion( pHandle:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetVendorName( pHandle:Longint;  pText:PChar;  pLen:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetProductName( pHandle:Longint;  pText:PChar;  pLen:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetSerialNumber( pHandle:Longint;  pText:PChar;  pLen:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetInputReportLength(pHandle:Longint):Longint; stdcall; external 'mcHID.dll'
 Function GetOutputReportLength( pHandle:Longint):Longint; stdcall; external 'mcHID.dll'
 Procedure SetReadNotify( pHandle:Longint;  pValue:Boolean); stdcall; external 'mcHID.dll'
 Function IsReadNotifyEnabled( pHandle:Longint):Boolean; stdcall; external 'mcHID.dll'
 Function IsAvailable( pVendorID:Longint;  pProductID:Longint):Boolean; stdcall; external 'mcHID.dll'


 Function ConnectToHID(pHostWin:Longint):Boolean;
 Function DisconnectFromHID():Boolean;

 var   FPrevWinProc:Longint;    //Handle to previous window procedure
       FWinHandle:Longint;      //Handle to message window

implementation


 // read and write buffers
 Const BufferInSize = 64;
 Const BufferOutSize = 64;



//Set up a windows hook to receive notification
//messages from the HID controller DLL - then connect
//to the controller
Function ConnectToHID(pHostWin:Longint):Boolean;
begin
   FWinHandle:= pHostWin;
   Result:= HIDConnect(FWinHandle);
end;

//Unhook from the HID controller and disconnect...
Function DisconnectFromHID():Boolean;
begin
   Result:=Disconnect;
end;

end.
