//---------------------------------
// Receiver for RF remote control project
// (c) www.CoolCircuit.com
//---------------------------------
#include<pic.h>
#include"delay.h"

__CONFIG(XT&MCLRDIS&WDTDIS);

#define Header	0x20
#define RX  GP3
#define out1 GP0
#define out2 GP1
#define out3 GP2

unsigned char RXREG[3];
unsigned char toggle=0x00;
unsigned char old_toggle=0x00;
#define Channel RXREG[1]

bit get_data(unsigned char *buff);


bit rx_bit;

void main()
{ 
	
	DelayBigUs(580);
	GPIO=0x00;
	TRIS=0B00001000;
	OPTION=0x03;	
	
	while(1)
	{	
		while(get_data(RXREG));
		if (RXREG[2]==(RXREG[0] ^ RXREG[1]))
		{
			if (RXREG[0]==Header)
			{
				toggle = RXREG[1] & 0x80;
				if (toggle!=old_toggle)
				{
					old_toggle=toggle;
					RXREG[1]=RXREG[1] & 0x03;
					if (RXREG[1]==0x01) out1=!out1;
					if (RXREG[1]==0x02) out2=!out2;
					if (RXREG[1]==0x03) out3=!out3;
				}
			}
		}
		//DelayMs(50);
	}
}	


bit get_data(unsigned char *buff)
{
	unsigned char i,j,T0,count;	
	
	i=35;		
	count=0;	
	OPTION=0x00;	// pre scaler = 2 for counting long time

	while(--i)	// wait preamble
	{		    
		 NOP();
	     NOP();
	     NOP();
	     while(RX);	     
	     TMR0=0;
	     NOP();
	     NOP();
	     NOP();
	     while(!RX);
	     T0=TMR0;
	     if (T0==0xFF) return 1;      // error
	     if ((T0>=198) && (T0<=218))	  // 396-432 uS it OK.   
	     {
		    count++;
		    if ((count>=1)|| (i==0)) break;
	     }	     
	}
	
	if (i==0) return 1; // error				
		
	OPTION=0x03;	// prescaler = 16
	//OPTION=0x04;	// prescaler = 32
	T0=0;
	while (!((T0>=94) && (T0<=114)))	     // 1504 - 1824 uS it OK. syn bit for 4Te or 1664 uS
	//while (!((T0>=158) && (T0<=180)))	     // 5056 - 5760 uS it OK. syn bit for 4Te or 5416=5mS+ (4*416uS) uS
	{
		NOP();
	    NOP();
     	NOP();
		while(RX);	// wait syn
		TMR0=0;
		NOP();
		NOP();
	    NOP();
     	NOP();
		while(!RX);
		T0=TMR0;    
	}	
		
	while(RX); 			//wait start bit go low
	DelayBigUs(580); 	// delay 624 uS before sampling (1.5Te)
	
	for (j=0;j<3;j++)
	{
	  i=8;
	  buff[j]=0;
	  while(i--)
	  {
		buff[j]=buff[j]<<1;
		rx_bit=RX;	// sampling
		buff[j]=buff[j] | rx_bit;			
		
		if (rx_bit==0) 
		   while(!RX);	
		else
		   while(RX);
		DelayBigUs(580); 	// delay 7500 uS before sampling		
		
	  }
	}
	
	if (rx_bit==0) 
		if (!RX) return 1; // error (no stop bit found)
	else
		if (!RX) return 1; // error (no stop bit found)
		
	return 0;
}	

