//-------------------------------------
// TX for RF remote control
// (c) www.CoolCircuit.com
//-------------------------------------
#include<pic.h>
#include"delay.h"

__CONFIG(XT&MCLRDIS&WDTDIS);

#define Header	0x20

#define sw1 GP0
#define sw2 GP3
#define sw3 GP1
#define TX GP2

void send_data(unsigned char *data);

void checkSW1(void);
void checkSW2(void);
void checkSW3(void);

unsigned char buff[3];
unsigned char toggle=0x80;

void main()
{		
	DelayBigUs(1197);  // Delay 416 uS for 2400 bps
	TX=0;		
	TRIS=0B00001011;
	OPTION=0x00;	// pull-up GP0,GP1,GP3, timer0 not use
	
	while(1)
	{
		if (!sw1) checkSW1();
		if (!sw3) checkSW3();   // first check sw3 then sw2(hardware limited)
		if (!sw2) checkSW2();		
	}	
}

	
void premable()
{
}
	
void send_data(unsigned char *data)
{
	unsigned char i,j;
	
	for (i=0;i<35;i++)	// send preamble 16 times
	{
		TX=1;
		DelayBigUs(379);  // Delay 416 uS for 2400 bps
		//DelayBigUs(4890);	 // 5 mS

		TX=0;
		DelayBigUs(379);  // Delay 416 uS for 2400 bps
		//DelayBigUs(4890);	 // 5 mS

	}
	//DelayBigUs(14738); // Delay 15000 uS  syn bit 3Te
	DelayBigUs(1197);  // Delay 1248 uS or 3Te for syn bit
	
	//-----------------
	TX=1;	// start bit
	//DelayBigUs(4890);	 // 5 mS
	DelayBigUs(379);  // Delay 416 uS for 2400 bps
	TX=0;
	//DelayBigUs(4890);	 // 5 mS
	DelayBigUs(379);  // Delay 416 uS for 2400 bps
	//-----------------
	
	
	for (j=0;j<3;j++)
	{
	  for(i=0;i<8;i++)
	  {
		if ((data[j] & 0x80) == 0x80)
		{
			TX=1;
			//DelayBigUs(4890);	 // 5 mS
			DelayBigUs(379);  // Delay 416 uS for 2400 bps
			TX=0;
			//DelayBigUs(4890);	 // 5 mS
			DelayBigUs(379);  // Delay 416 uS for 2400 bps
		}
		else
		{
			TX=0;
			//DelayBigUs(4890);	 // 5 mS
			DelayBigUs(379);  // Delay 416 uS for 2400 bps
			TX=1;
			//DelayBigUs(4890);	 // 5 mS
			DelayBigUs(379);  // Delay 416 uS for 2400 bps
		}
		data[j]=data[j]<<1;
	  }
	}
	//------ send stop bit -------
	TX=1;
	//DelayBigUs(4890);	 // 5 mS
	DelayBigUs(379);  // Delay 416 uS for 2400 bps
	TX=0;
	//DelayBigUs(4890);	 // 5 mS
	DelayBigUs(379);  // Delay 416 uS for 2400 bps
	DelayBigUs(2000);	// delay gaurd
}	

void checkSW1()
{
	//DelayMs(15);	
	if (!sw1)	
	{
		do{
			buff[0]=Header;
			buff[1]=0x01 | toggle;	// channel 1
			buff[2]=buff[0] ^ buff[1];
			send_data(buff);
		}while(!sw1);
		toggle=toggle ^ 0x80;
		DelayMs(15);
	}	
}

void checkSW2()
{
	//DelayMs(15);
	if (!sw2)	
	{
		do{
			buff[0]=Header;
			buff[1]=0x02 | toggle;	// channel 2
			buff[2]=buff[0] ^ buff[1];
			send_data(buff);
		}while(!sw2);
		toggle=toggle ^ 0x80;
		DelayMs(15);
	}	
}

void checkSW3()
{
	//DelayMs(15);
	if (!sw3)	
	{
		do{
			buff[0]=Header;
			buff[1]=0x03 | toggle;	// channel 3
			buff[2]=buff[0] ^ buff[1];
			send_data(buff);
		}while(!sw3);
		toggle=toggle ^ 0x80;
		DelayMs(15);
	}	
}	
