//;****************************************************************
//;*  Name    : tempc47.c                                          
//;*  Author  : David Vilmos                                      
//;*  Notice  : Copyright (c) 2009 DV Electronics                 
//;*          : All Rights Reserved                               
//;*  Date    : 20/06/2009                                        
//;*  Version : 1.0                                               
//;*  Notes   : This program    Display  & control                      
//;*                 temperature w. TC1047 Sensors.                                
//;*                                                        
//;*  Processor : 16F690      INT OSC                            
//;*  Compiler  : CCS PICC                                       
//;*****************************************************************/


#include <16F690.h>
#device ADC=10
#fuses INTRC_IO,NOWDT,PROTECT,NOMCLR,PUT,NOCPD  //FOR 16F690
#use delay(clock=8000000)
#pragma use fast_io(A)
#pragma use fast_io(B)
#pragma use fast_io(C)

#include <flexlcd.h>
#include <lcd_custom.c>

#BYTE port_a = 5
#BYTE port_b = 6
#BYTE port_c = 7
#BYTE option_r = 0x81
#BYTE tris_a = 0x85
#BYTE tris_b = 0x86
#BYTE tris_c = 0x87
#BYTE wpu_b = 0x115
#BYTE ioc_b = 0x116
#BIT  Led2 = port_c.3
#BIT  Led1 = port_b.7
#BIT  ssr = port_a.2
#BIT  Bt1 = port_b.5
#BIT  Bt2 = port_b.6
#BIT  Bt3 = port_b.4
#BIT  rbpu = option_r.7

typedef unsigned int16 	ulong;
typedef signed int16	slong;

#ifndef INT_EEPROM_ADDRESS
#define INT_EEPROM_ADDRESS  int8
#endif

//#define SIM               // Define Debug Mode

#define INTS_PER_SECOND 100     // (4000000/(4*64*256))
#define SAMPLET	50
#define SAMPLEI	20
#define SAMPLEB	4
#define SAMPLES	100
#define VR		2.56			//V ref of AD



char display_m[32];      //display mirror
int1 sample;
short int dbutton4, dbutton5, dbutton6;
int sp;
int tmin;
int prog;
int  gain1;	//gain,
int tsample;
int current;
int last;
BYTE int_count;    					// Number of interrupts left before a second has elapsed
signed int16 Ipwm1;
float Tpwm1;
float temp1;
float stemp1;
float srange;
float mt=100*VR/1024;
slong V_t1, V_t2;
ulong V_s1, V_s2;
ulong set_p;
ulong V_r1[8]; 
signed int16 i_val1[SAMPLEI];
int i_n;
slong i_sum1;
slong i_sum2;
slong T_min;
slong T_max;

#rom 0x2100={25,50,0,7,7,0,0x0,0,0x65,1,0xec,1,0x49,2,0xa1,2,0x5f,1}
#rom 0x2150={__TIME__}
#rom 0x2160={__DATE__}
#rom 0x2170={"DV Electronics"}
   

#int_rtcc                          // This function is called every time
void clock_isr() 
{                 					// the RTCC (timer0) overflows (255->0).
    set_timer0(100);                // For this program this is apx 156 times
	 if (int_count > Ipwm1)
	 {
		 ssr=0;
		 led2=0;
//		 led1=1;
	 }
	 else
	 {
		 ssr=1;
		 led2=1;
//		 led1=0;
	 }

	 tsample++;
	 if (tsample == SAMPLET)
	 {
		 tsample=0;
		 sample=1;
	 }
	  if(--int_count==0) {           
      int_count=INTS_PER_SECOND;
    }
}

#int_rb
void detect_rb_change() {


   current=input_b();
   if ((!bit_test(current,4))&&(bit_test(last,4))) {dbutton4=1;}
   if ((!bit_test(current,5))&&(bit_test(last,5))) {dbutton5=1;}
   if ((!bit_test(current,6))&&(bit_test(last,6))) {dbutton6=1;}

   last=current;
}
// Purpose:    Write a 16 bit number to internal eeprom
// Inputs:     1) An eeprom address
//             2) The 16 bit number to write to internal eeprom
// Outputs:    None
void write_int16_eeprom(INT_EEPROM_ADDRESS address, int16 data)
{
   int8 i;

   for(i = 0; i < 2; ++i)
   {
     write_eeprom(address + i, *((int8 *)(&data) + i));
   }
}
	

// Purpose:    Read a 16 bit number from internal eeprom
// Inputs:     An eeprom address
// Outputs:    The 16 bit number read from internal eeprom
int16 read_int16_eeprom(INT_EEPROM_ADDRESS address)
{
   int8  i;
   int16 data;

   for(i = 0; i < 2; ++i)
   {
     *((int8 *)(&data) + i) = read_eeprom(address + i);
   }

   return(data);
}

void clear_delta() {
   dbutton4=0;
   dbutton5=0;
   dbutton6=0;
   current=input_b();
   last=current;
}

void wr_set(float temp_s)
{
	temp_s=temp_s-tmin;
	Set_p=temp_s/Srange;
	write_int16_eeprom(6+prog*2, Set_p);
}	
	
#zero_ram
void main(void)
{
   int k;
	setup_oscillator( OSC_4MHZ );
	setup_timer_0 (RTCC_DIV_64|RTCC_INTERNAL);
    set_timer0(100);
	int_count=INTS_PER_SECOND;
    enable_interrupts(INT_TIMER0);
	port_a=0;
	port_b=0;
	port_c=0;
	tris_a=0b11111011;
	tris_b=0b01111111;
	tris_c=0b00000000;
	wpu_b = 0b01110000;
	ioc_b = 0b01110000;
	rbpu=0;
	lcd_init();
	lcd_load_custom_chars();
   setup_adc_ports( sAN0 |VSS_VREF);           //FOR 16F690
   setup_adc( ADC_CLOCK_INTERNAL);
   set_adc_channel( 0 );
 //  gain = read_EEPROM (3);
    gain1 = read_EEPROM (3);
   	tmin=read_EEPROM (0);
   	T_min=tmin;
   	T_max=read_EEPROM (1);
   	Srange=T_max-T_min;
	Srange = Srange/1024;
    prog=read_EEPROM (2);
    Set_p=read_int16_eeprom(6+prog*2);
    if (Set_p>1023) 
    {
	    write_int16_eeprom(6+prog*2, 1023);
	    Set_p=1023;
	}    
    printf(lcd_putc,"\f  Temp Control\n DV Electronics"); 
    delay_ms(2500);
    led1=1;
	for (k=0;k<8;k++)
	{
		delay_ms( 1);
		V_r1[k]=read_adc();
		delay_ms( 1);
   }   
 	delay_ms( 1000);
 	clear_delta();
 	enable_interrupts(INT_RB);
 	enable_interrupts(GLOBAL);
   while(true)
   { 
	if (sample ==1)
	{
		sample=0;
		V_r1[sp]=read_adc();
	     sp++;
	     if (sp>7) sp=0;
		V_t1=0;
		V_t2=0;
		V_s1=0;
		V_s2=0;
		 for (k=0;k<8;k++)
		 {
			 V_t1=	V_t1+V_r1[k];
		 }
		 V_t1=V_t1/8;
		 V_t1=V_t1-200;
		 V_s1=V_s1/8;	
		 Temp1=V_t1*mt;//*VR)/1024;
//		 Temp1=Temp1*100;
		 Stemp1=Set_p*Srange;
		 Stemp1=Stemp1+tmin;
		 Tpwm1=(Stemp1-Temp1);
 		 i_sum1=0;
		 for (k=0;k<SAMPLEI;k++)
		 {
			 i_sum1=	i_sum1+i_val1[k];
		 }
		 if (i_sum1>500) i_sum1=500;
		 if (i_sum1<-500) i_sum1=-500;		
		Ipwm1=Tpwm1*gain1;				
		if (Ipwm1>100) Ipwm1 =100;
		if (Ipwm1<-100) Ipwm1 =-100;
		i_val1[i_n]=Ipwm1;
//		Ipwm1=i_val1[i_n];
		Ipwm1=i_sum1+Ipwm1;
		if (Ipwm1>100) Ipwm1 =100;
		if (Ipwm1<1) Ipwm1 =0;
		i_n++;
   		if (i_n > (SAMPLEI-1)) i_n =0;        
        sprintf(display_m,"\f Temp: %05.2g \002C\n",temp1);
        printf(lcd_putc,"%s",display_m);
        sprintf(display_m,"M%u Set: %04.1g \002C",prog+1,Stemp1);        
        printf(lcd_putc,"%s",display_m);
        if (dbutton5)
        {
	        
	        if (Stemp1<T_max) Stemp1=Stemp1+0.1;
	        dbutton5=0;
	        wr_set(Stemp1);
	    }
	    if (dbutton6)
        {
	        
	        if (Stemp1>(T_min+0.1)) Stemp1=Stemp1-0.1;
	        dbutton6=0;
	        wr_set(Stemp1);
	    }
	    if (dbutton4)
        {
	        
	        prog++;
	        if (prog>4) prog =0;
	        dbutton4=0;
	        write_EEPROM (2,prog);
	        Set_p=read_int16_eeprom(6+prog*2);
	    }      
	        
 	}  
   }
}
