#define UP_ARROW   0
#define DOWN_ARROW 1
#define DEGREES    2

//=============================================
// Functions

// This table holds the data for the LCD custom chars.
// Only 3 chars were created below.  The 5 other blank
// chars can be edited to create more custom chars.

const int8 lcd_custom_chars[] =
{
// Char Number 0 -- Up Arrow
0b00000100,  // .....O..
0b00001110,  // ....OOO.
0b00011111,  // ...OOOOO
0b00000100,  // .....O..
0b00000100,  // .....O..
0b00000100,  // .....O..
0b00000100,  // .....O..
0b00000000,  // ........

// Char Number 1 -- Down Arrow
0b00000100,  // .....O..
0b00000100,  // .....O..
0b00000100,  // .....O..
0b00000100,  // .....O..
0b00011111,  // ...OOOOO
0b00001110,  // ....OOO.
0b00000100,  // .....O..
0b00000000,  // ........

// Char Number 2 -- Degrees
0b00001100,  // ....OO..
0b00010010,  // ...O..O.
0b00010010,  // ...O..O.
0b00001100,  // ....OO..
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........

// Char Number 3 -- Blank
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........

// Char Number 4 -- Blank
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........

// Char Number 5 -- Blank
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........

// Char Number 6 -- Blank
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........

// Char Number 7 -- Blank
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000,  // ........
0b00000000   // ........

};

void lcd_load_custom_chars(void)
{
int8 i;

// Set address counter pointing to CGRAM address 0.
lcd_send_byte(0, 0x40); 

// Load custom lcd character data into CGRAM.
// It can only hold a maximum of 8 custom characters.
for(i = 0; i < sizeof(lcd_custom_chars); i++)
   {
    lcd_send_byte(1, lcd_custom_chars[i]);
   }

// Set address counter pointing back to the DDRAM.
lcd_send_byte(0, 0x80);
} 