/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class LEDElm
extends DiodeElm {
    double colorR;
    double colorG;
    double colorB;
    Point ledLead1;
    Point ledLead2;
    Point ledCenter;

    public LEDElm(int n, int n2) {
        super(n, n2);
        this.fwdrop = 2.1024259;
        this.setup();
        this.colorR = 1.0;
        this.colorB = 0.0;
        this.colorG = 0.0;
    }

    public LEDElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
        if ((n5 & 1) == 0) {
            this.fwdrop = 2.1024259;
        }
        this.setup();
        this.colorR = new Double(stringTokenizer.nextToken());
        this.colorG = new Double(stringTokenizer.nextToken());
        this.colorB = new Double(stringTokenizer.nextToken());
    }

    int getDumpType() {
        return 162;
    }

    String dump() {
        return super.dump() + " " + this.colorR + " " + this.colorG + " " + this.colorB;
    }

    void setPoints() {
        super.setPoints();
        int n = 12;
        this.ledLead1 = this.interpPoint(this.point1, this.point2, 0.5 - (double)n / this.dn);
        this.ledLead2 = this.interpPoint(this.point1, this.point2, 0.5 + (double)n / this.dn);
        this.ledCenter = this.interpPoint(this.point1, this.point2, 0.5);
    }

    void draw(Graphics graphics) {
        if (this.needsHighlight() || this == LEDElm.sim.dragElm) {
            super.draw(graphics);
            return;
        }
        this.setVoltageColor(graphics, this.volts[0]);
        LEDElm.drawThickLine(graphics, this.point1, this.ledLead1);
        this.setVoltageColor(graphics, this.volts[1]);
        LEDElm.drawThickLine(graphics, this.ledLead2, this.point2);
        graphics.setColor(Color.gray);
        int n = 12;
        LEDElm.drawThickCircle(graphics, this.ledCenter.x, this.ledCenter.y, n);
        n -= 4;
        double d = 255.0 * this.current / 0.01;
        if (d > 255.0) {
            d = 255.0;
        }
        Color color = new Color((int)(this.colorR * d), (int)(this.colorG * d), (int)(this.colorB * d));
        graphics.setColor(color);
        graphics.fillOval(this.ledCenter.x - n, this.ledCenter.y - n, n * 2, n * 2);
        this.setBbox(this.point1, this.point2, n);
        this.updateDotCount();
        this.drawDots(graphics, this.point1, this.ledLead1, this.curcount);
        this.drawDots(graphics, this.point2, this.ledLead2, -this.curcount);
        this.drawPosts(graphics);
    }

    void getInfo(String[] stringArray) {
        super.getInfo(stringArray);
        stringArray[0] = "LED";
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return super.getEditInfo(n);
        }
        if (n == 1) {
            return new EditInfo("Red Value (0-1)", this.colorR, 0.0, 1.0).setDimensionless();
        }
        if (n == 2) {
            return new EditInfo("Green Value (0-1)", this.colorG, 0.0, 1.0).setDimensionless();
        }
        if (n == 3) {
            return new EditInfo("Blue Value (0-1)", this.colorB, 0.0, 1.0).setDimensionless();
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            super.setEditValue(0, editInfo);
        }
        if (n == 1) {
            this.colorR = editInfo.value;
        }
        if (n == 2) {
            this.colorG = editInfo.value;
        }
        if (n == 3) {
            this.colorB = editInfo.value;
        }
    }
}

