/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

class LatchElm
extends ChipElm {
    int loadPin;
    boolean lastLoad = false;

    public LatchElm(int n, int n2) {
        super(n, n2);
    }

    public LatchElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
    }

    String getChipName() {
        return "Latch";
    }

    boolean needsBits() {
        return true;
    }

    void setupPins() {
        int n;
        this.sizeX = 2;
        this.sizeY = this.bits + 1;
        this.pins = new ChipElm.Pin[this.getPostCount()];
        for (n = 0; n != this.bits; ++n) {
            this.pins[n] = new ChipElm.Pin(this.bits - 1 - n, 2, "I" + n);
        }
        for (n = 0; n != this.bits; ++n) {
            this.pins[n + this.bits] = new ChipElm.Pin(this.bits - 1 - n, 3, "O");
            this.pins[n + this.bits].output = true;
        }
        this.loadPin = this.bits * 2;
        this.pins[this.loadPin] = new ChipElm.Pin(this.bits, 2, "Ld");
        this.allocNodes();
    }

    void execute() {
        if (this.pins[this.loadPin].value && !this.lastLoad) {
            for (int i = 0; i != this.bits; ++i) {
                this.pins[i + this.bits].value = this.pins[i].value;
            }
        }
        this.lastLoad = this.pins[this.loadPin].value;
    }

    int getVoltageSourceCount() {
        return this.bits;
    }

    int getPostCount() {
        return this.bits * 2 + 1;
    }

    int getDumpType() {
        return 168;
    }
}

