/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class TriodeElm
extends CircuitElm {
    double mu;
    double kg1;
    double curcountp;
    double curcountc;
    double curcountg;
    double currentp;
    double currentg;
    double currentc;
    final double gridCurrentR = 6000.0;
    Point[] plate;
    Point[] grid;
    Point[] cath;
    Point midgrid;
    Point midcath;
    int circler;
    double lastv0;
    double lastv1;
    double lastv2;

    public TriodeElm(int n, int n2) {
        super(n, n2);
        this.mu = 93.0;
        this.kg1 = 680.0;
        this.setup();
    }

    public TriodeElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.mu = new Double(stringTokenizer.nextToken());
        this.kg1 = new Double(stringTokenizer.nextToken());
        this.setup();
    }

    void setup() {
        this.noDiagonal = true;
    }

    boolean nonLinear() {
        return true;
    }

    void reset() {
        this.volts[2] = 0.0;
        this.volts[1] = 0.0;
        this.volts[0] = 0.0;
        this.curcount = 0.0;
    }

    String dump() {
        return super.dump() + " " + this.mu + " " + this.kg1;
    }

    int getDumpType() {
        return 173;
    }

    void setPoints() {
        super.setPoints();
        this.plate = this.newPointArray(4);
        this.grid = this.newPointArray(8);
        this.cath = this.newPointArray(4);
        this.grid[0] = this.point1;
        int n = 8;
        this.interpPoint(this.point1, this.point2, this.plate[1], 1.0, n);
        int n2 = 32;
        this.interpPoint(this.point1, this.point2, this.plate[0], 1.0, n2);
        int n3 = 18;
        this.interpPoint2(this.point2, this.plate[1], this.plate[2], this.plate[3], 1.0, n3);
        this.circler = 24;
        this.interpPoint(this.point1, this.point2, this.grid[1], (this.dn - (double)this.circler) / this.dn, 0.0);
        for (int i = 0; i != 3; ++i) {
            this.interpPoint(this.grid[1], this.point2, this.grid[2 + i * 2], (double)(i * 3 + 1) / 4.5, 0.0);
            this.interpPoint(this.grid[1], this.point2, this.grid[3 + i * 2], (double)(i * 3 + 2) / 4.5, 0.0);
        }
        this.midgrid = this.point2;
        int n4 = 16;
        this.midcath = this.interpPoint(this.point1, this.point2, 1.0, (double)(-n));
        this.interpPoint2(this.point2, this.plate[1], this.cath[1], this.cath[2], -1.0, n4);
        this.interpPoint(this.point2, this.plate[1], this.cath[3], -1.2, -n4);
        this.interpPoint(this.point2, this.plate[1], this.cath[0], (double)(-n2) / (double)n, n4);
    }

    void draw(Graphics graphics) {
        int n;
        graphics.setColor(Color.gray);
        TriodeElm.drawThickCircle(graphics, this.point2.x, this.point2.y, this.circler);
        this.setBbox(this.point1, this.plate[0], 16.0);
        this.adjustBbox(this.cath[0].x, this.cath[1].y, this.point2.x + this.circler, this.point2.y + this.circler);
        this.setPowerColor(graphics, true);
        this.setVoltageColor(graphics, this.volts[0]);
        TriodeElm.drawThickLine(graphics, this.plate[0], this.plate[1]);
        TriodeElm.drawThickLine(graphics, this.plate[2], this.plate[3]);
        this.setVoltageColor(graphics, this.volts[1]);
        for (n = 0; n != 8; n += 2) {
            TriodeElm.drawThickLine(graphics, this.grid[n], this.grid[n + 1]);
        }
        this.setVoltageColor(graphics, this.volts[2]);
        for (n = 0; n != 3; ++n) {
            TriodeElm.drawThickLine(graphics, this.cath[n], this.cath[n + 1]);
        }
        this.curcountp = this.updateDotCount(this.currentp, this.curcountp);
        this.curcountc = this.updateDotCount(this.currentc, this.curcountc);
        this.curcountg = this.updateDotCount(this.currentg, this.curcountg);
        if (TriodeElm.sim.dragElm != this) {
            this.drawDots(graphics, this.plate[0], this.midgrid, this.curcountp);
            this.drawDots(graphics, this.midgrid, this.midcath, this.curcountc);
            this.drawDots(graphics, this.midcath, this.cath[1], this.curcountc + 8.0);
            this.drawDots(graphics, this.cath[1], this.cath[0], this.curcountc + 8.0);
            this.drawDots(graphics, this.point1, this.midgrid, this.curcountg);
        }
        this.drawPosts(graphics);
    }

    Point getPost(int n) {
        return n == 0 ? this.plate[0] : (n == 1 ? this.grid[0] : this.cath[0]);
    }

    int getPostCount() {
        return 3;
    }

    double getPower() {
        return (this.volts[0] - this.volts[2]) * this.current;
    }

    void doStep() {
        double d;
        double[] dArray = new double[]{this.volts[0], this.volts[1], this.volts[2]};
        if (dArray[1] > this.lastv1 + 0.5) {
            dArray[1] = this.lastv1 + 0.5;
        }
        if (dArray[1] < this.lastv1 - 0.5) {
            dArray[1] = this.lastv1 - 0.5;
        }
        if (dArray[2] > this.lastv2 + 0.5) {
            dArray[2] = this.lastv2 + 0.5;
        }
        if (dArray[2] < this.lastv2 - 0.5) {
            dArray[2] = this.lastv2 - 0.5;
        }
        int n = 1;
        int n2 = 2;
        int n3 = 0;
        double d2 = dArray[n] - dArray[n2];
        double d3 = dArray[n3] - dArray[n2];
        if (Math.abs(this.lastv0 - dArray[0]) > 0.01 || Math.abs(this.lastv1 - dArray[1]) > 0.01 || Math.abs(this.lastv2 - dArray[2]) > 0.01) {
            TriodeElm.sim.converged = false;
        }
        this.lastv0 = dArray[0];
        this.lastv1 = dArray[1];
        this.lastv2 = dArray[2];
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = d2 + d3 / this.mu;
        this.currentg = 0.0;
        if (d2 > 0.01) {
            sim.stampResistor(this.nodes[n], this.nodes[n2], 6000.0);
            this.currentg = d2 / 6000.0;
        }
        if (d7 < 0.0) {
            d6 = 1.0E-8;
            d4 = d3 * d6;
        } else {
            d4 = Math.pow(d7, 1.5) / this.kg1;
            d6 = d = 1.5 * Math.sqrt(d7) / this.kg1;
            d5 = d / this.mu;
        }
        this.currentp = d4;
        this.currentc = d4 + this.currentg;
        d = -d4 + d6 * d3 + d5 * d2;
        sim.stampMatrix(this.nodes[n3], this.nodes[n3], d6);
        sim.stampMatrix(this.nodes[n3], this.nodes[n2], -d6 - d5);
        sim.stampMatrix(this.nodes[n3], this.nodes[n], d5);
        sim.stampMatrix(this.nodes[n2], this.nodes[n3], -d6);
        sim.stampMatrix(this.nodes[n2], this.nodes[n2], d6 + d5);
        sim.stampMatrix(this.nodes[n2], this.nodes[n], -d5);
        sim.stampRightSide(this.nodes[n3], d);
        sim.stampRightSide(this.nodes[n2], -d);
    }

    void stamp() {
        sim.stampNonLinear(this.nodes[0]);
        sim.stampNonLinear(this.nodes[1]);
        sim.stampNonLinear(this.nodes[2]);
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "triode";
        double d = this.volts[0] - this.volts[1];
        double d2 = this.volts[0] - this.volts[2];
        double d3 = this.volts[1] - this.volts[2];
        stringArray[1] = "Vbe = " + TriodeElm.getVoltageText(d2);
        stringArray[2] = "Vbc = " + TriodeElm.getVoltageText(d);
        stringArray[3] = "Vce = " + TriodeElm.getVoltageText(d3);
    }

    boolean getConnection(int n, int n2) {
        return n != 1 && n2 != 1;
    }
}

